import logging
import logging.handlers
import inspect
import os
from time import strftime
import builtins


def put_colour(txt, color=None):
    if color == 'red':
        result = f"\033[31m{txt}\033[0m"
    elif color == 'green':
        result = f"\033[32m{txt}\033[0m"
    elif color == 'yellow':
        result = f"\033[33m{txt}\033[0m"
    elif color == 'blue':
        result = f"\033[34m{txt}\033[0m"
    elif color == 'violet':
        result = f"\033[35m{txt}\033[0m"
    elif color == 'cyan':
        result = f"\033[36m{txt}\033[0m"
    elif color == 'gray':
        result = f"\033[37m{txt}\033[0m"
    elif color == 'black':
        result = f"\033[30m{txt}\033[0m"
    else:
        result = txt
    return result



def add_context_info(func,level=logging.INFO,filename=False,format='',show=True):
    def wrapper(*args, **kwargs):
        [logging.root.removeHandler(handler) or handler.close() for handler in logging.root.handlers[:]]
        frame = inspect.currentframe().f_back
        func_name = frame.f_code.co_name
        if func_name == '<module>':
            func_name = 'None'
        co_filename = frame.f_code.co_filename.split('\\')[-1]
        lineno = frame.f_lineno
        handler_list =[]
        if filename:
            handler_list.append(logging.FileHandler(filename,encoding='utf-8'))
        if show:
            handler_list.append(logging.StreamHandler())

        if format:
            format_txt = format.replace('%(pathname)s', str(frame.f_code.co_filename)).replace('%(funcName)s', str(func_name)).replace('%(lineno)d', str(lineno))
        else:
            if filename:
                format_txt = f'File "{co_filename}", line {lineno}, time %(asctime)s, func {func_name}, level %(levelname)s: %(message)s'
            else:
                format_txt = f'File "{co_filename}", line {lineno}, func {func_name}, level %(levelname)s: %(message)s'

        if func.__name__ == 'debug':
            color = 'gray'
            format_txt = put_colour(format_txt,color=color)
            args = (' '.join([put_colour(str(i),color=color) if not filename else str(i) for i in args ]),)
        elif func.__name__ == 'info':
            color = 'cyan'
            format_txt = put_colour(format_txt, color=color)
            args = (' '.join([put_colour(str(i), color=color) if not filename else str(i) for i in args]),)
        elif func.__name__ == 'warning':
            color = 'yellow'
            format_txt = put_colour(format_txt, color=color)
            args = (' '.join([put_colour(str(i), color=color) if not filename else str(i) for i in args]),)
        elif func.__name__ == 'error':
            color = 'red'
            format_txt = put_colour(format_txt, color=color)
            args = (' '.join([put_colour(str(i), color=color) if not filename else str(i) for i in args]),)
        elif func.__name__ == 'fatal':
            color = None
            format_txt = put_colour(format_txt, color=color)
            args = (' '.join([put_colour(str(i), color=color) if not filename else str(i) for i in args]),)

        logging.basicConfig(level=level,
                                    format=format_txt,
                                    handlers=handler_list)

        return func(*args, **kwargs)
    return wrapper

debug = add_context_info(logging.debug)
info = add_context_info(logging.info)
warning = add_context_info(logging.warning)
error = add_context_info(logging.error)
fatal = add_context_info(logging.fatal)


def init(level='INFO',filename=False,save=False,format=False,show=True,print_pro=False):
    global debug,info,warning,error,fatal
    if level == 'DEBUG':
        log_level = logging.DEBUG
    elif level == 'INFO':
        log_level = logging.INFO
    elif level == 'WARN':
        log_level = logging.WARN
    elif level == 'WARNING':
        log_level = logging.WARNING
    elif level == 'ERROR':
        log_level = logging.ERROR
    elif level == 'FATAL':
        log_level = logging.FATAL
    elif level == 'CRITICAL':
        log_level = logging.CRITICAL
    else:
        log_level = logging.INFO
    if save:
        path = os.path.dirname(os.getcwd() + '\\logs\\')  # 判断日志目录
        if not os.path.exists(path):
            os.makedirs(path)
        filename = strftime("logs\my_log_%Y_%m_%d_%H.log")

    debug = add_context_info(logging.debug, log_level,filename,format,show)
    info = add_context_info(logging.info, log_level,filename,format,show)
    warning = add_context_info(logging.warning, log_level,filename,format,show)
    error = add_context_info(logging.error, log_level,filename,format,show)
    fatal = add_context_info(logging.fatal, log_level,filename,format,show)
    if print_pro:
        builtins.print = add_context_info(logging.info)

