# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/mysqlConnection.json
#   timestamp: 2022-06-14T09:18:33+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class MySQLType(Enum):
    Mysql = 'Mysql'


class MySQLScheme(Enum):
    mysql_pymysql = 'mysql+pymysql'


class MysqlConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MySQLType] = Field(
        MySQLType.Mysql, description='Service Type', title='Service Type'
    )
    scheme: Optional[MySQLScheme] = Field(
        MySQLScheme.mysql_pymysql,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to MySQL. This user should have privileges to read all the metadata in Mysql.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='Password to connect to MySQL.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the MySQL service.', title='Host and Port'
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='databaseSchema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single databaseSchema. When left blank, OpenMetadata Ingestion attempts to scan all the databaseSchema.',
        title='databaseSchema',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
