# generated by datamodel-codegen:
#   filename:  schema/security/credentials/gcsCredentials.json
#   timestamp: 2022-06-14T09:18:33+00:00

from __future__ import annotations

from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr


class GCSValues(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[str] = Field(
        None, description='Google Cloud service account type.', title='Credentials Type'
    )
    projectId: Optional[str] = Field(
        None, description='Google Cloud project id.', title='Project ID'
    )
    privateKeyId: Optional[str] = Field(
        None, description='Google Cloud private key id.', title='Private Key ID'
    )
    privateKey: Optional[SecretStr] = Field(
        None, description='Google Cloud private key.', title='Private Key'
    )
    clientEmail: Optional[str] = Field(
        None, description='Google Cloud email.', title='Client Email'
    )
    clientId: Optional[str] = Field(
        None, description='Google Cloud Client ID.', title='Client ID'
    )
    authUri: Optional[AnyUrl] = Field(
        'https://accounts.google.com/o/oauth2/auth',
        description='Google Cloud auth uri.',
        title='Authentication URI',
    )
    tokenUri: Optional[AnyUrl] = Field(
        'https://oauth2.googleapis.com/token',
        description='Google Cloud token uri.',
        title='Token URI',
    )
    authProviderX509CertUrl: Optional[AnyUrl] = Field(
        'https://www.googleapis.com/oauth2/v1/certs',
        description='Google Cloud auth provider certificate.',
        title='Authentication Provider x509 Certificate URL',
    )
    clientX509CertUrl: Optional[AnyUrl] = Field(
        None,
        description='Google Cloud client certificate uri.',
        title='Client x509 Certificate URL',
    )


class GCSCredentialsPath(BaseModel):
    __root__: str = Field(
        ..., description='GCS Credentials Path.', title='GCS Credentials Path'
    )


class GCSCredentials(BaseModel):
    class Config:
        extra = Extra.forbid

    gcsConfig: Union[GCSValues, GCSCredentialsPath] = Field(
        ..., description='GCS configs.', title='GCS Credentials Configuration'
    )
