from unittest.mock import patch
import json
from tests.utils import fixtures_path, fake_new_property, fake_download

from hestia_earth.models.globalCropWaterModel2008.rootingDepth import TERM_ID, run, _should_run, _should_run_product

class_path = 'hestia_earth.models.globalCropWaterModel2008.rootingDepth'
fixtures_folder = f"{fixtures_path}/globalCropWaterModel2008/{TERM_ID}"
TERMS = [
    'waterPumpedGroundWater',
    'waterBrackish',
    'waterSourceUnspecified'
]


def test_should_run():
    cycle = {'functionalUnitMeasure': '1 ha'}
    assert _should_run(cycle)

    cycle = {'functionalUnitMeasure': 'relative'}
    assert not _should_run(cycle)


def test_should_run_product():
    product = {}
    # no properties => run
    assert _should_run_product(product)

    # product with model => does not run
    prop = {
        'term': {
            '@id': TERM_ID
        }
    }
    product['properties'] = [prop]
    assert not _should_run_product(product)


@patch(f"{class_path}.get_irrigation_terms", return_value=TERMS)
@patch(f"{class_path}.download_hestia", side_effect=fake_download)
@patch(f"{class_path}._new_property", side_effect=fake_new_property)
def test_run(*args):
    with open(f"{fixtures_folder}/cycle.jsonld", encoding='utf-8') as f:
        cycle = json.load(f)

    with open(f"{fixtures_folder}/result.jsonld", encoding='utf-8') as f:
        expected = json.load(f)

    value = run(cycle)
    assert value == expected


@patch(f"{class_path}.get_irrigation_terms", return_value=TERMS)
@patch(f"{class_path}.download_hestia", side_effect=fake_download)
@patch(f"{class_path}._new_property", side_effect=fake_new_property)
def test_gap_fill_with_irrigation(*args):
    with open(f"{fixtures_folder}/with-irrigation/cycle.jsonld", encoding='utf-8') as f:
        cycle = json.load(f)

    with open(f"{fixtures_folder}/with-irrigation/result.jsonld", encoding='utf-8') as f:
        expected = json.load(f)

    value = run(cycle)
    assert value == expected
