[![Build Status](https://github.com/dstein64/LC4/workflows/build/badge.svg)](https://github.com/dstein64/LC4/actions)

LC4
===

A Python library that implements ElsieFour (LC4) encryption, based on the algorithm in
(Alan Kaminsky 2017).

Features
--------

- Support for custom alphabets
- An [interactive command-line utility](https://github.com/dstein64/LC4/blob/master/documentation.md#interactive-command-line-utility)
- Optional verbose output that visually shows the steps of the algorithm

<img src="https://github.com/dstein64/LC4/blob/master/verbose.gif?raw=true" width="200"/>

Requirements
------------

LC4 supports Python 3.x.

Linux, Mac, and Windows are supported.

Other operating systems may be compatible if NumPy can be properly installed.

Installation
------------

[LC4](https://pypi.python.org/pypi/lc4) is available on PyPI, the Python Package Index.

```sh
$ pip3 install lc4
```

Documentation
-------------

See [documentation.md](https://github.com/dstein64/LC4/blob/master/documentation.md).

Example Usage
-------------

See [example.py](https://github.com/dstein64/LC4/blob/master/example.py).

Tests
-----

Tests are in [tests/](https://github.com/dstein64/LC4/blob/master/tests).

```sh
# Run tests
$ python3 -m unittest discover tests -v
```

License
-------

The code in this repository has an [MIT License](https://en.wikipedia.org/wiki/MIT_License).

See [LICENSE](https://github.com/dstein64/LC4/blob/master/LICENSE).

References
----------

Kaminsky, Alan. “ElsieFour: A Low-Tech Authenticated Encryption Algorithm
For Human-to-Human Communication,” 2017. https://eprint.iacr.org/2017/339.
