# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecommendationArgs', 'Recommendation']

@pulumi.input_type
class RecommendationArgs:
    def __init__(__self__, *,
                 recommendation_id: pulumi.Input[str],
                 status: pulumi.Input[str],
                 time_status_end: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Recommendation resource.
        :param pulumi.Input[str] recommendation_id: The unique OCID associated with the recommendation.
        :param pulumi.Input[str] status: (Updatable) The status of the recommendation.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the recommendation will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "recommendation_id", recommendation_id)
        pulumi.set(__self__, "status", status)
        if time_status_end is not None:
            pulumi.set(__self__, "time_status_end", time_status_end)

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> pulumi.Input[str]:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @recommendation_id.setter
    def recommendation_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "recommendation_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        (Updatable) The status of the recommendation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date and time the current status will change. The format is defined by RFC3339.

        For example, "The current `postponed` status of the recommendation will end and change to `pending` on this date and time."


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_status_end")

    @time_status_end.setter
    def time_status_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_status_end", value)


@pulumi.input_type
class _RecommendationState:
    def __init__(__self__, *,
                 category_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 estimated_cost_saving: Optional[pulumi.Input[float]] = None,
                 extended_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 importance: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recommendation_id: Optional[pulumi.Input[str]] = None,
                 resource_counts: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationResourceCountArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 supported_levels: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationSupportedLevelArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_status_begin: Optional[pulumi.Input[str]] = None,
                 time_status_end: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Recommendation resources.
        :param pulumi.Input[str] category_id: The unique OCID associated with the category.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy. The tenancy is the root compartment.
        :param pulumi.Input[str] description: Text describing the recommendation.
        :param pulumi.Input[float] estimated_cost_saving: The estimated cost savings, in dollars, for the recommendation.
        :param pulumi.Input[Mapping[str, Any]] extended_metadata: Additional metadata key/value pairs for the recommendation.
        :param pulumi.Input[str] importance: The level of importance assigned to the recommendation.
        :param pulumi.Input[str] name: The name of the profile level.
        :param pulumi.Input[str] recommendation_id: The unique OCID associated with the recommendation.
        :param pulumi.Input[Sequence[pulumi.Input['RecommendationResourceCountArgs']]] resource_counts: An array of `ResourceCount` objects grouped by the status of the resource actions.
        :param pulumi.Input[str] state: The recommendation's current state.
        :param pulumi.Input[str] status: (Updatable) The status of the recommendation.
        :param pulumi.Input[Sequence[pulumi.Input['RecommendationSupportedLevelArgs']]] supported_levels: Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        :param pulumi.Input[str] time_created: The date and time the recommendation details were created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_status_begin: The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the recommendation will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_updated: The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        if category_id is not None:
            pulumi.set(__self__, "category_id", category_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if estimated_cost_saving is not None:
            pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        if extended_metadata is not None:
            pulumi.set(__self__, "extended_metadata", extended_metadata)
        if importance is not None:
            pulumi.set(__self__, "importance", importance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recommendation_id is not None:
            pulumi.set(__self__, "recommendation_id", recommendation_id)
        if resource_counts is not None:
            pulumi.set(__self__, "resource_counts", resource_counts)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supported_levels is not None:
            pulumi.set(__self__, "supported_levels", supported_levels)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_status_begin is not None:
            pulumi.set(__self__, "time_status_begin", time_status_begin)
        if time_status_end is not None:
            pulumi.set(__self__, "time_status_end", time_status_end)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @category_id.setter
    def category_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Text describing the recommendation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> Optional[pulumi.Input[float]]:
        """
        The estimated cost savings, in dollars, for the recommendation.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @estimated_cost_saving.setter
    def estimated_cost_saving(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "estimated_cost_saving", value)

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Additional metadata key/value pairs for the recommendation.
        """
        return pulumi.get(self, "extended_metadata")

    @extended_metadata.setter
    def extended_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "extended_metadata", value)

    @property
    @pulumi.getter
    def importance(self) -> Optional[pulumi.Input[str]]:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")

    @importance.setter
    def importance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "importance", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile level.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @recommendation_id.setter
    def recommendation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_id", value)

    @property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationResourceCountArgs']]]]:
        """
        An array of `ResourceCount` objects grouped by the status of the resource actions.
        """
        return pulumi.get(self, "resource_counts")

    @resource_counts.setter
    def resource_counts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationResourceCountArgs']]]]):
        pulumi.set(self, "resource_counts", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The status of the recommendation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="supportedLevels")
    def supported_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationSupportedLevelArgs']]]]:
        """
        Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        """
        return pulumi.get(self, "supported_levels")

    @supported_levels.setter
    def supported_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationSupportedLevelArgs']]]]):
        pulumi.set(self, "supported_levels", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the recommendation details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @time_status_begin.setter
    def time_status_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_status_begin", value)

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date and time the current status will change. The format is defined by RFC3339.

        For example, "The current `postponed` status of the recommendation will end and change to `pending` on this date and time."


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_status_end")

    @time_status_end.setter
    def time_status_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_status_end", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class Recommendation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recommendation_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_status_end: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Recommendation resource in Oracle Cloud Infrastructure Optimizer service.

        Updates the recommendation that corresponds to the specified OCID.
        Use this operation to implement the following actions:

          * Postpone recommendation
          * Dismiss recommendation
          * Reactivate recommendation

        ## Import

        Recommendations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Optimizer/recommendation:Recommendation test_recommendation "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] recommendation_id: The unique OCID associated with the recommendation.
        :param pulumi.Input[str] status: (Updatable) The status of the recommendation.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the recommendation will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecommendationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Recommendation resource in Oracle Cloud Infrastructure Optimizer service.

        Updates the recommendation that corresponds to the specified OCID.
        Use this operation to implement the following actions:

          * Postpone recommendation
          * Dismiss recommendation
          * Reactivate recommendation

        ## Import

        Recommendations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Optimizer/recommendation:Recommendation test_recommendation "id"
        ```

        :param str resource_name: The name of the resource.
        :param RecommendationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecommendationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recommendation_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_status_end: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecommendationArgs.__new__(RecommendationArgs)

            if recommendation_id is None and not opts.urn:
                raise TypeError("Missing required property 'recommendation_id'")
            __props__.__dict__["recommendation_id"] = recommendation_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["time_status_end"] = time_status_end
            __props__.__dict__["category_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["estimated_cost_saving"] = None
            __props__.__dict__["extended_metadata"] = None
            __props__.__dict__["importance"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["resource_counts"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["supported_levels"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_status_begin"] = None
            __props__.__dict__["time_updated"] = None
        super(Recommendation, __self__).__init__(
            'oci:Optimizer/recommendation:Recommendation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            estimated_cost_saving: Optional[pulumi.Input[float]] = None,
            extended_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            importance: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            recommendation_id: Optional[pulumi.Input[str]] = None,
            resource_counts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecommendationResourceCountArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            supported_levels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecommendationSupportedLevelArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_status_begin: Optional[pulumi.Input[str]] = None,
            time_status_end: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'Recommendation':
        """
        Get an existing Recommendation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category_id: The unique OCID associated with the category.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy. The tenancy is the root compartment.
        :param pulumi.Input[str] description: Text describing the recommendation.
        :param pulumi.Input[float] estimated_cost_saving: The estimated cost savings, in dollars, for the recommendation.
        :param pulumi.Input[Mapping[str, Any]] extended_metadata: Additional metadata key/value pairs for the recommendation.
        :param pulumi.Input[str] importance: The level of importance assigned to the recommendation.
        :param pulumi.Input[str] name: The name of the profile level.
        :param pulumi.Input[str] recommendation_id: The unique OCID associated with the recommendation.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecommendationResourceCountArgs']]]] resource_counts: An array of `ResourceCount` objects grouped by the status of the resource actions.
        :param pulumi.Input[str] state: The recommendation's current state.
        :param pulumi.Input[str] status: (Updatable) The status of the recommendation.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecommendationSupportedLevelArgs']]]] supported_levels: Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        :param pulumi.Input[str] time_created: The date and time the recommendation details were created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_status_begin: The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the recommendation will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_updated: The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecommendationState.__new__(_RecommendationState)

        __props__.__dict__["category_id"] = category_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["estimated_cost_saving"] = estimated_cost_saving
        __props__.__dict__["extended_metadata"] = extended_metadata
        __props__.__dict__["importance"] = importance
        __props__.__dict__["name"] = name
        __props__.__dict__["recommendation_id"] = recommendation_id
        __props__.__dict__["resource_counts"] = resource_counts
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["supported_levels"] = supported_levels
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_status_begin"] = time_status_begin
        __props__.__dict__["time_status_end"] = time_status_end
        __props__.__dict__["time_updated"] = time_updated
        return Recommendation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> pulumi.Output[str]:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Text describing the recommendation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> pulumi.Output[float]:
        """
        The estimated cost savings, in dollars, for the recommendation.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Additional metadata key/value pairs for the recommendation.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def importance(self) -> pulumi.Output[str]:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the profile level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> pulumi.Output[str]:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> pulumi.Output[Sequence['outputs.RecommendationResourceCount']]:
        """
        An array of `ResourceCount` objects grouped by the status of the resource actions.
        """
        return pulumi.get(self, "resource_counts")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The recommendation's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) The status of the recommendation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportedLevels")
    def supported_levels(self) -> pulumi.Output[Sequence['outputs.RecommendationSupportedLevel']]:
        """
        Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        """
        return pulumi.get(self, "supported_levels")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the recommendation details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> pulumi.Output[str]:
        """
        The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> pulumi.Output[str]:
        """
        (Updatable) The date and time the current status will change. The format is defined by RFC3339.

        For example, "The current `postponed` status of the recommendation will end and change to `pending` on this date and time."


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_status_end")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

