# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMonitoredResourceTasksResult',
    'AwaitableGetMonitoredResourceTasksResult',
    'get_monitored_resource_tasks',
    'get_monitored_resource_tasks_output',
]

@pulumi.output_type
class GetMonitoredResourceTasksResult:
    """
    A collection of values returned by getMonitoredResourceTasks.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, monitored_resource_tasks_collections=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitored_resource_tasks_collections and not isinstance(monitored_resource_tasks_collections, list):
            raise TypeError("Expected argument 'monitored_resource_tasks_collections' to be a list")
        pulumi.set(__self__, "monitored_resource_tasks_collections", monitored_resource_tasks_collections)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMonitoredResourceTasksFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitoredResourceTasksCollections")
    def monitored_resource_tasks_collections(self) -> Sequence['outputs.GetMonitoredResourceTasksMonitoredResourceTasksCollectionResult']:
        """
        The list of monitored_resource_tasks_collection.
        """
        return pulumi.get(self, "monitored_resource_tasks_collections")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetMonitoredResourceTasksResult(GetMonitoredResourceTasksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoredResourceTasksResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            monitored_resource_tasks_collections=self.monitored_resource_tasks_collections,
            status=self.status)


def get_monitored_resource_tasks(compartment_id: Optional[str] = None,
                                 filters: Optional[Sequence[pulumi.InputType['GetMonitoredResourceTasksFilterArgs']]] = None,
                                 status: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoredResourceTasksResult:
    """
    This data source provides the list of Monitored Resource Tasks in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of stack monitoring resource tasks in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resource_tasks = oci.StackMonitoring.get_monitored_resource_tasks(compartment_id=var["compartment_id"],
        status=var["monitored_resource_task_status"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for which  stack monitoring resource tasks should be listed.
    :param str status: A filter to return only resources that matches with lifecycleState given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMonitoredResourceTasks:getMonitoredResourceTasks', __args__, opts=opts, typ=GetMonitoredResourceTasksResult).value

    return AwaitableGetMonitoredResourceTasksResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        monitored_resource_tasks_collections=pulumi.get(__ret__, 'monitored_resource_tasks_collections'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_monitored_resource_tasks)
def get_monitored_resource_tasks_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMonitoredResourceTasksFilterArgs']]]]] = None,
                                        status: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitoredResourceTasksResult]:
    """
    This data source provides the list of Monitored Resource Tasks in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of stack monitoring resource tasks in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resource_tasks = oci.StackMonitoring.get_monitored_resource_tasks(compartment_id=var["compartment_id"],
        status=var["monitored_resource_task_status"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for which  stack monitoring resource tasks should be listed.
    :param str status: A filter to return only resources that matches with lifecycleState given.
    """
    ...
