from abc import ABC
from typing import Mapping

from kognic.io.model import BaseSerializer
from kognic.io.model.input.resources.resource import Resource


class BaseFrame(BaseSerializer, ABC):
    """
    Base class for the concept of a frame of data in sequential scenes.
    """

    @property
    def resources(self) -> Mapping[str, Resource]:
        raise NotImplementedError(f"resources not implemented for {type(self)}")
