"""
Defines flight controller vendor and board name depending on hwdef.dat file information.

File automatically generated by the update_flight_controller_ids.py script
Do not edit directly. ALL CHANGES WILL BE OVERWRITTEN
"""

# Maps USB VID to vendor (manufacturer) name
VID_VENDOR_DICT: dict[int, str] = {
    0x26AC: "3DR",
    0x1209: "ArduPilot",
    0x2DAE: "Hex/ProfiCNC",
    0x3162: "Holybro",
    0x27AC: "Swift-Flyer",
    0x35A7: "ThePeach",
}

# Maps USB VID,PID tuple to product name
VID_PID_PRODUCT_DICT: dict[tuple[int, int], str] = {
    (0x26AC, 0x1124): "CZOEMrevG",
    (0x1209, 0x5741): "ACNS-CM4Pilot",
    (0x2DAE, 0x1011): "CubeBlack",
    (0x2DAE, 0x1101): "CubeBlack+",
    (0x2DAE, 0x1016): "CubeOrange",
    (0x2DAE, 0x1057): "Joey",
    (0x2DAE, 0x1058): "CubeOrange+",
    (0x2DAE, 0x1015): "CubePurple",
    (0x2DAE, 0x1059): "CubeRed",
    (0x2DAE, 0x1012): "CubeYellow",
    (0x3162, 0x004B): "Durandal",
    (0x27AC, 0x0201): "F4BY",
    (0x3162, 0x004E): "Pix32v5",
    (0x3162, 0x0051): "Pixhawk5X",
    (0x3162, 0x0053): "Pixhawk6C",
    (0x35A7, 0x0001): "FCC-K1",
    (0x35A7, 0x0002): "FCC-R1",
    (0x27AC, 0x1151): "VRBrain-v51",
    (0x27AC, 0x1152): "VRBrain-v52",
    (0x27AC, 0x1154): "VRBrain-v54",
    (0x27AC, 0x1910): "VRCore-v10",
    (0x27AC, 0x1351): "VRUBrain-v51",
}

# Maps 16-bit APJ board ID to board name for 215 supported boards
APJ_BOARD_ID_NAME_DICT: dict[int, str] = {
    1124: "3DRControlZeroG",
    1115: "ACNS-CM4Pilot",
    1116: "ACNS-F405AIO",
    1077: "AeroFox-Airspeed",
    1104: "AeroFox-Airspeed-DLVR",
    1109: "AeroFox-GNSS_F9P",
    1080: "AeroFox-PMU",
    2024: "AET-H743-Basic",
    128: "airbotf4",
    55: "AIRLink",
    5200: "Airvolute-DCS2",
    1146: "AnyleafH7",
    5210: "Aocoda-RC-H743Dual",
    1134: "AR-F407SmartBat",
    57: "ARKV6X",
    83: "ARK_CANNODE",
    81: "ARK_GPS",
    82: "ARK_RTK_GPS",
    1078: "AtomRCF405NAVI",
    1026: "BeastF7",
    1057: "BeastF7v2",
    1025: "BeastH7",
    1056: "BeastH7v2",
    1125: "BETAFPV-F405",
    1044: "BirdCANdy",
    1164: "BlitzF745",
    1117: "BlitzF745AIO",
    1162: "BlitzH743Pro",
    1163: "BlitzMiniF745",
    1168: "BlitzWingH743",
    1148: "BotBloxDroneNet",
    1085: "C-RTK2-HP",
    1064: "CarbonixF405",
    1053: "CarbonixL496",
    1156: "CBU-H7-Stamp",
    12: "crazyflie2",
    1158: "CSKY405",
    7000: "CUAV-7-Nano",
    1009: "CUAV-Nora",
    9: "CUAV-Pixhack-v3",
    1010: "CUAV-X7",
    50: "CUAVv5",
    1001: "CUAV_GPS",
    1003: "CubeBlack+",
    1401: "CubeBlack",
    1079: "CubeNode",
    140: "CubeOrange",
    1033: "CubeOrange-joey",
    10140: "CubeOrange",
    1400: "CubeOrange",
    1063: "CubeOrangePlus",
    1069: "CubeRedPrimary",
    1409: "CubeRedPrimary-PPPGW",
    1070: "CubeRedSecondary",
    120: "CubeYellow",
    1061: "DevEBoxH7v2",
    13: "DrotekP3Pro",
    139: "Durandal",
    1000: "f103",
    1004: "f303",
    135: "F35Lightning",
    1014: "f405-MatekAirspeed",
    20: "F4BY",
    1530: "F4BY_F427",
    1067: "FlyingMoonF407",
    1068: "FlyingMoonF427",
    1112: "FlyingMoonH743",
    1180: "FlywooF405HD-AIOv2",
    1137: "FlywooF405Pro",
    1099: "FlywooF405S-AIO",
    1027: "FlywooF745",
    1042: "FlywooF745Nano",
    1181: "FlywooH743Pro",
    1157: "FoxeerF405v2",
    1089: "FoxeerH743v1",
    1028: "FreeflyRTK",
    1501: "GEPRCF745BTHD",
    146: "H757I_EVAL",
    1119: "HEEWING-F405",
    1043: "Here4AP",
    1046: "Hitec-Airspeed",
    1016: "HitecMosaic",
    5401: "HolybroF4_PMU",
    5405: "HolybroG4_Airspeed",
    1088: "HolybroG4_Compass",
    1035: "HolybroGPS",
    1173: "IFLIGHT_2RAW_H7",
    3: "iomcu",
    1084: "JFB100",
    1110: "JFB110",
    1059: "JHEMCU-GSF405A",
    1411: "JHEMCU-H743HD",
    1081: "JHEM_JHEF405",
    122: "KakuteF4",
    5406: "KakuteF4-Wing",
    1030: "KakuteF4Mini",
    123: "KakuteF7",
    145: "KakuteF7Mini",
    1048: "KakuteH7",
    1105: "KakuteH7-Wing",
    1058: "KakuteH7Mini",
    1315: "kha_eth",
    1422: "LongBowF405WING",
    11: "luminousbee4",
    1029: "luminousbee5",
    1038: "MambaF405-2022",
    1019: "MambaF405v2",
    1073: "MambaH743v4",
    125: "MatekF405",
    1054: "MatekF405-TE",
    127: "MatekF405-Wing",
    143: "MatekF765-SE",
    1170: "MatekG474-DShot",
    1013: "MatekH743",
    1149: "MatekH7A3",
    1062: "MatekL431",
    188: "MazzyStarDrone",
    6101: "MFE_POS3_CAN",
    2000: "MFT-SEMA100",
    1161: "MicoAir405Mini",
    1150: "MicoAir405v2",
    1166: "MicoAir743",
    88: "mindpx-v2",
    41775: "modalai_fc-v1",
    1041: "mRo-M10095",
    1098: "mRoCANPWM-M10126",
    1022: "mRoControlZeroClassic",
    141: "mRoControlZeroF7",
    1023: "mRoControlZeroH7",
    1024: "mRoControlZeroOEMH7",
    1145: "mRoKitCANrevC",
    1015: "mRoNexus",
    1017: "mRoPixracerPro",
    136: "mRoX21-777",
    1222: "MUPilot",
    1040: "Nucleo-G491",
    1051: "Nucleo-L476",
    1047: "Nucleo-L496",
    1159: "NxtPX4v2",
    1002: "omnibusf4",
    131: "omnibusf4pro",
    137: "omnibusf4v6",
    121: "OMNIBUSF7V2",
    133: "OmnibusNanoV6",
    1155: "OrqaF405Pro",
    1032: "PixC4-Jetson",
    1090: "PixFlamingo",
    1131: "PixFlamingo-F767",
    51: "Pixhawk5X",
    56: "Pixhawk6C",
    53: "Pixhawk6X",
    10053: "Pixhawk6X",
    1408: "Pixhawk6X-PPPGW",
    1140: "PixPilot-C3",
    1096: "PixPilot-V3",
    1083: "PixPilot-V6",
    1160: "PixPilot-V6PRO",
    1402: "Pixracer",
    1076: "PixSurveyA1",
    1107: "PixSurveyA1-IND",
    1097: "PixSurveyA2",
    1065: "QioTekAdeptF407",
    1021: "QioTekZealotF427",
    1036: "QioTekZealotH743",
    1008: "R9Pilot",
    1410: "RadiolinkPIX6",
    1118: "RADIX2HD",
    1074: "ReaperF745",
    124: "revo-mini",
    1102: "rFCU",
    1103: "rGNSS",
    1111: "SDMODELH7V1",
    1167: "SDMODELH7V2",
    1052: "Sierra-F405",
    1055: "Sierra-F412",
    1034: "Sierra-F9P",
    1050: "Sierra-L431",
    1095: "Sierra-PrecisionPoint",
    5302: "Sierra-TrueNavIC",
    1091: "Sierra-TrueNavPro",
    5301: "Sierra-TrueNavPro-G4",
    1093: "Sierra-TrueNorth",
    1094: "Sierra-TrueSpeed",
    1123: "SIYI_N7",
    2714: "SkySakuraH743",
    1075: "SkystarsH7HD",
    130: "sparky2",
    134: "speedybeef4",
    1135: "SpeedyBeeF405Mini",
    1106: "SpeedyBeeF405WING",
    1082: "speedybeef4v3",
    1136: "speedybeef4v4",
    1060: "SPRacingH7",
    1108: "SPRacingH7RF",
    1011: "SuccexF4",
    6001: "sw-boom-f407",
    6002: "sw-nav-f405",
    6000: "sw-spar-f407",
    5250: "TBS_LUCID_H7",
    212: "thepeach-k1",
    213: "thepeach-r1",
    1138: "TMotorH743",
    1151: "VRBrain-v51",
    1152: "VRBrain-v52",
    1154: "VRBrain-v54",
    1910: "VRCore-v10",
    1351: "VRUBrain-v51",
    7100: "VUAV-V7pro",
    1174: "X-MAV-AP-H743v2",
    1113: "YJUAV_A6",
    1127: "YJUAV_A6SE",
    1141: "YJUAV_A6SE_H743",
    1144: "YJUAV_A6Ultra",
    5600: "ZeroOneX6",
    1005: "ZubaxGNSS",
}

# Maps 16-bit APJ board ID to board vendor for 215 supported boards
APJ_BOARD_ID_VENDOR_DICT: dict[int, str] = {
    1124: "3DR",
    1115: "ArduPilot",
    1116: "ArduPilot",
    1077: "ArduPilot",
    1104: "ArduPilot",
    1109: "ArduPilot",
    1080: "ArduPilot",
    2024: "AET",
    128: "ArduPilot",
    55: "ArduPilot",
    5200: "Airvolute",
    1146: "ArduPilot",
    5210: "Aocoda-RC-H743Dual",
    1134: "ArduPilot",
    57: "ArduPilot",
    83: "ArduPilot",
    81: "ArduPilot",
    82: "ArduPilot",
    1078: "ArduPilot",
    1026: "ArduPilot",
    1057: "ArduPilot",
    1025: "ArduPilot",
    1056: "ArduPilot",
    1125: "ArduPilot",
    1044: "ArduPilot",
    1164: "ArduPilot",
    1117: "ArduPilot",
    1162: "ArduPilot",
    1163: "ArduPilot",
    1168: "ArduPilot",
    1148: "ArduPilot",
    1085: "ArduPilot",
    1064: "ArduPilot",
    1053: "ArduPilot",
    1156: "ArduPilot",
    12: "ArduPilot",
    1158: "CSKY",
    7000: "ArduPilot",
    1009: "ArduPilot",
    9: "ArduPilot",
    1010: "ArduPilot",
    50: "ArduPilot",
    1001: "ArduPilot",
    1003: "Hex/ProfiCNC",
    1401: "Hex/ProfiCNC",
    1079: "ArduPilot",
    140: "Hex/ProfiCNC",
    1033: "CubePilot",
    10140: "Hex/ProfiCNC",
    1400: "Hex/ProfiCNC",
    1063: "CubePilot",
    1069: "CubePilot",
    1409: "CubePilot",
    1070: "ArduPilot",
    120: "Hex/ProfiCNC",
    1061: "ArduPilot",
    13: "ArduPilot",
    139: "Holybro",
    1000: "ArduPilot",
    1004: "ArduPilot",
    135: "ArduPilot",
    1014: "ArduPilot",
    20: "Swift-Flyer",
    1530: "Swift-Flyer",
    1067: "ArduPilot",
    1068: "ArduPilot",
    1112: "ArduPilot",
    1180: "ArduPilot",
    1137: "ArduPilot",
    1099: "ArduPilot",
    1027: "ArduPilot",
    1042: "ArduPilot",
    1181: "ArduPilot",
    1157: "ArduPilot",
    1089: "ArduPilot",
    1028: "ArduPilot",
    1501: "ArduPilot",
    146: "ArduPilot",
    1119: "ArduPilot",
    1043: "ArduPilot",
    1046: "ArduPilot",
    1016: "ArduPilot",
    5401: "ArduPilot",
    5405: "ArduPilot",
    1088: "ArduPilot",
    1035: "ArduPilot",
    1173: "ArduPilot",
    3: "ArduPilot",
    1084: "ArduPilot",
    1110: "Japan Aviation Electronics Industry Ltd.",
    1059: "ArduPilot",
    1411: "ArduPilot",
    1081: "ArduPilot",
    122: "ArduPilot",
    5406: "ArduPilot",
    1030: "ArduPilot",
    123: "ArduPilot",
    145: "ArduPilot",
    1048: "ArduPilot",
    1105: "ArduPilot",
    1058: "ArduPilot",
    1315: "ArduPilot",
    1422: "ArduPilot",
    11: "ArduPilot",
    1029: "ArduPilot",
    1038: "ArduPilot",
    1019: "ArduPilot",
    1073: "ArduPilot",
    125: "ArduPilot",
    1054: "ArduPilot",
    127: "ArduPilot",
    143: "ArduPilot",
    1170: "ArduPilot",
    1013: "ArduPilot",
    1149: "ArduPilot",
    1062: "ArduPilot",
    188: "ArduPilot",
    6101: "ArduPilot",
    2000: "ArduPilot",
    1161: "ArduPilot",
    1150: "ArduPilot",
    1166: "ArduPilot",
    88: "ArduPilot",
    41775: "ArduPilot",
    1041: "ArduPilot",
    1098: "ArduPilot",
    1022: "mRo",
    141: "mRo",
    1023: "mRo",
    1024: "mRo",
    1145: "ArduPilot",
    1015: "mRo",
    1017: "mRo",
    136: "mRo",
    1222: "ArduPilot",
    1040: "ArduPilot",
    1051: "ArduPilot",
    1047: "ArduPilot",
    1159: "ArduPilot",
    1002: "ArduPilot",
    131: "ArduPilot",
    137: "ArduPilot",
    121: "ArduPilot",
    133: "ArduPilot",
    1155: "ArduPilot",
    1032: "Horizon31",
    1090: "Dheeran labs",
    1131: "Dheeran labs",
    51: "Holybro",
    56: "Holybro",
    53: "ArduPilot",
    10053: "ArduPilot",
    1408: "ArduPilot",
    1140: "ArduPilot",
    1096: "ArduPilot",
    1083: "ArduPilot",
    1160: "ArduPilot",
    1402: "ArduPilot",
    1076: "ArduPilot",
    1107: "ArduPilot",
    1097: "ArduPilot",
    1065: "Qiotek",
    1021: "ArduPilot",
    1036: "ArduPilot",
    1008: "ArduPilot",
    1410: "ArduPilot",
    1118: "ArduPilot",
    1074: "ArduPilot",
    124: "ArduPilot",
    1102: "ArduPilot",
    1103: "ArduPilot",
    1111: "ArduPilot",
    1167: "ArduPilot",
    1052: "ArduPilot",
    1055: "ArduPilot",
    1034: "ArduPilot",
    1050: "ArduPilot",
    1095: "Sierra Aerospace",
    5302: "ArduPilot",
    1091: "ArduPilot",
    5301: "ArduPilot",
    1093: "ArduPilot",
    1094: "ArduPilot",
    1123: "ArduPilot",
    2714: "SkySakura",
    1075: "ArduPilot",
    130: "ArduPilot",
    134: "ArduPilot",
    1135: "ArduPilot",
    1106: "ArduPilot",
    1082: "ArduPilot",
    1136: "ArduPilot",
    1060: "ArduPilot",
    1108: "ArduPilot",
    1011: "ArduPilot",
    6001: "ArduPilot",
    6002: "ArduPilot",
    6000: "ArduPilot",
    5250: "ArduPilot",
    212: "ThePeach",
    213: "ThePeach",
    1138: "ArduPilot",
    1151: "Laser Navigation",
    1152: "Laser Navigation",
    1154: "Laser Navigation",
    1910: "Laser Navigation",
    1351: "Laser Navigation",
    7100: "ArduPilot",
    1174: "ArduPilot",
    1113: "ArduPilot",
    1127: "ArduPilot",
    1141: "ArduPilot",
    1144: "ArduPilot",
    5600: "ArduPilot",
    1005: "ArduPilot",
}
