/*
 * Decompiled with CFR 0.152.
 */
package com.ionspin.kotlin.bignum.integer;

import com.ionspin.kotlin.bignum.BigNumber;
import com.ionspin.kotlin.bignum.BitwiseCapable;
import com.ionspin.kotlin.bignum.ByteArrayDeserializable;
import com.ionspin.kotlin.bignum.ByteArraySerializable;
import com.ionspin.kotlin.bignum.CommonBigNumberOperations;
import com.ionspin.kotlin.bignum.NarrowingOperations;
import com.ionspin.kotlin.bignum.decimal.BigDecimal;
import com.ionspin.kotlin.bignum.integer.BigIntegerArithmetic;
import com.ionspin.kotlin.bignum.integer.BigIntegerExtensionsKt;
import com.ionspin.kotlin.bignum.integer.ComparisonWorkaround;
import com.ionspin.kotlin.bignum.integer.ConfigurationKt;
import com.ionspin.kotlin.bignum.integer.Sign;
import com.ionspin.kotlin.bignum.integer.base63.array.BigInteger63Arithmetic;
import com.ionspin.kotlin.bignum.modular.ModularBigInteger;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.UShort;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0004\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u0095\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00060\u00052\u00020\u0007:\n\u0093\u0001\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B\u001e\b\u0000\u0012\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\b\u0010*\u001a\u00020\u0000H\u0016J\u0010\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0011\u0010-\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0096\u0004J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\tH\u0016J\u0010\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020/H\u0016J\u000e\u00103\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0000J\"\u00104\u001a\u00020\f2\u0006\u00105\u001a\u0002062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f08J\"\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020;2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f08J\u0011\u0010<\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0006H\u0096\u0002J\b\u0010=\u001a\u00020\u0000H\u0002J\t\u0010>\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010?\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u001c\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000A2\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0011\u0010B\u001a\u00020C2\u0006\u0010,\u001a\u00020\u0000H\u0086\u0004J\u0010\u0010D\u001a\u0002062\u0006\u00102\u001a\u00020/H\u0016J\u0013\u0010E\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J\u0010\u0010F\u001a\u00020;2\u0006\u00102\u001a\u00020/H\u0016J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00000IH\u0016J\b\u0010J\u001a\u00020\u0000H\u0016J\b\u0010K\u001a\u00020\fH\u0016J\t\u0010L\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010M\u001a\u00020\f2\u0006\u00102\u001a\u00020/H\u0016J!\u0010N\u001a\u00020/2\n\u0010O\u001a\u00060\u0015j\u0002`\u0016H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bP\u0010QJ\b\u0010R\u001a\u00020/H\u0016J\u0010\u0010S\u001a\u00020\f2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020\t2\u0006\u00102\u001a\u00020/H\u0016J\u0011\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0000H\u0086\u0004J\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0000J\u0010\u0010Z\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0010\u0010[\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0002J\b\u0010\\\u001a\u00020\u0000H\u0016J\b\u0010]\u001a\u00020\u0000H\u0016J\b\u0010^\u001a\u00020\tH\u0016J\u0011\u0010_\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0096\u0004J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u0000J\u0010\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\fH\u0016J\u0010\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\tH\u0016J\u0011\u0010b\u001a\u00020c2\u0006\u0010,\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010d\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\b\u0010e\u001a\u00020fH\u0016J\u0018\u0010g\u001a\u00020\u00002\u0006\u00100\u001a\u00020\t2\u0006\u0010h\u001a\u00020/H\u0016J\u0011\u0010i\u001a\u00020\u00002\u0006\u0010j\u001a\u00020\fH\u0096\u0004J\u0010\u0010k\u001a\u00020\u000f2\u0006\u00102\u001a\u00020/H\u0016J\u0011\u0010l\u001a\u00020\u00002\u0006\u0010j\u001a\u00020\fH\u0096\u0004J\b\u0010m\u001a\u00020\fH\u0016J\u0006\u0010n\u001a\u00020\u0000J\u0006\u0010o\u001a\u00020pJ\u0010\u0010q\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0011\u0010r\u001a\u00020%2\u0006\u0010s\u001a\u00020tH\u0086\u0002J\b\u0010u\u001a\u00020vH\u0016J\u000e\u0010w\u001a\u00020x2\u0006\u0010X\u001a\u00020\u0000J\b\u0010y\u001a\u00020%H\u0016J\u0010\u0010y\u001a\u00020%2\u0006\u0010z\u001a\u00020\fH\u0016J\u0015\u0010{\u001a\u00020%2\u0006\u0010z\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b|J\u0019\u0010}\u001a\u00020~H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0005\b\u007f\u0010\u0080\u0001J$\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u00102\u001a\u00020/H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001J$\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u00102\u001a\u00020/H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u0087\u0001\u0010\u0088\u0001J$\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u00102\u001a\u00020/H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u008b\u0001\u0010\u008c\u0001J\n\u0010\u008d\u0001\u001a\u00020\u0000H\u0096\u0002J$\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0006\u00102\u001a\u00020/H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u0090\u0001\u0010\u0091\u0001J\u0012\u0010\u0092\u0001\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0096\u0004R#\u0010\u001a\u001a\u00060\u0015j\u0002`\u0016X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0098\u0001"}, d2={"Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "Lcom/ionspin/kotlin/bignum/BigNumber;", "Lcom/ionspin/kotlin/bignum/CommonBigNumberOperations;", "Lcom/ionspin/kotlin/bignum/NarrowingOperations;", "Lcom/ionspin/kotlin/bignum/BitwiseCapable;", "", "", "Lcom/ionspin/kotlin/bignum/ByteArraySerializable;", "long", "", "(J)V", "int", "", "(I)V", "short", "", "(S)V", "byte", "", "(B)V", "wordArray", "Lkotlin/ULongArray;", "Lcom/ionspin/kotlin/bignum/integer/WordArray;", "requestedSign", "Lcom/ionspin/kotlin/bignum/integer/Sign;", "([JLcom/ionspin/kotlin/bignum/integer/Sign;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "magnitude", "getMagnitude-Y2RjT0g$bignum", "()[J", "[J", "numberOfWords", "getNumberOfWords", "()I", "sign", "getSign$bignum", "()Lcom/ionspin/kotlin/bignum/integer/Sign;", "stringRepresentation", "", "getStringRepresentation", "()Ljava/lang/String;", "setStringRepresentation", "(Ljava/lang/String;)V", "abs", "add", "other", "and", "bitAt", "", "position", "byteValue", "exactRequired", "compare", "compareDoubleAndBigInt", "double", "", "comparisonBlock", "Lkotlin/Function1;", "compareFloatAndBigInt", "float", "", "compareTo", "d1reciprocalRecursive", "dec", "divide", "divideAndRemainder", "Lkotlin/Pair;", "divrem", "Lcom/ionspin/kotlin/bignum/integer/BigInteger$QuotientAndRemainder;", "doubleValue", "equals", "floatValue", "gcd", "getCreator", "Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "getInstance", "hashCode", "inc", "intValue", "isResultZero", "resultMagnitude", "isResultZero-QwZRm1k", "([J)Z", "isZero", "javascriptNumberComparison", "number", "", "longValue", "mod", "modulo", "modInverse", "multiply", "naiveGcd", "negate", "not", "numberOfDecimalDigits", "or", "pow", "exponent", "rangeTo", "Lcom/ionspin/kotlin/bignum/integer/BigInteger$BigIntegerRange;", "remainder", "secureOverwrite", "", "setBitAt", "bit", "shl", "places", "shortValue", "shr", "signum", "sqrt", "sqrtAndRemainder", "Lcom/ionspin/kotlin/bignum/integer/BigInteger$SqareRootAndRemainder;", "subtract", "times", "char", "", "toByteArray", "", "toModularBigInteger", "Lcom/ionspin/kotlin/bignum/modular/ModularBigInteger;", "toString", "base", "toStringWithoutSign", "toStringWithoutSign$bignum", "toUByteArray", "Lkotlin/UByteArray;", "toUByteArray-TcUX1vc", "()[B", "ubyteValue", "Lkotlin/UByte;", "ubyteValue-Wa3L5BU", "(Z)B", "uintValue", "Lkotlin/UInt;", "uintValue-OGnWXxg", "(Z)I", "ulongValue", "Lkotlin/ULong;", "ulongValue-I7RO_PI", "(Z)J", "unaryMinus", "ushortValue", "Lkotlin/UShort;", "ushortValue-BwKQO78", "(Z)S", "xor", "BigIntegerIterator", "BigIntegerRange", "Companion", "QuotientAndRemainder", "SqareRootAndRemainder", "bignum"})
public final class BigInteger
implements BigNumber<BigInteger>,
CommonBigNumberOperations<BigInteger>,
NarrowingOperations<BigInteger>,
BitwiseCapable<BigInteger>,
Comparable<Object>,
ByteArraySerializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] magnitude;
    @NotNull
    private final Sign sign;
    private final int numberOfWords;
    @Nullable
    private String stringRepresentation;
    @NotNull
    private static final BigIntegerArithmetic arithmetic = ConfigurationKt.getChosenArithmetic();
    @NotNull
    private static final BigInteger ZERO = new BigInteger(arithmetic.getZERO-Y2RjT0g(), Sign.ZERO, null);
    @NotNull
    private static final BigInteger ONE = new BigInteger(arithmetic.getONE-Y2RjT0g(), Sign.POSITIVE, null);
    @NotNull
    private static final BigInteger TWO = new BigInteger(arithmetic.getTWO-Y2RjT0g(), Sign.POSITIVE, null);
    @NotNull
    private static final BigInteger TEN = new BigInteger(arithmetic.getTEN-Y2RjT0g(), Sign.POSITIVE, null);
    private static final double LOG_10_OF_2;

    private BigInteger(long[] wordArray, Sign requestedSign) {
        if (requestedSign == Sign.ZERO) {
            boolean bl = this.isResultZero-QwZRm1k(wordArray);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "sign should be Sign.ZERO iff magnitude has a value of 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        this.magnitude = BigInteger63Arithmetic.INSTANCE.removeLeadingZeros-JIhQxVY(wordArray);
        this.sign = this.isResultZero-QwZRm1k(this.getMagnitude-Y2RjT0g$bignum()) ? Sign.ZERO : requestedSign;
        this.numberOfWords = ULongArray.getSize-impl(this.getMagnitude-Y2RjT0g$bignum());
    }

    public BigInteger(long l) {
        Sign sign;
        long[] lArray = arithmetic.fromLong-DHQ6RzY(l);
        Companion companion = Companion;
        Comparable number$iv = Long.valueOf(l);
        boolean $i$f$determinSignFromNumber = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(Long.class);
        if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long cfr_ignored_0 = (Long)number$iv;
            sign = ((Number)((Object)number$iv)).longValue() < 0L ? Sign.NEGATIVE : (((Number)((Object)number$iv)).longValue() > 0L ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer cfr_ignored_1 = (Integer)number$iv;
            sign = ((Number)((Object)number$iv)).intValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).intValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Short cfr_ignored_2 = (Short)number$iv;
            sign = ((Number)((Object)number$iv)).shortValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).shortValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Byte cfr_ignored_3 = (Byte)number$iv;
            sign = ((Number)((Object)number$iv)).byteValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).byteValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else {
            throw new RuntimeException(Intrinsics.stringPlus("Unsupported type ", Reflection.getOrCreateKotlinClass(Long.class)));
        }
        this(lArray, sign, null);
    }

    public BigInteger(int n) {
        Sign sign;
        long[] lArray = arithmetic.fromInt-DHQ6RzY(n);
        Companion companion = Companion;
        Comparable number$iv = Integer.valueOf(n);
        boolean $i$f$determinSignFromNumber = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(Integer.class);
        if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long cfr_ignored_0 = (Long)number$iv;
            sign = ((Number)((Object)number$iv)).longValue() < 0L ? Sign.NEGATIVE : (((Number)((Object)number$iv)).longValue() > 0L ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer cfr_ignored_1 = (Integer)number$iv;
            sign = ((Number)((Object)number$iv)).intValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).intValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Short cfr_ignored_2 = (Short)number$iv;
            sign = ((Number)((Object)number$iv)).shortValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).shortValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Byte cfr_ignored_3 = (Byte)number$iv;
            sign = ((Number)((Object)number$iv)).byteValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).byteValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else {
            throw new RuntimeException(Intrinsics.stringPlus("Unsupported type ", Reflection.getOrCreateKotlinClass(Integer.class)));
        }
        this(lArray, sign, null);
    }

    public BigInteger(short s) {
        Sign sign;
        long[] lArray = arithmetic.fromShort-DHQ6RzY(s);
        Companion companion = Companion;
        Comparable number$iv = Short.valueOf(s);
        boolean $i$f$determinSignFromNumber = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(Short.class);
        if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long cfr_ignored_0 = (Long)number$iv;
            sign = ((Number)((Object)number$iv)).longValue() < 0L ? Sign.NEGATIVE : (((Number)((Object)number$iv)).longValue() > 0L ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer cfr_ignored_1 = (Integer)number$iv;
            sign = ((Number)((Object)number$iv)).intValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).intValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Short cfr_ignored_2 = (Short)number$iv;
            sign = ((Number)((Object)number$iv)).shortValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).shortValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Byte cfr_ignored_3 = (Byte)number$iv;
            sign = ((Number)((Object)number$iv)).byteValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).byteValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else {
            throw new RuntimeException(Intrinsics.stringPlus("Unsupported type ", Reflection.getOrCreateKotlinClass(Short.class)));
        }
        this(lArray, sign, null);
    }

    public BigInteger(byte by) {
        Sign sign;
        long[] lArray = arithmetic.fromByte-DHQ6RzY(by);
        Companion companion = Companion;
        Comparable number$iv = Byte.valueOf(by);
        boolean $i$f$determinSignFromNumber = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(Byte.class);
        if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long cfr_ignored_0 = (Long)number$iv;
            sign = ((Number)((Object)number$iv)).longValue() < 0L ? Sign.NEGATIVE : (((Number)((Object)number$iv)).longValue() > 0L ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer cfr_ignored_1 = (Integer)number$iv;
            sign = ((Number)((Object)number$iv)).intValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).intValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Short cfr_ignored_2 = (Short)number$iv;
            sign = ((Number)((Object)number$iv)).shortValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).shortValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Byte cfr_ignored_3 = (Byte)number$iv;
            sign = ((Number)((Object)number$iv)).byteValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number$iv)).byteValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
        } else {
            throw new RuntimeException(Intrinsics.stringPlus("Unsupported type ", Reflection.getOrCreateKotlinClass(Byte.class)));
        }
        this(lArray, sign, null);
    }

    @Override
    @NotNull
    public BigNumber.Creator<BigInteger> getCreator() {
        return Companion;
    }

    @Override
    @NotNull
    public BigInteger getInstance() {
        return this;
    }

    @NotNull
    public final long[] getMagnitude-Y2RjT0g$bignum() {
        return this.magnitude;
    }

    @NotNull
    public final Sign getSign$bignum() {
        return this.sign;
    }

    private final boolean isResultZero-QwZRm1k(long[] resultMagnitude) {
        return arithmetic.compare-GR1PJdc(resultMagnitude, arithmetic.getZERO-Y2RjT0g()) == 0;
    }

    public final int getNumberOfWords() {
        return this.numberOfWords;
    }

    @Nullable
    public final String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public final void setStringRepresentation(@Nullable String string) {
        this.stringRepresentation = string;
    }

    @Override
    @NotNull
    public BigInteger add(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int comparison = arithmetic.compare-GR1PJdc(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum());
        if (other.sign == this.sign) {
            return new BigInteger(arithmetic.add-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), this.sign, null);
        }
        return comparison > 0 ? new BigInteger(arithmetic.subtract-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), this.sign, null) : (comparison < 0 ? new BigInteger(arithmetic.subtract-j68ebKY(other.getMagnitude-Y2RjT0g$bignum(), this.getMagnitude-Y2RjT0g$bignum()), other.sign, null) : ZERO);
    }

    @Override
    @NotNull
    public BigInteger subtract(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int comparison = arithmetic.compare-GR1PJdc(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum());
        if (Intrinsics.areEqual(this, ZERO)) {
            return other.negate();
        }
        if (Intrinsics.areEqual(other, ZERO)) {
            return this;
        }
        if (other.sign == this.sign) {
        } else {
            return new BigInteger(arithmetic.add-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), this.sign, null);
        }
        return comparison > 0 ? new BigInteger(arithmetic.subtract-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), this.sign, null) : (comparison < 0 ? new BigInteger(arithmetic.subtract-j68ebKY(other.getMagnitude-Y2RjT0g$bignum(), this.getMagnitude-Y2RjT0g$bignum()), this.sign.not(), null) : ZERO);
    }

    @Override
    @NotNull
    public BigInteger multiply(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.isZero() || other.isZero()) {
            return ZERO;
        }
        if (Intrinsics.areEqual(other, ONE)) {
            return this;
        }
        Sign sign = this.sign != other.sign ? Sign.NEGATIVE : Sign.POSITIVE;
        return sign == Sign.POSITIVE ? new BigInteger(arithmetic.multiply-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), sign, null) : new BigInteger(arithmetic.multiply-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), sign, null);
    }

    @Override
    @NotNull
    public BigInteger divide(@NotNull BigInteger other) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter(other, "other");
        if (other.isZero()) {
            throw new ArithmeticException("Division by zero! " + this + " / " + other);
        }
        long[] result2 = arithmetic.divide-GR1PJdc(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()).getFirst().unbox-impl();
        if (ULongArray.equals-impl0(result2, arithmetic.getZERO-Y2RjT0g())) {
            bigInteger = ZERO;
        } else {
            Sign sign = this.sign != other.sign ? Sign.NEGATIVE : Sign.POSITIVE;
            bigInteger = new BigInteger(result2, sign, null);
        }
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger remainder(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (other.isZero()) {
            throw new ArithmeticException("Division by zero! " + this + " / " + other);
        }
        Sign sign = this.sign != other.sign ? Sign.NEGATIVE : Sign.POSITIVE;
        long[] result2 = arithmetic.divide-GR1PJdc(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()).getSecond().unbox-impl();
        if (ULongArray.equals-impl0(result2, arithmetic.getZERO-Y2RjT0g())) {
            sign = Sign.ZERO;
        }
        return new BigInteger(result2, sign, null);
    }

    @Override
    @NotNull
    public Pair<BigInteger, BigInteger> divideAndRemainder(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (other.isZero()) {
            throw new ArithmeticException("Division by zero! " + this + " / " + other);
        }
        Sign sign = this.sign != other.sign ? Sign.NEGATIVE : Sign.POSITIVE;
        Pair<ULongArray, ULongArray> result2 = arithmetic.divide-GR1PJdc(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum());
        BigInteger quotient = ULongArray.equals-impl0(result2.getFirst().unbox-impl(), arithmetic.getZERO-Y2RjT0g()) ? ZERO : new BigInteger(result2.getFirst().unbox-impl(), sign, null);
        BigInteger remainder = ULongArray.equals-impl0(result2.getSecond().unbox-impl(), arithmetic.getZERO-Y2RjT0g()) ? ZERO : new BigInteger(result2.getSecond().unbox-impl(), this.sign, null);
        return new Pair<BigInteger, BigInteger>(quotient, remainder);
    }

    private final BigInteger d1reciprocalRecursive() {
        return new BigInteger(arithmetic.reciprocal-QwZRm1k(this.getMagnitude-Y2RjT0g$bignum()).getFirst().unbox-impl(), this.sign, null);
    }

    @NotNull
    public final BigInteger sqrt() {
        return new BigInteger(arithmetic.sqrt-QwZRm1k(this.getMagnitude-Y2RjT0g$bignum()).getFirst().unbox-impl(), this.sign, null);
    }

    @NotNull
    public final SqareRootAndRemainder sqrtAndRemainder() {
        return new SqareRootAndRemainder(new BigInteger(arithmetic.sqrt-QwZRm1k(this.getMagnitude-Y2RjT0g$bignum()).getFirst().unbox-impl(), this.sign, null), new BigInteger(arithmetic.sqrt-QwZRm1k(this.getMagnitude-Y2RjT0g$bignum()).getSecond().unbox-impl(), this.sign, null));
    }

    @NotNull
    public final BigInteger gcd(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new BigInteger(arithmetic.gcd-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), Sign.POSITIVE, null);
    }

    private final BigInteger naiveGcd(BigInteger other) {
        BigInteger u = this;
        BigInteger v = other;
        while (!Intrinsics.areEqual(v, ZERO)) {
            BigInteger tmpU = u;
            u = v;
            v = (BigInteger)tmpU.rem((BigNumber)v);
        }
        return u;
    }

    @NotNull
    public final BigInteger modInverse(@NotNull BigInteger modulo) {
        Intrinsics.checkNotNullParameter(modulo, "modulo");
        if (!Intrinsics.areEqual(this.gcd(modulo), ONE)) {
            throw new ArithmeticException("BigInteger is not invertible. This and modulus are not relatively prime (coprime)");
        }
        BigInteger u = ONE;
        BigInteger w = ZERO;
        BigInteger b = this;
        BigInteger c = modulo;
        while (!Intrinsics.areEqual(c, ZERO)) {
            QuotientAndRemainder quotientAndRemainder = b.divrem(c);
            BigInteger q2 = quotientAndRemainder.component1();
            BigInteger r2 = quotientAndRemainder.component2();
            b = c;
            c = r2;
            BigInteger tmpU = u;
            u = w;
            w = (BigInteger)tmpU.minus(q2.times((BigNumber)w));
        }
        return u;
    }

    @NotNull
    public final BigInteger mod(@NotNull BigInteger modulo) {
        Intrinsics.checkNotNullParameter(modulo, "modulo");
        BigInteger result2 = (BigInteger)this.rem((BigNumber)modulo);
        return result2.compareTo((Object)0) < 0 ? (BigInteger)result2.plus((BigNumber)modulo) : result2;
    }

    public final int compare(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.isZero() && other.isZero()) {
            return 0;
        }
        if (other.isZero() && this.sign == Sign.POSITIVE) {
            return 1;
        }
        if (other.isZero() && this.sign == Sign.NEGATIVE) {
            return -1;
        }
        if (this.isZero() && other.sign == Sign.POSITIVE) {
            return -1;
        }
        if (this.isZero() && other.sign == Sign.NEGATIVE) {
            return 1;
        }
        if (this.sign != other.sign) {
            return this.sign == Sign.POSITIVE ? 1 : -1;
        }
        int result2 = arithmetic.compare-GR1PJdc(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum());
        return this.sign == Sign.NEGATIVE && other.sign == Sign.NEGATIVE ? result2 * -1 : result2;
    }

    @Override
    public boolean isZero() {
        return this.sign == Sign.ZERO || ConfigurationKt.getChosenArithmetic().compare-GR1PJdc(this.getMagnitude-Y2RjT0g$bignum(), ConfigurationKt.getChosenArithmetic().getZERO-Y2RjT0g()) == 0;
    }

    @Override
    @NotNull
    public BigInteger negate() {
        return new BigInteger(this.getMagnitude-Y2RjT0g$bignum(), this.sign.not(), null);
    }

    @Override
    @NotNull
    public BigInteger abs() {
        return new BigInteger(this.getMagnitude-Y2RjT0g$bignum(), Sign.POSITIVE, null);
    }

    @NotNull
    public final BigInteger pow(@NotNull BigInteger exponent2) {
        Intrinsics.checkNotNullParameter(exponent2, "exponent");
        if (exponent2.compareTo((Object)Long.MAX_VALUE) <= 0) {
            long l = ULongArray.get-s-VKNKU(exponent2.getMagnitude-Y2RjT0g$bignum(), 0);
            boolean bl = false;
            return this.pow(l);
        }
        BigInteger counter = exponent2;
        BigInteger result2 = ONE;
        while (counter.compareTo((Object)0) > 0) {
            BigInteger bigInteger = counter;
            counter = bigInteger.dec();
            result2 = (BigInteger)result2.times((BigNumber)this);
        }
        return result2;
    }

    @Override
    @NotNull
    public BigInteger pow(long exponent2) {
        BigInteger bigInteger;
        if (exponent2 < 0L) {
            throw new ArithmeticException("Negative exponent not supported with BigInteger");
        }
        BigInteger bigInteger2 = this;
        if (Intrinsics.areEqual(bigInteger2, ZERO)) {
            bigInteger = ZERO;
        } else if (Intrinsics.areEqual(bigInteger2, ONE)) {
            bigInteger = ONE;
        } else {
            Sign sign = this.sign == Sign.NEGATIVE ? (exponent2 % (long)2 == 0L ? Sign.POSITIVE : Sign.NEGATIVE) : Sign.POSITIVE;
            bigInteger = new BigInteger(arithmetic.pow-GERUpyg(this.getMagnitude-Y2RjT0g$bignum(), exponent2), sign, null);
        }
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger pow(int exponent2) {
        return this.pow((long)exponent2);
    }

    @Override
    public int signum() {
        int n;
        Sign sign = this.sign;
        int n2 = WhenMappings.$EnumSwitchMapping$0[sign.ordinal()];
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = -1;
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Override
    public boolean bitAt(long position) {
        return arithmetic.bitAt-tBf0fek(this.getMagnitude-Y2RjT0g$bignum(), position);
    }

    @Override
    @NotNull
    public BigInteger setBitAt(long position, boolean bit) {
        return new BigInteger(arithmetic.setBitAt-v3PXmpk(this.getMagnitude-Y2RjT0g$bignum(), position, bit), this.sign, null);
    }

    @Override
    public long numberOfDecimalDigits() {
        if (this.isZero()) {
            return 1L;
        }
        int bitLenght = arithmetic.bitLength-QwZRm1k(this.getMagnitude-Y2RjT0g$bignum());
        double d2 = (double)(bitLenght - 1) * LOG_10_OF_2;
        boolean bl = false;
        double minDigit = Math.ceil(d2);
        BigInteger tmp = (BigInteger)this.div((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow((int)minDigit));
        long counter = 0L;
        while (tmp.compareTo((Object)0) != 0) {
            tmp = (BigInteger)tmp.div(10);
            long l = counter;
            counter = l + 1L;
        }
        return counter + (long)((int)minDigit);
    }

    @Override
    @NotNull
    public BigInteger shl(int places) {
        return new BigInteger(arithmetic.shiftLeft-GERUpyg(this.getMagnitude-Y2RjT0g$bignum(), places), this.sign, null);
    }

    @Override
    @NotNull
    public BigInteger shr(int places) {
        BigInteger result2 = new BigInteger(arithmetic.shiftRight-GERUpyg(this.getMagnitude-Y2RjT0g$bignum(), places), this.sign, null);
        if (ULongArray.equals-impl0(result2.getMagnitude-Y2RjT0g$bignum(), arithmetic.getZERO-Y2RjT0g())) {
            return ZERO;
        }
        return result2;
    }

    @Override
    @NotNull
    public BigInteger unaryMinus() {
        return this.negate();
    }

    @Override
    public void secureOverwrite() {
        int n = 0;
        int n2 = ULongArray.getSize-impl(this.getMagnitude-Y2RjT0g$bignum());
        if (n < n2) {
            do {
                int i2 = n++;
                ULongArray.set-k8EXiF4(this.getMagnitude-Y2RjT0g$bignum(), i2, 0L);
            } while (n < n2);
        }
    }

    @NotNull
    public final BigInteger dec() {
        return (BigInteger)this.minus((BigNumber)ONE);
    }

    @NotNull
    public final BigInteger inc() {
        return (BigInteger)this.plus((BigNumber)ONE);
    }

    @NotNull
    public final QuotientAndRemainder divrem(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Pair<BigInteger, BigInteger> result2 = this.divideAndRemainder(other);
        return new QuotientAndRemainder(result2.getFirst(), result2.getSecond());
    }

    @Override
    @NotNull
    public BigInteger and(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new BigInteger(arithmetic.and-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), this.sign, null);
    }

    @Override
    @NotNull
    public BigInteger or(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new BigInteger(arithmetic.or-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum()), this.sign, null);
    }

    @Override
    @NotNull
    public BigInteger xor(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        long[] resultMagnitude = arithmetic.xor-j68ebKY(this.getMagnitude-Y2RjT0g$bignum(), other.getMagnitude-Y2RjT0g$bignum());
        Sign resultSign = this.isNegative() ^ other.isNegative() ? Sign.NEGATIVE : (this.isResultZero-QwZRm1k(resultMagnitude) ? Sign.ZERO : Sign.POSITIVE);
        return new BigInteger(resultMagnitude, resultSign, null);
    }

    @Override
    @NotNull
    public BigInteger not() {
        return new BigInteger(arithmetic.not-JIhQxVY(this.getMagnitude-Y2RjT0g$bignum()), this.sign, null);
    }

    @Override
    public int compareTo(@NotNull Object other) {
        int n;
        Intrinsics.checkNotNullParameter(other, "other");
        if (other instanceof Number && ComparisonWorkaround.INSTANCE.isSpecialHandlingForFloatNeeded((Number)other)) {
            return this.javascriptNumberComparison((Number)other);
        }
        Object object = other;
        if (object instanceof BigInteger) {
            n = this.compare((BigInteger)other);
        } else if (object instanceof Long) {
            n = this.compare(Companion.fromLong(((Number)other).longValue()));
        } else if (object instanceof Integer) {
            n = this.compare(Companion.fromInt(((Number)other).intValue()));
        } else if (object instanceof Short) {
            n = this.compare(Companion.fromShort(((Number)other).shortValue()));
        } else if (object instanceof Byte) {
            n = this.compare(Companion.fromByte(((Number)other).byteValue()));
        } else if (object instanceof ULong) {
            n = this.compare(Companion.fromULong-VKZWuLQ(((ULong)other).unbox-impl()));
        } else if (object instanceof UInt) {
            n = this.compare(Companion.fromUInt-WZ4Q5Ns(((UInt)other).unbox-impl()));
        } else if (object instanceof UShort) {
            n = this.compare(Companion.fromUShort-xj2QHRw(((UShort)other).unbox-impl()));
        } else if (object instanceof UByte) {
            n = this.compare(Companion.fromUByte-7apg3OU(((UByte)other).unbox-impl()));
        } else if (object instanceof Float) {
            n = this.compareFloatAndBigInt(((Number)other).floatValue(), (Function1<? super BigInteger, Integer>)new Function1<BigInteger, Integer>(this){
                final /* synthetic */ BigInteger this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final int invoke(@NotNull BigInteger it2) {
                    Intrinsics.checkNotNullParameter(it2, "it");
                    return this.this$0.compare(it2);
                }
            });
        } else if (object instanceof Double) {
            n = this.compareDoubleAndBigInt(((Number)other).doubleValue(), (Function1<? super BigInteger, Integer>)new Function1<BigInteger, Integer>(this){
                final /* synthetic */ BigInteger this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final int invoke(@NotNull BigInteger it2) {
                    Intrinsics.checkNotNullParameter(it2, "it");
                    return this.this$0.compare(it2);
                }
            });
        } else {
            throw new RuntimeException(Intrinsics.stringPlus("Invalid comparison type for BigInteger: ", Reflection.getOrCreateKotlinClass(other.getClass())));
        }
        return n;
    }

    private final int javascriptNumberComparison(Number number) {
        float f = number.floatValue();
        return f % 1.0f == 0.0f ? this.compare(Companion.fromLong(number.longValue())) : this.compareFloatAndBigInt(number.floatValue(), (Function1<? super BigInteger, Integer>)new Function1<BigInteger, Integer>(this){
            final /* synthetic */ BigInteger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final int invoke(@NotNull BigInteger it2) {
                Intrinsics.checkNotNullParameter(it2, "it");
                return this.this$0.compare(it2);
            }
        });
    }

    public final int compareFloatAndBigInt(float f, @NotNull Function1<? super BigInteger, Integer> comparisonBlock) {
        int comparisonResult;
        boolean hasDecimalPart;
        Intrinsics.checkNotNullParameter(comparisonBlock, "comparisonBlock");
        boolean bl = false;
        float withoutDecimalPart = (float)Math.floor(f);
        boolean bl2 = hasDecimalPart = !(f % 1.0f == 0.0f);
        return hasDecimalPart ? ((comparisonResult = ((Number)comparisonBlock.invoke((BigInteger)BigNumber.Creator.DefaultImpls.tryFromFloat$default(Companion, withoutDecimalPart + 1.0f, false, 2, null))).intValue()) == 0 ? 1 : comparisonResult) : ((Number)comparisonBlock.invoke((BigInteger)BigNumber.Creator.DefaultImpls.tryFromFloat$default(Companion, withoutDecimalPart, false, 2, null))).intValue();
    }

    public final int compareDoubleAndBigInt(double d2, @NotNull Function1<? super BigInteger, Integer> comparisonBlock) {
        int comparisonResult;
        boolean hasDecimalPart;
        Intrinsics.checkNotNullParameter(comparisonBlock, "comparisonBlock");
        boolean bl = false;
        double withoutDecimalPart = Math.floor(d2);
        boolean bl2 = hasDecimalPart = !(d2 % 1.0 == 0.0);
        return hasDecimalPart ? ((comparisonResult = ((Number)comparisonBlock.invoke((BigInteger)BigNumber.Creator.DefaultImpls.tryFromDouble$default(Companion, withoutDecimalPart + 1.0, false, 2, null))).intValue()) == 0 ? 1 : comparisonResult) : ((Number)comparisonBlock.invoke((BigInteger)BigNumber.Creator.DefaultImpls.tryFromDouble$default(Companion, withoutDecimalPart, false, 2, null))).intValue();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        Object object = other;
        int comparison = object instanceof BigInteger ? this.compare((BigInteger)other) : (object instanceof Long ? this.compare(Companion.fromLong(((Number)other).longValue())) : (object instanceof Integer ? this.compare(Companion.fromInt(((Number)other).intValue())) : (object instanceof Short ? this.compare(Companion.fromShort(((Number)other).shortValue())) : (object instanceof Byte ? this.compare(Companion.fromByte(((Number)other).byteValue())) : (object instanceof ULong ? this.compare(Companion.fromULong-VKZWuLQ(((ULong)other).unbox-impl())) : (object instanceof UInt ? this.compare(Companion.fromUInt-WZ4Q5Ns(((UInt)other).unbox-impl())) : (object instanceof UShort ? this.compare(Companion.fromUShort-xj2QHRw(((UShort)other).unbox-impl())) : (object instanceof UByte ? this.compare(Companion.fromUByte-7apg3OU(((UByte)other).unbox-impl())) : -1))))))));
        return comparison == 0;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        long[] lArray = this.getMagnitude-Y2RjT0g$bignum();
        int n = 0;
        boolean bl = false;
        int n2 = n;
        long[] lArray2 = lArray;
        int n3 = lArray2.length;
        for (int j = 0; j < n3; ++j) {
            void uLong;
            long l;
            long l2 = l = lArray2[j];
            int acc = n2;
            boolean bl2 = false;
            n2 = acc + ULong.hashCode-impl((long)uLong);
        }
        return n2 + this.sign.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.toString(10);
    }

    @Override
    @NotNull
    public String toString(int base) {
        String sign = this.sign == Sign.NEGATIVE ? "-" : "";
        return Intrinsics.stringPlus(sign, this.toStringWithoutSign$bignum(base));
    }

    @NotNull
    public final String toStringWithoutSign$bignum(int base) {
        return arithmetic.toString-tBf0fek(this.getMagnitude-Y2RjT0g$bignum(), base);
    }

    @Override
    @NotNull
    public final String times(char c) {
        Object object;
        if (this.compareTo((Object)0) < 0) {
            throw new RuntimeException("Char cannot be multiplied with negative number");
        }
        BigInteger counter = this;
        StringBuilder stringBuilder = new StringBuilder();
        while (counter.compareTo((Object)0) > 0) {
            stringBuilder.append(c);
            object = counter;
            counter = ((BigInteger)object).dec();
        }
        object = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(object, "stringBuilder.toString()");
        return object;
    }

    @NotNull
    public final ModularBigInteger toModularBigInteger(@NotNull BigInteger modulo) {
        Intrinsics.checkNotNullParameter(modulo, "modulo");
        BigNumber.Creator<ModularBigInteger> creator = ModularBigInteger.Companion.creatorForModulo(modulo);
        return creator.fromBigInteger(this);
    }

    @Override
    public int intValue(boolean exactRequired) {
        if (exactRequired && (this.compareTo((Object)Integer.MAX_VALUE) > 0 || this.compareTo((Object)Integer.MIN_VALUE) < 0)) {
            throw new ArithmeticException("Cannot convert to int and provide exact value");
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        boolean bl = false;
        return (int)l * this.signum();
    }

    @Override
    public long longValue(boolean exactRequired) {
        if (exactRequired && (this.compareTo((Object)Long.MAX_VALUE) > 0 || this.compareTo((Object)Long.MIN_VALUE) < 0)) {
            throw new ArithmeticException("Cannot convert to long and provide exact value");
        }
        if (ULongArray.getSize-impl(this.getMagnitude-Y2RjT0g$bignum()) <= 1) {
            long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
            boolean bl = false;
            return l;
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 1);
        int n = 63;
        boolean bl = false;
        long firstBit = ULong.constructor-impl(l << n);
        l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        n = 0;
        boolean bl2 = false;
        return (l | firstBit) * (long)this.signum();
    }

    @Override
    public byte byteValue(boolean exactRequired) {
        if (exactRequired && (this.compareTo((Object)127) > 0 || this.compareTo((Object)-128) < 0)) {
            throw new ArithmeticException("Cannot convert to byte and provide exact value");
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        boolean bl = false;
        return (byte)((byte)l * this.signum());
    }

    @Override
    public short shortValue(boolean exactRequired) {
        if (exactRequired && (this.compareTo((Object)Short.MAX_VALUE) > 0 || this.compareTo((Object)Short.MIN_VALUE) < 0)) {
            throw new ArithmeticException("Cannot convert to short and provide exact value");
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        boolean bl = false;
        return (short)((short)l * this.signum());
    }

    @Override
    public int uintValue-OGnWXxg(boolean exactRequired) {
        if (exactRequired && (this.compareTo(UInt.box-impl(-1)) > 0 || this.isNegative())) {
            throw new ArithmeticException("Cannot convert to unsigned int and provide exact value");
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        boolean bl = false;
        long l2 = l;
        boolean bl2 = false;
        return UInt.constructor-impl((int)l2);
    }

    @Override
    public long ulongValue-I7RO_PI(boolean exactRequired) {
        if (exactRequired && (this.compareTo(ULong.box-impl(-1L)) > 0 || this.isNegative())) {
            throw new ArithmeticException("Cannot convert to unsigned long and provide exact value");
        }
        if (ULongArray.getSize-impl(this.getMagnitude-Y2RjT0g$bignum()) <= 1) {
            return ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 1);
        int n = 63;
        boolean bl = false;
        long firstBit = ULong.constructor-impl(l << n);
        l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        n = 0;
        return ULong.constructor-impl(l | firstBit);
    }

    @Override
    public byte ubyteValue-Wa3L5BU(boolean exactRequired) {
        if (exactRequired) {
            int n = -1;
            boolean bl = false;
            if (this.compareTo(UInt.box-impl(UInt.constructor-impl(n & 0xFF))) > 0 || this.isNegative()) {
                throw new ArithmeticException("Cannot convert to unsigned byte and provide exact value");
            }
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        boolean bl = false;
        long l2 = l;
        boolean bl2 = false;
        return UByte.constructor-impl((byte)l2);
    }

    @Override
    public short ushortValue-BwKQO78(boolean exactRequired) {
        block4: {
            block3: {
                block2: {
                    if (!exactRequired) break block2;
                    int n = -1;
                    boolean bl = false;
                    if (this.compareTo(UInt.box-impl(UInt.constructor-impl(n & 0xFFFF))) > 0) break block3;
                }
                if (!this.isNegative()) break block4;
            }
            throw new ArithmeticException("Cannot convert to unsigned short and provide exact value");
        }
        long l = ULongArray.get-s-VKNKU(this.getMagnitude-Y2RjT0g$bignum(), 0);
        boolean bl = false;
        long l2 = l;
        boolean bl2 = false;
        return UShort.constructor-impl((short)l2);
    }

    @Override
    public float floatValue(boolean exactRequired) {
        if (exactRequired && this.abs().compareTo(Float.valueOf(Float.MAX_VALUE)) > 0) {
            throw new ArithmeticException("Cannot convert to float and provide exact value");
        }
        String string = this.toString();
        boolean bl = false;
        return Float.parseFloat(string);
    }

    @Override
    public double doubleValue(boolean exactRequired) {
        if (exactRequired && this.abs().compareTo((Object)Double.MAX_VALUE) > 0) {
            throw new ArithmeticException("Cannot convert to float and provide exact value");
        }
        String string = this.toString();
        boolean bl = false;
        return Double.parseDouble(string);
    }

    @Override
    @NotNull
    public byte[] toUByteArray-TcUX1vc() {
        return arithmetic.toUByteArray-cMszsnM(this.getMagnitude-Y2RjT0g$bignum());
    }

    @Override
    @NotNull
    public byte[] toByteArray() {
        return arithmetic.toByteArray-QwZRm1k(this.getMagnitude-Y2RjT0g$bignum());
    }

    @NotNull
    public final BigIntegerRange rangeTo(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new BigIntegerRange(this, other);
    }

    @Override
    @NotNull
    public BigInteger div(byte by) {
        return CommonBigNumberOperations.DefaultImpls.div(this, by);
    }

    @Override
    @NotNull
    public BigInteger div(int n) {
        return CommonBigNumberOperations.DefaultImpls.div(this, n);
    }

    @Override
    @NotNull
    public BigInteger div(long l) {
        return CommonBigNumberOperations.DefaultImpls.div(this, l);
    }

    @Override
    @NotNull
    public BigInteger div(@NotNull BigInteger other) {
        return (BigInteger)CommonBigNumberOperations.DefaultImpls.div(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public BigInteger div(short s) {
        return CommonBigNumberOperations.DefaultImpls.div(this, s);
    }

    @Override
    @NotNull
    public BigInteger minus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, by);
    }

    @Override
    @NotNull
    public BigInteger minus(int n) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, n);
    }

    @Override
    @NotNull
    public BigInteger minus(long l) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, l);
    }

    @Override
    @NotNull
    public BigInteger minus(@NotNull BigInteger other) {
        return (BigInteger)CommonBigNumberOperations.DefaultImpls.minus(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public BigInteger minus(short s) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, s);
    }

    @Override
    @NotNull
    public BigInteger plus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, by);
    }

    @Override
    @NotNull
    public BigInteger plus(int n) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, n);
    }

    @Override
    @NotNull
    public BigInteger plus(long l) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, l);
    }

    @Override
    @NotNull
    public BigInteger plus(@NotNull BigInteger other) {
        return (BigInteger)CommonBigNumberOperations.DefaultImpls.plus(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public BigInteger plus(short s) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, s);
    }

    @Override
    @NotNull
    public BigInteger rem(byte by) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, by);
    }

    @Override
    @NotNull
    public BigInteger rem(int n) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, n);
    }

    @Override
    @NotNull
    public BigInteger rem(long l) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, l);
    }

    @Override
    @NotNull
    public BigInteger rem(@NotNull BigInteger other) {
        return (BigInteger)CommonBigNumberOperations.DefaultImpls.rem(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public BigInteger rem(short s) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, s);
    }

    @Override
    @NotNull
    public BigInteger times(byte by) {
        return CommonBigNumberOperations.DefaultImpls.times(this, by);
    }

    @Override
    @NotNull
    public BigInteger times(int n) {
        return CommonBigNumberOperations.DefaultImpls.times(this, n);
    }

    @Override
    @NotNull
    public BigInteger times(long l) {
        return CommonBigNumberOperations.DefaultImpls.times(this, l);
    }

    @Override
    @NotNull
    public BigInteger times(@NotNull BigInteger other) {
        return (BigInteger)CommonBigNumberOperations.DefaultImpls.times(this, (BigNumber)other);
    }

    @Override
    @NotNull
    public BigInteger times(short s) {
        return CommonBigNumberOperations.DefaultImpls.times(this, s);
    }

    @Override
    public boolean isNegative() {
        return BigNumber.DefaultImpls.isNegative(this);
    }

    @Override
    public boolean isPositive() {
        return BigNumber.DefaultImpls.isPositive(this);
    }

    public /* synthetic */ BigInteger(long[] wordArray, Sign requestedSign, DefaultConstructorMarker $constructor_marker) {
        this(wordArray, requestedSign);
    }

    static {
        double d2 = 2.0;
        boolean bl = false;
        LOG_10_OF_2 = Math.log10(d2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u0015\u001a\u00020\u0016\"\u0006\b\u0000\u0010\u0017\u0018\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0082\bJ\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0016J\u001d\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b/\u00100J%\u00101\u001a\u00020\u00022\u0006\u0010 \u001a\u0002022\u0006\u0010\"\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b3\u00104J\u001d\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u000207H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b8\u00109J\u001d\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b=\u0010>J\u001d\u0010?\u001a\u00020\u00022\u0006\u0010@\u001a\u00020AH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bB\u0010CJ)\u0010D\u001a\u00020\u00022\n\u0010E\u001a\u00060Fj\u0002`G2\u0006\u0010\"\u001a\u00020\u0016H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bH\u0010IJ\u0018\u0010J\u001a\u00020\u00022\u0006\u0010K\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u0002H\u0016J\u0018\u0010M\u001a\u00020\u00022\u0006\u0010K\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u0002H\u0016J\u0018\u0010N\u001a\u00020\u00022\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020%H\u0016J\u0018\u0010R\u001a\u00020\u00022\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020UH\u0016J\u0018\u0010V\u001a\u00020\u00022\u0006\u0010W\u001a\u00020X2\u0006\u0010T\u001a\u00020UH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006Y"}, d2={"Lcom/ionspin/kotlin/bignum/integer/BigInteger$Companion;", "Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "Lcom/ionspin/kotlin/bignum/BigNumber$Util;", "Lcom/ionspin/kotlin/bignum/ByteArrayDeserializable;", "()V", "LOG_10_OF_2", "", "getLOG_10_OF_2", "()D", "ONE", "getONE", "()Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "TEN", "getTEN", "TWO", "getTWO", "ZERO", "getZERO", "arithmetic", "Lcom/ionspin/kotlin/bignum/integer/BigIntegerArithmetic;", "determinSignFromNumber", "Lcom/ionspin/kotlin/bignum/integer/Sign;", "T", "number", "", "fromBigInteger", "bigInteger", "fromByte", "byte", "", "fromByteArray", "source", "", "sign", "fromInt", "int", "", "fromLong", "long", "", "fromShort", "short", "", "fromUByte", "uByte", "Lkotlin/UByte;", "fromUByte-7apg3OU", "(B)Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "fromUByteArray", "Lkotlin/UByteArray;", "fromUByteArray-rto03Yo", "([BLcom/ionspin/kotlin/bignum/integer/Sign;)Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "fromUInt", "uInt", "Lkotlin/UInt;", "fromUInt-WZ4Q5Ns", "(I)Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "fromULong", "uLong", "Lkotlin/ULong;", "fromULong-VKZWuLQ", "(J)Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "fromUShort", "uShort", "Lkotlin/UShort;", "fromUShort-xj2QHRw", "(S)Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "fromWordArray", "wordArray", "Lkotlin/ULongArray;", "Lcom/ionspin/kotlin/bignum/integer/WordArray;", "fromWordArray-tBf0fek$bignum", "([JLcom/ionspin/kotlin/bignum/integer/Sign;)Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "max", "first", "second", "min", "parseString", "string", "", "base", "tryFromDouble", "double", "exactRequired", "", "tryFromFloat", "float", "", "bignum"})
    public static final class Companion
    implements BigNumber.Creator<BigInteger>,
    BigNumber.Util<BigInteger>,
    ByteArrayDeserializable<BigInteger> {
        private Companion() {
        }

        @Override
        @NotNull
        public BigInteger getZERO() {
            return ZERO;
        }

        @Override
        @NotNull
        public BigInteger getONE() {
            return ONE;
        }

        @Override
        @NotNull
        public BigInteger getTWO() {
            return TWO;
        }

        @Override
        @NotNull
        public BigInteger getTEN() {
            return TEN;
        }

        public final double getLOG_10_OF_2() {
            return LOG_10_OF_2;
        }

        @Override
        @NotNull
        public BigInteger parseString(@NotNull String string, int base) {
            BigInteger bigInteger;
            boolean signed;
            Intrinsics.checkNotNullParameter(string, "string");
            if (base < 2 || base > 36) {
                throw new NumberFormatException("Unsupported base: " + base + ". Supported base range is from 2 to 36");
            }
            boolean decimal = StringsKt.contains$default((CharSequence)string, '.', false, 2, null);
            if (decimal) {
                boolean isActuallyDecimal;
                BigDecimal bigDecimal = BigDecimal.Companion.parseString(string);
                boolean bl = isActuallyDecimal = bigDecimal.minus(bigDecimal.floor()).compareTo((Object)0) > 0;
                if (isActuallyDecimal) {
                    throw new NumberFormatException("Supplied string is decimal, which cannot be converted to BigInteger without precision loss.");
                }
                return bigDecimal.toBigInteger();
            }
            boolean bl = signed = string.charAt(0) == '-' || string.charAt(0) == '+';
            if (signed) {
                Sign isNegative;
                if (string.length() == 1) {
                    throw new NumberFormatException(Intrinsics.stringPlus("Invalid big integer: ", string));
                }
                Sign sign = isNegative = string.charAt(0) == '-' ? Sign.NEGATIVE : Sign.POSITIVE;
                if (string.length() == 2 && string.charAt(1) == '0') {
                    return this.getZERO();
                }
                BigIntegerArithmetic bigIntegerArithmetic = arithmetic;
                String string2 = string;
                int n = 1;
                int n2 = string.length();
                boolean bl2 = false;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                bigInteger = new BigInteger(bigIntegerArithmetic.parseForBase-_llDaS8(string3, base), isNegative, null);
            } else {
                if (string.length() == 1 && string.charAt(0) == '0') {
                    return this.getZERO();
                }
                bigInteger = new BigInteger(arithmetic.parseForBase-_llDaS8(string, base), Sign.POSITIVE, null);
            }
            return bigInteger;
        }

        @NotNull
        public final BigInteger fromWordArray-tBf0fek$bignum(@NotNull long[] wordArray, @NotNull Sign sign) {
            Intrinsics.checkNotNullParameter(wordArray, "wordArray");
            Intrinsics.checkNotNullParameter((Object)sign, "sign");
            return new BigInteger(wordArray, sign, null);
        }

        private final /* synthetic */ Sign determinSignFromNumber(Comparable number) {
            Sign sign;
            boolean $i$f$determinSignFromNumber = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
            if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                Long cfr_ignored_0 = (Long)number;
                sign = ((Number)((Object)number)).longValue() < 0L ? Sign.NEGATIVE : (((Number)((Object)number)).longValue() > 0L ? Sign.POSITIVE : Sign.ZERO);
            } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                Integer cfr_ignored_1 = (Integer)number;
                sign = ((Number)((Object)number)).intValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number)).intValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
            } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                Short cfr_ignored_2 = (Short)number;
                sign = ((Number)((Object)number)).shortValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number)).shortValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
            } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                Byte cfr_ignored_3 = (Byte)number;
                sign = ((Number)((Object)number)).byteValue() < 0 ? Sign.NEGATIVE : (((Number)((Object)number)).byteValue() > 0 ? Sign.POSITIVE : Sign.ZERO);
            } else {
                Intrinsics.reifiedOperationMarker(4, "T");
                throw new RuntimeException(Intrinsics.stringPlus("Unsupported type ", Reflection.getOrCreateKotlinClass(Object.class)));
            }
            return sign;
        }

        @Override
        @NotNull
        public BigInteger fromBigInteger(@NotNull BigInteger bigInteger) {
            Intrinsics.checkNotNullParameter(bigInteger, "bigInteger");
            return bigInteger;
        }

        @Override
        @NotNull
        public BigInteger fromULong-VKZWuLQ(long uLong) {
            return new BigInteger(arithmetic.fromULong--GCcj4Q(uLong), Sign.POSITIVE, null);
        }

        @Override
        @NotNull
        public BigInteger fromUInt-WZ4Q5Ns(int uInt) {
            return new BigInteger(arithmetic.fromUInt-kOc6_GI(uInt), Sign.POSITIVE, null);
        }

        @Override
        @NotNull
        public BigInteger fromUShort-xj2QHRw(short uShort) {
            return new BigInteger(arithmetic.fromUShort-jOPi9CM(uShort), Sign.POSITIVE, null);
        }

        @Override
        @NotNull
        public BigInteger fromUByte-7apg3OU(byte uByte) {
            return new BigInteger(arithmetic.fromUByte-ab45Ak8(uByte), Sign.POSITIVE, null);
        }

        @Override
        @NotNull
        public BigInteger fromLong(long l) {
            return new BigInteger(l);
        }

        @Override
        @NotNull
        public BigInteger fromInt(int n) {
            return new BigInteger(n);
        }

        @Override
        @NotNull
        public BigInteger fromShort(short s) {
            return new BigInteger(s);
        }

        @Override
        @NotNull
        public BigInteger fromByte(byte by) {
            return new BigInteger(by);
        }

        @Override
        @NotNull
        public BigInteger tryFromFloat(float f, boolean exactRequired) {
            boolean bl = false;
            float floatDecimalPart = f - (float)Math.floor(f);
            boolean bl2 = false;
            BigDecimal bigDecimal = BigDecimal.Companion.fromFloat((float)Math.floor(f), null);
            if (exactRequired && floatDecimalPart > 0.0f) {
                throw new ArithmeticException("Cant create BigInteger without precision loss, and exact  value was required");
            }
            return bigDecimal.toBigInteger();
        }

        @Override
        @NotNull
        public BigInteger tryFromDouble(double d2, boolean exactRequired) {
            boolean bl = false;
            double doubleDecimalPart = d2 - Math.floor(d2);
            boolean bl2 = false;
            BigDecimal bigDecimal = BigDecimal.Companion.fromDouble(Math.floor(d2), null);
            if (exactRequired && doubleDecimalPart > 0.0) {
                throw new ArithmeticException("Cant create BigInteger without precision loss, and exact  value was required");
            }
            return bigDecimal.toBigInteger();
        }

        @Override
        @NotNull
        public BigInteger max(@NotNull BigInteger first2, @NotNull BigInteger second2) {
            Intrinsics.checkNotNullParameter(first2, "first");
            Intrinsics.checkNotNullParameter(second2, "second");
            return first2.compareTo(second2) > 0 ? first2 : second2;
        }

        @Override
        @NotNull
        public BigInteger min(@NotNull BigInteger first2, @NotNull BigInteger second2) {
            Intrinsics.checkNotNullParameter(first2, "first");
            Intrinsics.checkNotNullParameter(second2, "second");
            return first2.compareTo(second2) < 0 ? first2 : second2;
        }

        @Override
        @NotNull
        public BigInteger fromUByteArray-rto03Yo(@NotNull byte[] source, @NotNull Sign sign) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter((Object)sign, "sign");
            long[] result2 = arithmetic.fromUByteArray-S4Jqe-A(source);
            return new BigInteger(result2, sign, null);
        }

        @Override
        @NotNull
        public BigInteger fromByteArray(@NotNull byte[] source, @NotNull Sign sign) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter((Object)sign, "sign");
            long[] result2 = arithmetic.fromByteArray-DHQ6RzY(source);
            return new BigInteger(result2, sign, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/ionspin/kotlin/bignum/integer/BigInteger$QuotientAndRemainder;", "", "quotient", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "remainder", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;Lcom/ionspin/kotlin/bignum/integer/BigInteger;)V", "getQuotient", "()Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "getRemainder", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bignum"})
    public static final class QuotientAndRemainder {
        @NotNull
        private final BigInteger quotient;
        @NotNull
        private final BigInteger remainder;

        public QuotientAndRemainder(@NotNull BigInteger quotient, @NotNull BigInteger remainder) {
            Intrinsics.checkNotNullParameter(quotient, "quotient");
            Intrinsics.checkNotNullParameter(remainder, "remainder");
            this.quotient = quotient;
            this.remainder = remainder;
        }

        @NotNull
        public final BigInteger getQuotient() {
            return this.quotient;
        }

        @NotNull
        public final BigInteger getRemainder() {
            return this.remainder;
        }

        @NotNull
        public final BigInteger component1() {
            return this.quotient;
        }

        @NotNull
        public final BigInteger component2() {
            return this.remainder;
        }

        @NotNull
        public final QuotientAndRemainder copy(@NotNull BigInteger quotient, @NotNull BigInteger remainder) {
            Intrinsics.checkNotNullParameter(quotient, "quotient");
            Intrinsics.checkNotNullParameter(remainder, "remainder");
            return new QuotientAndRemainder(quotient, remainder);
        }

        public static /* synthetic */ QuotientAndRemainder copy$default(QuotientAndRemainder quotientAndRemainder, BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
            if ((n & 1) != 0) {
                bigInteger = quotientAndRemainder.quotient;
            }
            if ((n & 2) != 0) {
                bigInteger2 = quotientAndRemainder.remainder;
            }
            return quotientAndRemainder.copy(bigInteger, bigInteger2);
        }

        @NotNull
        public String toString() {
            return "QuotientAndRemainder(quotient=" + this.quotient + ", remainder=" + this.remainder + ')';
        }

        public int hashCode() {
            int result2 = this.quotient.hashCode();
            result2 = result2 * 31 + this.remainder.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuotientAndRemainder)) {
                return false;
            }
            QuotientAndRemainder quotientAndRemainder = (QuotientAndRemainder)other;
            if (!Intrinsics.areEqual(this.quotient, quotientAndRemainder.quotient)) {
                return false;
            }
            return Intrinsics.areEqual(this.remainder, quotientAndRemainder.remainder);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/ionspin/kotlin/bignum/integer/BigInteger$SqareRootAndRemainder;", "", "squareRoot", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "remainder", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;Lcom/ionspin/kotlin/bignum/integer/BigInteger;)V", "getRemainder", "()Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "getSquareRoot", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bignum"})
    public static final class SqareRootAndRemainder {
        @NotNull
        private final BigInteger squareRoot;
        @NotNull
        private final BigInteger remainder;

        public SqareRootAndRemainder(@NotNull BigInteger squareRoot, @NotNull BigInteger remainder) {
            Intrinsics.checkNotNullParameter(squareRoot, "squareRoot");
            Intrinsics.checkNotNullParameter(remainder, "remainder");
            this.squareRoot = squareRoot;
            this.remainder = remainder;
        }

        @NotNull
        public final BigInteger getSquareRoot() {
            return this.squareRoot;
        }

        @NotNull
        public final BigInteger getRemainder() {
            return this.remainder;
        }

        @NotNull
        public final BigInteger component1() {
            return this.squareRoot;
        }

        @NotNull
        public final BigInteger component2() {
            return this.remainder;
        }

        @NotNull
        public final SqareRootAndRemainder copy(@NotNull BigInteger squareRoot, @NotNull BigInteger remainder) {
            Intrinsics.checkNotNullParameter(squareRoot, "squareRoot");
            Intrinsics.checkNotNullParameter(remainder, "remainder");
            return new SqareRootAndRemainder(squareRoot, remainder);
        }

        public static /* synthetic */ SqareRootAndRemainder copy$default(SqareRootAndRemainder sqareRootAndRemainder, BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
            if ((n & 1) != 0) {
                bigInteger = sqareRootAndRemainder.squareRoot;
            }
            if ((n & 2) != 0) {
                bigInteger2 = sqareRootAndRemainder.remainder;
            }
            return sqareRootAndRemainder.copy(bigInteger, bigInteger2);
        }

        @NotNull
        public String toString() {
            return "SqareRootAndRemainder(squareRoot=" + this.squareRoot + ", remainder=" + this.remainder + ')';
        }

        public int hashCode() {
            int result2 = this.squareRoot.hashCode();
            result2 = result2 * 31 + this.remainder.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SqareRootAndRemainder)) {
                return false;
            }
            SqareRootAndRemainder sqareRootAndRemainder = (SqareRootAndRemainder)other;
            if (!Intrinsics.areEqual(this.squareRoot, sqareRootAndRemainder.squareRoot)) {
                return false;
            }
            return Intrinsics.areEqual(this.remainder, sqareRootAndRemainder.remainder);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0096\u0002R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/ionspin/kotlin/bignum/integer/BigInteger$BigIntegerRange;", "Lkotlin/ranges/ClosedRange;", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "", "start", "endInclusive", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;Lcom/ionspin/kotlin/bignum/integer/BigInteger;)V", "getEndInclusive", "()Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "getStart", "iterator", "", "bignum"})
    public static final class BigIntegerRange
    implements ClosedRange<BigInteger>,
    Iterable<BigInteger>,
    KMappedMarker {
        @NotNull
        private final BigInteger start;
        @NotNull
        private final BigInteger endInclusive;

        public BigIntegerRange(@NotNull BigInteger start, @NotNull BigInteger endInclusive) {
            Intrinsics.checkNotNullParameter(start, "start");
            Intrinsics.checkNotNullParameter(endInclusive, "endInclusive");
            this.start = start;
            this.endInclusive = endInclusive;
        }

        @Override
        @NotNull
        public BigInteger getStart() {
            return this.start;
        }

        @Override
        @NotNull
        public BigInteger getEndInclusive() {
            return this.endInclusive;
        }

        @Override
        @NotNull
        public Iterator<BigInteger> iterator() {
            return new BigIntegerIterator(this.getStart(), this.getEndInclusive());
        }

        @Override
        public boolean contains(@NotNull BigInteger value2) {
            return ClosedRange.DefaultImpls.contains(this, (Comparable)value2);
        }

        @Override
        public boolean isEmpty() {
            return ClosedRange.DefaultImpls.isEmpty(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0007\u001a\u00020\bH\u0096\u0002J\t\u0010\t\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ionspin/kotlin/bignum/integer/BigInteger$BigIntegerIterator;", "", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "start", "endInclusive", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;Lcom/ionspin/kotlin/bignum/integer/BigInteger;)V", "current", "hasNext", "", "next", "bignum"})
    public static final class BigIntegerIterator
    implements Iterator<BigInteger>,
    KMappedMarker {
        @NotNull
        private final BigInteger endInclusive;
        @NotNull
        private BigInteger current;

        public BigIntegerIterator(@NotNull BigInteger start, @NotNull BigInteger endInclusive) {
            Intrinsics.checkNotNullParameter(start, "start");
            Intrinsics.checkNotNullParameter(endInclusive, "endInclusive");
            this.endInclusive = endInclusive;
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(this.endInclusive) <= 0;
        }

        @Override
        @NotNull
        public BigInteger next() {
            BigIntegerIterator bigIntegerIterator = this;
            BigInteger bigInteger = bigIntegerIterator.current;
            bigIntegerIterator.current = bigInteger.inc();
            return bigInteger;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Sign.values().length];
            nArray[Sign.POSITIVE.ordinal()] = 1;
            nArray[Sign.NEGATIVE.ordinal()] = 2;
            nArray[Sign.ZERO.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

