/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\rJ\b\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/serialization/json/internal/JsonPath;", "", "()V", "currentDepth", "", "currentObjectPath", "", "[Ljava/lang/Object;", "indicies", "", "getPath", "", "popDescriptor", "", "prettyString", "it", "pushDescriptor", "sd", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "resetCurrentMapKey", "resize", "toString", "updateCurrentMapKey", "key", "updateDescriptorIndex", "index", "Tombstone", "kotlinx-serialization-json"})
public final class JsonPath {
    @NotNull
    private Object[] currentObjectPath = new Object[8];
    @NotNull
    private int[] indicies;
    private int currentDepth;

    public JsonPath() {
        int n = 0;
        int[] nArray = new int[8];
        JsonPath jsonPath = this;
        while (n < 8) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        jsonPath.indicies = nArray;
        this.currentDepth = -1;
    }

    public final void pushDescriptor(@NotNull SerialDescriptor sd) {
        Intrinsics.checkNotNullParameter(sd, "sd");
        ++this.currentDepth;
        int depth = this.currentDepth;
        if (depth == this.currentObjectPath.length) {
            this.resize();
        }
        this.currentObjectPath[depth] = sd;
    }

    public final void updateDescriptorIndex(int index) {
        this.indicies[this.currentDepth] = index;
    }

    public final void updateCurrentMapKey(@Nullable Object key) {
        if (this.indicies[this.currentDepth] != -2) {
            ++this.currentDepth;
            if (this.currentDepth == this.currentObjectPath.length) {
                this.resize();
            }
        }
        this.currentObjectPath[this.currentDepth] = key;
        this.indicies[this.currentDepth] = -2;
    }

    public final void resetCurrentMapKey() {
        if (this.indicies[this.currentDepth] == -2) {
            this.currentObjectPath[this.currentDepth] = Tombstone.INSTANCE;
        }
    }

    public final void popDescriptor() {
        int n;
        int depth = this.currentDepth;
        if (this.indicies[depth] == -2) {
            this.indicies[depth] = -1;
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
        if (this.currentDepth != -1) {
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
    }

    @NotNull
    public final String getPath() {
        StringBuilder stringBuilder;
        StringBuilder $this$getPath_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getPath_u24lambda_u241.append("$");
        int n = this.currentDepth + 1;
        for (int j = 0; j < n; ++j) {
            int it2 = j;
            boolean bl2 = false;
            Object element = this.currentObjectPath[it2];
            if (element instanceof SerialDescriptor) {
                if (Intrinsics.areEqual(((SerialDescriptor)element).getKind(), StructureKind.LIST.INSTANCE)) {
                    if (this.indicies[it2] == -1) continue;
                    $this$getPath_u24lambda_u241.append("[");
                    $this$getPath_u24lambda_u241.append(this.indicies[it2]);
                    $this$getPath_u24lambda_u241.append("]");
                    continue;
                }
                int idx = this.indicies[it2];
                if (idx < 0) continue;
                $this$getPath_u24lambda_u241.append(".");
                $this$getPath_u24lambda_u241.append(((SerialDescriptor)element).getElementName(idx));
                continue;
            }
            if (element == Tombstone.INSTANCE) continue;
            $this$getPath_u24lambda_u241.append("[");
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append(element);
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append("]");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String prettyString(Object it2) {
        Object object = it2 instanceof SerialDescriptor ? (SerialDescriptor)it2 : null;
        if (object == null || (object = object.getSerialName()) == null) {
            object = String.valueOf(it2);
        }
        return object;
    }

    private final void resize() {
        int newSize = this.currentDepth * 2;
        Object[] objectArray = Arrays.copyOf(this.currentObjectPath, newSize);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(this, newSize)");
        this.currentObjectPath = objectArray;
        int[] nArray = Arrays.copyOf(this.indicies, newSize);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
        this.indicies = nArray;
    }

    @NotNull
    public String toString() {
        return this.getPath();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lkotlinx/serialization/json/internal/JsonPath$Tombstone;", "", "()V", "kotlinx-serialization-json"})
    private static final class Tombstone {
        @NotNull
        public static final Tombstone INSTANCE = new Tombstone();

        private Tombstone() {
        }
    }
}

