/*
 * Decompiled with CFR 0.152.
 */
package log;

import config.Config;
import config.DevMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import log.Logger;
import log.LoggerKt;
import log.LoggerLevels;
import log.LoggerName;
import log.LoggerNameKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.OutPrinter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J \u0010\u001b\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J \u0010 \u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J(\u0010!\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010\"\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J \u0010#\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Llog/KotlinLoggingLogger;", "Llog/Logger;", "type", "Llog/LoggerName;", "(Llog/LoggerName;)V", "consoleLogExceptions", "", "isDebugEnabled", "()Z", "isEnabled", "isErrorEnabled", "isInfoEnabled", "isTraceEnabled", "isWarnEnabled", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "getType", "()Llog/LoggerName;", "debug", "", "t", "", "msg", "Lkotlin/Function0;", "", "error", "formatMessage", "", "level", "Llog/LoggerLevels;", "info", "outPrintLog", "trace", "warn", "Companion", "Shared"})
@SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nlog/KotlinLoggingLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
public final class KotlinLoggingLogger
extends Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoggerName type;
    private final boolean consoleLogExceptions;
    @NotNull
    private final KLogger logger;
    @NotNull
    private static final String slf4jPrefix = "org.slf4j.simpleLogger.log.";

    public KotlinLoggingLogger(@NotNull LoggerName type) {
        String levelString;
        Intrinsics.checkNotNullParameter(type, "type");
        this.type = type;
        String levelProp = LoggerNameKt.toLevelProp(this.type);
        String level = System.getProperty(levelProp);
        String verboseProp = LoggerNameKt.toVerboseProp(this.type);
        String string = level != null ? level : (levelString = System.getProperty(verboseProp) != null ? "DEBUG" : null);
        if (levelString != null) {
            System.setProperty(slf4jPrefix + this.type, levelString);
            if (System.getProperty(LoggerNameKt.toTopicProp(this.type)) == null) {
                System.setProperty(LoggerNameKt.toTopicProp(this.type), "1");
            }
        }
        this.consoleLogExceptions = DevMode.INSTANCE.isDevMode();
        this.logger = KotlinLogging.INSTANCE.logger(this.type.toString());
    }

    @NotNull
    public final LoggerName getType() {
        return this.type;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isEnabled() {
        return Config.INSTANCE.isEnabledLogger(this.type);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    private final String formatMessage(LoggerLevels level, Function0<? extends Object> msg) {
        return "[" + Thread.currentThread().getName() + "] " + level.name() + " " + this.type + " - " + msg.invoke();
    }

    private final void outPrintLog(Throwable t, Function0<? extends Object> msg, LoggerLevels level) {
        OutPrinter.print$default(OutPrinter.INSTANCE, t, this.formatMessage(level, msg), false, 4, null);
    }

    @Override
    public void error(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        block2: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter(msg, "msg");
            this.outPrintLog(t, msg, LoggerLevels.ERROR);
            KLogger kLogger = this.logger;
            Throwable throwable2 = t;
            if (throwable2 != null) {
                Throwable throwable3;
                Throwable throwable4 = throwable3 = throwable2;
                KLogger kLogger2 = kLogger;
                boolean bl = false;
                boolean bl2 = this.consoleLogExceptions;
                kLogger = kLogger2;
                throwable = bl2 ? throwable3 : null;
            } else {
                throwable = null;
            }
            kLogger.error(throwable, msg);
            LoggerKt.regression(Logger.Companion, msg);
            Object object = t;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) break block2;
            Object it2 = object;
            boolean bl = false;
            LoggerKt.regression(Logger.Companion, (Function0<? extends Object>)new Function0<Object>((String)it2){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$it;
                }
            });
        }
    }

    @Override
    public void warn(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        block2: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter(msg, "msg");
            this.outPrintLog(t, msg, LoggerLevels.WARN);
            KLogger kLogger = this.logger;
            Throwable throwable2 = t;
            if (throwable2 != null) {
                Throwable throwable3;
                Throwable throwable4 = throwable3 = throwable2;
                KLogger kLogger2 = kLogger;
                boolean bl = false;
                boolean bl2 = this.consoleLogExceptions;
                kLogger = kLogger2;
                throwable = bl2 ? throwable3 : null;
            } else {
                throwable = null;
            }
            kLogger.warn(throwable, msg);
            LoggerKt.regression(Logger.Companion, msg);
            Object object = t;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) break block2;
            Object it2 = object;
            boolean bl = false;
            LoggerKt.regression(Logger.Companion, (Function0<? extends Object>)new Function0<Object>((String)it2){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$it;
                }
            });
        }
    }

    @Override
    public void info(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.logger.isInfoEnabled()) {
            this.outPrintLog(t, msg, LoggerLevels.INFO);
        }
        KLogger kLogger = this.logger;
        Throwable throwable2 = t;
        if (throwable2 != null) {
            Throwable throwable3;
            Throwable throwable4 = throwable3 = throwable2;
            KLogger kLogger2 = kLogger;
            boolean bl = false;
            boolean bl2 = this.consoleLogExceptions;
            kLogger = kLogger2;
            throwable = bl2 ? throwable3 : null;
        } else {
            throwable = null;
        }
        kLogger.info(throwable, msg);
    }

    @Override
    public void debug(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.logger.isDebugEnabled()) {
            this.outPrintLog(t, msg, LoggerLevels.DEBUG);
        }
        KLogger kLogger = this.logger;
        Throwable throwable2 = t;
        if (throwable2 != null) {
            Throwable throwable3;
            Throwable throwable4 = throwable3 = throwable2;
            KLogger kLogger2 = kLogger;
            boolean bl = false;
            boolean bl2 = this.consoleLogExceptions;
            kLogger = kLogger2;
            throwable = bl2 ? throwable3 : null;
        } else {
            throwable = null;
        }
        kLogger.debug(throwable, msg);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.logger.isTraceEnabled()) {
            this.outPrintLog(null, msg, LoggerLevels.TRACE);
        }
        this.logger.trace(msg);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llog/KotlinLoggingLogger$Companion;", "", "()V", "slf4jPrefix", "", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

