/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.cli.UnrecognizedOptionException;

public class AmbiguousOptionException
extends UnrecognizedOptionException {
    private static final long serialVersionUID = 5829816121277947229L;
    private final Collection<String> matchingOptions;

    private static String createMessage(String option2, Collection<String> matchingOptions) {
        StringBuilder buf = new StringBuilder("Ambiguous option: '");
        buf.append(option2);
        buf.append("'  (could be: ");
        Iterator<String> it2 = matchingOptions.iterator();
        while (it2.hasNext()) {
            buf.append("'");
            buf.append(it2.next());
            buf.append("'");
            if (!it2.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public AmbiguousOptionException(String option2, Collection<String> matchingOptions) {
        super(AmbiguousOptionException.createMessage(option2, matchingOptions), option2);
        this.matchingOptions = matchingOptions;
    }

    public Collection<String> getMatchingOptions() {
        return this.matchingOptions;
    }
}

