/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScanner
implements Scanner {
    public static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"};
    protected String[] includes;
    protected String[] excludes;
    protected boolean isCaseSensitive = true;

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    protected static boolean matchPatternStart(String pattern, String str2) {
        return SelectorUtils.matchPatternStart(pattern, str2);
    }

    protected static boolean matchPatternStart(String pattern, String str2, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str2, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str2) {
        return SelectorUtils.matchPath(pattern, str2);
    }

    protected static boolean matchPath(String pattern, String str2, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str2, isCaseSensitive);
    }

    public static boolean match(String pattern, String str2) {
        return SelectorUtils.match(pattern, str2);
    }

    protected static boolean match(String pattern, String str2, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str2, isCaseSensitive);
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i2 = 0; i2 < includes.length; ++i2) {
                this.includes[i2] = this.normalizePattern(includes[i2]);
            }
        }
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i2 = 0; i2 < excludes.length; ++i2) {
                this.excludes[i2] = this.normalizePattern(excludes[i2]);
            }
        }
    }

    private String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? StringUtils.replace(pattern, "/", "\\\\") : StringUtils.replace(pattern, "\\\\", "/");
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    protected boolean isIncluded(String name) {
        for (int i2 = 0; i2 < this.includes.length; ++i2) {
            if (!AbstractScanner.matchPath(this.includes[i2], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        for (int i2 = 0; i2 < this.includes.length; ++i2) {
            if (!AbstractScanner.matchPatternStart(this.includes[i2], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        for (int i2 = 0; i2 < this.excludes.length; ++i2) {
            if (!AbstractScanner.matchPath(this.excludes[i2], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i2 = 0; i2 < DEFAULTEXCLUDES.length; ++i2) {
            newExcludes[i2 + excludesLength] = DEFAULTEXCLUDES[i2].replace('/', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    protected void setupDefaultFilters() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }
}

