/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.SerializerXMLWriter;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class Xpp3Dom {
    protected String name;
    protected String value;
    protected Map attributes;
    protected final List childList;
    protected final Map childMap;
    protected Xpp3Dom parent;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Xpp3Dom[] EMPTY_DOM_ARRAY = new Xpp3Dom[0];
    public static final String CHILDREN_COMBINATION_MODE_ATTRIBUTE = "combine.children";
    public static final String CHILDREN_COMBINATION_MERGE = "merge";
    public static final String CHILDREN_COMBINATION_APPEND = "append";
    public static final String DEFAULT_CHILDREN_COMBINATION_MODE = "merge";
    public static final String SELF_COMBINATION_MODE_ATTRIBUTE = "combine.self";
    public static final String SELF_COMBINATION_OVERRIDE = "override";
    public static final String SELF_COMBINATION_MERGE = "merge";
    public static final String DEFAULT_SELF_COMBINATION_MODE = "merge";

    public Xpp3Dom(String name) {
        this.name = name;
        this.childList = new ArrayList();
        this.childMap = new HashMap();
    }

    public Xpp3Dom(Xpp3Dom src) {
        this(src, src.getName());
    }

    public Xpp3Dom(Xpp3Dom src, String name) {
        int i2;
        this.name = name;
        int childCount = src.getChildCount();
        this.childList = new ArrayList(childCount);
        this.childMap = new HashMap(childCount << 1);
        this.setValue(src.getValue());
        String[] attributeNames = src.getAttributeNames();
        for (i2 = 0; i2 < attributeNames.length; ++i2) {
            String attributeName = attributeNames[i2];
            this.setAttribute(attributeName, src.getAttribute(attributeName));
        }
        for (i2 = 0; i2 < childCount; ++i2) {
            this.addChild(new Xpp3Dom(src.getChild(i2)));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public String[] getAttributeNames() {
        if (null == this.attributes || this.attributes.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAttribute(String name) {
        return null != this.attributes ? (String)this.attributes.get(name) : null;
    }

    public void setAttribute(String name, String value2) {
        if (null == value2) {
            throw new NullPointerException("Attribute value can not be null");
        }
        if (null == name) {
            throw new NullPointerException("Attribute name can not be null");
        }
        if (null == this.attributes) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value2);
    }

    public Xpp3Dom getChild(int i2) {
        return (Xpp3Dom)this.childList.get(i2);
    }

    public Xpp3Dom getChild(String name) {
        return (Xpp3Dom)this.childMap.get(name);
    }

    public void addChild(Xpp3Dom xpp3Dom) {
        xpp3Dom.setParent(this);
        this.childList.add(xpp3Dom);
        this.childMap.put(xpp3Dom.getName(), xpp3Dom);
    }

    public Xpp3Dom[] getChildren() {
        if (null == this.childList || this.childList.isEmpty()) {
            return EMPTY_DOM_ARRAY;
        }
        return this.childList.toArray(new Xpp3Dom[this.childList.size()]);
    }

    public Xpp3Dom[] getChildren(String name) {
        if (null == this.childList) {
            return EMPTY_DOM_ARRAY;
        }
        ArrayList<Xpp3Dom> children2 = new ArrayList<Xpp3Dom>();
        int size = this.childList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Xpp3Dom configuration = (Xpp3Dom)this.childList.get(i2);
            if (!name.equals(configuration.getName())) continue;
            children2.add(configuration);
        }
        return children2.toArray(new Xpp3Dom[children2.size()]);
    }

    public int getChildCount() {
        if (null == this.childList) {
            return 0;
        }
        return this.childList.size();
    }

    public void removeChild(int i2) {
        Xpp3Dom child = this.getChild(i2);
        this.childMap.values().remove(child);
        this.childList.remove(i2);
        child.setParent(null);
    }

    public Xpp3Dom getParent() {
        return this.parent;
    }

    public void setParent(Xpp3Dom parent) {
        this.parent = parent;
    }

    public void writeToSerializer(String namespace, XmlSerializer serializer2) throws IOException {
        SerializerXMLWriter xmlWriter = new SerializerXMLWriter(namespace, serializer2);
        Xpp3DomWriter.write(xmlWriter, this);
        if (xmlWriter.getExceptions().size() > 0) {
            throw (IOException)xmlWriter.getExceptions().get(0);
        }
    }

    private static void mergeIntoXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        block15: {
            if (recessive == null) {
                return;
            }
            boolean mergeSelf = true;
            String selfMergeMode = dominant.getAttribute(SELF_COMBINATION_MODE_ATTRIBUTE);
            if (SELF_COMBINATION_OVERRIDE.equals(selfMergeMode)) {
                mergeSelf = false;
            }
            if (!mergeSelf) break block15;
            if (Xpp3Dom.isEmpty(dominant.getValue())) {
                dominant.setValue(recessive.getValue());
            }
            String[] recessiveAttrs = recessive.getAttributeNames();
            for (int i2 = 0; i2 < recessiveAttrs.length; ++i2) {
                String attr = recessiveAttrs[i2];
                if (!Xpp3Dom.isEmpty(dominant.getAttribute(attr))) continue;
                dominant.setAttribute(attr, recessive.getAttribute(attr));
            }
            if (recessive.getChildCount() > 0) {
                boolean mergeChildren = true;
                if (childMergeOverride != null) {
                    mergeChildren = childMergeOverride;
                } else {
                    String childMergeMode = dominant.getAttribute(CHILDREN_COMBINATION_MODE_ATTRIBUTE);
                    if (CHILDREN_COMBINATION_APPEND.equals(childMergeMode)) {
                        mergeChildren = false;
                    }
                }
                if (!mergeChildren) {
                    int i3;
                    Xpp3Dom[] dominantChildren = dominant.getChildren();
                    dominant.childList.clear();
                    int recessiveChildCount = recessive.getChildCount();
                    for (i3 = 0; i3 < recessiveChildCount; ++i3) {
                        Xpp3Dom recessiveChild = recessive.getChild(i3);
                        dominant.addChild(new Xpp3Dom(recessiveChild));
                    }
                    for (i3 = 0; i3 < dominantChildren.length; ++i3) {
                        dominant.addChild(dominantChildren[i3]);
                    }
                } else {
                    HashMap<String, Iterator<Xpp3Dom>> commonChildren = new HashMap<String, Iterator<Xpp3Dom>>();
                    Iterator it2 = recessive.childMap.keySet().iterator();
                    while (it2.hasNext()) {
                        String childName = (String)it2.next();
                        Xpp3Dom[] dominantChildren = dominant.getChildren(childName);
                        if (dominantChildren.length <= 0) continue;
                        commonChildren.put(childName, Arrays.asList(dominantChildren).iterator());
                    }
                    int recessiveChildCount = recessive.getChildCount();
                    for (int i4 = 0; i4 < recessiveChildCount; ++i4) {
                        Xpp3Dom recessiveChild = recessive.getChild(i4);
                        Iterator it3 = (Iterator)commonChildren.get(recessiveChild.getName());
                        if (it3 == null) {
                            dominant.addChild(new Xpp3Dom(recessiveChild));
                            continue;
                        }
                        if (!it3.hasNext()) continue;
                        Xpp3Dom dominantChild = (Xpp3Dom)it3.next();
                        Xpp3Dom.mergeIntoXpp3Dom(dominantChild, recessiveChild, childMergeOverride);
                    }
                }
            }
        }
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        if (dominant != null) {
            Xpp3Dom.mergeIntoXpp3Dom(dominant, recessive, childMergeOverride);
            return dominant;
        }
        return recessive;
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        if (dominant != null) {
            Xpp3Dom.mergeIntoXpp3Dom(dominant, recessive, null);
            return dominant;
        }
        return recessive;
    }

    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (!(obj2 instanceof Xpp3Dom)) {
            return false;
        }
        Xpp3Dom dom = (Xpp3Dom)obj2;
        if (this.name == null ? dom.name != null : !this.name.equals(dom.name)) {
            return false;
        }
        if (this.value == null ? dom.value != null : !this.value.equals(dom.value)) {
            return false;
        }
        if (this.attributes == null ? dom.attributes != null : !((Object)this.attributes).equals(dom.attributes)) {
            return false;
        }
        return !(this.childList == null ? dom.childList != null : !((Object)this.childList).equals(dom.childList));
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + (this.name != null ? this.name.hashCode() : 0);
        result2 = 37 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 37 * result2 + (this.attributes != null ? ((Object)this.attributes).hashCode() : 0);
        result2 = 37 * result2 + (this.childList != null ? ((Object)this.childList).hashCode() : 0);
        return result2;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer, "UTF-8", null);
        Xpp3DomWriter.write(xmlWriter, this);
        return writer.toString();
    }

    public String toUnescapedString() {
        StringWriter writer = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer, "UTF-8", null);
        Xpp3DomWriter.write(xmlWriter, this, false);
        return writer.toString();
    }

    public static boolean isNotEmpty(String str2) {
        return str2 != null && str2.length() > 0;
    }

    public static boolean isEmpty(String str2) {
        return str2 == null || str2.trim().length() == 0;
    }
}

