/*
 * Decompiled with CFR 0.152.
 */
package report;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.CVTAlertSeverity;
import report.CVTAlertType;
import report.TreeViewLocation;
import report.TreeViewReportable;
import report.TreeViewReportableKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\tH\u00c6\u0003J?\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lreport/CVTAlertInstance;", "", "type", "Lreport/CVTAlertType;", "severity", "Lreport/CVTAlertSeverity;", "jumpToDefinition", "Lreport/TreeViewLocation;", "message", "", "hint", "(Lreport/CVTAlertType;Lreport/CVTAlertSeverity;Lreport/TreeViewLocation;Ljava/lang/String;Ljava/lang/String;)V", "getHint", "()Ljava/lang/String;", "jsonRepBuilder", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonObjectBuilder;", "", "Lkotlin/ExtensionFunctionType;", "getJsonRepBuilder", "()Lkotlin/jvm/functions/Function1;", "getJumpToDefinition", "()Lreport/TreeViewLocation;", "getMessage", "getSeverity", "()Lreport/CVTAlertSeverity;", "timeStamp", "getType", "()Lreport/CVTAlertType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Shared"})
public final class CVTAlertInstance {
    @NotNull
    private final CVTAlertType type;
    @NotNull
    private final CVTAlertSeverity severity;
    @Nullable
    private final TreeViewLocation jumpToDefinition;
    @NotNull
    private final String message;
    @Nullable
    private final String hint;
    @NotNull
    private final String timeStamp;
    @NotNull
    private final Function1<JsonObjectBuilder, Unit> jsonRepBuilder;

    public CVTAlertInstance(@NotNull CVTAlertType type, @NotNull CVTAlertSeverity severity, @Nullable TreeViewLocation jumpToDefinition, @NotNull String message2, @Nullable String hint) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        Intrinsics.checkNotNullParameter(message2, "message");
        this.type = type;
        this.severity = severity;
        this.jumpToDefinition = jumpToDefinition;
        this.message = message2;
        this.hint = hint;
        String string = DateTimeFormatter.ofPattern("dd/MM/uuuu-HH:mm:ss:SSS").withZone(ZoneId.systemDefault()).format(Instant.now().truncatedTo(ChronoUnit.MILLIS));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        this.timeStamp = string;
        this.jsonRepBuilder = new Function1<JsonObjectBuilder, Unit>(this){
            final /* synthetic */ CVTAlertInstance this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonObjectBuilder $this$null) {
                Object it2;
                Intrinsics.checkNotNullParameter($this$null, "$this$null");
                JsonElementBuildersKt.put($this$null, "type", this.this$0.getType().toString());
                JsonElementBuildersKt.put($this$null, "severity", this.this$0.getSeverity().toString());
                TreeViewLocation treeViewLocation = this.this$0.getJumpToDefinition();
                if (treeViewLocation != null) {
                    it2 = treeViewLocation;
                    boolean bl = false;
                    TreeViewReportableKt.put($this$null, "jumpToDefinition", (TreeViewReportable)it2);
                }
                JsonElementBuildersKt.put($this$null, "message", this.this$0.getMessage());
                String string = this.this$0.getHint();
                if (string != null) {
                    it2 = string;
                    boolean bl = false;
                    JsonElementBuildersKt.put($this$null, "hint", (String)it2);
                }
                JsonElementBuildersKt.put($this$null, "timeStamp", CVTAlertInstance.access$getTimeStamp$p(this.this$0));
            }
        };
    }

    @NotNull
    public final CVTAlertType getType() {
        return this.type;
    }

    @NotNull
    public final CVTAlertSeverity getSeverity() {
        return this.severity;
    }

    @Nullable
    public final TreeViewLocation getJumpToDefinition() {
        return this.jumpToDefinition;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final String getHint() {
        return this.hint;
    }

    @NotNull
    public final Function1<JsonObjectBuilder, Unit> getJsonRepBuilder() {
        return this.jsonRepBuilder;
    }

    @NotNull
    public final CVTAlertType component1() {
        return this.type;
    }

    @NotNull
    public final CVTAlertSeverity component2() {
        return this.severity;
    }

    @Nullable
    public final TreeViewLocation component3() {
        return this.jumpToDefinition;
    }

    @NotNull
    public final String component4() {
        return this.message;
    }

    @Nullable
    public final String component5() {
        return this.hint;
    }

    @NotNull
    public final CVTAlertInstance copy(@NotNull CVTAlertType type, @NotNull CVTAlertSeverity severity, @Nullable TreeViewLocation jumpToDefinition, @NotNull String message2, @Nullable String hint) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        Intrinsics.checkNotNullParameter(message2, "message");
        return new CVTAlertInstance(type, severity, jumpToDefinition, message2, hint);
    }

    public static /* synthetic */ CVTAlertInstance copy$default(CVTAlertInstance cVTAlertInstance, CVTAlertType cVTAlertType, CVTAlertSeverity cVTAlertSeverity, TreeViewLocation treeViewLocation, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            cVTAlertType = cVTAlertInstance.type;
        }
        if ((n & 2) != 0) {
            cVTAlertSeverity = cVTAlertInstance.severity;
        }
        if ((n & 4) != 0) {
            treeViewLocation = cVTAlertInstance.jumpToDefinition;
        }
        if ((n & 8) != 0) {
            string = cVTAlertInstance.message;
        }
        if ((n & 0x10) != 0) {
            string2 = cVTAlertInstance.hint;
        }
        return cVTAlertInstance.copy(cVTAlertType, cVTAlertSeverity, treeViewLocation, string, string2);
    }

    @NotNull
    public String toString() {
        return "CVTAlertInstance(type=" + this.type + ", severity=" + this.severity + ", jumpToDefinition=" + this.jumpToDefinition + ", message=" + this.message + ", hint=" + this.hint + ")";
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + this.severity.hashCode();
        result2 = result2 * 31 + (this.jumpToDefinition == null ? 0 : this.jumpToDefinition.hashCode());
        result2 = result2 * 31 + this.message.hashCode();
        result2 = result2 * 31 + (this.hint == null ? 0 : this.hint.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CVTAlertInstance)) {
            return false;
        }
        CVTAlertInstance cVTAlertInstance = (CVTAlertInstance)other;
        if (this.type != cVTAlertInstance.type) {
            return false;
        }
        if (this.severity != cVTAlertInstance.severity) {
            return false;
        }
        if (!Intrinsics.areEqual(this.jumpToDefinition, cVTAlertInstance.jumpToDefinition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.message, cVTAlertInstance.message)) {
            return false;
        }
        return Intrinsics.areEqual(this.hint, cVTAlertInstance.hint);
    }

    public static final /* synthetic */ String access$getTimeStamp$p(CVTAlertInstance $this) {
        return $this.timeStamp;
    }
}

