/*
 * Decompiled with CFR 0.152.
 */
package report;

import datastructures.stdcollections.ListsKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import log.ArtifactLocation;
import log.ArtifactManagerFactory;
import log.Logger;
import log.LoggerKt;
import log.StaticArtifactLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.AlertReportFileWriter;
import report.CVTAlertInstance;
import report.CVTAlertSeverity;
import report.CVTAlertType;
import report.ICVTAlertsReporter;
import report.TreeViewLocation;
import utils.ArtifactFileUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J4\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lreport/CVTAlertsReporter;", "Lreport/ICVTAlertsReporter;", "()V", "fileName", "", "getFileName", "()Ljava/lang/String;", "fileWriter", "Lreport/AlertReportFileWriter;", "firstAlert", "", "close", "", "init", "isInit", "reportAlert", "type", "Lreport/CVTAlertType;", "severity", "Lreport/CVTAlertSeverity;", "jumpToDefinition", "Lreport/TreeViewLocation;", "message", "hint", "reportAlerts", "alertInstances", "", "Lreport/CVTAlertInstance;", "Shared"})
@SourceDebugExtension(value={"SMAP\nCVTAlertsReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVTAlertsReporter.kt\nreport/CVTAlertsReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,186:1\n1#2:187\n28#3,4:188\n*S KotlinDebug\n*F\n+ 1 CVTAlertsReporter.kt\nreport/CVTAlertsReporter\n*L\n121#1:188,4\n*E\n"})
public final class CVTAlertsReporter
implements ICVTAlertsReporter {
    @NotNull
    public static final CVTAlertsReporter INSTANCE = new CVTAlertsReporter();
    @Nullable
    private static AlertReportFileWriter fileWriter;
    private static boolean firstAlert;

    private CVTAlertsReporter() {
    }

    private final String getFileName() {
        return "alertReport.json";
    }

    @Override
    public synchronized void init() {
        if (!(fileWriter == null)) {
            boolean $i$a$-require-CVTAlertsReporter$init$22 = false;
            String $i$a$-require-CVTAlertsReporter$init$22 = "Alert file writer is already open, was object already initialized?";
            throw new IllegalArgumentException($i$a$-require-CVTAlertsReporter$init$22.toString());
        }
        ArtifactManagerFactory.INSTANCE.invoke().registerArtifact(this.getFileName(), (ArtifactLocation)StaticArtifactLocation.Reports.INSTANCE);
        String filePath = ArtifactManagerFactory.INSTANCE.invoke().getRegisteredArtifactPath(this.getFileName());
        boolean append = false;
        boolean overwrite = false;
        File file = ArtifactFileUtils.INSTANCE.getActualFile(filePath, overwrite, append);
        fileWriter = new AlertReportFileWriter(file, append);
    }

    @Override
    public boolean isInit() {
        return fileWriter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reportAlerts(@NotNull List<CVTAlertInstance> alertInstances) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(alertInstances, "alertInstances");
        AlertReportFileWriter alertReportFileWriter = fileWriter;
        if (alertReportFileWriter == null) {
            return;
        }
        AlertReportFileWriter fileWriter = alertReportFileWriter;
        StringBuilder $this$reportAlerts_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (CVTAlertInstance alertInst : alertInstances) {
            if (firstAlert) {
                firstAlert = false;
            } else {
                $this$reportAlerts_u24lambda_u241.append(',');
            }
            Function1<JsonObjectBuilder, Unit> builderAction$iv = alertInst.getJsonRepBuilder();
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder builder$iv = new JsonObjectBuilder();
            builderAction$iv.invoke(builder$iv);
            JsonObject currentAlertAsJson = builder$iv.build();
            $this$reportAlerts_u24lambda_u241.append(currentAlertAsJson);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String jsonToAppend = string;
        Object object = new StringBuilder();
        StringBuilder $this$reportAlerts_u24lambda_u242 = object;
        boolean bl2 = false;
        for (CVTAlertInstance alertInst : alertInstances) {
            StringBuilder stringBuilder2 = $this$reportAlerts_u24lambda_u242.append("Report alert: " + alertInst.getMessage());
            Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append(...)");
            StringBuilder stringBuilder3 = $this$reportAlerts_u24lambda_u242.append("hint: " + alertInst.getHint());
            Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append(...)");
        }
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String regressionMessages = string2;
        object = this;
        synchronized (object) {
            boolean bl3 = false;
            fileWriter.write(jsonToAppend);
            LoggerKt.regression(Logger.Companion, (Function0<? extends Object>)new Function0<Object>(regressionMessages){
                final /* synthetic */ String $regressionMessages;
                {
                    this.$regressionMessages = $regressionMessages;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$regressionMessages;
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void reportAlert(@NotNull CVTAlertType type, @NotNull CVTAlertSeverity severity, @Nullable TreeViewLocation jumpToDefinition, @NotNull String message2, @Nullable String hint) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        Intrinsics.checkNotNullParameter(message2, "message");
        CVTAlertInstance alert = new CVTAlertInstance(type, severity, jumpToDefinition, message2, hint);
        this.reportAlerts(ListsKt.listOf(alert));
    }

    @Override
    public void close() {
        block0: {
            AlertReportFileWriter alertReportFileWriter = fileWriter;
            if (alertReportFileWriter == null) break block0;
            alertReportFileWriter.close();
        }
    }

    static {
        firstAlert = true;
    }
}

