/*
 * Decompiled with CFR 0.152.
 */
package scene;

import allocator.Allocator;
import bridge.ContractInstanceInSDC;
import caching.WithMemento;
import datastructures.stdcollections.ListsKt;
import disassembler.DisassembledEVMBytecode;
import evm.SighashInt;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.Parallel;
import parallel.ParallelKt;
import parallel.ParallelPool;
import parallel.Scheduler;
import scene.ContractClassIdentifiers;
import scene.ContractWithStateLinkInfo;
import scene.IContractClass;
import scene.IContractClassIdentifiers;
import scene.IContractWithSource;
import scene.IMethodIdentifiers;
import scene.IMutableStorageInfo;
import scene.IMutableTransientStorageInfo;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import scene.MethodIdentifiers;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.ITACSymbol;
import tac.TACStorageLayout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001@J\b\u0010#\u001a\u00020\u0000H&J\n\u0010$\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H&J\u0012\u0010)\u001a\u0004\u0018\u00010\u00132\u0006\u0010*\u001a\u00020\u0018H&J\u0012\u0010+\u001a\u0004\u0018\u00010\u00132\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130.H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0016J\n\u00100\u001a\u0004\u0018\u00010\u0013H\u0016J*\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020706H\u0016J2\u00101\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u0002042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020706H&J*\u0010:\u001a\u0002022\u0006\u00103\u001a\u0002042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020206H\u0016J2\u0010:\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u0002042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020206H\u0016J\u0010\u0010;\u001a\u0002022\u0006\u0010<\u001a\u00020\u0002H\u0016J\b\u0010=\u001a\u00020\u0002H\u0016J\b\u0010>\u001a\u00020?H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00130\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u0004\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015\u00a8\u0006A"}, d2={"Lscene/IContractClass;", "Lcaching/WithMemento;", "Lscene/IContractClass$ContractMemento;", "Lscene/IContractClassIdentifiers;", "addressSym", "Ltac/ITACSymbol;", "getAddressSym", "()Ltac/ITACSymbol;", "bytecode", "Ldisassembler/DisassembledEVMBytecode;", "getBytecode", "()Ldisassembler/DisassembledEVMBytecode;", "constructorBytecode", "getConstructorBytecode", "constructorCodeName", "", "getConstructorCodeName", "()Ljava/lang/String;", "constructorMethod", "Lscene/ITACMethod;", "getConstructorMethod", "()Lscene/ITACMethod;", "methods", "", "Ljava/math/BigInteger;", "getMethods", "()Ljava/util/Map;", "storage", "Ltac/IStorageInfo;", "getStorage", "()Ltac/IStorageInfo;", "transientStorage", "getTransientStorage", "wholeContractMethod", "getWholeContractMethod", "fork", "getConstructor", "getContractStateLinks", "Lscene/ContractWithStateLinkInfo;", "getDeclaredMethods", "", "getMethodBySigHash", "sig", "getMethodByUniqueAttribute", "attr", "Lscene/MethodAttribute$Unique;", "", "getStandardMethods", "getWholeContract", "mapMethods", "", "scene", "Lscene/IScene;", "p", "Lkotlin/Function2;", "Ltac/ICoreTACProgram;", "sort", "Lscene/IScene$MapSort;", "mapMethodsInPlace", "restore", "m", "saveState", "toIdentifiers", "Lscene/ContractClassIdentifiers;", "ContractMemento", "Shared"})
public interface IContractClass
extends WithMemento<ContractMemento>,
IContractClassIdentifiers {
    @NotNull
    public Map<BigInteger, ITACMethod> getMethods();

    @Override
    @Nullable
    public ITACMethod getWholeContractMethod();

    @Override
    @Nullable
    public ITACMethod getConstructorMethod();

    @NotNull
    public ContractClassIdentifiers toIdentifiers();

    @Override
    @Nullable
    public ITACMethod getWholeContract();

    @Override
    @Nullable
    public ITACMethod getConstructor();

    @Override
    @Nullable
    public ITACMethod getMethodBySigHash(@NotNull BigInteger var1);

    @Override
    @Nullable
    public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique var1);

    @NotNull
    public IStorageInfo getStorage();

    @NotNull
    public IStorageInfo getTransientStorage();

    @NotNull
    public List<ITACMethod> getMethods();

    @NotNull
    public Collection<ITACMethod> getDeclaredMethods();

    @NotNull
    public Collection<ITACMethod> getStandardMethods();

    public void mapMethodsInPlace(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> var2);

    public void mapMethodsInPlace(@NotNull IScene.MapSort var1, @NotNull IScene var2, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> var3);

    public void mapMethods(@NotNull IScene.MapSort var1, @NotNull IScene var2, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> var3);

    public void mapMethods(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> var2);

    @NotNull
    public IContractClass fork();

    @NotNull
    public ITACSymbol getAddressSym();

    @Nullable
    public DisassembledEVMBytecode getBytecode();

    @Nullable
    public DisassembledEVMBytecode getConstructorBytecode();

    @NotNull
    public String getConstructorCodeName();

    @Override
    @NotNull
    public ContractMemento saveState();

    @Override
    public void restore(@NotNull ContractMemento var1);

    @Nullable
    public ContractWithStateLinkInfo getContractStateLinks();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B=\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lscene/IContractClass$ContractMemento;", "Ljava/io/Serializable;", "methods", "", "Ljava/math/BigInteger;", "Ltac/ICoreTACProgram;", "constructorCode", "Lscene/ITACMethod;", "storageInfo", "Ltac/IStorageInfo;", "transientStorageInfo", "allocState", "Lallocator/Allocator$Memento;", "(Ljava/util/Map;Lscene/ITACMethod;Ltac/IStorageInfo;Ltac/IStorageInfo;Lallocator/Allocator$Memento;)V", "getAllocState", "()Lallocator/Allocator$Memento;", "getConstructorCode", "()Lscene/ITACMethod;", "getMethods", "()Ljava/util/Map;", "getStorageInfo", "()Ltac/IStorageInfo;", "getTransientStorageInfo", "Shared"})
    public static final class ContractMemento
    implements Serializable {
        @NotNull
        private final Map<BigInteger, ICoreTACProgram> methods;
        @Nullable
        private final ITACMethod constructorCode;
        @NotNull
        private final IStorageInfo storageInfo;
        @NotNull
        private final IStorageInfo transientStorageInfo;
        @NotNull
        private final Allocator.Memento allocState;

        public ContractMemento(@NotNull Map<BigInteger, ? extends ICoreTACProgram> methods, @Nullable ITACMethod constructorCode, @NotNull IStorageInfo storageInfo, @NotNull IStorageInfo transientStorageInfo, @NotNull Allocator.Memento allocState) {
            Intrinsics.checkNotNullParameter(methods, "methods");
            Intrinsics.checkNotNullParameter(storageInfo, "storageInfo");
            Intrinsics.checkNotNullParameter(transientStorageInfo, "transientStorageInfo");
            Intrinsics.checkNotNullParameter(allocState, "allocState");
            this.methods = methods;
            this.constructorCode = constructorCode;
            this.storageInfo = storageInfo;
            this.transientStorageInfo = transientStorageInfo;
            this.allocState = allocState;
        }

        @NotNull
        public final Map<BigInteger, ICoreTACProgram> getMethods() {
            return this.methods;
        }

        @Nullable
        public final ITACMethod getConstructorCode() {
            return this.constructorCode;
        }

        @NotNull
        public final IStorageInfo getStorageInfo() {
            return this.storageInfo;
        }

        @NotNull
        public final IStorageInfo getTransientStorageInfo() {
            return this.transientStorageInfo;
        }

        @NotNull
        public final Allocator.Memento getAllocState() {
            return this.allocState;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nIContractClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IContractClass.kt\nscene/IContractClass$DefaultImpls\n+ 2 Sequences.kt\ndatastructures/stdcollections/SequencesKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n29#2:208\n704#3,4:209\n819#4:213\n847#4,2:214\n1855#4,2:216\n1179#4,2:218\n1253#4,4:220\n1#5:224\n*S KotlinDebug\n*F\n+ 1 IContractClass.kt\nscene/IContractClass$DefaultImpls\n*L\n100#1:208\n100#1:209,4\n128#1:213\n128#1:214,2\n148#1:216,2\n173#1:218,2\n173#1:220,4\n*E\n"})
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ContractClassIdentifiers toIdentifiers(@NotNull IContractClass $this) {
            void $this$associateByTo$iv$iv;
            BigInteger bigInteger = $this.getInstanceId();
            String string = $this.getName();
            ITACMethod iTACMethod = $this.getMethodByUniqueAttribute(MethodAttribute.Unique.Whole.INSTANCE);
            MethodIdentifiers methodIdentifiers = iTACMethod != null ? iTACMethod.toIdentifiers() : null;
            ITACMethod iTACMethod2 = $this.getConstructor();
            MethodIdentifiers methodIdentifiers2 = iTACMethod2 != null ? iTACMethod2.toIdentifiers() : null;
            Sequence $this$associateBy$iv = SequencesKt.map(CollectionsKt.asSequence((Iterable)$this.getMethods()), toIdentifiers.1.INSTANCE);
            boolean $i$f$associateBy = false;
            Sequence sequence = $this$associateBy$iv;
            Map<BigInteger, MethodIdentifiers> destination$iv$iv = datastructures.stdcollections.MapsKt.mutableMapOf();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it2;
                MethodIdentifiers methodIdentifiers3 = (MethodIdentifiers)element$iv$iv;
                Map<BigInteger, MethodIdentifiers> map2 = destination$iv$iv;
                boolean bl = false;
                SighashInt sighashInt = it2.getSigHash();
                map2.put(sighashInt != null ? sighashInt.getN() : null, (MethodIdentifiers)element$iv$iv);
            }
            Map<BigInteger, MethodIdentifiers> map3 = destination$iv$iv;
            TACStorageLayout tACStorageLayout = $this.getStorageLayout();
            return new ContractClassIdentifiers(bigInteger, string, map3, methodIdentifiers, methodIdentifiers2, tACStorageLayout);
        }

        @Nullable
        public static ITACMethod getWholeContract(@NotNull IContractClass $this) {
            return $this.getMethodByUniqueAttribute(MethodAttribute.Unique.Whole.INSTANCE);
        }

        @Nullable
        public static ITACMethod getConstructor(@NotNull IContractClass $this) {
            return $this.getMethodByUniqueAttribute(MethodAttribute.Unique.Constructor.INSTANCE);
        }

        @Nullable
        public static ITACMethod getMethodByUniqueAttribute(@NotNull IContractClass $this, @NotNull MethodAttribute.Unique attr) {
            Intrinsics.checkNotNullParameter(attr, "attr");
            return (ITACMethod)IContractClassIdentifiers.DefaultImpls.getMethodByUniqueAttribute($this, attr);
        }

        @NotNull
        public static List<ITACMethod> getMethods(@NotNull IContractClass $this) {
            return ListsKt.plus($this.getDeclaredMethods(), (Iterable)CollectionsKt.listOfNotNull($this.getWholeContract()));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Collection<ITACMethod> getStandardMethods(@NotNull IContractClass $this) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this.getDeclaredMethods();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ITACMethod it2 = (ITACMethod)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it2.getAttribute(), MethodAttribute.Unique.Constructor.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static void mapMethodsInPlace(@NotNull IContractClass $this, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p2) {
            Intrinsics.checkNotNullParameter(scene, "scene");
            Intrinsics.checkNotNullParameter(p2, "p");
            $this.mapMethodsInPlace(IScene.MapSort.SEQUENTIAL, scene, p2);
        }

        public static void mapMethodsInPlace(@NotNull IContractClass $this, @NotNull IScene.MapSort sort, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p2) {
            Intrinsics.checkNotNullParameter((Object)sort, "sort");
            Intrinsics.checkNotNullParameter(scene, "scene");
            Intrinsics.checkNotNullParameter(p2, "p");
            if (sort == IScene.MapSort.PARALLEL) {
                ParallelPool.Companion.runInheritT$default(ParallelPool.Companion, ParallelKt.pcompute(ParallelKt.forkEvery((Iterable)$this.getDeclaredMethods(), (Function1)new Function1<ITACMethod, Parallel<? extends Unit>>(p2, scene){
                    final /* synthetic */ Function2<IScene, ITACMethod, Unit> $p;
                    final /* synthetic */ IScene $scene;
                    {
                        this.$p = $p;
                        this.$scene = $scene;
                        super(1);
                    }

                    @NotNull
                    public final Parallel<Unit> invoke(@NotNull ITACMethod it2) {
                        Intrinsics.checkNotNullParameter(it2, "it");
                        return Scheduler.INSTANCE.compute((Function0)new Function0<Unit>(this.$p, this.$scene, it2){
                            final /* synthetic */ Function2<IScene, ITACMethod, Unit> $p;
                            final /* synthetic */ IScene $scene;
                            final /* synthetic */ ITACMethod $it;
                            {
                                this.$p = $p;
                                this.$scene = $scene;
                                this.$it = $it;
                                super(0);
                            }

                            public final void invoke() {
                                this.$p.invoke(this.$scene, this.$it);
                            }
                        });
                    }
                })), null, 1, null);
            } else {
                Iterable $this$forEach$iv = $this.getDeclaredMethods();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ITACMethod it2 = (ITACMethod)element$iv;
                    boolean bl = false;
                    p2.invoke(scene, it2);
                }
            }
        }

        public static void mapMethods(@NotNull IContractClass $this, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> p2) {
            Intrinsics.checkNotNullParameter(scene, "scene");
            Intrinsics.checkNotNullParameter(p2, "p");
            $this.mapMethods(IScene.MapSort.SEQUENTIAL, scene, p2);
        }

        @NotNull
        public static String getConstructorCodeName(@NotNull IContractClass $this) {
            return "constructor_" + $this.getName();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ContractMemento saveState(@NotNull IContractClass $this) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = $this.getMethods();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                ITACMethod it2 = (ITACMethod)element$iv$iv;
                boolean bl = false;
                SighashInt sighashInt = it2.getSigHash();
                Pair<BigInteger, ICoreTACProgram> pair2 = TuplesKt.to(sighashInt != null ? sighashInt.getN() : null, it2.getCode());
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Allocator.Memento memento = Allocator.INSTANCE.saveState();
            IStorageInfo iStorageInfo = $this.getTransientStorage();
            IStorageInfo iStorageInfo2 = $this.getStorage();
            ITACMethod iTACMethod = $this.getConstructor();
            Map map3 = destination$iv$iv;
            return new ContractMemento(map3, iTACMethod, iStorageInfo2, iStorageInfo, memento);
        }

        public static void restore(@NotNull IContractClass $this, @NotNull ContractMemento m) {
            String string;
            Intrinsics.checkNotNullParameter(m, "m");
            for (ITACMethod meth : $this.getMethods()) {
                SighashInt sighashInt = meth.getSigHash();
                ICoreTACProgram iCoreTACProgram = m.getMethods().get(sighashInt != null ? sighashInt.getN() : null);
                if (iCoreTACProgram == null) {
                    throw new IllegalStateException("Broken cache".toString());
                }
                meth.setCode(iCoreTACProgram);
            }
            ITACMethod iTACMethod = $this.getConstructor();
            if (iTACMethod != null) {
                ITACMethod iTACMethod2 = m.getConstructorCode();
                Intrinsics.checkNotNull(iTACMethod2);
                iTACMethod.setCode(iTACMethod2.getCode());
            }
            if ($this instanceof IMutableStorageInfo) {
                ((IMutableStorageInfo)((Object)$this)).setStorageInfo(m.getStorageInfo());
            } else if (!Intrinsics.areEqual($this.getStorage(), m.getStorageInfo())) {
                string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if ($this instanceof IMutableTransientStorageInfo) {
                ((IMutableTransientStorageInfo)((Object)$this)).setTransientStorageInfo(m.getTransientStorageInfo());
            } else if (!Intrinsics.areEqual($this.getTransientStorage(), m.getTransientStorageInfo())) {
                string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Allocator.INSTANCE.restore(m.getAllocState());
        }

        @Nullable
        public static ContractWithStateLinkInfo getContractStateLinks(@NotNull IContractClass $this) {
            ContractWithStateLinkInfo contractWithStateLinkInfo;
            Object object = $this instanceof IContractWithSource ? (IContractWithSource)((Object)$this) : null;
            if (object != null && (object = object.getSrc()) != null && (object = ((ContractInstanceInSDC)object).getState()) != null) {
                Map<BigInteger, BigInteger> it2 = object;
                boolean bl = false;
                contractWithStateLinkInfo = new ContractWithStateLinkInfo($this, it2);
            } else {
                contractWithStateLinkInfo = null;
            }
            return contractWithStateLinkInfo;
        }

        @Nullable
        public static IMethodIdentifiers getMethodOrFallback(@NotNull IContractClass $this, @Nullable BigInteger sig) {
            return IContractClassIdentifiers.DefaultImpls.getMethodOrFallback($this, sig);
        }

        public static boolean getInstanceIdIsStaticAddress(@NotNull IContractClass $this) {
            return IContractClassIdentifiers.DefaultImpls.getInstanceIdIsStaticAddress($this);
        }
    }
}

