/*
 * Decompiled with CFR 0.152.
 */
package spec;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import log.LoggerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.CVTAlertSeverity;
import report.CVTAlertType;
import report.CVTAlertsReporterFactory;
import report.TreeViewLocation;
import spec.cvlast.CVLRange;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lspec/CVLWarningLogger;", "", "()V", "warnings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "generalWarning", "", "msg", "syntaxWarning", "cvlRange", "Lspec/cvlast/CVLRange;", "warn", "type", "Lreport/CVTAlertType;", "location", "Lreport/TreeViewLocation;", "warning", "Shared"})
public final class CVLWarningLogger {
    @NotNull
    public static final CVLWarningLogger INSTANCE = new CVLWarningLogger();
    @NotNull
    private static final ConcurrentHashMap<String, Boolean> warnings = new ConcurrentHashMap();

    private CVLWarningLogger() {
    }

    private final void warn(CVTAlertType type, String msg, TreeViewLocation location) {
        if (!warnings.containsKey(msg)) {
            LoggerKt.alwaysWarn(Logger.Companion, msg);
            ((Map)warnings).put(msg, true);
            CVTAlertsReporterFactory.INSTANCE.invoke().reportAlert(type, CVTAlertSeverity.WARNING, location, msg, null);
        }
    }

    public final void generalWarning(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.warn(CVTAlertType.GENERAL, "Warning: " + msg, null);
    }

    public final void syntaxWarning(@NotNull String msg, @NotNull CVLRange cvlRange) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(cvlRange, "cvlRange");
        this.warn(CVTAlertType.SYNTAX, "Syntax warning in spec file " + cvlRange + ": " + msg, cvlRange instanceof TreeViewLocation ? (TreeViewLocation)((Object)cvlRange) : null);
    }

    public final void warning(@NotNull CVTAlertType type, @NotNull String msg, @Nullable CVLRange location) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.warn(type, msg, location instanceof TreeViewLocation ? (TreeViewLocation)((Object)location) : null);
    }
}

