/*
 * Decompiled with CFR 0.152.
 */
package utils;

import config.SharedConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import utils.CanonFile;
import utils.CertoraFileCacheException;
import utils.LineStarts;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\nJ\u001b\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001a"}, d2={"Lutils/CertoraFileCache;", "", "()V", "fileToBytes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lutils/CanonFile;", "", "fileToLineStarts", "Lutils/LineStarts;", "fileToString", "", "byteContent", "fileName", "canonicalize", "certoraSourcesDir", "Ljava/io/File;", "findReaderPath", "path", "getContentReader", "Ljava/io/Reader;", "lineStarts", "lineStarts-CilK_FQ", "(Ljava/lang/String;)Ljava/util/List;", "loadBytes", "canonFile", "stringContent", "Shared"})
@SourceDebugExtension(value={"SMAP\nCertoraFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertoraFileCache.kt\nutils/CertoraFileCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class CertoraFileCache {
    @NotNull
    public static final CertoraFileCache INSTANCE = new CertoraFileCache();
    @NotNull
    private static final ConcurrentHashMap<CanonFile, String> fileToString = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<CanonFile, byte[]> fileToBytes = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<CanonFile, LineStarts> fileToLineStarts = new ConcurrentHashMap();

    private CertoraFileCache() {
    }

    @NotNull
    public final File certoraSourcesDir() {
        String buildDir = (String)SharedConfig.INSTANCE.getCertoraBuildDirectory().get();
        return FilesKt.normalize(FilesKt.resolve(new File(buildDir), ".certora_sources"));
    }

    @NotNull
    public final Reader getContentReader(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String content = this.stringContent(fileName);
        return new StringReader(content);
    }

    @NotNull
    public final String stringContent(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        CanonFile canonFile = this.canonicalize(fileName);
        String string = fileToString.computeIfAbsent(canonFile, arg_0 -> CertoraFileCache.stringContent$lambda$0(new Function1<CanonFile, String>(canonFile){
            final /* synthetic */ CanonFile $canonFile;
            {
                this.$canonFile = $canonFile;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull CanonFile it2) {
                Intrinsics.checkNotNullParameter(it2, "it");
                byte[] bytes = CertoraFileCache.access$loadBytes(CertoraFileCache.INSTANCE, this.$canonFile);
                return new String(bytes, Charsets.UTF_8);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(string, "computeIfAbsent(...)");
        return string;
    }

    @NotNull
    public final byte[] byteContent(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        CanonFile canonFile = this.canonicalize(fileName);
        return this.loadBytes(canonFile);
    }

    @NotNull
    public final List<? extends Integer> lineStarts-CilK_FQ(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        CanonFile canonFile = this.canonicalize(fileName);
        Function1 function1 = new Function1<CanonFile, LineStarts>(canonFile){
            final /* synthetic */ CanonFile $canonFile;
            {
                this.$canonFile = $canonFile;
                super(1);
            }

            @NotNull
            public final List<? extends Integer> invoke-CilK_FQ(@NotNull CanonFile it2) {
                Intrinsics.checkNotNullParameter(it2, "it");
                byte[] bytes = CertoraFileCache.access$loadBytes(CertoraFileCache.INSTANCE, this.$canonFile);
                return LineStarts.Companion.fromBytes-CilK_FQ(bytes);
            }
        };
        LineStarts lineStarts2 = fileToLineStarts.computeIfAbsent(canonFile, new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter(function, "function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(lineStarts2, "computeIfAbsent(...)");
        return lineStarts2.unbox-impl();
    }

    private final CanonFile canonicalize(String fileName) {
        CharSequence charSequence;
        CharSequence charSequence2 = this.findReaderPath(fileName);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = fileName;
        } else {
            charSequence = charSequence2;
        }
        String readerPath = (String)charSequence;
        return new CanonFile(readerPath);
    }

    private final String findReaderPath(String path) {
        if (new File(path).exists()) {
            return path;
        }
        int index = StringsKt.indexOf$default((CharSequence)path, ".certora_sources", 0, false, 6, null);
        String relPath = "";
        if (index >= 0) {
            String string = path.substring(index);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            relPath = string;
            if (new File(relPath).exists()) {
                return relPath;
            }
            Path path2 = Paths.get((String)SharedConfig.INSTANCE.getCertoraBuildDirectory().get(), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            String pathInBuild = ((Object)path2.resolve(relPath)).toString();
            if (new File(pathInBuild).exists()) {
                return pathInBuild;
            }
        }
        return relPath;
    }

    private final byte[] loadBytes(CanonFile canonFile) {
        byte[] byArray = fileToBytes.computeIfAbsent(canonFile, arg_0 -> CertoraFileCache.loadBytes$lambda$2(new Function1<CanonFile, byte[]>(canonFile){
            final /* synthetic */ CanonFile $canonFile;
            {
                this.$canonFile = $canonFile;
                super(1);
            }

            @NotNull
            public final byte[] invoke(@NotNull CanonFile it2) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter(it2, "it");
                File file = this.$canonFile.getCanon();
                try {
                    byArray = Files.readAllBytes(file.toPath());
                }
                catch (FileNotFoundException e) {
                    throw new CertoraFileCacheException(e, file);
                }
                catch (NoSuchFileException e) {
                    throw new CertoraFileCacheException(e, file);
                }
                catch (IOException e) {
                    throw new CertoraFileCacheException(e, file);
                }
                return byArray;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(byArray, "computeIfAbsent(...)");
        return byArray;
    }

    private static final String stringContent$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final byte[] loadBytes$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (byte[])$tmp0.invoke(p0);
    }

    public static final /* synthetic */ byte[] access$loadBytes(CertoraFileCache $this, CanonFile canonFile) {
        return $this.loadBytes(canonFile);
    }
}

