methods {
    // Assertion cheatcodes
    function _.assertEq(bytes memory a, bytes memory b) internal => assertEqBytes(a, b) expect void;
    function _.assertGt(int256 a, int256 b) internal => assertGtSumm(a, b) expect void;
    function _.assertGe(int256 a, int256 b) internal => assertGeSumm(a, b) expect void;
    function _.assertGe(uint256 a, uint256 b) internal => assertGeSumm(a, b) expect void;
    function _.assertLe(uint256 a, uint256 b) internal => assertLeSumm(a, b) expect void;
    function _.assertEq(bool a, bool b) internal => assertEqBoolSumm(a, b) expect void;
    function _.assertEq(int256 a, int256 b) internal => assertEqSumm(a, b) expect void;
    function _.assertEq(uint256 a, uint256 b) internal => assertEqSumm(a, b) expect void;
    function _.assertEq(uint256 a, uint256 b, string memory err) internal => assertEqSumm(a, b) expect void;
    function _.assertTrue(bool condition) internal => assertTrueSumm(condition) expect void;
    function _.assertTrue(bool condition, string memory err) internal => assertTrueSumm(condition) expect void;
    function _.assertApproxEqAbs(uint256 a, uint256 b, uint256 maxDelta) internal => assertApproxEqAbsSumm(a, b, maxDelta) expect void;
    function _.assertApproxEqRel(uint256 a, uint256 b, uint256 maxPercentDelta) internal => assertApproxEqRelSumm(a, b, maxPercentDelta) expect void;
}

function assertEqBytes(bytes a, bytes b) {
    assert a == b;
}

function assertEqSumm(mathint a, mathint b) {
    assert a == b;
}

function assertEqBoolSumm(bool a, bool b) {
    assert a == b;
}

function assertTrueSumm(bool condition) {
    assert condition;
}

function assertGeSumm(mathint a, mathint b) {
    assert a >= b;
}

function assertGtSumm(mathint a, mathint b) {
    assert a > b;
}

function assertLeSumm(mathint a, mathint b) {
    assert a <= b;
}

function delta(uint256 a, uint256 b) returns mathint {
    mathint delta;
    if (a > b) {
        delta = a - b;
    } else {
        delta = b - a;
    }
    return delta;
}

function percentDelta(uint256 a, uint256 b) returns mathint {
    mathint absDelta = delta(a, b);

    return absDelta * 10^18 / b;
}

function assertApproxEqAbsSumm(uint256 a, uint256 b, uint256 maxDelta) {
    mathint delta = delta(a, b);
    assert delta <= to_mathint(maxDelta);
}

function assertApproxEqRelSumm(uint256 a, uint256 b, uint256 maxPercentDelta /* An 18 decimal fixed point number, where 1e18 == 100% */) {
    if (b == 0) {
        assert a == 0;
        return;
    }
    mathint delta = percentDelta(a, b);
    assert delta <= to_mathint(maxPercentDelta);
}

methods {
    // implemented cheatcodes
    function _.prank(address msgSender) external => __certora_foundry_prank(msgSender) expect void;
    function _.warp(uint256 newTimestamp) external => __certora_foundry_warp(newTimestamp) expect void;
    function _.makeAddrAndKey(string memory name) internal => makeAddrAndKeySumm(name) expect (address, uint256);
    function _.assume(bool condition) external => assumeSumm(condition) expect void;
    function _.expectRevert() external => expectRevertSumm() expect void;
    function _.expectRevert(bytes revertData) external => expectRevertSumm() expect void;
    function _.addr(uint256 privateKey) external => g_addr[privateKey] expect address;
}

ghost mapping(uint256 => address) g_addr;

ghost mapping(string => address) g_makeAddrAndKey_addr;
ghost mapping(string => uint256) g_makeAddrAndKey_privateKey;
function makeAddrAndKeySumm(string name) returns (address, uint256) {
  return (g_makeAddrAndKey_addr[name], g_makeAddrAndKey_privateKey[name]);
}

persistent ghost bool g_expectRevertAllowed;
persistent ghost bool g_expectRevert;
function expectRevertSumm() {
    if (!g_expectRevertAllowed) {
        assert false, "non reverting test shouldn't call `expectRevert`";
    }
    g_expectRevert = true;
}

function assumeSumm(bool condition) {
    require condition;
}


methods {
    // unimplemented cheatcodes that we can ignore for now
    function _.startBroadcast(address) external => NONDET DELETE;
    function _.stopBroadcast() external => NONDET DELETE;
    function _._sendLogPayload(bytes memory payload) internal => NONDET;
    function _.console2_log_StdUtils(string memory p0) internal => NONDET;
    function _.toString(int256) external => NONDET;
    function _.log(string memory p0, address p1) internal => NONDET;
    function _.label(address account, string newLabel) external => NONDET DELETE;
    function _.rpcUrl(string rpcAlias) external => NONDET DELETE;
    function _.createSelectFork(string urlOrAlias, uint256 blockNumber) external => NONDET DELETE;

    // unimplemented cheatcodes that can't be ignored
    function _.expectCall(address callee, bytes data) external => unsupportedCheatcode() expect void;
    function _.expectCall(address callee, uint256 msgValue, bytes data) external => unsupportedCheatcode() expect void;
}

function unsupportedCheatcode() {
    assert false, "unsupported cheatcode";
}


function init_fuzz_tests(method f, env e) {}

rule verify_fuzz_tests(calldataarg args, method f) filtered { f -> f.numberOfArguments > 0} {
    g_expectRevertAllowed = true;
    g_expectRevert = false;
    env e;
    init_fuzz_tests(f, e);
    currentContract.f@withrevert(e, args);
    assert g_expectRevert == lastReverted, "fuzz test revertion assert";
}

rule verify_fuzz_tests_no_revert(calldataarg args, method f) filtered { f -> f.numberOfArguments > 0} {
    g_expectRevertAllowed = false;
    env e;
    init_fuzz_tests(f, e);
    currentContract.f(e, args);
    assert true;
}
