/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#admin_name Account#admin_name}
    */
    readonly adminName: string;
    /**
    * Password for the initial administrative user of the account. Either admin_password or admin_rsa_public_key has to be specified. This field cannot be used whenever admin_user_type is set to SERVICE. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#admin_password Account#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Assigns a public key to the initial administrative user of the account. Either admin_password or admin_rsa_public_key has to be specified. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#admin_rsa_public_key Account#admin_rsa_public_key}
    */
    readonly adminRsaPublicKey?: string;
    /**
    * Used for setting the type of the first user that is assigned the ACCOUNTADMIN role during account creation. Valid options are: `PERSON` | `SERVICE` | `LEGACY_SERVICE` External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#admin_user_type Account#admin_user_type}
    */
    readonly adminUserType?: string;
    /**
    * Specifies a comment for the account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#comment Account#comment}
    */
    readonly comment?: string;
    /**
    * Determines which billing entity is responsible for the account's consumption-based billing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#consumption_billing_entity Account#consumption_billing_entity}
    */
    readonly consumptionBillingEntity?: string;
    /**
    * Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#edition Account#edition}
    */
    readonly edition: string;
    /**
    * Email address of the initial administrative user of the account. This email address is used to send any notifications about the account. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#email Account#email}
    */
    readonly email: string;
    /**
    * First name of the initial administrative user of the account. This field cannot be used whenever admin_user_type is set to SERVICE. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#first_name Account#first_name}
    */
    readonly firstName?: string;
    /**
    * Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#grace_period_in_days Account#grace_period_in_days}
    */
    readonly gracePeriodInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#id Account#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#is_org_admin Account#is_org_admin}
    */
    readonly isOrgAdmin?: string;
    /**
    * Last name of the initial administrative user of the account. This field cannot be used whenever admin_user_type is set to SERVICE. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#last_name Account#last_name}
    */
    readonly lastName?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the new user created to administer the account is forced to change their password upon first login into the account. This field cannot be used whenever admin_user_type is set to SERVICE. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#must_change_password Account#must_change_password}
    */
    readonly mustChangePassword?: string;
    /**
    * Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#name Account#name}
    */
    readonly name: string;
    /**
    * [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#region Account#region}
    */
    readonly region?: string;
    /**
    * ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#region_group Account#region_group}
    */
    readonly regionGroup?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#timeouts Account#timeouts}
    */
    readonly timeouts?: AccountTimeouts;
}
export interface AccountShowOutput {
}
export declare function accountShowOutputToTerraform(struct?: AccountShowOutput): any;
export declare function accountShowOutputToHclTerraform(struct?: AccountShowOutput): any;
export declare class AccountShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccountShowOutput | undefined;
    set internalValue(value: AccountShowOutput | undefined);
    get accountLocator(): string;
    get accountLocatorUrl(): string;
    get accountName(): string;
    get accountOldUrlLastUsed(): string;
    get accountOldUrlSavedOn(): string;
    get accountUrl(): string;
    get comment(): string;
    get consumptionBillingEntityName(): string;
    get createdOn(): string;
    get droppedOn(): string;
    get edition(): string;
    get isEventsAccount(): cdktf.IResolvable;
    get isOrgAdmin(): cdktf.IResolvable;
    get isOrganizationAccount(): cdktf.IResolvable;
    get managedAccounts(): number;
    get marketplaceConsumerBillingEntityName(): string;
    get marketplaceProviderBillingEntityName(): string;
    get movedOn(): string;
    get movedToOrganization(): string;
    get oldAccountUrl(): string;
    get organizationName(): string;
    get organizationOldUrl(): string;
    get organizationOldUrlLastUsed(): string;
    get organizationOldUrlSavedOn(): string;
    get organizationUrlExpirationOn(): string;
    get regionGroup(): string;
    get restoredOn(): string;
    get scheduledDeletionTime(): string;
    get snowflakeRegion(): string;
}
export declare class AccountShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccountShowOutputOutputReference;
}
export interface AccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#create Account#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#delete Account#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#read Account#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#update Account#update}
    */
    readonly update?: string;
}
export declare function accountTimeoutsToTerraform(struct?: AccountTimeouts | cdktf.IResolvable): any;
export declare function accountTimeoutsToHclTerraform(struct?: AccountTimeouts | cdktf.IResolvable): any;
export declare class AccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account snowflake_account}
*/
export declare class Account extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_account";
    /**
    * Generates CDKTF code for importing a Account resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Account to import
    * @param importFromId The id of the existing Account that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Account to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/account snowflake_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccountConfig
    */
    constructor(scope: Construct, id: string, config: AccountConfig);
    private _adminName?;
    get adminName(): string;
    set adminName(value: string);
    get adminNameInput(): string | undefined;
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminRsaPublicKey?;
    get adminRsaPublicKey(): string;
    set adminRsaPublicKey(value: string);
    resetAdminRsaPublicKey(): void;
    get adminRsaPublicKeyInput(): string | undefined;
    private _adminUserType?;
    get adminUserType(): string;
    set adminUserType(value: string);
    resetAdminUserType(): void;
    get adminUserTypeInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _consumptionBillingEntity?;
    get consumptionBillingEntity(): string;
    set consumptionBillingEntity(value: string);
    resetConsumptionBillingEntity(): void;
    get consumptionBillingEntityInput(): string | undefined;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    get editionInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    resetFirstName(): void;
    get firstNameInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _gracePeriodInDays?;
    get gracePeriodInDays(): number;
    set gracePeriodInDays(value: number);
    get gracePeriodInDaysInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isOrgAdmin?;
    get isOrgAdmin(): string;
    set isOrgAdmin(value: string);
    resetIsOrgAdmin(): void;
    get isOrgAdminInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    resetLastName(): void;
    get lastNameInput(): string | undefined;
    private _mustChangePassword?;
    get mustChangePassword(): string;
    set mustChangePassword(value: string);
    resetMustChangePassword(): void;
    get mustChangePasswordInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _regionGroup?;
    get regionGroup(): string;
    set regionGroup(value: string);
    resetRegionGroup(): void;
    get regionGroupInput(): string | undefined;
    private _showOutput;
    get showOutput(): AccountShowOutputList;
    private _timeouts;
    get timeouts(): AccountTimeoutsOutputReference;
    putTimeouts(value: AccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccountTimeouts | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
