/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiAuthenticationIntegrationWithJwtBearerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#comment ApiAuthenticationIntegrationWithJwtBearer#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this security integration is enabled or disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#enabled ApiAuthenticationIntegrationWithJwtBearer#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#id ApiAuthenticationIntegrationWithJwtBearer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier (i.e. name) for the integration. This value must be unique in your account. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#name ApiAuthenticationIntegrationWithJwtBearer#name}
    */
    readonly name: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the default lifetime of the OAuth access token (in seconds) issued by an OAuth server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_access_token_validity ApiAuthenticationIntegrationWithJwtBearer#oauth_access_token_validity}
    */
    readonly oauthAccessTokenValidity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_assertion_issuer ApiAuthenticationIntegrationWithJwtBearer#oauth_assertion_issuer}
    */
    readonly oauthAssertionIssuer: string;
    /**
    * Specifies the URL for authenticating to the external service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_authorization_endpoint ApiAuthenticationIntegrationWithJwtBearer#oauth_authorization_endpoint}
    */
    readonly oauthAuthorizationEndpoint?: string;
    /**
    * Specifies that POST is used as the authentication method to the external service. If removed from the config, the resource is recreated. Valid values are (case-insensitive): `CLIENT_SECRET_POST`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_client_auth_method ApiAuthenticationIntegrationWithJwtBearer#oauth_client_auth_method}
    */
    readonly oauthClientAuthMethod?: string;
    /**
    * Specifies the client ID for the OAuth application in the external service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_client_id ApiAuthenticationIntegrationWithJwtBearer#oauth_client_id}
    */
    readonly oauthClientId: string;
    /**
    * Specifies the client secret for the OAuth application in the ServiceNow instance from the previous step. The connector uses this to request an access token from the ServiceNow instance. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_client_secret ApiAuthenticationIntegrationWithJwtBearer#oauth_client_secret}
    */
    readonly oauthClientSecret: string;
    /**
    * Specifies the value to determine the validity of the refresh token obtained from the OAuth server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_refresh_token_validity ApiAuthenticationIntegrationWithJwtBearer#oauth_refresh_token_validity}
    */
    readonly oauthRefreshTokenValidity?: number;
    /**
    * Specifies the token endpoint used by the client to obtain an access token by presenting its authorization grant or refresh token. The token endpoint is used with every authorization grant except for the implicit grant type (since an access token is issued directly). If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#oauth_token_endpoint ApiAuthenticationIntegrationWithJwtBearer#oauth_token_endpoint}
    */
    readonly oauthTokenEndpoint?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#timeouts ApiAuthenticationIntegrationWithJwtBearer#timeouts}
    */
    readonly timeouts?: ApiAuthenticationIntegrationWithJwtBearerTimeouts;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthType {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthTypeToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthType): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthTypeToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthType): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthType | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthType | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthTypeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthTypeOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputComment {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputCommentToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputComment): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputCommentToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputComment): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputComment | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputCommentOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabled {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabledToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabled): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabledToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabled): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabled | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabled | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabledList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabledOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidity {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidityToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidity): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidityToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidity): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidity | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidityOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopes {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopesToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopes): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopesToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopes): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopes | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopes | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopesOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpoint {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpointToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpoint): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpointToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpoint): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpoint | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpointOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethod {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethodToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethod): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethodToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethod): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethod | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethod | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethodOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrant {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrantToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrant): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrantToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrant): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrant | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrant | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrantList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrantOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidity {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidityToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidity): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidityToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidity): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidity | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidityOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpoint {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpointToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpoint): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpointToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpoint): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpoint | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpointOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegration {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegrationToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegration): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegrationToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegration): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegration | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegration | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegrationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegrationOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerDescribeOutput {
}
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutput): any;
export declare function apiAuthenticationIntegrationWithJwtBearerDescribeOutputToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerDescribeOutput): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutput | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerDescribeOutput | undefined);
    private _authType;
    get authType(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputAuthTypeList;
    private _comment;
    get comment(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputCommentList;
    private _enabled;
    get enabled(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputEnabledList;
    private _oauthAccessTokenValidity;
    get oauthAccessTokenValidity(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAccessTokenValidityList;
    private _oauthAllowedScopes;
    get oauthAllowedScopes(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAllowedScopesList;
    private _oauthAuthorizationEndpoint;
    get oauthAuthorizationEndpoint(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthAuthorizationEndpointList;
    private _oauthClientAuthMethod;
    get oauthClientAuthMethod(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthClientAuthMethodList;
    private _oauthGrant;
    get oauthGrant(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthGrantList;
    private _oauthRefreshTokenValidity;
    get oauthRefreshTokenValidity(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthRefreshTokenValidityList;
    private _oauthTokenEndpoint;
    get oauthTokenEndpoint(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOauthTokenEndpointList;
    private _parentIntegration;
    get parentIntegration(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputParentIntegrationList;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerShowOutput {
}
export declare function apiAuthenticationIntegrationWithJwtBearerShowOutputToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerShowOutput): any;
export declare function apiAuthenticationIntegrationWithJwtBearerShowOutputToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerShowOutput): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerShowOutput | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class ApiAuthenticationIntegrationWithJwtBearerShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithJwtBearerShowOutputOutputReference;
}
export interface ApiAuthenticationIntegrationWithJwtBearerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#create ApiAuthenticationIntegrationWithJwtBearer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#delete ApiAuthenticationIntegrationWithJwtBearer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#read ApiAuthenticationIntegrationWithJwtBearer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#update ApiAuthenticationIntegrationWithJwtBearer#update}
    */
    readonly update?: string;
}
export declare function apiAuthenticationIntegrationWithJwtBearerTimeoutsToTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerTimeouts | cdktf.IResolvable): any;
export declare function apiAuthenticationIntegrationWithJwtBearerTimeoutsToHclTerraform(struct?: ApiAuthenticationIntegrationWithJwtBearerTimeouts | cdktf.IResolvable): any;
export declare class ApiAuthenticationIntegrationWithJwtBearerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiAuthenticationIntegrationWithJwtBearerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithJwtBearerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer snowflake_api_authentication_integration_with_jwt_bearer}
*/
export declare class ApiAuthenticationIntegrationWithJwtBearer extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_api_authentication_integration_with_jwt_bearer";
    /**
    * Generates CDKTF code for importing a ApiAuthenticationIntegrationWithJwtBearer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiAuthenticationIntegrationWithJwtBearer to import
    * @param importFromId The id of the existing ApiAuthenticationIntegrationWithJwtBearer that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiAuthenticationIntegrationWithJwtBearer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/api_authentication_integration_with_jwt_bearer snowflake_api_authentication_integration_with_jwt_bearer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiAuthenticationIntegrationWithJwtBearerConfig
    */
    constructor(scope: Construct, id: string, config: ApiAuthenticationIntegrationWithJwtBearerConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ApiAuthenticationIntegrationWithJwtBearerDescribeOutputList;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oauthAccessTokenValidity?;
    get oauthAccessTokenValidity(): number;
    set oauthAccessTokenValidity(value: number);
    resetOauthAccessTokenValidity(): void;
    get oauthAccessTokenValidityInput(): number | undefined;
    private _oauthAssertionIssuer?;
    get oauthAssertionIssuer(): string;
    set oauthAssertionIssuer(value: string);
    get oauthAssertionIssuerInput(): string | undefined;
    private _oauthAuthorizationEndpoint?;
    get oauthAuthorizationEndpoint(): string;
    set oauthAuthorizationEndpoint(value: string);
    resetOauthAuthorizationEndpoint(): void;
    get oauthAuthorizationEndpointInput(): string | undefined;
    private _oauthClientAuthMethod?;
    get oauthClientAuthMethod(): string;
    set oauthClientAuthMethod(value: string);
    resetOauthClientAuthMethod(): void;
    get oauthClientAuthMethodInput(): string | undefined;
    private _oauthClientId?;
    get oauthClientId(): string;
    set oauthClientId(value: string);
    get oauthClientIdInput(): string | undefined;
    private _oauthClientSecret?;
    get oauthClientSecret(): string;
    set oauthClientSecret(value: string);
    get oauthClientSecretInput(): string | undefined;
    private _oauthRefreshTokenValidity?;
    get oauthRefreshTokenValidity(): number;
    set oauthRefreshTokenValidity(value: number);
    resetOauthRefreshTokenValidity(): void;
    get oauthRefreshTokenValidityInput(): number | undefined;
    private _oauthTokenEndpoint?;
    get oauthTokenEndpoint(): string;
    set oauthTokenEndpoint(value: string);
    resetOauthTokenEndpoint(): void;
    get oauthTokenEndpointInput(): string | undefined;
    private _showOutput;
    get showOutput(): ApiAuthenticationIntegrationWithJwtBearerShowOutputList;
    private _timeouts;
    get timeouts(): ApiAuthenticationIntegrationWithJwtBearerTimeoutsOutputReference;
    putTimeouts(value: ApiAuthenticationIntegrationWithJwtBearerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiAuthenticationIntegrationWithJwtBearerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
