/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a compute pool when a service or job is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#auto_resume ComputePool#auto_resume}
    */
    readonly autoResume?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Number of seconds of inactivity after which you want Snowflake to automatically suspend the compute pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#auto_suspend_secs ComputePool#auto_suspend_secs}
    */
    readonly autoSuspendSecs?: number;
    /**
    * Specifies a comment for the compute pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#comment ComputePool#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the Snowflake Native App name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#for_application ComputePool#for_application}
    */
    readonly forApplication?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#id ComputePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the compute pool is created initially in the suspended state. This field is used only when creating a compute pool. Changes on this field are ignored after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#initially_suspended ComputePool#initially_suspended}
    */
    readonly initiallySuspended?: string;
    /**
    * Identifies the type of machine you want to provision for the nodes in the compute pool. Valid values are (case-insensitive): `CPU_X64_XS` | `CPU_X64_S` | `CPU_X64_M` | `CPU_X64_L` | `HIGHMEM_X64_S` | `HIGHMEM_X64_M` | `HIGHMEM_X64_L` | `HIGHMEM_X64_SL` | `GPU_NV_S` | `GPU_NV_M` | `GPU_NV_L` | `GPU_NV_XS` | `GPU_NV_SM` | `GPU_NV_2M` | `GPU_NV_3M` | `GPU_NV_SL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#instance_family ComputePool#instance_family}
    */
    readonly instanceFamily: string;
    /**
    * Specifies the maximum number of nodes for the compute pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#max_nodes ComputePool#max_nodes}
    */
    readonly maxNodes: number;
    /**
    * Specifies the minimum number of nodes for the compute pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#min_nodes ComputePool#min_nodes}
    */
    readonly minNodes: number;
    /**
    * Specifies the identifier for the compute pool; must be unique for the account. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#name ComputePool#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#timeouts ComputePool#timeouts}
    */
    readonly timeouts?: ComputePoolTimeouts;
}
export interface ComputePoolDescribeOutput {
}
export declare function computePoolDescribeOutputToTerraform(struct?: ComputePoolDescribeOutput): any;
export declare function computePoolDescribeOutputToHclTerraform(struct?: ComputePoolDescribeOutput): any;
export declare class ComputePoolDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputePoolDescribeOutput | undefined;
    set internalValue(value: ComputePoolDescribeOutput | undefined);
    get activeNodes(): number;
    get application(): string;
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get createdOn(): string;
    get errorCode(): string;
    get idleNodes(): number;
    get instanceFamily(): string;
    get isExclusive(): cdktf.IResolvable;
    get maxNodes(): number;
    get minNodes(): number;
    get name(): string;
    get numJobs(): number;
    get numServices(): number;
    get owner(): string;
    get resumedOn(): string;
    get state(): string;
    get statusMessage(): string;
    get targetNodes(): number;
    get updatedOn(): string;
}
export declare class ComputePoolDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputePoolDescribeOutputOutputReference;
}
export interface ComputePoolShowOutput {
}
export declare function computePoolShowOutputToTerraform(struct?: ComputePoolShowOutput): any;
export declare function computePoolShowOutputToHclTerraform(struct?: ComputePoolShowOutput): any;
export declare class ComputePoolShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputePoolShowOutput | undefined;
    set internalValue(value: ComputePoolShowOutput | undefined);
    get activeNodes(): number;
    get application(): string;
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get createdOn(): string;
    get idleNodes(): number;
    get instanceFamily(): string;
    get isExclusive(): cdktf.IResolvable;
    get maxNodes(): number;
    get minNodes(): number;
    get name(): string;
    get numJobs(): number;
    get numServices(): number;
    get owner(): string;
    get resumedOn(): string;
    get state(): string;
    get targetNodes(): number;
    get updatedOn(): string;
}
export declare class ComputePoolShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputePoolShowOutputOutputReference;
}
export interface ComputePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#create ComputePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#delete ComputePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#read ComputePool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#update ComputePool#update}
    */
    readonly update?: string;
}
export declare function computePoolTimeoutsToTerraform(struct?: ComputePoolTimeouts | cdktf.IResolvable): any;
export declare function computePoolTimeoutsToHclTerraform(struct?: ComputePoolTimeouts | cdktf.IResolvable): any;
export declare class ComputePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool snowflake_compute_pool}
*/
export declare class ComputePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_compute_pool";
    /**
    * Generates CDKTF code for importing a ComputePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ComputePool to import
    * @param importFromId The id of the existing ComputePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ComputePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/compute_pool snowflake_compute_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputePoolConfig
    */
    constructor(scope: Construct, id: string, config: ComputePoolConfig);
    private _autoResume?;
    get autoResume(): string;
    set autoResume(value: string);
    resetAutoResume(): void;
    get autoResumeInput(): string | undefined;
    private _autoSuspendSecs?;
    get autoSuspendSecs(): number;
    set autoSuspendSecs(value: number);
    resetAutoSuspendSecs(): void;
    get autoSuspendSecsInput(): number | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ComputePoolDescribeOutputList;
    private _forApplication?;
    get forApplication(): string;
    set forApplication(value: string);
    resetForApplication(): void;
    get forApplicationInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initiallySuspended?;
    get initiallySuspended(): string;
    set initiallySuspended(value: string);
    resetInitiallySuspended(): void;
    get initiallySuspendedInput(): string | undefined;
    private _instanceFamily?;
    get instanceFamily(): string;
    set instanceFamily(value: string);
    get instanceFamilyInput(): string | undefined;
    private _maxNodes?;
    get maxNodes(): number;
    set maxNodes(value: number);
    get maxNodesInput(): number | undefined;
    private _minNodes?;
    get minNodes(): number;
    set minNodes(value: number);
    get minNodesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _showOutput;
    get showOutput(): ComputePoolShowOutputList;
    private _timeouts;
    get timeouts(): ComputePoolTimeoutsOutputReference;
    putTimeouts(value: ComputePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
