"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrentAccount = exports.CurrentAccountTimeoutsOutputReference = void 0;
exports.currentAccountTimeoutsToTerraform = currentAccountTimeoutsToTerraform;
exports.currentAccountTimeoutsToHclTerraform = currentAccountTimeoutsToHclTerraform;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function currentAccountTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
function currentAccountTimeoutsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        create: {
            value: cdktf.stringToHclTerraform(struct.create),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        delete: {
            value: cdktf.stringToHclTerraform(struct.delete),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        read: {
            value: cdktf.stringToHclTerraform(struct.read),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        update: {
            value: cdktf.stringToHclTerraform(struct.update),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
class CurrentAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.CurrentAccountTimeoutsOutputReference = CurrentAccountTimeoutsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
CurrentAccountTimeoutsOutputReference[_a] = { fqn: "@cdktf/provider-snowflake.currentAccount.CurrentAccountTimeoutsOutputReference", version: "15.1.0" };
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/current_account snowflake_current_account}
*/
class CurrentAccount extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a CurrentAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CurrentAccount to import
    * @param importFromId The id of the existing CurrentAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/current_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CurrentAccount to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake_current_account", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/current_account snowflake_current_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CurrentAccountConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'snowflake_current_account',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '2.2.0',
                providerVersionConstraint: ' ~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new CurrentAccountTimeoutsOutputReference(this, "timeouts");
        this._abortDetachedQuery = config.abortDetachedQuery;
        this._activePythonProfiler = config.activePythonProfiler;
        this._allowClientMfaCaching = config.allowClientMfaCaching;
        this._allowIdToken = config.allowIdToken;
        this._authenticationPolicy = config.authenticationPolicy;
        this._autocommit = config.autocommit;
        this._baseLocationPrefix = config.baseLocationPrefix;
        this._binaryInputFormat = config.binaryInputFormat;
        this._binaryOutputFormat = config.binaryOutputFormat;
        this._catalog = config.catalog;
        this._catalogSync = config.catalogSync;
        this._clientEnableLogInfoStatementParameters = config.clientEnableLogInfoStatementParameters;
        this._clientEncryptionKeySize = config.clientEncryptionKeySize;
        this._clientMemoryLimit = config.clientMemoryLimit;
        this._clientMetadataRequestUseConnectionCtx = config.clientMetadataRequestUseConnectionCtx;
        this._clientMetadataUseSessionDatabase = config.clientMetadataUseSessionDatabase;
        this._clientPrefetchThreads = config.clientPrefetchThreads;
        this._clientResultChunkSize = config.clientResultChunkSize;
        this._clientResultColumnCaseInsensitive = config.clientResultColumnCaseInsensitive;
        this._clientSessionKeepAlive = config.clientSessionKeepAlive;
        this._clientSessionKeepAliveHeartbeatFrequency = config.clientSessionKeepAliveHeartbeatFrequency;
        this._clientTimestampTypeMapping = config.clientTimestampTypeMapping;
        this._cortexEnabledCrossRegion = config.cortexEnabledCrossRegion;
        this._cortexModelsAllowlist = config.cortexModelsAllowlist;
        this._csvTimestampFormat = config.csvTimestampFormat;
        this._dataRetentionTimeInDays = config.dataRetentionTimeInDays;
        this._dateInputFormat = config.dateInputFormat;
        this._dateOutputFormat = config.dateOutputFormat;
        this._defaultDdlCollation = config.defaultDdlCollation;
        this._defaultNotebookComputePoolCpu = config.defaultNotebookComputePoolCpu;
        this._defaultNotebookComputePoolGpu = config.defaultNotebookComputePoolGpu;
        this._defaultNullOrdering = config.defaultNullOrdering;
        this._defaultStreamlitNotebookWarehouse = config.defaultStreamlitNotebookWarehouse;
        this._disableUiDownloadButton = config.disableUiDownloadButton;
        this._disableUserPrivilegeGrants = config.disableUserPrivilegeGrants;
        this._enableAutomaticSensitiveDataClassificationLog = config.enableAutomaticSensitiveDataClassificationLog;
        this._enableEgressCostOptimizer = config.enableEgressCostOptimizer;
        this._enableIdentifierFirstLogin = config.enableIdentifierFirstLogin;
        this._enableInternalStagesPrivatelink = config.enableInternalStagesPrivatelink;
        this._enableTriSecretAndRekeyOptOutForImageRepository = config.enableTriSecretAndRekeyOptOutForImageRepository;
        this._enableTriSecretAndRekeyOptOutForSpcsBlockStorage = config.enableTriSecretAndRekeyOptOutForSpcsBlockStorage;
        this._enableUnhandledExceptionsReporting = config.enableUnhandledExceptionsReporting;
        this._enableUnloadPhysicalTypeOptimization = config.enableUnloadPhysicalTypeOptimization;
        this._enableUnredactedQuerySyntaxError = config.enableUnredactedQuerySyntaxError;
        this._enableUnredactedSecureObjectError = config.enableUnredactedSecureObjectError;
        this._enforceNetworkRulesForInternalStages = config.enforceNetworkRulesForInternalStages;
        this._errorOnNondeterministicMerge = config.errorOnNondeterministicMerge;
        this._errorOnNondeterministicUpdate = config.errorOnNondeterministicUpdate;
        this._eventTable = config.eventTable;
        this._externalOauthAddPrivilegedRolesToBlockedList = config.externalOauthAddPrivilegedRolesToBlockedList;
        this._externalVolume = config.externalVolume;
        this._featurePolicy = config.featurePolicy;
        this._geographyOutputFormat = config.geographyOutputFormat;
        this._geometryOutputFormat = config.geometryOutputFormat;
        this._hybridTableLockTimeout = config.hybridTableLockTimeout;
        this._id = config.id;
        this._initialReplicationSizeLimitInTb = config.initialReplicationSizeLimitInTb;
        this._jdbcTreatDecimalAsInt = config.jdbcTreatDecimalAsInt;
        this._jdbcTreatTimestampNtzAsUtc = config.jdbcTreatTimestampNtzAsUtc;
        this._jdbcUseSessionTimezone = config.jdbcUseSessionTimezone;
        this._jsTreatIntegerAsBigint = config.jsTreatIntegerAsBigint;
        this._jsonIndent = config.jsonIndent;
        this._listingAutoFulfillmentReplicationRefreshSchedule = config.listingAutoFulfillmentReplicationRefreshSchedule;
        this._lockTimeout = config.lockTimeout;
        this._logLevel = config.logLevel;
        this._maxConcurrencyLevel = config.maxConcurrencyLevel;
        this._maxDataExtensionTimeInDays = config.maxDataExtensionTimeInDays;
        this._metricLevel = config.metricLevel;
        this._minDataRetentionTimeInDays = config.minDataRetentionTimeInDays;
        this._multiStatementCount = config.multiStatementCount;
        this._networkPolicy = config.networkPolicy;
        this._noorderSequenceAsDefault = config.noorderSequenceAsDefault;
        this._oauthAddPrivilegedRolesToBlockedList = config.oauthAddPrivilegedRolesToBlockedList;
        this._odbcTreatDecimalAsInt = config.odbcTreatDecimalAsInt;
        this._packagesPolicy = config.packagesPolicy;
        this._passwordPolicy = config.passwordPolicy;
        this._periodicDataRekeying = config.periodicDataRekeying;
        this._pipeExecutionPaused = config.pipeExecutionPaused;
        this._preventUnloadToInlineUrl = config.preventUnloadToInlineUrl;
        this._preventUnloadToInternalStages = config.preventUnloadToInternalStages;
        this._pythonProfilerModules = config.pythonProfilerModules;
        this._pythonProfilerTargetStage = config.pythonProfilerTargetStage;
        this._queryTag = config.queryTag;
        this._quotedIdentifiersIgnoreCase = config.quotedIdentifiersIgnoreCase;
        this._replaceInvalidCharacters = config.replaceInvalidCharacters;
        this._requireStorageIntegrationForStageCreation = config.requireStorageIntegrationForStageCreation;
        this._requireStorageIntegrationForStageOperation = config.requireStorageIntegrationForStageOperation;
        this._resourceMonitor = config.resourceMonitor;
        this._rowsPerResultset = config.rowsPerResultset;
        this._s3StageVpceDnsName = config.s3StageVpceDnsName;
        this._samlIdentityProvider = config.samlIdentityProvider;
        this._searchPath = config.searchPath;
        this._serverlessTaskMaxStatementSize = config.serverlessTaskMaxStatementSize;
        this._serverlessTaskMinStatementSize = config.serverlessTaskMinStatementSize;
        this._sessionPolicy = config.sessionPolicy;
        this._simulatedDataSharingConsumer = config.simulatedDataSharingConsumer;
        this._ssoLoginPage = config.ssoLoginPage;
        this._statementQueuedTimeoutInSeconds = config.statementQueuedTimeoutInSeconds;
        this._statementTimeoutInSeconds = config.statementTimeoutInSeconds;
        this._storageSerializationPolicy = config.storageSerializationPolicy;
        this._strictJsonOutput = config.strictJsonOutput;
        this._suspendTaskAfterNumFailures = config.suspendTaskAfterNumFailures;
        this._taskAutoRetryAttempts = config.taskAutoRetryAttempts;
        this._timeInputFormat = config.timeInputFormat;
        this._timeOutputFormat = config.timeOutputFormat;
        this._timestampDayIsAlways24H = config.timestampDayIsAlways24H;
        this._timestampInputFormat = config.timestampInputFormat;
        this._timestampLtzOutputFormat = config.timestampLtzOutputFormat;
        this._timestampNtzOutputFormat = config.timestampNtzOutputFormat;
        this._timestampOutputFormat = config.timestampOutputFormat;
        this._timestampTypeMapping = config.timestampTypeMapping;
        this._timestampTzOutputFormat = config.timestampTzOutputFormat;
        this._timezone = config.timezone;
        this._traceLevel = config.traceLevel;
        this._transactionAbortOnError = config.transactionAbortOnError;
        this._transactionDefaultIsolationLevel = config.transactionDefaultIsolationLevel;
        this._twoDigitCenturyStart = config.twoDigitCenturyStart;
        this._unsupportedDdlAction = config.unsupportedDdlAction;
        this._useCachedResult = config.useCachedResult;
        this._userTaskManagedInitialWarehouseSize = config.userTaskManagedInitialWarehouseSize;
        this._userTaskMinimumTriggerIntervalInSeconds = config.userTaskMinimumTriggerIntervalInSeconds;
        this._userTaskTimeoutMs = config.userTaskTimeoutMs;
        this._weekOfYearPolicy = config.weekOfYearPolicy;
        this._weekStart = config.weekStart;
        this._timeouts.internalValue = config.timeouts;
    }
    get abortDetachedQuery() {
        return this.getBooleanAttribute('abort_detached_query');
    }
    set abortDetachedQuery(value) {
        this._abortDetachedQuery = value;
    }
    resetAbortDetachedQuery() {
        this._abortDetachedQuery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get abortDetachedQueryInput() {
        return this._abortDetachedQuery;
    }
    get activePythonProfiler() {
        return this.getStringAttribute('active_python_profiler');
    }
    set activePythonProfiler(value) {
        this._activePythonProfiler = value;
    }
    resetActivePythonProfiler() {
        this._activePythonProfiler = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activePythonProfilerInput() {
        return this._activePythonProfiler;
    }
    get allowClientMfaCaching() {
        return this.getBooleanAttribute('allow_client_mfa_caching');
    }
    set allowClientMfaCaching(value) {
        this._allowClientMfaCaching = value;
    }
    resetAllowClientMfaCaching() {
        this._allowClientMfaCaching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowClientMfaCachingInput() {
        return this._allowClientMfaCaching;
    }
    get allowIdToken() {
        return this.getBooleanAttribute('allow_id_token');
    }
    set allowIdToken(value) {
        this._allowIdToken = value;
    }
    resetAllowIdToken() {
        this._allowIdToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowIdTokenInput() {
        return this._allowIdToken;
    }
    get authenticationPolicy() {
        return this.getStringAttribute('authentication_policy');
    }
    set authenticationPolicy(value) {
        this._authenticationPolicy = value;
    }
    resetAuthenticationPolicy() {
        this._authenticationPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authenticationPolicyInput() {
        return this._authenticationPolicy;
    }
    get autocommit() {
        return this.getBooleanAttribute('autocommit');
    }
    set autocommit(value) {
        this._autocommit = value;
    }
    resetAutocommit() {
        this._autocommit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autocommitInput() {
        return this._autocommit;
    }
    get baseLocationPrefix() {
        return this.getStringAttribute('base_location_prefix');
    }
    set baseLocationPrefix(value) {
        this._baseLocationPrefix = value;
    }
    resetBaseLocationPrefix() {
        this._baseLocationPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseLocationPrefixInput() {
        return this._baseLocationPrefix;
    }
    get binaryInputFormat() {
        return this.getStringAttribute('binary_input_format');
    }
    set binaryInputFormat(value) {
        this._binaryInputFormat = value;
    }
    resetBinaryInputFormat() {
        this._binaryInputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryInputFormatInput() {
        return this._binaryInputFormat;
    }
    get binaryOutputFormat() {
        return this.getStringAttribute('binary_output_format');
    }
    set binaryOutputFormat(value) {
        this._binaryOutputFormat = value;
    }
    resetBinaryOutputFormat() {
        this._binaryOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryOutputFormatInput() {
        return this._binaryOutputFormat;
    }
    get catalog() {
        return this.getStringAttribute('catalog');
    }
    set catalog(value) {
        this._catalog = value;
    }
    resetCatalog() {
        this._catalog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get catalogInput() {
        return this._catalog;
    }
    get catalogSync() {
        return this.getStringAttribute('catalog_sync');
    }
    set catalogSync(value) {
        this._catalogSync = value;
    }
    resetCatalogSync() {
        this._catalogSync = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get catalogSyncInput() {
        return this._catalogSync;
    }
    get clientEnableLogInfoStatementParameters() {
        return this.getBooleanAttribute('client_enable_log_info_statement_parameters');
    }
    set clientEnableLogInfoStatementParameters(value) {
        this._clientEnableLogInfoStatementParameters = value;
    }
    resetClientEnableLogInfoStatementParameters() {
        this._clientEnableLogInfoStatementParameters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientEnableLogInfoStatementParametersInput() {
        return this._clientEnableLogInfoStatementParameters;
    }
    get clientEncryptionKeySize() {
        return this.getNumberAttribute('client_encryption_key_size');
    }
    set clientEncryptionKeySize(value) {
        this._clientEncryptionKeySize = value;
    }
    resetClientEncryptionKeySize() {
        this._clientEncryptionKeySize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientEncryptionKeySizeInput() {
        return this._clientEncryptionKeySize;
    }
    get clientMemoryLimit() {
        return this.getNumberAttribute('client_memory_limit');
    }
    set clientMemoryLimit(value) {
        this._clientMemoryLimit = value;
    }
    resetClientMemoryLimit() {
        this._clientMemoryLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientMemoryLimitInput() {
        return this._clientMemoryLimit;
    }
    get clientMetadataRequestUseConnectionCtx() {
        return this.getBooleanAttribute('client_metadata_request_use_connection_ctx');
    }
    set clientMetadataRequestUseConnectionCtx(value) {
        this._clientMetadataRequestUseConnectionCtx = value;
    }
    resetClientMetadataRequestUseConnectionCtx() {
        this._clientMetadataRequestUseConnectionCtx = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientMetadataRequestUseConnectionCtxInput() {
        return this._clientMetadataRequestUseConnectionCtx;
    }
    get clientMetadataUseSessionDatabase() {
        return this.getBooleanAttribute('client_metadata_use_session_database');
    }
    set clientMetadataUseSessionDatabase(value) {
        this._clientMetadataUseSessionDatabase = value;
    }
    resetClientMetadataUseSessionDatabase() {
        this._clientMetadataUseSessionDatabase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientMetadataUseSessionDatabaseInput() {
        return this._clientMetadataUseSessionDatabase;
    }
    get clientPrefetchThreads() {
        return this.getNumberAttribute('client_prefetch_threads');
    }
    set clientPrefetchThreads(value) {
        this._clientPrefetchThreads = value;
    }
    resetClientPrefetchThreads() {
        this._clientPrefetchThreads = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientPrefetchThreadsInput() {
        return this._clientPrefetchThreads;
    }
    get clientResultChunkSize() {
        return this.getNumberAttribute('client_result_chunk_size');
    }
    set clientResultChunkSize(value) {
        this._clientResultChunkSize = value;
    }
    resetClientResultChunkSize() {
        this._clientResultChunkSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientResultChunkSizeInput() {
        return this._clientResultChunkSize;
    }
    get clientResultColumnCaseInsensitive() {
        return this.getBooleanAttribute('client_result_column_case_insensitive');
    }
    set clientResultColumnCaseInsensitive(value) {
        this._clientResultColumnCaseInsensitive = value;
    }
    resetClientResultColumnCaseInsensitive() {
        this._clientResultColumnCaseInsensitive = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientResultColumnCaseInsensitiveInput() {
        return this._clientResultColumnCaseInsensitive;
    }
    get clientSessionKeepAlive() {
        return this.getBooleanAttribute('client_session_keep_alive');
    }
    set clientSessionKeepAlive(value) {
        this._clientSessionKeepAlive = value;
    }
    resetClientSessionKeepAlive() {
        this._clientSessionKeepAlive = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSessionKeepAliveInput() {
        return this._clientSessionKeepAlive;
    }
    get clientSessionKeepAliveHeartbeatFrequency() {
        return this.getNumberAttribute('client_session_keep_alive_heartbeat_frequency');
    }
    set clientSessionKeepAliveHeartbeatFrequency(value) {
        this._clientSessionKeepAliveHeartbeatFrequency = value;
    }
    resetClientSessionKeepAliveHeartbeatFrequency() {
        this._clientSessionKeepAliveHeartbeatFrequency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSessionKeepAliveHeartbeatFrequencyInput() {
        return this._clientSessionKeepAliveHeartbeatFrequency;
    }
    get clientTimestampTypeMapping() {
        return this.getStringAttribute('client_timestamp_type_mapping');
    }
    set clientTimestampTypeMapping(value) {
        this._clientTimestampTypeMapping = value;
    }
    resetClientTimestampTypeMapping() {
        this._clientTimestampTypeMapping = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTimestampTypeMappingInput() {
        return this._clientTimestampTypeMapping;
    }
    get cortexEnabledCrossRegion() {
        return this.getStringAttribute('cortex_enabled_cross_region');
    }
    set cortexEnabledCrossRegion(value) {
        this._cortexEnabledCrossRegion = value;
    }
    resetCortexEnabledCrossRegion() {
        this._cortexEnabledCrossRegion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cortexEnabledCrossRegionInput() {
        return this._cortexEnabledCrossRegion;
    }
    get cortexModelsAllowlist() {
        return this.getStringAttribute('cortex_models_allowlist');
    }
    set cortexModelsAllowlist(value) {
        this._cortexModelsAllowlist = value;
    }
    resetCortexModelsAllowlist() {
        this._cortexModelsAllowlist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cortexModelsAllowlistInput() {
        return this._cortexModelsAllowlist;
    }
    get csvTimestampFormat() {
        return this.getStringAttribute('csv_timestamp_format');
    }
    set csvTimestampFormat(value) {
        this._csvTimestampFormat = value;
    }
    resetCsvTimestampFormat() {
        this._csvTimestampFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get csvTimestampFormatInput() {
        return this._csvTimestampFormat;
    }
    get dataRetentionTimeInDays() {
        return this.getNumberAttribute('data_retention_time_in_days');
    }
    set dataRetentionTimeInDays(value) {
        this._dataRetentionTimeInDays = value;
    }
    resetDataRetentionTimeInDays() {
        this._dataRetentionTimeInDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataRetentionTimeInDaysInput() {
        return this._dataRetentionTimeInDays;
    }
    get dateInputFormat() {
        return this.getStringAttribute('date_input_format');
    }
    set dateInputFormat(value) {
        this._dateInputFormat = value;
    }
    resetDateInputFormat() {
        this._dateInputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dateInputFormatInput() {
        return this._dateInputFormat;
    }
    get dateOutputFormat() {
        return this.getStringAttribute('date_output_format');
    }
    set dateOutputFormat(value) {
        this._dateOutputFormat = value;
    }
    resetDateOutputFormat() {
        this._dateOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dateOutputFormatInput() {
        return this._dateOutputFormat;
    }
    get defaultDdlCollation() {
        return this.getStringAttribute('default_ddl_collation');
    }
    set defaultDdlCollation(value) {
        this._defaultDdlCollation = value;
    }
    resetDefaultDdlCollation() {
        this._defaultDdlCollation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultDdlCollationInput() {
        return this._defaultDdlCollation;
    }
    get defaultNotebookComputePoolCpu() {
        return this.getStringAttribute('default_notebook_compute_pool_cpu');
    }
    set defaultNotebookComputePoolCpu(value) {
        this._defaultNotebookComputePoolCpu = value;
    }
    resetDefaultNotebookComputePoolCpu() {
        this._defaultNotebookComputePoolCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultNotebookComputePoolCpuInput() {
        return this._defaultNotebookComputePoolCpu;
    }
    get defaultNotebookComputePoolGpu() {
        return this.getStringAttribute('default_notebook_compute_pool_gpu');
    }
    set defaultNotebookComputePoolGpu(value) {
        this._defaultNotebookComputePoolGpu = value;
    }
    resetDefaultNotebookComputePoolGpu() {
        this._defaultNotebookComputePoolGpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultNotebookComputePoolGpuInput() {
        return this._defaultNotebookComputePoolGpu;
    }
    get defaultNullOrdering() {
        return this.getStringAttribute('default_null_ordering');
    }
    set defaultNullOrdering(value) {
        this._defaultNullOrdering = value;
    }
    resetDefaultNullOrdering() {
        this._defaultNullOrdering = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultNullOrderingInput() {
        return this._defaultNullOrdering;
    }
    get defaultStreamlitNotebookWarehouse() {
        return this.getStringAttribute('default_streamlit_notebook_warehouse');
    }
    set defaultStreamlitNotebookWarehouse(value) {
        this._defaultStreamlitNotebookWarehouse = value;
    }
    resetDefaultStreamlitNotebookWarehouse() {
        this._defaultStreamlitNotebookWarehouse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultStreamlitNotebookWarehouseInput() {
        return this._defaultStreamlitNotebookWarehouse;
    }
    get disableUiDownloadButton() {
        return this.getBooleanAttribute('disable_ui_download_button');
    }
    set disableUiDownloadButton(value) {
        this._disableUiDownloadButton = value;
    }
    resetDisableUiDownloadButton() {
        this._disableUiDownloadButton = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableUiDownloadButtonInput() {
        return this._disableUiDownloadButton;
    }
    get disableUserPrivilegeGrants() {
        return this.getBooleanAttribute('disable_user_privilege_grants');
    }
    set disableUserPrivilegeGrants(value) {
        this._disableUserPrivilegeGrants = value;
    }
    resetDisableUserPrivilegeGrants() {
        this._disableUserPrivilegeGrants = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableUserPrivilegeGrantsInput() {
        return this._disableUserPrivilegeGrants;
    }
    get enableAutomaticSensitiveDataClassificationLog() {
        return this.getBooleanAttribute('enable_automatic_sensitive_data_classification_log');
    }
    set enableAutomaticSensitiveDataClassificationLog(value) {
        this._enableAutomaticSensitiveDataClassificationLog = value;
    }
    resetEnableAutomaticSensitiveDataClassificationLog() {
        this._enableAutomaticSensitiveDataClassificationLog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableAutomaticSensitiveDataClassificationLogInput() {
        return this._enableAutomaticSensitiveDataClassificationLog;
    }
    get enableEgressCostOptimizer() {
        return this.getBooleanAttribute('enable_egress_cost_optimizer');
    }
    set enableEgressCostOptimizer(value) {
        this._enableEgressCostOptimizer = value;
    }
    resetEnableEgressCostOptimizer() {
        this._enableEgressCostOptimizer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableEgressCostOptimizerInput() {
        return this._enableEgressCostOptimizer;
    }
    get enableIdentifierFirstLogin() {
        return this.getBooleanAttribute('enable_identifier_first_login');
    }
    set enableIdentifierFirstLogin(value) {
        this._enableIdentifierFirstLogin = value;
    }
    resetEnableIdentifierFirstLogin() {
        this._enableIdentifierFirstLogin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableIdentifierFirstLoginInput() {
        return this._enableIdentifierFirstLogin;
    }
    get enableInternalStagesPrivatelink() {
        return this.getBooleanAttribute('enable_internal_stages_privatelink');
    }
    set enableInternalStagesPrivatelink(value) {
        this._enableInternalStagesPrivatelink = value;
    }
    resetEnableInternalStagesPrivatelink() {
        this._enableInternalStagesPrivatelink = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableInternalStagesPrivatelinkInput() {
        return this._enableInternalStagesPrivatelink;
    }
    get enableTriSecretAndRekeyOptOutForImageRepository() {
        return this.getBooleanAttribute('enable_tri_secret_and_rekey_opt_out_for_image_repository');
    }
    set enableTriSecretAndRekeyOptOutForImageRepository(value) {
        this._enableTriSecretAndRekeyOptOutForImageRepository = value;
    }
    resetEnableTriSecretAndRekeyOptOutForImageRepository() {
        this._enableTriSecretAndRekeyOptOutForImageRepository = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableTriSecretAndRekeyOptOutForImageRepositoryInput() {
        return this._enableTriSecretAndRekeyOptOutForImageRepository;
    }
    get enableTriSecretAndRekeyOptOutForSpcsBlockStorage() {
        return this.getBooleanAttribute('enable_tri_secret_and_rekey_opt_out_for_spcs_block_storage');
    }
    set enableTriSecretAndRekeyOptOutForSpcsBlockStorage(value) {
        this._enableTriSecretAndRekeyOptOutForSpcsBlockStorage = value;
    }
    resetEnableTriSecretAndRekeyOptOutForSpcsBlockStorage() {
        this._enableTriSecretAndRekeyOptOutForSpcsBlockStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableTriSecretAndRekeyOptOutForSpcsBlockStorageInput() {
        return this._enableTriSecretAndRekeyOptOutForSpcsBlockStorage;
    }
    get enableUnhandledExceptionsReporting() {
        return this.getBooleanAttribute('enable_unhandled_exceptions_reporting');
    }
    set enableUnhandledExceptionsReporting(value) {
        this._enableUnhandledExceptionsReporting = value;
    }
    resetEnableUnhandledExceptionsReporting() {
        this._enableUnhandledExceptionsReporting = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableUnhandledExceptionsReportingInput() {
        return this._enableUnhandledExceptionsReporting;
    }
    get enableUnloadPhysicalTypeOptimization() {
        return this.getBooleanAttribute('enable_unload_physical_type_optimization');
    }
    set enableUnloadPhysicalTypeOptimization(value) {
        this._enableUnloadPhysicalTypeOptimization = value;
    }
    resetEnableUnloadPhysicalTypeOptimization() {
        this._enableUnloadPhysicalTypeOptimization = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableUnloadPhysicalTypeOptimizationInput() {
        return this._enableUnloadPhysicalTypeOptimization;
    }
    get enableUnredactedQuerySyntaxError() {
        return this.getBooleanAttribute('enable_unredacted_query_syntax_error');
    }
    set enableUnredactedQuerySyntaxError(value) {
        this._enableUnredactedQuerySyntaxError = value;
    }
    resetEnableUnredactedQuerySyntaxError() {
        this._enableUnredactedQuerySyntaxError = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableUnredactedQuerySyntaxErrorInput() {
        return this._enableUnredactedQuerySyntaxError;
    }
    get enableUnredactedSecureObjectError() {
        return this.getBooleanAttribute('enable_unredacted_secure_object_error');
    }
    set enableUnredactedSecureObjectError(value) {
        this._enableUnredactedSecureObjectError = value;
    }
    resetEnableUnredactedSecureObjectError() {
        this._enableUnredactedSecureObjectError = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableUnredactedSecureObjectErrorInput() {
        return this._enableUnredactedSecureObjectError;
    }
    get enforceNetworkRulesForInternalStages() {
        return this.getBooleanAttribute('enforce_network_rules_for_internal_stages');
    }
    set enforceNetworkRulesForInternalStages(value) {
        this._enforceNetworkRulesForInternalStages = value;
    }
    resetEnforceNetworkRulesForInternalStages() {
        this._enforceNetworkRulesForInternalStages = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enforceNetworkRulesForInternalStagesInput() {
        return this._enforceNetworkRulesForInternalStages;
    }
    get errorOnNondeterministicMerge() {
        return this.getBooleanAttribute('error_on_nondeterministic_merge');
    }
    set errorOnNondeterministicMerge(value) {
        this._errorOnNondeterministicMerge = value;
    }
    resetErrorOnNondeterministicMerge() {
        this._errorOnNondeterministicMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorOnNondeterministicMergeInput() {
        return this._errorOnNondeterministicMerge;
    }
    get errorOnNondeterministicUpdate() {
        return this.getBooleanAttribute('error_on_nondeterministic_update');
    }
    set errorOnNondeterministicUpdate(value) {
        this._errorOnNondeterministicUpdate = value;
    }
    resetErrorOnNondeterministicUpdate() {
        this._errorOnNondeterministicUpdate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorOnNondeterministicUpdateInput() {
        return this._errorOnNondeterministicUpdate;
    }
    get eventTable() {
        return this.getStringAttribute('event_table');
    }
    set eventTable(value) {
        this._eventTable = value;
    }
    resetEventTable() {
        this._eventTable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventTableInput() {
        return this._eventTable;
    }
    get externalOauthAddPrivilegedRolesToBlockedList() {
        return this.getBooleanAttribute('external_oauth_add_privileged_roles_to_blocked_list');
    }
    set externalOauthAddPrivilegedRolesToBlockedList(value) {
        this._externalOauthAddPrivilegedRolesToBlockedList = value;
    }
    resetExternalOauthAddPrivilegedRolesToBlockedList() {
        this._externalOauthAddPrivilegedRolesToBlockedList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalOauthAddPrivilegedRolesToBlockedListInput() {
        return this._externalOauthAddPrivilegedRolesToBlockedList;
    }
    get externalVolume() {
        return this.getStringAttribute('external_volume');
    }
    set externalVolume(value) {
        this._externalVolume = value;
    }
    resetExternalVolume() {
        this._externalVolume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalVolumeInput() {
        return this._externalVolume;
    }
    get featurePolicy() {
        return this.getStringAttribute('feature_policy');
    }
    set featurePolicy(value) {
        this._featurePolicy = value;
    }
    resetFeaturePolicy() {
        this._featurePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get featurePolicyInput() {
        return this._featurePolicy;
    }
    get geographyOutputFormat() {
        return this.getStringAttribute('geography_output_format');
    }
    set geographyOutputFormat(value) {
        this._geographyOutputFormat = value;
    }
    resetGeographyOutputFormat() {
        this._geographyOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geographyOutputFormatInput() {
        return this._geographyOutputFormat;
    }
    get geometryOutputFormat() {
        return this.getStringAttribute('geometry_output_format');
    }
    set geometryOutputFormat(value) {
        this._geometryOutputFormat = value;
    }
    resetGeometryOutputFormat() {
        this._geometryOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geometryOutputFormatInput() {
        return this._geometryOutputFormat;
    }
    get hybridTableLockTimeout() {
        return this.getNumberAttribute('hybrid_table_lock_timeout');
    }
    set hybridTableLockTimeout(value) {
        this._hybridTableLockTimeout = value;
    }
    resetHybridTableLockTimeout() {
        this._hybridTableLockTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hybridTableLockTimeoutInput() {
        return this._hybridTableLockTimeout;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get initialReplicationSizeLimitInTb() {
        return this.getStringAttribute('initial_replication_size_limit_in_tb');
    }
    set initialReplicationSizeLimitInTb(value) {
        this._initialReplicationSizeLimitInTb = value;
    }
    resetInitialReplicationSizeLimitInTb() {
        this._initialReplicationSizeLimitInTb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initialReplicationSizeLimitInTbInput() {
        return this._initialReplicationSizeLimitInTb;
    }
    get jdbcTreatDecimalAsInt() {
        return this.getBooleanAttribute('jdbc_treat_decimal_as_int');
    }
    set jdbcTreatDecimalAsInt(value) {
        this._jdbcTreatDecimalAsInt = value;
    }
    resetJdbcTreatDecimalAsInt() {
        this._jdbcTreatDecimalAsInt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jdbcTreatDecimalAsIntInput() {
        return this._jdbcTreatDecimalAsInt;
    }
    get jdbcTreatTimestampNtzAsUtc() {
        return this.getBooleanAttribute('jdbc_treat_timestamp_ntz_as_utc');
    }
    set jdbcTreatTimestampNtzAsUtc(value) {
        this._jdbcTreatTimestampNtzAsUtc = value;
    }
    resetJdbcTreatTimestampNtzAsUtc() {
        this._jdbcTreatTimestampNtzAsUtc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jdbcTreatTimestampNtzAsUtcInput() {
        return this._jdbcTreatTimestampNtzAsUtc;
    }
    get jdbcUseSessionTimezone() {
        return this.getBooleanAttribute('jdbc_use_session_timezone');
    }
    set jdbcUseSessionTimezone(value) {
        this._jdbcUseSessionTimezone = value;
    }
    resetJdbcUseSessionTimezone() {
        this._jdbcUseSessionTimezone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jdbcUseSessionTimezoneInput() {
        return this._jdbcUseSessionTimezone;
    }
    get jsTreatIntegerAsBigint() {
        return this.getBooleanAttribute('js_treat_integer_as_bigint');
    }
    set jsTreatIntegerAsBigint(value) {
        this._jsTreatIntegerAsBigint = value;
    }
    resetJsTreatIntegerAsBigint() {
        this._jsTreatIntegerAsBigint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jsTreatIntegerAsBigintInput() {
        return this._jsTreatIntegerAsBigint;
    }
    get jsonIndent() {
        return this.getNumberAttribute('json_indent');
    }
    set jsonIndent(value) {
        this._jsonIndent = value;
    }
    resetJsonIndent() {
        this._jsonIndent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jsonIndentInput() {
        return this._jsonIndent;
    }
    get listingAutoFulfillmentReplicationRefreshSchedule() {
        return this.getStringAttribute('listing_auto_fulfillment_replication_refresh_schedule');
    }
    set listingAutoFulfillmentReplicationRefreshSchedule(value) {
        this._listingAutoFulfillmentReplicationRefreshSchedule = value;
    }
    resetListingAutoFulfillmentReplicationRefreshSchedule() {
        this._listingAutoFulfillmentReplicationRefreshSchedule = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get listingAutoFulfillmentReplicationRefreshScheduleInput() {
        return this._listingAutoFulfillmentReplicationRefreshSchedule;
    }
    get lockTimeout() {
        return this.getNumberAttribute('lock_timeout');
    }
    set lockTimeout(value) {
        this._lockTimeout = value;
    }
    resetLockTimeout() {
        this._lockTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lockTimeoutInput() {
        return this._lockTimeout;
    }
    get logLevel() {
        return this.getStringAttribute('log_level');
    }
    set logLevel(value) {
        this._logLevel = value;
    }
    resetLogLevel() {
        this._logLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logLevelInput() {
        return this._logLevel;
    }
    get maxConcurrencyLevel() {
        return this.getNumberAttribute('max_concurrency_level');
    }
    set maxConcurrencyLevel(value) {
        this._maxConcurrencyLevel = value;
    }
    resetMaxConcurrencyLevel() {
        this._maxConcurrencyLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxConcurrencyLevelInput() {
        return this._maxConcurrencyLevel;
    }
    get maxDataExtensionTimeInDays() {
        return this.getNumberAttribute('max_data_extension_time_in_days');
    }
    set maxDataExtensionTimeInDays(value) {
        this._maxDataExtensionTimeInDays = value;
    }
    resetMaxDataExtensionTimeInDays() {
        this._maxDataExtensionTimeInDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxDataExtensionTimeInDaysInput() {
        return this._maxDataExtensionTimeInDays;
    }
    get metricLevel() {
        return this.getStringAttribute('metric_level');
    }
    set metricLevel(value) {
        this._metricLevel = value;
    }
    resetMetricLevel() {
        this._metricLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metricLevelInput() {
        return this._metricLevel;
    }
    get minDataRetentionTimeInDays() {
        return this.getNumberAttribute('min_data_retention_time_in_days');
    }
    set minDataRetentionTimeInDays(value) {
        this._minDataRetentionTimeInDays = value;
    }
    resetMinDataRetentionTimeInDays() {
        this._minDataRetentionTimeInDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minDataRetentionTimeInDaysInput() {
        return this._minDataRetentionTimeInDays;
    }
    get multiStatementCount() {
        return this.getNumberAttribute('multi_statement_count');
    }
    set multiStatementCount(value) {
        this._multiStatementCount = value;
    }
    resetMultiStatementCount() {
        this._multiStatementCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get multiStatementCountInput() {
        return this._multiStatementCount;
    }
    get networkPolicy() {
        return this.getStringAttribute('network_policy');
    }
    set networkPolicy(value) {
        this._networkPolicy = value;
    }
    resetNetworkPolicy() {
        this._networkPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkPolicyInput() {
        return this._networkPolicy;
    }
    get noorderSequenceAsDefault() {
        return this.getBooleanAttribute('noorder_sequence_as_default');
    }
    set noorderSequenceAsDefault(value) {
        this._noorderSequenceAsDefault = value;
    }
    resetNoorderSequenceAsDefault() {
        this._noorderSequenceAsDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noorderSequenceAsDefaultInput() {
        return this._noorderSequenceAsDefault;
    }
    get oauthAddPrivilegedRolesToBlockedList() {
        return this.getBooleanAttribute('oauth_add_privileged_roles_to_blocked_list');
    }
    set oauthAddPrivilegedRolesToBlockedList(value) {
        this._oauthAddPrivilegedRolesToBlockedList = value;
    }
    resetOauthAddPrivilegedRolesToBlockedList() {
        this._oauthAddPrivilegedRolesToBlockedList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthAddPrivilegedRolesToBlockedListInput() {
        return this._oauthAddPrivilegedRolesToBlockedList;
    }
    get odbcTreatDecimalAsInt() {
        return this.getBooleanAttribute('odbc_treat_decimal_as_int');
    }
    set odbcTreatDecimalAsInt(value) {
        this._odbcTreatDecimalAsInt = value;
    }
    resetOdbcTreatDecimalAsInt() {
        this._odbcTreatDecimalAsInt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get odbcTreatDecimalAsIntInput() {
        return this._odbcTreatDecimalAsInt;
    }
    get packagesPolicy() {
        return this.getStringAttribute('packages_policy');
    }
    set packagesPolicy(value) {
        this._packagesPolicy = value;
    }
    resetPackagesPolicy() {
        this._packagesPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packagesPolicyInput() {
        return this._packagesPolicy;
    }
    get passwordPolicy() {
        return this.getStringAttribute('password_policy');
    }
    set passwordPolicy(value) {
        this._passwordPolicy = value;
    }
    resetPasswordPolicy() {
        this._passwordPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordPolicyInput() {
        return this._passwordPolicy;
    }
    get periodicDataRekeying() {
        return this.getBooleanAttribute('periodic_data_rekeying');
    }
    set periodicDataRekeying(value) {
        this._periodicDataRekeying = value;
    }
    resetPeriodicDataRekeying() {
        this._periodicDataRekeying = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get periodicDataRekeyingInput() {
        return this._periodicDataRekeying;
    }
    get pipeExecutionPaused() {
        return this.getBooleanAttribute('pipe_execution_paused');
    }
    set pipeExecutionPaused(value) {
        this._pipeExecutionPaused = value;
    }
    resetPipeExecutionPaused() {
        this._pipeExecutionPaused = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipeExecutionPausedInput() {
        return this._pipeExecutionPaused;
    }
    get preventUnloadToInlineUrl() {
        return this.getBooleanAttribute('prevent_unload_to_inline_url');
    }
    set preventUnloadToInlineUrl(value) {
        this._preventUnloadToInlineUrl = value;
    }
    resetPreventUnloadToInlineUrl() {
        this._preventUnloadToInlineUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventUnloadToInlineUrlInput() {
        return this._preventUnloadToInlineUrl;
    }
    get preventUnloadToInternalStages() {
        return this.getBooleanAttribute('prevent_unload_to_internal_stages');
    }
    set preventUnloadToInternalStages(value) {
        this._preventUnloadToInternalStages = value;
    }
    resetPreventUnloadToInternalStages() {
        this._preventUnloadToInternalStages = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventUnloadToInternalStagesInput() {
        return this._preventUnloadToInternalStages;
    }
    get pythonProfilerModules() {
        return this.getStringAttribute('python_profiler_modules');
    }
    set pythonProfilerModules(value) {
        this._pythonProfilerModules = value;
    }
    resetPythonProfilerModules() {
        this._pythonProfilerModules = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pythonProfilerModulesInput() {
        return this._pythonProfilerModules;
    }
    get pythonProfilerTargetStage() {
        return this.getStringAttribute('python_profiler_target_stage');
    }
    set pythonProfilerTargetStage(value) {
        this._pythonProfilerTargetStage = value;
    }
    resetPythonProfilerTargetStage() {
        this._pythonProfilerTargetStage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pythonProfilerTargetStageInput() {
        return this._pythonProfilerTargetStage;
    }
    get queryTag() {
        return this.getStringAttribute('query_tag');
    }
    set queryTag(value) {
        this._queryTag = value;
    }
    resetQueryTag() {
        this._queryTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get queryTagInput() {
        return this._queryTag;
    }
    get quotedIdentifiersIgnoreCase() {
        return this.getBooleanAttribute('quoted_identifiers_ignore_case');
    }
    set quotedIdentifiersIgnoreCase(value) {
        this._quotedIdentifiersIgnoreCase = value;
    }
    resetQuotedIdentifiersIgnoreCase() {
        this._quotedIdentifiersIgnoreCase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get quotedIdentifiersIgnoreCaseInput() {
        return this._quotedIdentifiersIgnoreCase;
    }
    get replaceInvalidCharacters() {
        return this.getBooleanAttribute('replace_invalid_characters');
    }
    set replaceInvalidCharacters(value) {
        this._replaceInvalidCharacters = value;
    }
    resetReplaceInvalidCharacters() {
        this._replaceInvalidCharacters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceInvalidCharactersInput() {
        return this._replaceInvalidCharacters;
    }
    get requireStorageIntegrationForStageCreation() {
        return this.getBooleanAttribute('require_storage_integration_for_stage_creation');
    }
    set requireStorageIntegrationForStageCreation(value) {
        this._requireStorageIntegrationForStageCreation = value;
    }
    resetRequireStorageIntegrationForStageCreation() {
        this._requireStorageIntegrationForStageCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireStorageIntegrationForStageCreationInput() {
        return this._requireStorageIntegrationForStageCreation;
    }
    get requireStorageIntegrationForStageOperation() {
        return this.getBooleanAttribute('require_storage_integration_for_stage_operation');
    }
    set requireStorageIntegrationForStageOperation(value) {
        this._requireStorageIntegrationForStageOperation = value;
    }
    resetRequireStorageIntegrationForStageOperation() {
        this._requireStorageIntegrationForStageOperation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireStorageIntegrationForStageOperationInput() {
        return this._requireStorageIntegrationForStageOperation;
    }
    get resourceMonitor() {
        return this.getStringAttribute('resource_monitor');
    }
    set resourceMonitor(value) {
        this._resourceMonitor = value;
    }
    resetResourceMonitor() {
        this._resourceMonitor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceMonitorInput() {
        return this._resourceMonitor;
    }
    get rowsPerResultset() {
        return this.getNumberAttribute('rows_per_resultset');
    }
    set rowsPerResultset(value) {
        this._rowsPerResultset = value;
    }
    resetRowsPerResultset() {
        this._rowsPerResultset = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rowsPerResultsetInput() {
        return this._rowsPerResultset;
    }
    get s3StageVpceDnsName() {
        return this.getStringAttribute('s3_stage_vpce_dns_name');
    }
    set s3StageVpceDnsName(value) {
        this._s3StageVpceDnsName = value;
    }
    resetS3StageVpceDnsName() {
        this._s3StageVpceDnsName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get s3StageVpceDnsNameInput() {
        return this._s3StageVpceDnsName;
    }
    get samlIdentityProvider() {
        return this.getStringAttribute('saml_identity_provider');
    }
    set samlIdentityProvider(value) {
        this._samlIdentityProvider = value;
    }
    resetSamlIdentityProvider() {
        this._samlIdentityProvider = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get samlIdentityProviderInput() {
        return this._samlIdentityProvider;
    }
    get searchPath() {
        return this.getStringAttribute('search_path');
    }
    set searchPath(value) {
        this._searchPath = value;
    }
    resetSearchPath() {
        this._searchPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get searchPathInput() {
        return this._searchPath;
    }
    get serverlessTaskMaxStatementSize() {
        return this.getStringAttribute('serverless_task_max_statement_size');
    }
    set serverlessTaskMaxStatementSize(value) {
        this._serverlessTaskMaxStatementSize = value;
    }
    resetServerlessTaskMaxStatementSize() {
        this._serverlessTaskMaxStatementSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverlessTaskMaxStatementSizeInput() {
        return this._serverlessTaskMaxStatementSize;
    }
    get serverlessTaskMinStatementSize() {
        return this.getStringAttribute('serverless_task_min_statement_size');
    }
    set serverlessTaskMinStatementSize(value) {
        this._serverlessTaskMinStatementSize = value;
    }
    resetServerlessTaskMinStatementSize() {
        this._serverlessTaskMinStatementSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverlessTaskMinStatementSizeInput() {
        return this._serverlessTaskMinStatementSize;
    }
    get sessionPolicy() {
        return this.getStringAttribute('session_policy');
    }
    set sessionPolicy(value) {
        this._sessionPolicy = value;
    }
    resetSessionPolicy() {
        this._sessionPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sessionPolicyInput() {
        return this._sessionPolicy;
    }
    get simulatedDataSharingConsumer() {
        return this.getStringAttribute('simulated_data_sharing_consumer');
    }
    set simulatedDataSharingConsumer(value) {
        this._simulatedDataSharingConsumer = value;
    }
    resetSimulatedDataSharingConsumer() {
        this._simulatedDataSharingConsumer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get simulatedDataSharingConsumerInput() {
        return this._simulatedDataSharingConsumer;
    }
    get ssoLoginPage() {
        return this.getBooleanAttribute('sso_login_page');
    }
    set ssoLoginPage(value) {
        this._ssoLoginPage = value;
    }
    resetSsoLoginPage() {
        this._ssoLoginPage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ssoLoginPageInput() {
        return this._ssoLoginPage;
    }
    get statementQueuedTimeoutInSeconds() {
        return this.getNumberAttribute('statement_queued_timeout_in_seconds');
    }
    set statementQueuedTimeoutInSeconds(value) {
        this._statementQueuedTimeoutInSeconds = value;
    }
    resetStatementQueuedTimeoutInSeconds() {
        this._statementQueuedTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statementQueuedTimeoutInSecondsInput() {
        return this._statementQueuedTimeoutInSeconds;
    }
    get statementTimeoutInSeconds() {
        return this.getNumberAttribute('statement_timeout_in_seconds');
    }
    set statementTimeoutInSeconds(value) {
        this._statementTimeoutInSeconds = value;
    }
    resetStatementTimeoutInSeconds() {
        this._statementTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statementTimeoutInSecondsInput() {
        return this._statementTimeoutInSeconds;
    }
    get storageSerializationPolicy() {
        return this.getStringAttribute('storage_serialization_policy');
    }
    set storageSerializationPolicy(value) {
        this._storageSerializationPolicy = value;
    }
    resetStorageSerializationPolicy() {
        this._storageSerializationPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageSerializationPolicyInput() {
        return this._storageSerializationPolicy;
    }
    get strictJsonOutput() {
        return this.getBooleanAttribute('strict_json_output');
    }
    set strictJsonOutput(value) {
        this._strictJsonOutput = value;
    }
    resetStrictJsonOutput() {
        this._strictJsonOutput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get strictJsonOutputInput() {
        return this._strictJsonOutput;
    }
    get suspendTaskAfterNumFailures() {
        return this.getNumberAttribute('suspend_task_after_num_failures');
    }
    set suspendTaskAfterNumFailures(value) {
        this._suspendTaskAfterNumFailures = value;
    }
    resetSuspendTaskAfterNumFailures() {
        this._suspendTaskAfterNumFailures = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendTaskAfterNumFailuresInput() {
        return this._suspendTaskAfterNumFailures;
    }
    get taskAutoRetryAttempts() {
        return this.getNumberAttribute('task_auto_retry_attempts');
    }
    set taskAutoRetryAttempts(value) {
        this._taskAutoRetryAttempts = value;
    }
    resetTaskAutoRetryAttempts() {
        this._taskAutoRetryAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get taskAutoRetryAttemptsInput() {
        return this._taskAutoRetryAttempts;
    }
    get timeInputFormat() {
        return this.getStringAttribute('time_input_format');
    }
    set timeInputFormat(value) {
        this._timeInputFormat = value;
    }
    resetTimeInputFormat() {
        this._timeInputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeInputFormatInput() {
        return this._timeInputFormat;
    }
    get timeOutputFormat() {
        return this.getStringAttribute('time_output_format');
    }
    set timeOutputFormat(value) {
        this._timeOutputFormat = value;
    }
    resetTimeOutputFormat() {
        this._timeOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeOutputFormatInput() {
        return this._timeOutputFormat;
    }
    get timestampDayIsAlways24H() {
        return this.getBooleanAttribute('timestamp_day_is_always_24h');
    }
    set timestampDayIsAlways24H(value) {
        this._timestampDayIsAlways24H = value;
    }
    resetTimestampDayIsAlways24H() {
        this._timestampDayIsAlways24H = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampDayIsAlways24HInput() {
        return this._timestampDayIsAlways24H;
    }
    get timestampInputFormat() {
        return this.getStringAttribute('timestamp_input_format');
    }
    set timestampInputFormat(value) {
        this._timestampInputFormat = value;
    }
    resetTimestampInputFormat() {
        this._timestampInputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampInputFormatInput() {
        return this._timestampInputFormat;
    }
    get timestampLtzOutputFormat() {
        return this.getStringAttribute('timestamp_ltz_output_format');
    }
    set timestampLtzOutputFormat(value) {
        this._timestampLtzOutputFormat = value;
    }
    resetTimestampLtzOutputFormat() {
        this._timestampLtzOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampLtzOutputFormatInput() {
        return this._timestampLtzOutputFormat;
    }
    get timestampNtzOutputFormat() {
        return this.getStringAttribute('timestamp_ntz_output_format');
    }
    set timestampNtzOutputFormat(value) {
        this._timestampNtzOutputFormat = value;
    }
    resetTimestampNtzOutputFormat() {
        this._timestampNtzOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampNtzOutputFormatInput() {
        return this._timestampNtzOutputFormat;
    }
    get timestampOutputFormat() {
        return this.getStringAttribute('timestamp_output_format');
    }
    set timestampOutputFormat(value) {
        this._timestampOutputFormat = value;
    }
    resetTimestampOutputFormat() {
        this._timestampOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampOutputFormatInput() {
        return this._timestampOutputFormat;
    }
    get timestampTypeMapping() {
        return this.getStringAttribute('timestamp_type_mapping');
    }
    set timestampTypeMapping(value) {
        this._timestampTypeMapping = value;
    }
    resetTimestampTypeMapping() {
        this._timestampTypeMapping = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampTypeMappingInput() {
        return this._timestampTypeMapping;
    }
    get timestampTzOutputFormat() {
        return this.getStringAttribute('timestamp_tz_output_format');
    }
    set timestampTzOutputFormat(value) {
        this._timestampTzOutputFormat = value;
    }
    resetTimestampTzOutputFormat() {
        this._timestampTzOutputFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampTzOutputFormatInput() {
        return this._timestampTzOutputFormat;
    }
    get timezone() {
        return this.getStringAttribute('timezone');
    }
    set timezone(value) {
        this._timezone = value;
    }
    resetTimezone() {
        this._timezone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timezoneInput() {
        return this._timezone;
    }
    get traceLevel() {
        return this.getStringAttribute('trace_level');
    }
    set traceLevel(value) {
        this._traceLevel = value;
    }
    resetTraceLevel() {
        this._traceLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get traceLevelInput() {
        return this._traceLevel;
    }
    get transactionAbortOnError() {
        return this.getBooleanAttribute('transaction_abort_on_error');
    }
    set transactionAbortOnError(value) {
        this._transactionAbortOnError = value;
    }
    resetTransactionAbortOnError() {
        this._transactionAbortOnError = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transactionAbortOnErrorInput() {
        return this._transactionAbortOnError;
    }
    get transactionDefaultIsolationLevel() {
        return this.getStringAttribute('transaction_default_isolation_level');
    }
    set transactionDefaultIsolationLevel(value) {
        this._transactionDefaultIsolationLevel = value;
    }
    resetTransactionDefaultIsolationLevel() {
        this._transactionDefaultIsolationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transactionDefaultIsolationLevelInput() {
        return this._transactionDefaultIsolationLevel;
    }
    get twoDigitCenturyStart() {
        return this.getNumberAttribute('two_digit_century_start');
    }
    set twoDigitCenturyStart(value) {
        this._twoDigitCenturyStart = value;
    }
    resetTwoDigitCenturyStart() {
        this._twoDigitCenturyStart = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get twoDigitCenturyStartInput() {
        return this._twoDigitCenturyStart;
    }
    get unsupportedDdlAction() {
        return this.getStringAttribute('unsupported_ddl_action');
    }
    set unsupportedDdlAction(value) {
        this._unsupportedDdlAction = value;
    }
    resetUnsupportedDdlAction() {
        this._unsupportedDdlAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get unsupportedDdlActionInput() {
        return this._unsupportedDdlAction;
    }
    get useCachedResult() {
        return this.getBooleanAttribute('use_cached_result');
    }
    set useCachedResult(value) {
        this._useCachedResult = value;
    }
    resetUseCachedResult() {
        this._useCachedResult = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCachedResultInput() {
        return this._useCachedResult;
    }
    get userTaskManagedInitialWarehouseSize() {
        return this.getStringAttribute('user_task_managed_initial_warehouse_size');
    }
    set userTaskManagedInitialWarehouseSize(value) {
        this._userTaskManagedInitialWarehouseSize = value;
    }
    resetUserTaskManagedInitialWarehouseSize() {
        this._userTaskManagedInitialWarehouseSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskManagedInitialWarehouseSizeInput() {
        return this._userTaskManagedInitialWarehouseSize;
    }
    get userTaskMinimumTriggerIntervalInSeconds() {
        return this.getNumberAttribute('user_task_minimum_trigger_interval_in_seconds');
    }
    set userTaskMinimumTriggerIntervalInSeconds(value) {
        this._userTaskMinimumTriggerIntervalInSeconds = value;
    }
    resetUserTaskMinimumTriggerIntervalInSeconds() {
        this._userTaskMinimumTriggerIntervalInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskMinimumTriggerIntervalInSecondsInput() {
        return this._userTaskMinimumTriggerIntervalInSeconds;
    }
    get userTaskTimeoutMs() {
        return this.getNumberAttribute('user_task_timeout_ms');
    }
    set userTaskTimeoutMs(value) {
        this._userTaskTimeoutMs = value;
    }
    resetUserTaskTimeoutMs() {
        this._userTaskTimeoutMs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskTimeoutMsInput() {
        return this._userTaskTimeoutMs;
    }
    get weekOfYearPolicy() {
        return this.getNumberAttribute('week_of_year_policy');
    }
    set weekOfYearPolicy(value) {
        this._weekOfYearPolicy = value;
    }
    resetWeekOfYearPolicy() {
        this._weekOfYearPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get weekOfYearPolicyInput() {
        return this._weekOfYearPolicy;
    }
    get weekStart() {
        return this.getNumberAttribute('week_start');
    }
    set weekStart(value) {
        this._weekStart = value;
    }
    resetWeekStart() {
        this._weekStart = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get weekStartInput() {
        return this._weekStart;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            abort_detached_query: cdktf.booleanToTerraform(this._abortDetachedQuery),
            active_python_profiler: cdktf.stringToTerraform(this._activePythonProfiler),
            allow_client_mfa_caching: cdktf.booleanToTerraform(this._allowClientMfaCaching),
            allow_id_token: cdktf.booleanToTerraform(this._allowIdToken),
            authentication_policy: cdktf.stringToTerraform(this._authenticationPolicy),
            autocommit: cdktf.booleanToTerraform(this._autocommit),
            base_location_prefix: cdktf.stringToTerraform(this._baseLocationPrefix),
            binary_input_format: cdktf.stringToTerraform(this._binaryInputFormat),
            binary_output_format: cdktf.stringToTerraform(this._binaryOutputFormat),
            catalog: cdktf.stringToTerraform(this._catalog),
            catalog_sync: cdktf.stringToTerraform(this._catalogSync),
            client_enable_log_info_statement_parameters: cdktf.booleanToTerraform(this._clientEnableLogInfoStatementParameters),
            client_encryption_key_size: cdktf.numberToTerraform(this._clientEncryptionKeySize),
            client_memory_limit: cdktf.numberToTerraform(this._clientMemoryLimit),
            client_metadata_request_use_connection_ctx: cdktf.booleanToTerraform(this._clientMetadataRequestUseConnectionCtx),
            client_metadata_use_session_database: cdktf.booleanToTerraform(this._clientMetadataUseSessionDatabase),
            client_prefetch_threads: cdktf.numberToTerraform(this._clientPrefetchThreads),
            client_result_chunk_size: cdktf.numberToTerraform(this._clientResultChunkSize),
            client_result_column_case_insensitive: cdktf.booleanToTerraform(this._clientResultColumnCaseInsensitive),
            client_session_keep_alive: cdktf.booleanToTerraform(this._clientSessionKeepAlive),
            client_session_keep_alive_heartbeat_frequency: cdktf.numberToTerraform(this._clientSessionKeepAliveHeartbeatFrequency),
            client_timestamp_type_mapping: cdktf.stringToTerraform(this._clientTimestampTypeMapping),
            cortex_enabled_cross_region: cdktf.stringToTerraform(this._cortexEnabledCrossRegion),
            cortex_models_allowlist: cdktf.stringToTerraform(this._cortexModelsAllowlist),
            csv_timestamp_format: cdktf.stringToTerraform(this._csvTimestampFormat),
            data_retention_time_in_days: cdktf.numberToTerraform(this._dataRetentionTimeInDays),
            date_input_format: cdktf.stringToTerraform(this._dateInputFormat),
            date_output_format: cdktf.stringToTerraform(this._dateOutputFormat),
            default_ddl_collation: cdktf.stringToTerraform(this._defaultDdlCollation),
            default_notebook_compute_pool_cpu: cdktf.stringToTerraform(this._defaultNotebookComputePoolCpu),
            default_notebook_compute_pool_gpu: cdktf.stringToTerraform(this._defaultNotebookComputePoolGpu),
            default_null_ordering: cdktf.stringToTerraform(this._defaultNullOrdering),
            default_streamlit_notebook_warehouse: cdktf.stringToTerraform(this._defaultStreamlitNotebookWarehouse),
            disable_ui_download_button: cdktf.booleanToTerraform(this._disableUiDownloadButton),
            disable_user_privilege_grants: cdktf.booleanToTerraform(this._disableUserPrivilegeGrants),
            enable_automatic_sensitive_data_classification_log: cdktf.booleanToTerraform(this._enableAutomaticSensitiveDataClassificationLog),
            enable_egress_cost_optimizer: cdktf.booleanToTerraform(this._enableEgressCostOptimizer),
            enable_identifier_first_login: cdktf.booleanToTerraform(this._enableIdentifierFirstLogin),
            enable_internal_stages_privatelink: cdktf.booleanToTerraform(this._enableInternalStagesPrivatelink),
            enable_tri_secret_and_rekey_opt_out_for_image_repository: cdktf.booleanToTerraform(this._enableTriSecretAndRekeyOptOutForImageRepository),
            enable_tri_secret_and_rekey_opt_out_for_spcs_block_storage: cdktf.booleanToTerraform(this._enableTriSecretAndRekeyOptOutForSpcsBlockStorage),
            enable_unhandled_exceptions_reporting: cdktf.booleanToTerraform(this._enableUnhandledExceptionsReporting),
            enable_unload_physical_type_optimization: cdktf.booleanToTerraform(this._enableUnloadPhysicalTypeOptimization),
            enable_unredacted_query_syntax_error: cdktf.booleanToTerraform(this._enableUnredactedQuerySyntaxError),
            enable_unredacted_secure_object_error: cdktf.booleanToTerraform(this._enableUnredactedSecureObjectError),
            enforce_network_rules_for_internal_stages: cdktf.booleanToTerraform(this._enforceNetworkRulesForInternalStages),
            error_on_nondeterministic_merge: cdktf.booleanToTerraform(this._errorOnNondeterministicMerge),
            error_on_nondeterministic_update: cdktf.booleanToTerraform(this._errorOnNondeterministicUpdate),
            event_table: cdktf.stringToTerraform(this._eventTable),
            external_oauth_add_privileged_roles_to_blocked_list: cdktf.booleanToTerraform(this._externalOauthAddPrivilegedRolesToBlockedList),
            external_volume: cdktf.stringToTerraform(this._externalVolume),
            feature_policy: cdktf.stringToTerraform(this._featurePolicy),
            geography_output_format: cdktf.stringToTerraform(this._geographyOutputFormat),
            geometry_output_format: cdktf.stringToTerraform(this._geometryOutputFormat),
            hybrid_table_lock_timeout: cdktf.numberToTerraform(this._hybridTableLockTimeout),
            id: cdktf.stringToTerraform(this._id),
            initial_replication_size_limit_in_tb: cdktf.stringToTerraform(this._initialReplicationSizeLimitInTb),
            jdbc_treat_decimal_as_int: cdktf.booleanToTerraform(this._jdbcTreatDecimalAsInt),
            jdbc_treat_timestamp_ntz_as_utc: cdktf.booleanToTerraform(this._jdbcTreatTimestampNtzAsUtc),
            jdbc_use_session_timezone: cdktf.booleanToTerraform(this._jdbcUseSessionTimezone),
            js_treat_integer_as_bigint: cdktf.booleanToTerraform(this._jsTreatIntegerAsBigint),
            json_indent: cdktf.numberToTerraform(this._jsonIndent),
            listing_auto_fulfillment_replication_refresh_schedule: cdktf.stringToTerraform(this._listingAutoFulfillmentReplicationRefreshSchedule),
            lock_timeout: cdktf.numberToTerraform(this._lockTimeout),
            log_level: cdktf.stringToTerraform(this._logLevel),
            max_concurrency_level: cdktf.numberToTerraform(this._maxConcurrencyLevel),
            max_data_extension_time_in_days: cdktf.numberToTerraform(this._maxDataExtensionTimeInDays),
            metric_level: cdktf.stringToTerraform(this._metricLevel),
            min_data_retention_time_in_days: cdktf.numberToTerraform(this._minDataRetentionTimeInDays),
            multi_statement_count: cdktf.numberToTerraform(this._multiStatementCount),
            network_policy: cdktf.stringToTerraform(this._networkPolicy),
            noorder_sequence_as_default: cdktf.booleanToTerraform(this._noorderSequenceAsDefault),
            oauth_add_privileged_roles_to_blocked_list: cdktf.booleanToTerraform(this._oauthAddPrivilegedRolesToBlockedList),
            odbc_treat_decimal_as_int: cdktf.booleanToTerraform(this._odbcTreatDecimalAsInt),
            packages_policy: cdktf.stringToTerraform(this._packagesPolicy),
            password_policy: cdktf.stringToTerraform(this._passwordPolicy),
            periodic_data_rekeying: cdktf.booleanToTerraform(this._periodicDataRekeying),
            pipe_execution_paused: cdktf.booleanToTerraform(this._pipeExecutionPaused),
            prevent_unload_to_inline_url: cdktf.booleanToTerraform(this._preventUnloadToInlineUrl),
            prevent_unload_to_internal_stages: cdktf.booleanToTerraform(this._preventUnloadToInternalStages),
            python_profiler_modules: cdktf.stringToTerraform(this._pythonProfilerModules),
            python_profiler_target_stage: cdktf.stringToTerraform(this._pythonProfilerTargetStage),
            query_tag: cdktf.stringToTerraform(this._queryTag),
            quoted_identifiers_ignore_case: cdktf.booleanToTerraform(this._quotedIdentifiersIgnoreCase),
            replace_invalid_characters: cdktf.booleanToTerraform(this._replaceInvalidCharacters),
            require_storage_integration_for_stage_creation: cdktf.booleanToTerraform(this._requireStorageIntegrationForStageCreation),
            require_storage_integration_for_stage_operation: cdktf.booleanToTerraform(this._requireStorageIntegrationForStageOperation),
            resource_monitor: cdktf.stringToTerraform(this._resourceMonitor),
            rows_per_resultset: cdktf.numberToTerraform(this._rowsPerResultset),
            s3_stage_vpce_dns_name: cdktf.stringToTerraform(this._s3StageVpceDnsName),
            saml_identity_provider: cdktf.stringToTerraform(this._samlIdentityProvider),
            search_path: cdktf.stringToTerraform(this._searchPath),
            serverless_task_max_statement_size: cdktf.stringToTerraform(this._serverlessTaskMaxStatementSize),
            serverless_task_min_statement_size: cdktf.stringToTerraform(this._serverlessTaskMinStatementSize),
            session_policy: cdktf.stringToTerraform(this._sessionPolicy),
            simulated_data_sharing_consumer: cdktf.stringToTerraform(this._simulatedDataSharingConsumer),
            sso_login_page: cdktf.booleanToTerraform(this._ssoLoginPage),
            statement_queued_timeout_in_seconds: cdktf.numberToTerraform(this._statementQueuedTimeoutInSeconds),
            statement_timeout_in_seconds: cdktf.numberToTerraform(this._statementTimeoutInSeconds),
            storage_serialization_policy: cdktf.stringToTerraform(this._storageSerializationPolicy),
            strict_json_output: cdktf.booleanToTerraform(this._strictJsonOutput),
            suspend_task_after_num_failures: cdktf.numberToTerraform(this._suspendTaskAfterNumFailures),
            task_auto_retry_attempts: cdktf.numberToTerraform(this._taskAutoRetryAttempts),
            time_input_format: cdktf.stringToTerraform(this._timeInputFormat),
            time_output_format: cdktf.stringToTerraform(this._timeOutputFormat),
            timestamp_day_is_always_24h: cdktf.booleanToTerraform(this._timestampDayIsAlways24H),
            timestamp_input_format: cdktf.stringToTerraform(this._timestampInputFormat),
            timestamp_ltz_output_format: cdktf.stringToTerraform(this._timestampLtzOutputFormat),
            timestamp_ntz_output_format: cdktf.stringToTerraform(this._timestampNtzOutputFormat),
            timestamp_output_format: cdktf.stringToTerraform(this._timestampOutputFormat),
            timestamp_type_mapping: cdktf.stringToTerraform(this._timestampTypeMapping),
            timestamp_tz_output_format: cdktf.stringToTerraform(this._timestampTzOutputFormat),
            timezone: cdktf.stringToTerraform(this._timezone),
            trace_level: cdktf.stringToTerraform(this._traceLevel),
            transaction_abort_on_error: cdktf.booleanToTerraform(this._transactionAbortOnError),
            transaction_default_isolation_level: cdktf.stringToTerraform(this._transactionDefaultIsolationLevel),
            two_digit_century_start: cdktf.numberToTerraform(this._twoDigitCenturyStart),
            unsupported_ddl_action: cdktf.stringToTerraform(this._unsupportedDdlAction),
            use_cached_result: cdktf.booleanToTerraform(this._useCachedResult),
            user_task_managed_initial_warehouse_size: cdktf.stringToTerraform(this._userTaskManagedInitialWarehouseSize),
            user_task_minimum_trigger_interval_in_seconds: cdktf.numberToTerraform(this._userTaskMinimumTriggerIntervalInSeconds),
            user_task_timeout_ms: cdktf.numberToTerraform(this._userTaskTimeoutMs),
            week_of_year_policy: cdktf.numberToTerraform(this._weekOfYearPolicy),
            week_start: cdktf.numberToTerraform(this._weekStart),
            timeouts: currentAccountTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            abort_detached_query: {
                value: cdktf.booleanToHclTerraform(this._abortDetachedQuery),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            active_python_profiler: {
                value: cdktf.stringToHclTerraform(this._activePythonProfiler),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            allow_client_mfa_caching: {
                value: cdktf.booleanToHclTerraform(this._allowClientMfaCaching),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            allow_id_token: {
                value: cdktf.booleanToHclTerraform(this._allowIdToken),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            authentication_policy: {
                value: cdktf.stringToHclTerraform(this._authenticationPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            autocommit: {
                value: cdktf.booleanToHclTerraform(this._autocommit),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            base_location_prefix: {
                value: cdktf.stringToHclTerraform(this._baseLocationPrefix),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            binary_input_format: {
                value: cdktf.stringToHclTerraform(this._binaryInputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            binary_output_format: {
                value: cdktf.stringToHclTerraform(this._binaryOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            catalog: {
                value: cdktf.stringToHclTerraform(this._catalog),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            catalog_sync: {
                value: cdktf.stringToHclTerraform(this._catalogSync),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_enable_log_info_statement_parameters: {
                value: cdktf.booleanToHclTerraform(this._clientEnableLogInfoStatementParameters),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            client_encryption_key_size: {
                value: cdktf.numberToHclTerraform(this._clientEncryptionKeySize),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            client_memory_limit: {
                value: cdktf.numberToHclTerraform(this._clientMemoryLimit),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            client_metadata_request_use_connection_ctx: {
                value: cdktf.booleanToHclTerraform(this._clientMetadataRequestUseConnectionCtx),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            client_metadata_use_session_database: {
                value: cdktf.booleanToHclTerraform(this._clientMetadataUseSessionDatabase),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            client_prefetch_threads: {
                value: cdktf.numberToHclTerraform(this._clientPrefetchThreads),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            client_result_chunk_size: {
                value: cdktf.numberToHclTerraform(this._clientResultChunkSize),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            client_result_column_case_insensitive: {
                value: cdktf.booleanToHclTerraform(this._clientResultColumnCaseInsensitive),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            client_session_keep_alive: {
                value: cdktf.booleanToHclTerraform(this._clientSessionKeepAlive),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            client_session_keep_alive_heartbeat_frequency: {
                value: cdktf.numberToHclTerraform(this._clientSessionKeepAliveHeartbeatFrequency),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            client_timestamp_type_mapping: {
                value: cdktf.stringToHclTerraform(this._clientTimestampTypeMapping),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            cortex_enabled_cross_region: {
                value: cdktf.stringToHclTerraform(this._cortexEnabledCrossRegion),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            cortex_models_allowlist: {
                value: cdktf.stringToHclTerraform(this._cortexModelsAllowlist),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            csv_timestamp_format: {
                value: cdktf.stringToHclTerraform(this._csvTimestampFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            data_retention_time_in_days: {
                value: cdktf.numberToHclTerraform(this._dataRetentionTimeInDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            date_input_format: {
                value: cdktf.stringToHclTerraform(this._dateInputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            date_output_format: {
                value: cdktf.stringToHclTerraform(this._dateOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            default_ddl_collation: {
                value: cdktf.stringToHclTerraform(this._defaultDdlCollation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            default_notebook_compute_pool_cpu: {
                value: cdktf.stringToHclTerraform(this._defaultNotebookComputePoolCpu),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            default_notebook_compute_pool_gpu: {
                value: cdktf.stringToHclTerraform(this._defaultNotebookComputePoolGpu),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            default_null_ordering: {
                value: cdktf.stringToHclTerraform(this._defaultNullOrdering),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            default_streamlit_notebook_warehouse: {
                value: cdktf.stringToHclTerraform(this._defaultStreamlitNotebookWarehouse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            disable_ui_download_button: {
                value: cdktf.booleanToHclTerraform(this._disableUiDownloadButton),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            disable_user_privilege_grants: {
                value: cdktf.booleanToHclTerraform(this._disableUserPrivilegeGrants),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_automatic_sensitive_data_classification_log: {
                value: cdktf.booleanToHclTerraform(this._enableAutomaticSensitiveDataClassificationLog),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_egress_cost_optimizer: {
                value: cdktf.booleanToHclTerraform(this._enableEgressCostOptimizer),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_identifier_first_login: {
                value: cdktf.booleanToHclTerraform(this._enableIdentifierFirstLogin),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_internal_stages_privatelink: {
                value: cdktf.booleanToHclTerraform(this._enableInternalStagesPrivatelink),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_tri_secret_and_rekey_opt_out_for_image_repository: {
                value: cdktf.booleanToHclTerraform(this._enableTriSecretAndRekeyOptOutForImageRepository),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_tri_secret_and_rekey_opt_out_for_spcs_block_storage: {
                value: cdktf.booleanToHclTerraform(this._enableTriSecretAndRekeyOptOutForSpcsBlockStorage),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_unhandled_exceptions_reporting: {
                value: cdktf.booleanToHclTerraform(this._enableUnhandledExceptionsReporting),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_unload_physical_type_optimization: {
                value: cdktf.booleanToHclTerraform(this._enableUnloadPhysicalTypeOptimization),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_unredacted_query_syntax_error: {
                value: cdktf.booleanToHclTerraform(this._enableUnredactedQuerySyntaxError),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_unredacted_secure_object_error: {
                value: cdktf.booleanToHclTerraform(this._enableUnredactedSecureObjectError),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enforce_network_rules_for_internal_stages: {
                value: cdktf.booleanToHclTerraform(this._enforceNetworkRulesForInternalStages),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            error_on_nondeterministic_merge: {
                value: cdktf.booleanToHclTerraform(this._errorOnNondeterministicMerge),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            error_on_nondeterministic_update: {
                value: cdktf.booleanToHclTerraform(this._errorOnNondeterministicUpdate),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            event_table: {
                value: cdktf.stringToHclTerraform(this._eventTable),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            external_oauth_add_privileged_roles_to_blocked_list: {
                value: cdktf.booleanToHclTerraform(this._externalOauthAddPrivilegedRolesToBlockedList),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            external_volume: {
                value: cdktf.stringToHclTerraform(this._externalVolume),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            feature_policy: {
                value: cdktf.stringToHclTerraform(this._featurePolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            geography_output_format: {
                value: cdktf.stringToHclTerraform(this._geographyOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            geometry_output_format: {
                value: cdktf.stringToHclTerraform(this._geometryOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            hybrid_table_lock_timeout: {
                value: cdktf.numberToHclTerraform(this._hybridTableLockTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            initial_replication_size_limit_in_tb: {
                value: cdktf.stringToHclTerraform(this._initialReplicationSizeLimitInTb),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            jdbc_treat_decimal_as_int: {
                value: cdktf.booleanToHclTerraform(this._jdbcTreatDecimalAsInt),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            jdbc_treat_timestamp_ntz_as_utc: {
                value: cdktf.booleanToHclTerraform(this._jdbcTreatTimestampNtzAsUtc),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            jdbc_use_session_timezone: {
                value: cdktf.booleanToHclTerraform(this._jdbcUseSessionTimezone),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            js_treat_integer_as_bigint: {
                value: cdktf.booleanToHclTerraform(this._jsTreatIntegerAsBigint),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            json_indent: {
                value: cdktf.numberToHclTerraform(this._jsonIndent),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            listing_auto_fulfillment_replication_refresh_schedule: {
                value: cdktf.stringToHclTerraform(this._listingAutoFulfillmentReplicationRefreshSchedule),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            lock_timeout: {
                value: cdktf.numberToHclTerraform(this._lockTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            log_level: {
                value: cdktf.stringToHclTerraform(this._logLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            max_concurrency_level: {
                value: cdktf.numberToHclTerraform(this._maxConcurrencyLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            max_data_extension_time_in_days: {
                value: cdktf.numberToHclTerraform(this._maxDataExtensionTimeInDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            metric_level: {
                value: cdktf.stringToHclTerraform(this._metricLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            min_data_retention_time_in_days: {
                value: cdktf.numberToHclTerraform(this._minDataRetentionTimeInDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            multi_statement_count: {
                value: cdktf.numberToHclTerraform(this._multiStatementCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            network_policy: {
                value: cdktf.stringToHclTerraform(this._networkPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            noorder_sequence_as_default: {
                value: cdktf.booleanToHclTerraform(this._noorderSequenceAsDefault),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            oauth_add_privileged_roles_to_blocked_list: {
                value: cdktf.booleanToHclTerraform(this._oauthAddPrivilegedRolesToBlockedList),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            odbc_treat_decimal_as_int: {
                value: cdktf.booleanToHclTerraform(this._odbcTreatDecimalAsInt),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            packages_policy: {
                value: cdktf.stringToHclTerraform(this._packagesPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            password_policy: {
                value: cdktf.stringToHclTerraform(this._passwordPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            periodic_data_rekeying: {
                value: cdktf.booleanToHclTerraform(this._periodicDataRekeying),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            pipe_execution_paused: {
                value: cdktf.booleanToHclTerraform(this._pipeExecutionPaused),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            prevent_unload_to_inline_url: {
                value: cdktf.booleanToHclTerraform(this._preventUnloadToInlineUrl),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            prevent_unload_to_internal_stages: {
                value: cdktf.booleanToHclTerraform(this._preventUnloadToInternalStages),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            python_profiler_modules: {
                value: cdktf.stringToHclTerraform(this._pythonProfilerModules),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            python_profiler_target_stage: {
                value: cdktf.stringToHclTerraform(this._pythonProfilerTargetStage),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            query_tag: {
                value: cdktf.stringToHclTerraform(this._queryTag),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            quoted_identifiers_ignore_case: {
                value: cdktf.booleanToHclTerraform(this._quotedIdentifiersIgnoreCase),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            replace_invalid_characters: {
                value: cdktf.booleanToHclTerraform(this._replaceInvalidCharacters),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            require_storage_integration_for_stage_creation: {
                value: cdktf.booleanToHclTerraform(this._requireStorageIntegrationForStageCreation),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            require_storage_integration_for_stage_operation: {
                value: cdktf.booleanToHclTerraform(this._requireStorageIntegrationForStageOperation),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            resource_monitor: {
                value: cdktf.stringToHclTerraform(this._resourceMonitor),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            rows_per_resultset: {
                value: cdktf.numberToHclTerraform(this._rowsPerResultset),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            s3_stage_vpce_dns_name: {
                value: cdktf.stringToHclTerraform(this._s3StageVpceDnsName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            saml_identity_provider: {
                value: cdktf.stringToHclTerraform(this._samlIdentityProvider),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            search_path: {
                value: cdktf.stringToHclTerraform(this._searchPath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            serverless_task_max_statement_size: {
                value: cdktf.stringToHclTerraform(this._serverlessTaskMaxStatementSize),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            serverless_task_min_statement_size: {
                value: cdktf.stringToHclTerraform(this._serverlessTaskMinStatementSize),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            session_policy: {
                value: cdktf.stringToHclTerraform(this._sessionPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            simulated_data_sharing_consumer: {
                value: cdktf.stringToHclTerraform(this._simulatedDataSharingConsumer),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sso_login_page: {
                value: cdktf.booleanToHclTerraform(this._ssoLoginPage),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            statement_queued_timeout_in_seconds: {
                value: cdktf.numberToHclTerraform(this._statementQueuedTimeoutInSeconds),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            statement_timeout_in_seconds: {
                value: cdktf.numberToHclTerraform(this._statementTimeoutInSeconds),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            storage_serialization_policy: {
                value: cdktf.stringToHclTerraform(this._storageSerializationPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            strict_json_output: {
                value: cdktf.booleanToHclTerraform(this._strictJsonOutput),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            suspend_task_after_num_failures: {
                value: cdktf.numberToHclTerraform(this._suspendTaskAfterNumFailures),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            task_auto_retry_attempts: {
                value: cdktf.numberToHclTerraform(this._taskAutoRetryAttempts),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            time_input_format: {
                value: cdktf.stringToHclTerraform(this._timeInputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            time_output_format: {
                value: cdktf.stringToHclTerraform(this._timeOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            timestamp_day_is_always_24h: {
                value: cdktf.booleanToHclTerraform(this._timestampDayIsAlways24H),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            timestamp_input_format: {
                value: cdktf.stringToHclTerraform(this._timestampInputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            timestamp_ltz_output_format: {
                value: cdktf.stringToHclTerraform(this._timestampLtzOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            timestamp_ntz_output_format: {
                value: cdktf.stringToHclTerraform(this._timestampNtzOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            timestamp_output_format: {
                value: cdktf.stringToHclTerraform(this._timestampOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            timestamp_type_mapping: {
                value: cdktf.stringToHclTerraform(this._timestampTypeMapping),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            timestamp_tz_output_format: {
                value: cdktf.stringToHclTerraform(this._timestampTzOutputFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            timezone: {
                value: cdktf.stringToHclTerraform(this._timezone),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            trace_level: {
                value: cdktf.stringToHclTerraform(this._traceLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            transaction_abort_on_error: {
                value: cdktf.booleanToHclTerraform(this._transactionAbortOnError),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            transaction_default_isolation_level: {
                value: cdktf.stringToHclTerraform(this._transactionDefaultIsolationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            two_digit_century_start: {
                value: cdktf.numberToHclTerraform(this._twoDigitCenturyStart),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            unsupported_ddl_action: {
                value: cdktf.stringToHclTerraform(this._unsupportedDdlAction),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            use_cached_result: {
                value: cdktf.booleanToHclTerraform(this._useCachedResult),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            user_task_managed_initial_warehouse_size: {
                value: cdktf.stringToHclTerraform(this._userTaskManagedInitialWarehouseSize),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_task_minimum_trigger_interval_in_seconds: {
                value: cdktf.numberToHclTerraform(this._userTaskMinimumTriggerIntervalInSeconds),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            user_task_timeout_ms: {
                value: cdktf.numberToHclTerraform(this._userTaskTimeoutMs),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            week_of_year_policy: {
                value: cdktf.numberToHclTerraform(this._weekOfYearPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            week_start: {
                value: cdktf.numberToHclTerraform(this._weekStart),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            timeouts: {
                value: currentAccountTimeoutsToHclTerraform(this._timeouts.internalValue),
                isBlock: true,
                type: "struct",
                storageClassType: "CurrentAccountTimeouts",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.CurrentAccount = CurrentAccount;
_b = JSII_RTTI_SYMBOL_1;
CurrentAccount[_b] = { fqn: "@cdktf/provider-snowflake.currentAccount.CurrentAccount", version: "15.1.0" };
// =================
// STATIC PROPERTIES
// =================
CurrentAccount.tfResourceType = "snowflake_current_account";
//# sourceMappingURL=data:application/json;base64,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