/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeAccountRolesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/account_roles#id DataSnowflakeAccountRoles#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the SHOW GRANTS output by class name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/account_roles#in_class DataSnowflakeAccountRoles#in_class}
    */
    readonly inClass?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/account_roles#like DataSnowflakeAccountRoles#like}
    */
    readonly like?: string;
}
export interface DataSnowflakeAccountRolesAccountRolesShowOutput {
}
export declare function dataSnowflakeAccountRolesAccountRolesShowOutputToTerraform(struct?: DataSnowflakeAccountRolesAccountRolesShowOutput): any;
export declare function dataSnowflakeAccountRolesAccountRolesShowOutputToHclTerraform(struct?: DataSnowflakeAccountRolesAccountRolesShowOutput): any;
export declare class DataSnowflakeAccountRolesAccountRolesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeAccountRolesAccountRolesShowOutput | undefined;
    set internalValue(value: DataSnowflakeAccountRolesAccountRolesShowOutput | undefined);
    get assignedToUsers(): number;
    get comment(): string;
    get createdOn(): string;
    get grantedRoles(): number;
    get grantedToRoles(): number;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get isInherited(): cdktf.IResolvable;
    get name(): string;
    get owner(): string;
}
export declare class DataSnowflakeAccountRolesAccountRolesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeAccountRolesAccountRolesShowOutputOutputReference;
}
export interface DataSnowflakeAccountRolesAccountRoles {
}
export declare function dataSnowflakeAccountRolesAccountRolesToTerraform(struct?: DataSnowflakeAccountRolesAccountRoles): any;
export declare function dataSnowflakeAccountRolesAccountRolesToHclTerraform(struct?: DataSnowflakeAccountRolesAccountRoles): any;
export declare class DataSnowflakeAccountRolesAccountRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeAccountRolesAccountRoles | undefined;
    set internalValue(value: DataSnowflakeAccountRolesAccountRoles | undefined);
    private _showOutput;
    get showOutput(): DataSnowflakeAccountRolesAccountRolesShowOutputList;
}
export declare class DataSnowflakeAccountRolesAccountRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeAccountRolesAccountRolesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/account_roles snowflake_account_roles}
*/
export declare class DataSnowflakeAccountRoles extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_account_roles";
    /**
    * Generates CDKTF code for importing a DataSnowflakeAccountRoles resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeAccountRoles to import
    * @param importFromId The id of the existing DataSnowflakeAccountRoles that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/account_roles#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeAccountRoles to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/account_roles snowflake_account_roles} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeAccountRolesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeAccountRolesConfig);
    private _accountRoles;
    get accountRoles(): DataSnowflakeAccountRolesAccountRolesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inClass?;
    get inClass(): string;
    set inClass(value: string);
    resetInClass(): void;
    get inClassInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
