/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeComputePoolsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#id DataSnowflakeComputePools#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#like DataSnowflakeComputePools#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#starts_with DataSnowflakeComputePools#starts_with}
    */
    readonly startsWith?: string;
    /**
    * (Default: `true`) Runs DESC COMPUTE POOL for each compute pool returned by SHOW COMPUTE POOLS. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#with_describe DataSnowflakeComputePools#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#limit DataSnowflakeComputePools#limit}
    */
    readonly limit?: DataSnowflakeComputePoolsLimit;
}
export interface DataSnowflakeComputePoolsComputePoolsDescribeOutput {
}
export declare function dataSnowflakeComputePoolsComputePoolsDescribeOutputToTerraform(struct?: DataSnowflakeComputePoolsComputePoolsDescribeOutput): any;
export declare function dataSnowflakeComputePoolsComputePoolsDescribeOutputToHclTerraform(struct?: DataSnowflakeComputePoolsComputePoolsDescribeOutput): any;
export declare class DataSnowflakeComputePoolsComputePoolsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeComputePoolsComputePoolsDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeComputePoolsComputePoolsDescribeOutput | undefined);
    get activeNodes(): number;
    get application(): string;
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get createdOn(): string;
    get errorCode(): string;
    get idleNodes(): number;
    get instanceFamily(): string;
    get isExclusive(): cdktf.IResolvable;
    get maxNodes(): number;
    get minNodes(): number;
    get name(): string;
    get numJobs(): number;
    get numServices(): number;
    get owner(): string;
    get resumedOn(): string;
    get state(): string;
    get statusMessage(): string;
    get targetNodes(): number;
    get updatedOn(): string;
}
export declare class DataSnowflakeComputePoolsComputePoolsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeComputePoolsComputePoolsDescribeOutputOutputReference;
}
export interface DataSnowflakeComputePoolsComputePoolsShowOutput {
}
export declare function dataSnowflakeComputePoolsComputePoolsShowOutputToTerraform(struct?: DataSnowflakeComputePoolsComputePoolsShowOutput): any;
export declare function dataSnowflakeComputePoolsComputePoolsShowOutputToHclTerraform(struct?: DataSnowflakeComputePoolsComputePoolsShowOutput): any;
export declare class DataSnowflakeComputePoolsComputePoolsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeComputePoolsComputePoolsShowOutput | undefined;
    set internalValue(value: DataSnowflakeComputePoolsComputePoolsShowOutput | undefined);
    get activeNodes(): number;
    get application(): string;
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get createdOn(): string;
    get idleNodes(): number;
    get instanceFamily(): string;
    get isExclusive(): cdktf.IResolvable;
    get maxNodes(): number;
    get minNodes(): number;
    get name(): string;
    get numJobs(): number;
    get numServices(): number;
    get owner(): string;
    get resumedOn(): string;
    get state(): string;
    get targetNodes(): number;
    get updatedOn(): string;
}
export declare class DataSnowflakeComputePoolsComputePoolsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeComputePoolsComputePoolsShowOutputOutputReference;
}
export interface DataSnowflakeComputePoolsComputePools {
}
export declare function dataSnowflakeComputePoolsComputePoolsToTerraform(struct?: DataSnowflakeComputePoolsComputePools): any;
export declare function dataSnowflakeComputePoolsComputePoolsToHclTerraform(struct?: DataSnowflakeComputePoolsComputePools): any;
export declare class DataSnowflakeComputePoolsComputePoolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeComputePoolsComputePools | undefined;
    set internalValue(value: DataSnowflakeComputePoolsComputePools | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeComputePoolsComputePoolsDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeComputePoolsComputePoolsShowOutputList;
}
export declare class DataSnowflakeComputePoolsComputePoolsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeComputePoolsComputePoolsOutputReference;
}
export interface DataSnowflakeComputePoolsLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#from DataSnowflakeComputePools#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#rows DataSnowflakeComputePools#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeComputePoolsLimitToTerraform(struct?: DataSnowflakeComputePoolsLimitOutputReference | DataSnowflakeComputePoolsLimit): any;
export declare function dataSnowflakeComputePoolsLimitToHclTerraform(struct?: DataSnowflakeComputePoolsLimitOutputReference | DataSnowflakeComputePoolsLimit): any;
export declare class DataSnowflakeComputePoolsLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeComputePoolsLimit | undefined;
    set internalValue(value: DataSnowflakeComputePoolsLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools snowflake_compute_pools}
*/
export declare class DataSnowflakeComputePools extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_compute_pools";
    /**
    * Generates CDKTF code for importing a DataSnowflakeComputePools resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeComputePools to import
    * @param importFromId The id of the existing DataSnowflakeComputePools that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeComputePools to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/compute_pools snowflake_compute_pools} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeComputePoolsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeComputePoolsConfig);
    private _computePools;
    get computePools(): DataSnowflakeComputePoolsComputePoolsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _limit;
    get limit(): DataSnowflakeComputePoolsLimitOutputReference;
    putLimit(value: DataSnowflakeComputePoolsLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeComputePoolsLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
