/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeDynamicTablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#id DataSnowflakeDynamicTables#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optionally filters the command output based on the characters that appear at the beginning of the object name. The string is case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#starts_with DataSnowflakeDynamicTables#starts_with}
    */
    readonly startsWith?: string;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#in DataSnowflakeDynamicTables#in}
    */
    readonly in?: DataSnowflakeDynamicTablesIn;
    /**
    * like block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#like DataSnowflakeDynamicTables#like}
    */
    readonly like?: DataSnowflakeDynamicTablesLike;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#limit DataSnowflakeDynamicTables#limit}
    */
    readonly limit?: DataSnowflakeDynamicTablesLimit;
}
export interface DataSnowflakeDynamicTablesRecords {
}
export declare function dataSnowflakeDynamicTablesRecordsToTerraform(struct?: DataSnowflakeDynamicTablesRecords): any;
export declare function dataSnowflakeDynamicTablesRecordsToHclTerraform(struct?: DataSnowflakeDynamicTablesRecords): any;
export declare class DataSnowflakeDynamicTablesRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDynamicTablesRecords | undefined;
    set internalValue(value: DataSnowflakeDynamicTablesRecords | undefined);
    get automaticClustering(): cdktf.IResolvable;
    get bytes(): number;
    get clusterBy(): string;
    get comment(): string;
    get createdOn(): string;
    get dataTimestamp(): string;
    get databaseName(): string;
    get isClone(): cdktf.IResolvable;
    get isReplica(): cdktf.IResolvable;
    get lastSuspendedOn(): string;
    get name(): string;
    get owner(): string;
    get refreshMode(): string;
    get refreshModeReason(): string;
    get rows(): number;
    get schedulingState(): string;
    get schemaName(): string;
    get targetLag(): string;
    get text(): string;
    get warehouse(): string;
}
export declare class DataSnowflakeDynamicTablesRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDynamicTablesRecordsOutputReference;
}
export interface DataSnowflakeDynamicTablesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#account DataSnowflakeDynamicTables#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the current database in use or for a specified database (db_name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#database DataSnowflakeDynamicTables#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema (schema_name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#schema DataSnowflakeDynamicTables#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeDynamicTablesInToTerraform(struct?: DataSnowflakeDynamicTablesInOutputReference | DataSnowflakeDynamicTablesIn): any;
export declare function dataSnowflakeDynamicTablesInToHclTerraform(struct?: DataSnowflakeDynamicTablesInOutputReference | DataSnowflakeDynamicTablesIn): any;
export declare class DataSnowflakeDynamicTablesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeDynamicTablesIn | undefined;
    set internalValue(value: DataSnowflakeDynamicTablesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeDynamicTablesLike {
    /**
    * Filters the command output by object name. The filter uses case-insensitive pattern matching with support for SQL wildcard characters (% and _).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#pattern DataSnowflakeDynamicTables#pattern}
    */
    readonly pattern: string;
}
export declare function dataSnowflakeDynamicTablesLikeToTerraform(struct?: DataSnowflakeDynamicTablesLikeOutputReference | DataSnowflakeDynamicTablesLike): any;
export declare function dataSnowflakeDynamicTablesLikeToHclTerraform(struct?: DataSnowflakeDynamicTablesLikeOutputReference | DataSnowflakeDynamicTablesLike): any;
export declare class DataSnowflakeDynamicTablesLikeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeDynamicTablesLike | undefined;
    set internalValue(value: DataSnowflakeDynamicTablesLike | undefined);
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
}
export interface DataSnowflakeDynamicTablesLimit {
    /**
    * The optional FROM 'name_string' subclause effectively serves as a “cursor” for the results. This enables fetching the specified number of rows following the first row whose object name matches the specified string
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#from DataSnowflakeDynamicTables#from}
    */
    readonly from?: string;
    /**
    * Specifies the maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#rows DataSnowflakeDynamicTables#rows}
    */
    readonly rows?: number;
}
export declare function dataSnowflakeDynamicTablesLimitToTerraform(struct?: DataSnowflakeDynamicTablesLimitOutputReference | DataSnowflakeDynamicTablesLimit): any;
export declare function dataSnowflakeDynamicTablesLimitToHclTerraform(struct?: DataSnowflakeDynamicTablesLimitOutputReference | DataSnowflakeDynamicTablesLimit): any;
export declare class DataSnowflakeDynamicTablesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeDynamicTablesLimit | undefined;
    set internalValue(value: DataSnowflakeDynamicTablesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    resetRows(): void;
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables snowflake_dynamic_tables}
*/
export declare class DataSnowflakeDynamicTables extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_dynamic_tables";
    /**
    * Generates CDKTF code for importing a DataSnowflakeDynamicTables resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeDynamicTables to import
    * @param importFromId The id of the existing DataSnowflakeDynamicTables that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeDynamicTables to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/dynamic_tables snowflake_dynamic_tables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeDynamicTablesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeDynamicTablesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _records;
    get records(): DataSnowflakeDynamicTablesRecordsList;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _in;
    get in(): DataSnowflakeDynamicTablesInOutputReference;
    putIn(value: DataSnowflakeDynamicTablesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeDynamicTablesIn | undefined;
    private _like;
    get like(): DataSnowflakeDynamicTablesLikeOutputReference;
    putLike(value: DataSnowflakeDynamicTablesLike): void;
    resetLike(): void;
    get likeInput(): DataSnowflakeDynamicTablesLike | undefined;
    private _limit;
    get limit(): DataSnowflakeDynamicTablesLimitOutputReference;
    putLimit(value: DataSnowflakeDynamicTablesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeDynamicTablesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
