/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeGitRepositoriesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#id DataSnowflakeGitRepositories#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#like DataSnowflakeGitRepositories#like}
    */
    readonly like?: string;
    /**
    * (Default: `true`) Runs DESC GIT REPOSITORY for each git repository returned by SHOW GIT REPOSITORIES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#with_describe DataSnowflakeGitRepositories#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#in DataSnowflakeGitRepositories#in}
    */
    readonly in?: DataSnowflakeGitRepositoriesIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#limit DataSnowflakeGitRepositories#limit}
    */
    readonly limit?: DataSnowflakeGitRepositoriesLimit;
}
export interface DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutput {
}
export declare function dataSnowflakeGitRepositoriesGitRepositoriesDescribeOutputToTerraform(struct?: DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutput): any;
export declare function dataSnowflakeGitRepositoriesGitRepositoriesDescribeOutputToHclTerraform(struct?: DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutput): any;
export declare class DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutput | undefined);
    get apiIntegration(): string;
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get gitCredentials(): string;
    get lastFetchedAt(): string;
    get name(): string;
    get origin(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutputOutputReference;
}
export interface DataSnowflakeGitRepositoriesGitRepositoriesShowOutput {
}
export declare function dataSnowflakeGitRepositoriesGitRepositoriesShowOutputToTerraform(struct?: DataSnowflakeGitRepositoriesGitRepositoriesShowOutput): any;
export declare function dataSnowflakeGitRepositoriesGitRepositoriesShowOutputToHclTerraform(struct?: DataSnowflakeGitRepositoriesGitRepositoriesShowOutput): any;
export declare class DataSnowflakeGitRepositoriesGitRepositoriesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeGitRepositoriesGitRepositoriesShowOutput | undefined;
    set internalValue(value: DataSnowflakeGitRepositoriesGitRepositoriesShowOutput | undefined);
    get apiIntegration(): string;
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get gitCredentials(): string;
    get lastFetchedAt(): string;
    get name(): string;
    get origin(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class DataSnowflakeGitRepositoriesGitRepositoriesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeGitRepositoriesGitRepositoriesShowOutputOutputReference;
}
export interface DataSnowflakeGitRepositoriesGitRepositories {
}
export declare function dataSnowflakeGitRepositoriesGitRepositoriesToTerraform(struct?: DataSnowflakeGitRepositoriesGitRepositories): any;
export declare function dataSnowflakeGitRepositoriesGitRepositoriesToHclTerraform(struct?: DataSnowflakeGitRepositoriesGitRepositories): any;
export declare class DataSnowflakeGitRepositoriesGitRepositoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeGitRepositoriesGitRepositories | undefined;
    set internalValue(value: DataSnowflakeGitRepositoriesGitRepositories | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeGitRepositoriesGitRepositoriesDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeGitRepositoriesGitRepositoriesShowOutputList;
}
export declare class DataSnowflakeGitRepositoriesGitRepositoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeGitRepositoriesGitRepositoriesOutputReference;
}
export interface DataSnowflakeGitRepositoriesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#account DataSnowflakeGitRepositories#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#database DataSnowflakeGitRepositories#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#schema DataSnowflakeGitRepositories#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeGitRepositoriesInToTerraform(struct?: DataSnowflakeGitRepositoriesInOutputReference | DataSnowflakeGitRepositoriesIn): any;
export declare function dataSnowflakeGitRepositoriesInToHclTerraform(struct?: DataSnowflakeGitRepositoriesInOutputReference | DataSnowflakeGitRepositoriesIn): any;
export declare class DataSnowflakeGitRepositoriesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGitRepositoriesIn | undefined;
    set internalValue(value: DataSnowflakeGitRepositoriesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeGitRepositoriesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#from DataSnowflakeGitRepositories#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#rows DataSnowflakeGitRepositories#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeGitRepositoriesLimitToTerraform(struct?: DataSnowflakeGitRepositoriesLimitOutputReference | DataSnowflakeGitRepositoriesLimit): any;
export declare function dataSnowflakeGitRepositoriesLimitToHclTerraform(struct?: DataSnowflakeGitRepositoriesLimitOutputReference | DataSnowflakeGitRepositoriesLimit): any;
export declare class DataSnowflakeGitRepositoriesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGitRepositoriesLimit | undefined;
    set internalValue(value: DataSnowflakeGitRepositoriesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories snowflake_git_repositories}
*/
export declare class DataSnowflakeGitRepositories extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_git_repositories";
    /**
    * Generates CDKTF code for importing a DataSnowflakeGitRepositories resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeGitRepositories to import
    * @param importFromId The id of the existing DataSnowflakeGitRepositories that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeGitRepositories to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/git_repositories snowflake_git_repositories} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeGitRepositoriesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeGitRepositoriesConfig);
    private _gitRepositories;
    get gitRepositories(): DataSnowflakeGitRepositoriesGitRepositoriesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeGitRepositoriesInOutputReference;
    putIn(value: DataSnowflakeGitRepositoriesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeGitRepositoriesIn | undefined;
    private _limit;
    get limit(): DataSnowflakeGitRepositoriesLimitOutputReference;
    putLimit(value: DataSnowflakeGitRepositoriesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeGitRepositoriesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
