/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeImageRepositoriesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories#id DataSnowflakeImageRepositories#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories#like DataSnowflakeImageRepositories#like}
    */
    readonly like?: string;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories#in DataSnowflakeImageRepositories#in}
    */
    readonly in?: DataSnowflakeImageRepositoriesIn;
}
export interface DataSnowflakeImageRepositoriesImageRepositoriesShowOutput {
}
export declare function dataSnowflakeImageRepositoriesImageRepositoriesShowOutputToTerraform(struct?: DataSnowflakeImageRepositoriesImageRepositoriesShowOutput): any;
export declare function dataSnowflakeImageRepositoriesImageRepositoriesShowOutputToHclTerraform(struct?: DataSnowflakeImageRepositoriesImageRepositoriesShowOutput): any;
export declare class DataSnowflakeImageRepositoriesImageRepositoriesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeImageRepositoriesImageRepositoriesShowOutput | undefined;
    set internalValue(value: DataSnowflakeImageRepositoriesImageRepositoriesShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get privatelinkRepositoryUrl(): string;
    get repositoryUrl(): string;
    get schemaName(): string;
}
export declare class DataSnowflakeImageRepositoriesImageRepositoriesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeImageRepositoriesImageRepositoriesShowOutputOutputReference;
}
export interface DataSnowflakeImageRepositoriesImageRepositories {
}
export declare function dataSnowflakeImageRepositoriesImageRepositoriesToTerraform(struct?: DataSnowflakeImageRepositoriesImageRepositories): any;
export declare function dataSnowflakeImageRepositoriesImageRepositoriesToHclTerraform(struct?: DataSnowflakeImageRepositoriesImageRepositories): any;
export declare class DataSnowflakeImageRepositoriesImageRepositoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeImageRepositoriesImageRepositories | undefined;
    set internalValue(value: DataSnowflakeImageRepositoriesImageRepositories | undefined);
    private _showOutput;
    get showOutput(): DataSnowflakeImageRepositoriesImageRepositoriesShowOutputList;
}
export declare class DataSnowflakeImageRepositoriesImageRepositoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeImageRepositoriesImageRepositoriesOutputReference;
}
export interface DataSnowflakeImageRepositoriesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories#account DataSnowflakeImageRepositories#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories#database DataSnowflakeImageRepositories#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories#schema DataSnowflakeImageRepositories#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeImageRepositoriesInToTerraform(struct?: DataSnowflakeImageRepositoriesInOutputReference | DataSnowflakeImageRepositoriesIn): any;
export declare function dataSnowflakeImageRepositoriesInToHclTerraform(struct?: DataSnowflakeImageRepositoriesInOutputReference | DataSnowflakeImageRepositoriesIn): any;
export declare class DataSnowflakeImageRepositoriesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeImageRepositoriesIn | undefined;
    set internalValue(value: DataSnowflakeImageRepositoriesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories snowflake_image_repositories}
*/
export declare class DataSnowflakeImageRepositories extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_image_repositories";
    /**
    * Generates CDKTF code for importing a DataSnowflakeImageRepositories resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeImageRepositories to import
    * @param importFromId The id of the existing DataSnowflakeImageRepositories that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeImageRepositories to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/image_repositories snowflake_image_repositories} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeImageRepositoriesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeImageRepositoriesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageRepositories;
    get imageRepositories(): DataSnowflakeImageRepositoriesImageRepositoriesList;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _in;
    get in(): DataSnowflakeImageRepositoriesInOutputReference;
    putIn(value: DataSnowflakeImageRepositoriesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeImageRepositoriesIn | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
