/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeRowAccessPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#id DataSnowflakeRowAccessPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#like DataSnowflakeRowAccessPolicies#like}
    */
    readonly like?: string;
    /**
    * (Default: `true`) Runs DESC ROW ACCESS POLICY for each row access policy returned by SHOW ROW ACCESS POLICIES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#with_describe DataSnowflakeRowAccessPolicies#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#in DataSnowflakeRowAccessPolicies#in}
    */
    readonly in?: DataSnowflakeRowAccessPoliciesIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#limit DataSnowflakeRowAccessPolicies#limit}
    */
    readonly limit?: DataSnowflakeRowAccessPoliciesLimit;
}
export interface DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignature {
}
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignatureToTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignature): any;
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignatureToHclTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignature): any;
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignatureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignature | undefined;
    set internalValue(value: DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignature | undefined);
    get name(): string;
    get type(): string;
}
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignatureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignatureOutputReference;
}
export interface DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutput {
}
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputToTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutput): any;
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputToHclTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutput): any;
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutput | undefined);
    get body(): string;
    get name(): string;
    get returnType(): string;
    private _signature;
    get signature(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputSignatureList;
}
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputOutputReference;
}
export interface DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutput {
}
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutputToTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutput): any;
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutputToHclTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutput): any;
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutput | undefined;
    set internalValue(value: DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get kind(): string;
    get name(): string;
    get options(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutputOutputReference;
}
export interface DataSnowflakeRowAccessPoliciesRowAccessPolicies {
}
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesToTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPolicies): any;
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesToHclTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPolicies): any;
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeRowAccessPoliciesRowAccessPolicies | undefined;
    set internalValue(value: DataSnowflakeRowAccessPoliciesRowAccessPolicies | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesShowOutputList;
}
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeRowAccessPoliciesRowAccessPoliciesOutputReference;
}
export interface DataSnowflakeRowAccessPoliciesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#account DataSnowflakeRowAccessPolicies#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#application DataSnowflakeRowAccessPolicies#application}
    */
    readonly application?: string;
    /**
    * Returns records for the specified application package.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#application_package DataSnowflakeRowAccessPolicies#application_package}
    */
    readonly applicationPackage?: string;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#database DataSnowflakeRowAccessPolicies#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#schema DataSnowflakeRowAccessPolicies#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeRowAccessPoliciesInToTerraform(struct?: DataSnowflakeRowAccessPoliciesInOutputReference | DataSnowflakeRowAccessPoliciesIn): any;
export declare function dataSnowflakeRowAccessPoliciesInToHclTerraform(struct?: DataSnowflakeRowAccessPoliciesInOutputReference | DataSnowflakeRowAccessPoliciesIn): any;
export declare class DataSnowflakeRowAccessPoliciesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeRowAccessPoliciesIn | undefined;
    set internalValue(value: DataSnowflakeRowAccessPoliciesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationPackage?;
    get applicationPackage(): string;
    set applicationPackage(value: string);
    resetApplicationPackage(): void;
    get applicationPackageInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeRowAccessPoliciesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#from DataSnowflakeRowAccessPolicies#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#rows DataSnowflakeRowAccessPolicies#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeRowAccessPoliciesLimitToTerraform(struct?: DataSnowflakeRowAccessPoliciesLimitOutputReference | DataSnowflakeRowAccessPoliciesLimit): any;
export declare function dataSnowflakeRowAccessPoliciesLimitToHclTerraform(struct?: DataSnowflakeRowAccessPoliciesLimitOutputReference | DataSnowflakeRowAccessPoliciesLimit): any;
export declare class DataSnowflakeRowAccessPoliciesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeRowAccessPoliciesLimit | undefined;
    set internalValue(value: DataSnowflakeRowAccessPoliciesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies snowflake_row_access_policies}
*/
export declare class DataSnowflakeRowAccessPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_row_access_policies";
    /**
    * Generates CDKTF code for importing a DataSnowflakeRowAccessPolicies resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeRowAccessPolicies to import
    * @param importFromId The id of the existing DataSnowflakeRowAccessPolicies that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeRowAccessPolicies to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/row_access_policies snowflake_row_access_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeRowAccessPoliciesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeRowAccessPoliciesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _rowAccessPolicies;
    get rowAccessPolicies(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeRowAccessPoliciesInOutputReference;
    putIn(value: DataSnowflakeRowAccessPoliciesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeRowAccessPoliciesIn | undefined;
    private _limit;
    get limit(): DataSnowflakeRowAccessPoliciesLimitOutputReference;
    putLimit(value: DataSnowflakeRowAccessPoliciesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeRowAccessPoliciesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
