/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSchemasConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#id DataSnowflakeSchemas#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#like DataSnowflakeSchemas#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#starts_with DataSnowflakeSchemas#starts_with}
    */
    readonly startsWith?: string;
    /**
    * (Default: `true`) Runs DESC SCHEMA for each schema returned by SHOW SCHEMAS. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#with_describe DataSnowflakeSchemas#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * (Default: `true`) Runs SHOW PARAMETERS FOR SCHEMA for each schema returned by SHOW SCHEMAS. The output of describe is saved to the parameters field as a map. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#with_parameters DataSnowflakeSchemas#with_parameters}
    */
    readonly withParameters?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#in DataSnowflakeSchemas#in}
    */
    readonly in?: DataSnowflakeSchemasIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#limit DataSnowflakeSchemas#limit}
    */
    readonly limit?: DataSnowflakeSchemasLimit;
}
export interface DataSnowflakeSchemasSchemasDescribeOutput {
}
export declare function dataSnowflakeSchemasSchemasDescribeOutputToTerraform(struct?: DataSnowflakeSchemasSchemasDescribeOutput): any;
export declare function dataSnowflakeSchemasSchemasDescribeOutputToHclTerraform(struct?: DataSnowflakeSchemasSchemasDescribeOutput): any;
export declare class DataSnowflakeSchemasSchemasDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasDescribeOutput | undefined);
    get createdOn(): string;
    get kind(): string;
    get name(): string;
}
export declare class DataSnowflakeSchemasSchemasDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasDescribeOutputOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersCatalog {
}
export declare function dataSnowflakeSchemasSchemasParametersCatalogToTerraform(struct?: DataSnowflakeSchemasSchemasParametersCatalog): any;
export declare function dataSnowflakeSchemasSchemasParametersCatalogToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersCatalog): any;
export declare class DataSnowflakeSchemasSchemasParametersCatalogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersCatalog | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersCatalog | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersCatalogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersCatalogOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDays {
}
export declare function dataSnowflakeSchemasSchemasParametersDataRetentionTimeInDaysToTerraform(struct?: DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDays): any;
export declare function dataSnowflakeSchemasSchemasParametersDataRetentionTimeInDaysToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDays): any;
export declare class DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDaysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDays | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDays | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDaysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDaysOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersDefaultDdlCollation {
}
export declare function dataSnowflakeSchemasSchemasParametersDefaultDdlCollationToTerraform(struct?: DataSnowflakeSchemasSchemasParametersDefaultDdlCollation): any;
export declare function dataSnowflakeSchemasSchemasParametersDefaultDdlCollationToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersDefaultDdlCollation): any;
export declare class DataSnowflakeSchemasSchemasParametersDefaultDdlCollationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersDefaultDdlCollation | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersDefaultDdlCollation | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersDefaultDdlCollationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersDefaultDdlCollationOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersEnableConsoleOutput {
}
export declare function dataSnowflakeSchemasSchemasParametersEnableConsoleOutputToTerraform(struct?: DataSnowflakeSchemasSchemasParametersEnableConsoleOutput): any;
export declare function dataSnowflakeSchemasSchemasParametersEnableConsoleOutputToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersEnableConsoleOutput): any;
export declare class DataSnowflakeSchemasSchemasParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersEnableConsoleOutput | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersEnableConsoleOutputOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersExternalVolume {
}
export declare function dataSnowflakeSchemasSchemasParametersExternalVolumeToTerraform(struct?: DataSnowflakeSchemasSchemasParametersExternalVolume): any;
export declare function dataSnowflakeSchemasSchemasParametersExternalVolumeToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersExternalVolume): any;
export declare class DataSnowflakeSchemasSchemasParametersExternalVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersExternalVolume | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersExternalVolume | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersExternalVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersExternalVolumeOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersLogLevel {
}
export declare function dataSnowflakeSchemasSchemasParametersLogLevelToTerraform(struct?: DataSnowflakeSchemasSchemasParametersLogLevel): any;
export declare function dataSnowflakeSchemasSchemasParametersLogLevelToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersLogLevel): any;
export declare class DataSnowflakeSchemasSchemasParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersLogLevel | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersLogLevelOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDays {
}
export declare function dataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDaysToTerraform(struct?: DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDays): any;
export declare function dataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDaysToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDays): any;
export declare class DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDaysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDays | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDays | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDaysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDaysOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersPipeExecutionPaused {
}
export declare function dataSnowflakeSchemasSchemasParametersPipeExecutionPausedToTerraform(struct?: DataSnowflakeSchemasSchemasParametersPipeExecutionPaused): any;
export declare function dataSnowflakeSchemasSchemasParametersPipeExecutionPausedToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersPipeExecutionPaused): any;
export declare class DataSnowflakeSchemasSchemasParametersPipeExecutionPausedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersPipeExecutionPaused | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersPipeExecutionPaused | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersPipeExecutionPausedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersPipeExecutionPausedOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCase {
}
export declare function dataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCase): any;
export declare function dataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCase): any;
export declare class DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersReplaceInvalidCharacters {
}
export declare function dataSnowflakeSchemasSchemasParametersReplaceInvalidCharactersToTerraform(struct?: DataSnowflakeSchemasSchemasParametersReplaceInvalidCharacters): any;
export declare function dataSnowflakeSchemasSchemasParametersReplaceInvalidCharactersToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersReplaceInvalidCharacters): any;
export declare class DataSnowflakeSchemasSchemasParametersReplaceInvalidCharactersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersReplaceInvalidCharacters | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersReplaceInvalidCharacters | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersReplaceInvalidCharactersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersReplaceInvalidCharactersOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersStorageSerializationPolicy {
}
export declare function dataSnowflakeSchemasSchemasParametersStorageSerializationPolicyToTerraform(struct?: DataSnowflakeSchemasSchemasParametersStorageSerializationPolicy): any;
export declare function dataSnowflakeSchemasSchemasParametersStorageSerializationPolicyToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersStorageSerializationPolicy): any;
export declare class DataSnowflakeSchemasSchemasParametersStorageSerializationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersStorageSerializationPolicy | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersStorageSerializationPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersStorageSerializationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersStorageSerializationPolicyOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailures {
}
export declare function dataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailuresToTerraform(struct?: DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailures): any;
export declare function dataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailuresToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailures): any;
export declare class DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailuresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailures | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailures | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailuresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailuresOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttempts {
}
export declare function dataSnowflakeSchemasSchemasParametersTaskAutoRetryAttemptsToTerraform(struct?: DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttempts): any;
export declare function dataSnowflakeSchemasSchemasParametersTaskAutoRetryAttemptsToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttempts): any;
export declare class DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttemptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttempts | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttempts | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttemptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttemptsOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersTraceLevel {
}
export declare function dataSnowflakeSchemasSchemasParametersTraceLevelToTerraform(struct?: DataSnowflakeSchemasSchemasParametersTraceLevel): any;
export declare function dataSnowflakeSchemasSchemasParametersTraceLevelToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersTraceLevel): any;
export declare class DataSnowflakeSchemasSchemasParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersTraceLevel | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersTraceLevelOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSize {
}
export declare function dataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSizeToTerraform(struct?: DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSize): any;
export declare function dataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSizeToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSize): any;
export declare class DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSize | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSizeOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSeconds {
}
export declare function dataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSecondsToTerraform(struct?: DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare function dataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSecondsToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare class DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSeconds | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference;
}
export interface DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMs {
}
export declare function dataSnowflakeSchemasSchemasParametersUserTaskTimeoutMsToTerraform(struct?: DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMs): any;
export declare function dataSnowflakeSchemasSchemasParametersUserTaskTimeoutMsToHclTerraform(struct?: DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMs): any;
export declare class DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMs | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMs | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMsOutputReference;
}
export interface DataSnowflakeSchemasSchemasParameters {
}
export declare function dataSnowflakeSchemasSchemasParametersToTerraform(struct?: DataSnowflakeSchemasSchemasParameters): any;
export declare function dataSnowflakeSchemasSchemasParametersToHclTerraform(struct?: DataSnowflakeSchemasSchemasParameters): any;
export declare class DataSnowflakeSchemasSchemasParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasParameters | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasParameters | undefined);
    private _catalog;
    get catalog(): DataSnowflakeSchemasSchemasParametersCatalogList;
    private _dataRetentionTimeInDays;
    get dataRetentionTimeInDays(): DataSnowflakeSchemasSchemasParametersDataRetentionTimeInDaysList;
    private _defaultDdlCollation;
    get defaultDdlCollation(): DataSnowflakeSchemasSchemasParametersDefaultDdlCollationList;
    private _enableConsoleOutput;
    get enableConsoleOutput(): DataSnowflakeSchemasSchemasParametersEnableConsoleOutputList;
    private _externalVolume;
    get externalVolume(): DataSnowflakeSchemasSchemasParametersExternalVolumeList;
    private _logLevel;
    get logLevel(): DataSnowflakeSchemasSchemasParametersLogLevelList;
    private _maxDataExtensionTimeInDays;
    get maxDataExtensionTimeInDays(): DataSnowflakeSchemasSchemasParametersMaxDataExtensionTimeInDaysList;
    private _pipeExecutionPaused;
    get pipeExecutionPaused(): DataSnowflakeSchemasSchemasParametersPipeExecutionPausedList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): DataSnowflakeSchemasSchemasParametersQuotedIdentifiersIgnoreCaseList;
    private _replaceInvalidCharacters;
    get replaceInvalidCharacters(): DataSnowflakeSchemasSchemasParametersReplaceInvalidCharactersList;
    private _storageSerializationPolicy;
    get storageSerializationPolicy(): DataSnowflakeSchemasSchemasParametersStorageSerializationPolicyList;
    private _suspendTaskAfterNumFailures;
    get suspendTaskAfterNumFailures(): DataSnowflakeSchemasSchemasParametersSuspendTaskAfterNumFailuresList;
    private _taskAutoRetryAttempts;
    get taskAutoRetryAttempts(): DataSnowflakeSchemasSchemasParametersTaskAutoRetryAttemptsList;
    private _traceLevel;
    get traceLevel(): DataSnowflakeSchemasSchemasParametersTraceLevelList;
    private _userTaskManagedInitialWarehouseSize;
    get userTaskManagedInitialWarehouseSize(): DataSnowflakeSchemasSchemasParametersUserTaskManagedInitialWarehouseSizeList;
    private _userTaskMinimumTriggerIntervalInSeconds;
    get userTaskMinimumTriggerIntervalInSeconds(): DataSnowflakeSchemasSchemasParametersUserTaskMinimumTriggerIntervalInSecondsList;
    private _userTaskTimeoutMs;
    get userTaskTimeoutMs(): DataSnowflakeSchemasSchemasParametersUserTaskTimeoutMsList;
}
export declare class DataSnowflakeSchemasSchemasParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasParametersOutputReference;
}
export interface DataSnowflakeSchemasSchemasShowOutput {
}
export declare function dataSnowflakeSchemasSchemasShowOutputToTerraform(struct?: DataSnowflakeSchemasSchemasShowOutput): any;
export declare function dataSnowflakeSchemasSchemasShowOutputToHclTerraform(struct?: DataSnowflakeSchemasSchemasShowOutput): any;
export declare class DataSnowflakeSchemasSchemasShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemasShowOutput | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemasShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get droppedOn(): string;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get name(): string;
    get options(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get retentionTime(): string;
}
export declare class DataSnowflakeSchemasSchemasShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasShowOutputOutputReference;
}
export interface DataSnowflakeSchemasSchemas {
}
export declare function dataSnowflakeSchemasSchemasToTerraform(struct?: DataSnowflakeSchemasSchemas): any;
export declare function dataSnowflakeSchemasSchemasToHclTerraform(struct?: DataSnowflakeSchemasSchemas): any;
export declare class DataSnowflakeSchemasSchemasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemas | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemas | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeSchemasSchemasDescribeOutputList;
    private _parameters;
    get parameters(): DataSnowflakeSchemasSchemasParametersList;
    private _showOutput;
    get showOutput(): DataSnowflakeSchemasSchemasShowOutputList;
}
export declare class DataSnowflakeSchemasSchemasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasOutputReference;
}
export interface DataSnowflakeSchemasIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#account DataSnowflakeSchemas#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#application DataSnowflakeSchemas#application}
    */
    readonly application?: string;
    /**
    * Returns records for the specified application package.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#application_package DataSnowflakeSchemas#application_package}
    */
    readonly applicationPackage?: string;
    /**
    * Returns records for the current database in use or for a specified database (db_name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#database DataSnowflakeSchemas#database}
    */
    readonly database?: string;
}
export declare function dataSnowflakeSchemasInToTerraform(struct?: DataSnowflakeSchemasInOutputReference | DataSnowflakeSchemasIn): any;
export declare function dataSnowflakeSchemasInToHclTerraform(struct?: DataSnowflakeSchemasInOutputReference | DataSnowflakeSchemasIn): any;
export declare class DataSnowflakeSchemasInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeSchemasIn | undefined;
    set internalValue(value: DataSnowflakeSchemasIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationPackage?;
    get applicationPackage(): string;
    set applicationPackage(value: string);
    resetApplicationPackage(): void;
    get applicationPackageInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
}
export interface DataSnowflakeSchemasLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#from DataSnowflakeSchemas#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#rows DataSnowflakeSchemas#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeSchemasLimitToTerraform(struct?: DataSnowflakeSchemasLimitOutputReference | DataSnowflakeSchemasLimit): any;
export declare function dataSnowflakeSchemasLimitToHclTerraform(struct?: DataSnowflakeSchemasLimitOutputReference | DataSnowflakeSchemasLimit): any;
export declare class DataSnowflakeSchemasLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeSchemasLimit | undefined;
    set internalValue(value: DataSnowflakeSchemasLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas snowflake_schemas}
*/
export declare class DataSnowflakeSchemas extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_schemas";
    /**
    * Generates CDKTF code for importing a DataSnowflakeSchemas resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeSchemas to import
    * @param importFromId The id of the existing DataSnowflakeSchemas that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeSchemas to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/schemas snowflake_schemas} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSchemasConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeSchemasConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _schemas;
    get schemas(): DataSnowflakeSchemasSchemasList;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _withParameters?;
    get withParameters(): boolean | cdktf.IResolvable;
    set withParameters(value: boolean | cdktf.IResolvable);
    resetWithParameters(): void;
    get withParametersInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeSchemasInOutputReference;
    putIn(value: DataSnowflakeSchemasIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeSchemasIn | undefined;
    private _limit;
    get limit(): DataSnowflakeSchemasLimitOutputReference;
    putLimit(value: DataSnowflakeSchemasLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeSchemasLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
