/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSecretsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#id DataSnowflakeSecrets#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#like DataSnowflakeSecrets#like}
    */
    readonly like?: string;
    /**
    * (Default: `true`) Runs DESC SECRET for each secret returned by SHOW SECRETS. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#with_describe DataSnowflakeSecrets#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#in DataSnowflakeSecrets#in}
    */
    readonly in?: DataSnowflakeSecretsIn;
}
export interface DataSnowflakeSecretsSecretsDescribeOutput {
}
export declare function dataSnowflakeSecretsSecretsDescribeOutputToTerraform(struct?: DataSnowflakeSecretsSecretsDescribeOutput): any;
export declare function dataSnowflakeSecretsSecretsDescribeOutputToHclTerraform(struct?: DataSnowflakeSecretsSecretsDescribeOutput): any;
export declare class DataSnowflakeSecretsSecretsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSecretsSecretsDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeSecretsSecretsDescribeOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get integrationName(): string;
    get name(): string;
    get oauthAccessTokenExpiryTime(): string;
    get oauthRefreshTokenExpiryTime(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get schemaName(): string;
    get secretType(): string;
    get username(): string;
}
export declare class DataSnowflakeSecretsSecretsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSecretsSecretsDescribeOutputOutputReference;
}
export interface DataSnowflakeSecretsSecretsShowOutput {
}
export declare function dataSnowflakeSecretsSecretsShowOutputToTerraform(struct?: DataSnowflakeSecretsSecretsShowOutput): any;
export declare function dataSnowflakeSecretsSecretsShowOutputToHclTerraform(struct?: DataSnowflakeSecretsSecretsShowOutput): any;
export declare class DataSnowflakeSecretsSecretsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSecretsSecretsShowOutput | undefined;
    set internalValue(value: DataSnowflakeSecretsSecretsShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get secretType(): string;
}
export declare class DataSnowflakeSecretsSecretsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSecretsSecretsShowOutputOutputReference;
}
export interface DataSnowflakeSecretsSecrets {
}
export declare function dataSnowflakeSecretsSecretsToTerraform(struct?: DataSnowflakeSecretsSecrets): any;
export declare function dataSnowflakeSecretsSecretsToHclTerraform(struct?: DataSnowflakeSecretsSecrets): any;
export declare class DataSnowflakeSecretsSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSecretsSecrets | undefined;
    set internalValue(value: DataSnowflakeSecretsSecrets | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeSecretsSecretsDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeSecretsSecretsShowOutputList;
}
export declare class DataSnowflakeSecretsSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSecretsSecretsOutputReference;
}
export interface DataSnowflakeSecretsIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#account DataSnowflakeSecrets#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#application DataSnowflakeSecrets#application}
    */
    readonly application?: string;
    /**
    * Returns records for the specified application package.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#application_package DataSnowflakeSecrets#application_package}
    */
    readonly applicationPackage?: string;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#database DataSnowflakeSecrets#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#schema DataSnowflakeSecrets#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeSecretsInToTerraform(struct?: DataSnowflakeSecretsInOutputReference | DataSnowflakeSecretsIn): any;
export declare function dataSnowflakeSecretsInToHclTerraform(struct?: DataSnowflakeSecretsInOutputReference | DataSnowflakeSecretsIn): any;
export declare class DataSnowflakeSecretsInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeSecretsIn | undefined;
    set internalValue(value: DataSnowflakeSecretsIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationPackage?;
    get applicationPackage(): string;
    set applicationPackage(value: string);
    resetApplicationPackage(): void;
    get applicationPackageInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets snowflake_secrets}
*/
export declare class DataSnowflakeSecrets extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_secrets";
    /**
    * Generates CDKTF code for importing a DataSnowflakeSecrets resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeSecrets to import
    * @param importFromId The id of the existing DataSnowflakeSecrets that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeSecrets to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/secrets snowflake_secrets} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSecretsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeSecretsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _secrets;
    get secrets(): DataSnowflakeSecretsSecretsList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeSecretsInOutputReference;
    putIn(value: DataSnowflakeSecretsIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeSecretsIn | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
