/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeServicesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#id DataSnowflakeServices#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#like DataSnowflakeServices#like}
    */
    readonly like?: string;
    /**
    * (Default: `ALL`) The type filtering of `SHOW SERVICES` results. `ALL` returns both services and job services. `JOBS_ONLY` returns only job services (`JOB` option in SQL). `SERVICES_ONLY` returns only services (`EXCLUDE_JOBS` option in SQL).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#service_type DataSnowflakeServices#service_type}
    */
    readonly serviceType?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#starts_with DataSnowflakeServices#starts_with}
    */
    readonly startsWith?: string;
    /**
    * (Default: `true`) Runs DESC SERVICE for each service returned by SHOW SERVICES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#with_describe DataSnowflakeServices#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#in DataSnowflakeServices#in}
    */
    readonly in?: DataSnowflakeServicesIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#limit DataSnowflakeServices#limit}
    */
    readonly limit?: DataSnowflakeServicesLimit;
}
export interface DataSnowflakeServicesServicesDescribeOutput {
}
export declare function dataSnowflakeServicesServicesDescribeOutputToTerraform(struct?: DataSnowflakeServicesServicesDescribeOutput): any;
export declare function dataSnowflakeServicesServicesDescribeOutputToHclTerraform(struct?: DataSnowflakeServicesServicesDescribeOutput): any;
export declare class DataSnowflakeServicesServicesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeServicesServicesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeServicesServicesDescribeOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get computePool(): string;
    get createdOn(): string;
    get currentInstances(): number;
    get databaseName(): string;
    get dnsName(): string;
    get externalAccessIntegrations(): string[];
    get isAsyncJob(): cdktf.IResolvable;
    get isJob(): cdktf.IResolvable;
    get isUpgrading(): cdktf.IResolvable;
    get managingObjectDomain(): string;
    get managingObjectName(): string;
    get maxInstances(): number;
    get minInstances(): number;
    get minReadyInstances(): number;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get resumedOn(): string;
    get schemaName(): string;
    get spec(): string;
    get specDigest(): string;
    get status(): string;
    get suspendedOn(): string;
    get targetInstances(): number;
    get updatedOn(): string;
}
export declare class DataSnowflakeServicesServicesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeServicesServicesDescribeOutputOutputReference;
}
export interface DataSnowflakeServicesServicesShowOutput {
}
export declare function dataSnowflakeServicesServicesShowOutputToTerraform(struct?: DataSnowflakeServicesServicesShowOutput): any;
export declare function dataSnowflakeServicesServicesShowOutputToHclTerraform(struct?: DataSnowflakeServicesServicesShowOutput): any;
export declare class DataSnowflakeServicesServicesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeServicesServicesShowOutput | undefined;
    set internalValue(value: DataSnowflakeServicesServicesShowOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get computePool(): string;
    get createdOn(): string;
    get currentInstances(): number;
    get databaseName(): string;
    get dnsName(): string;
    get externalAccessIntegrations(): string[];
    get isAsyncJob(): cdktf.IResolvable;
    get isJob(): cdktf.IResolvable;
    get isUpgrading(): cdktf.IResolvable;
    get managingObjectDomain(): string;
    get managingObjectName(): string;
    get maxInstances(): number;
    get minInstances(): number;
    get minReadyInstances(): number;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get resumedOn(): string;
    get schemaName(): string;
    get specDigest(): string;
    get status(): string;
    get suspendedOn(): string;
    get targetInstances(): number;
    get updatedOn(): string;
}
export declare class DataSnowflakeServicesServicesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeServicesServicesShowOutputOutputReference;
}
export interface DataSnowflakeServicesServices {
}
export declare function dataSnowflakeServicesServicesToTerraform(struct?: DataSnowflakeServicesServices): any;
export declare function dataSnowflakeServicesServicesToHclTerraform(struct?: DataSnowflakeServicesServices): any;
export declare class DataSnowflakeServicesServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeServicesServices | undefined;
    set internalValue(value: DataSnowflakeServicesServices | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeServicesServicesDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeServicesServicesShowOutputList;
}
export declare class DataSnowflakeServicesServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeServicesServicesOutputReference;
}
export interface DataSnowflakeServicesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#account DataSnowflakeServices#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified compute pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#compute_pool DataSnowflakeServices#compute_pool}
    */
    readonly computePool?: string;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#database DataSnowflakeServices#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#schema DataSnowflakeServices#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeServicesInToTerraform(struct?: DataSnowflakeServicesInOutputReference | DataSnowflakeServicesIn): any;
export declare function dataSnowflakeServicesInToHclTerraform(struct?: DataSnowflakeServicesInOutputReference | DataSnowflakeServicesIn): any;
export declare class DataSnowflakeServicesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeServicesIn | undefined;
    set internalValue(value: DataSnowflakeServicesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _computePool?;
    get computePool(): string;
    set computePool(value: string);
    resetComputePool(): void;
    get computePoolInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeServicesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#from DataSnowflakeServices#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#rows DataSnowflakeServices#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeServicesLimitToTerraform(struct?: DataSnowflakeServicesLimitOutputReference | DataSnowflakeServicesLimit): any;
export declare function dataSnowflakeServicesLimitToHclTerraform(struct?: DataSnowflakeServicesLimitOutputReference | DataSnowflakeServicesLimit): any;
export declare class DataSnowflakeServicesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeServicesLimit | undefined;
    set internalValue(value: DataSnowflakeServicesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services snowflake_services}
*/
export declare class DataSnowflakeServices extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_services";
    /**
    * Generates CDKTF code for importing a DataSnowflakeServices resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeServices to import
    * @param importFromId The id of the existing DataSnowflakeServices that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeServices to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/services snowflake_services} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeServicesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeServicesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _serviceType?;
    get serviceType(): string;
    set serviceType(value: string);
    resetServiceType(): void;
    get serviceTypeInput(): string | undefined;
    private _services;
    get services(): DataSnowflakeServicesServicesList;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeServicesInOutputReference;
    putIn(value: DataSnowflakeServicesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeServicesIn | undefined;
    private _limit;
    get limit(): DataSnowflakeServicesLimitOutputReference;
    putLimit(value: DataSnowflakeServicesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeServicesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
