/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeStreamlitsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#id DataSnowflakeStreamlits#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#like DataSnowflakeStreamlits#like}
    */
    readonly like?: string;
    /**
    * (Default: `true`) Runs DESC STREAMLIT for each streamlit returned by SHOW STREAMLITS. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#with_describe DataSnowflakeStreamlits#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#in DataSnowflakeStreamlits#in}
    */
    readonly in?: DataSnowflakeStreamlitsIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#limit DataSnowflakeStreamlits#limit}
    */
    readonly limit?: DataSnowflakeStreamlitsLimit;
}
export interface DataSnowflakeStreamlitsStreamlitsDescribeOutput {
}
export declare function dataSnowflakeStreamlitsStreamlitsDescribeOutputToTerraform(struct?: DataSnowflakeStreamlitsStreamlitsDescribeOutput): any;
export declare function dataSnowflakeStreamlitsStreamlitsDescribeOutputToHclTerraform(struct?: DataSnowflakeStreamlitsStreamlitsDescribeOutput): any;
export declare class DataSnowflakeStreamlitsStreamlitsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeStreamlitsStreamlitsDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeStreamlitsStreamlitsDescribeOutput | undefined);
    get defaultPackages(): string;
    get externalAccessIntegrations(): string[];
    get externalAccessSecrets(): string;
    get importUrls(): string[];
    get mainFile(): string;
    get name(): string;
    get queryWarehouse(): string;
    get rootLocation(): string;
    get title(): string;
    get urlId(): string;
    get userPackages(): string[];
}
export declare class DataSnowflakeStreamlitsStreamlitsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeStreamlitsStreamlitsDescribeOutputOutputReference;
}
export interface DataSnowflakeStreamlitsStreamlitsShowOutput {
}
export declare function dataSnowflakeStreamlitsStreamlitsShowOutputToTerraform(struct?: DataSnowflakeStreamlitsStreamlitsShowOutput): any;
export declare function dataSnowflakeStreamlitsStreamlitsShowOutputToHclTerraform(struct?: DataSnowflakeStreamlitsStreamlitsShowOutput): any;
export declare class DataSnowflakeStreamlitsStreamlitsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeStreamlitsStreamlitsShowOutput | undefined;
    set internalValue(value: DataSnowflakeStreamlitsStreamlitsShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get schemaName(): string;
    get title(): string;
    get urlId(): string;
}
export declare class DataSnowflakeStreamlitsStreamlitsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeStreamlitsStreamlitsShowOutputOutputReference;
}
export interface DataSnowflakeStreamlitsStreamlits {
}
export declare function dataSnowflakeStreamlitsStreamlitsToTerraform(struct?: DataSnowflakeStreamlitsStreamlits): any;
export declare function dataSnowflakeStreamlitsStreamlitsToHclTerraform(struct?: DataSnowflakeStreamlitsStreamlits): any;
export declare class DataSnowflakeStreamlitsStreamlitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeStreamlitsStreamlits | undefined;
    set internalValue(value: DataSnowflakeStreamlitsStreamlits | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeStreamlitsStreamlitsDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeStreamlitsStreamlitsShowOutputList;
}
export declare class DataSnowflakeStreamlitsStreamlitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeStreamlitsStreamlitsOutputReference;
}
export interface DataSnowflakeStreamlitsIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#account DataSnowflakeStreamlits#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the current database in use or for a specified database (db_name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#database DataSnowflakeStreamlits#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema (schema_name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#schema DataSnowflakeStreamlits#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeStreamlitsInToTerraform(struct?: DataSnowflakeStreamlitsInOutputReference | DataSnowflakeStreamlitsIn): any;
export declare function dataSnowflakeStreamlitsInToHclTerraform(struct?: DataSnowflakeStreamlitsInOutputReference | DataSnowflakeStreamlitsIn): any;
export declare class DataSnowflakeStreamlitsInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeStreamlitsIn | undefined;
    set internalValue(value: DataSnowflakeStreamlitsIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeStreamlitsLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#from DataSnowflakeStreamlits#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#rows DataSnowflakeStreamlits#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeStreamlitsLimitToTerraform(struct?: DataSnowflakeStreamlitsLimitOutputReference | DataSnowflakeStreamlitsLimit): any;
export declare function dataSnowflakeStreamlitsLimitToHclTerraform(struct?: DataSnowflakeStreamlitsLimitOutputReference | DataSnowflakeStreamlitsLimit): any;
export declare class DataSnowflakeStreamlitsLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeStreamlitsLimit | undefined;
    set internalValue(value: DataSnowflakeStreamlitsLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits snowflake_streamlits}
*/
export declare class DataSnowflakeStreamlits extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_streamlits";
    /**
    * Generates CDKTF code for importing a DataSnowflakeStreamlits resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeStreamlits to import
    * @param importFromId The id of the existing DataSnowflakeStreamlits that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeStreamlits to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streamlits snowflake_streamlits} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeStreamlitsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeStreamlitsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _streamlits;
    get streamlits(): DataSnowflakeStreamlitsStreamlitsList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeStreamlitsInOutputReference;
    putIn(value: DataSnowflakeStreamlitsIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeStreamlitsIn | undefined;
    private _limit;
    get limit(): DataSnowflakeStreamlitsLimitOutputReference;
    putLimit(value: DataSnowflakeStreamlitsLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeStreamlitsLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
