/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeStreamsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#id DataSnowflakeStreams#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#like DataSnowflakeStreams#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#starts_with DataSnowflakeStreams#starts_with}
    */
    readonly startsWith?: string;
    /**
    * (Default: `true`) Runs DESC STREAM for each user returned by SHOW STREAMS. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#with_describe DataSnowflakeStreams#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#in DataSnowflakeStreams#in}
    */
    readonly in?: DataSnowflakeStreamsIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#limit DataSnowflakeStreams#limit}
    */
    readonly limit?: DataSnowflakeStreamsLimit;
}
export interface DataSnowflakeStreamsStreamsDescribeOutput {
}
export declare function dataSnowflakeStreamsStreamsDescribeOutputToTerraform(struct?: DataSnowflakeStreamsStreamsDescribeOutput): any;
export declare function dataSnowflakeStreamsStreamsDescribeOutputToHclTerraform(struct?: DataSnowflakeStreamsStreamsDescribeOutput): any;
export declare class DataSnowflakeStreamsStreamsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeStreamsStreamsDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeStreamsStreamsDescribeOutput | undefined);
    get baseTables(): string[];
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get invalidReason(): string;
    get mode(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get sourceType(): string;
    get stale(): cdktf.IResolvable;
    get staleAfter(): string;
    get tableName(): string;
    get type(): string;
}
export declare class DataSnowflakeStreamsStreamsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeStreamsStreamsDescribeOutputOutputReference;
}
export interface DataSnowflakeStreamsStreamsShowOutput {
}
export declare function dataSnowflakeStreamsStreamsShowOutputToTerraform(struct?: DataSnowflakeStreamsStreamsShowOutput): any;
export declare function dataSnowflakeStreamsStreamsShowOutputToHclTerraform(struct?: DataSnowflakeStreamsStreamsShowOutput): any;
export declare class DataSnowflakeStreamsStreamsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeStreamsStreamsShowOutput | undefined;
    set internalValue(value: DataSnowflakeStreamsStreamsShowOutput | undefined);
    get baseTables(): string[];
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get invalidReason(): string;
    get mode(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get sourceType(): string;
    get stale(): cdktf.IResolvable;
    get staleAfter(): string;
    get tableName(): string;
    get type(): string;
}
export declare class DataSnowflakeStreamsStreamsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeStreamsStreamsShowOutputOutputReference;
}
export interface DataSnowflakeStreamsStreams {
}
export declare function dataSnowflakeStreamsStreamsToTerraform(struct?: DataSnowflakeStreamsStreams): any;
export declare function dataSnowflakeStreamsStreamsToHclTerraform(struct?: DataSnowflakeStreamsStreams): any;
export declare class DataSnowflakeStreamsStreamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeStreamsStreams | undefined;
    set internalValue(value: DataSnowflakeStreamsStreams | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeStreamsStreamsDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeStreamsStreamsShowOutputList;
}
export declare class DataSnowflakeStreamsStreamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeStreamsStreamsOutputReference;
}
export interface DataSnowflakeStreamsIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#account DataSnowflakeStreams#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#application DataSnowflakeStreams#application}
    */
    readonly application?: string;
    /**
    * Returns records for the specified application package.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#application_package DataSnowflakeStreams#application_package}
    */
    readonly applicationPackage?: string;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#database DataSnowflakeStreams#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#schema DataSnowflakeStreams#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeStreamsInToTerraform(struct?: DataSnowflakeStreamsInOutputReference | DataSnowflakeStreamsIn): any;
export declare function dataSnowflakeStreamsInToHclTerraform(struct?: DataSnowflakeStreamsInOutputReference | DataSnowflakeStreamsIn): any;
export declare class DataSnowflakeStreamsInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeStreamsIn | undefined;
    set internalValue(value: DataSnowflakeStreamsIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationPackage?;
    get applicationPackage(): string;
    set applicationPackage(value: string);
    resetApplicationPackage(): void;
    get applicationPackageInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeStreamsLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#from DataSnowflakeStreams#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#rows DataSnowflakeStreams#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeStreamsLimitToTerraform(struct?: DataSnowflakeStreamsLimitOutputReference | DataSnowflakeStreamsLimit): any;
export declare function dataSnowflakeStreamsLimitToHclTerraform(struct?: DataSnowflakeStreamsLimitOutputReference | DataSnowflakeStreamsLimit): any;
export declare class DataSnowflakeStreamsLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeStreamsLimit | undefined;
    set internalValue(value: DataSnowflakeStreamsLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams snowflake_streams}
*/
export declare class DataSnowflakeStreams extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_streams";
    /**
    * Generates CDKTF code for importing a DataSnowflakeStreams resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeStreams to import
    * @param importFromId The id of the existing DataSnowflakeStreams that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeStreams to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/streams snowflake_streams} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeStreamsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeStreamsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _streams;
    get streams(): DataSnowflakeStreamsStreamsList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeStreamsInOutputReference;
    putIn(value: DataSnowflakeStreamsIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeStreamsIn | undefined;
    private _limit;
    get limit(): DataSnowflakeStreamsLimitOutputReference;
    putLimit(value: DataSnowflakeStreamsLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeStreamsLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
