/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeTablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#id DataSnowflakeTables#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#like DataSnowflakeTables#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#starts_with DataSnowflakeTables#starts_with}
    */
    readonly startsWith?: string;
    /**
    * (Default: `true`) Runs DESC TABLE for each table returned by SHOW TABLES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#with_describe DataSnowflakeTables#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#in DataSnowflakeTables#in}
    */
    readonly in?: DataSnowflakeTablesIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#limit DataSnowflakeTables#limit}
    */
    readonly limit?: DataSnowflakeTablesLimit;
}
export interface DataSnowflakeTablesTablesDescribeOutput {
}
export declare function dataSnowflakeTablesTablesDescribeOutputToTerraform(struct?: DataSnowflakeTablesTablesDescribeOutput): any;
export declare function dataSnowflakeTablesTablesDescribeOutputToHclTerraform(struct?: DataSnowflakeTablesTablesDescribeOutput): any;
export declare class DataSnowflakeTablesTablesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTablesTablesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeTablesTablesDescribeOutput | undefined);
    get check(): string;
    get collation(): string;
    get comment(): string;
    get default(): string;
    get expression(): string;
    get isNullable(): cdktf.IResolvable;
    get isPrimary(): cdktf.IResolvable;
    get isUnique(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get policyName(): string;
    get schemaEvolutionRecord(): string;
    get type(): string;
}
export declare class DataSnowflakeTablesTablesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTablesTablesDescribeOutputOutputReference;
}
export interface DataSnowflakeTablesTablesShowOutput {
}
export declare function dataSnowflakeTablesTablesShowOutputToTerraform(struct?: DataSnowflakeTablesTablesShowOutput): any;
export declare function dataSnowflakeTablesTablesShowOutputToHclTerraform(struct?: DataSnowflakeTablesTablesShowOutput): any;
export declare class DataSnowflakeTablesTablesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTablesTablesShowOutput | undefined;
    set internalValue(value: DataSnowflakeTablesTablesShowOutput | undefined);
    get automaticClustering(): cdktf.IResolvable;
    get budget(): string;
    get bytes(): number;
    get changeTracking(): cdktf.IResolvable;
    get clusterBy(): string;
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get droppedOn(): string;
    get enableSchemaEvolution(): cdktf.IResolvable;
    get isEvent(): cdktf.IResolvable;
    get isExternal(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get retentionTime(): number;
    get rows(): number;
    get schemaName(): string;
    get searchOptimization(): cdktf.IResolvable;
    get searchOptimizationBytes(): number;
    get searchOptimizationProgress(): string;
}
export declare class DataSnowflakeTablesTablesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTablesTablesShowOutputOutputReference;
}
export interface DataSnowflakeTablesTables {
}
export declare function dataSnowflakeTablesTablesToTerraform(struct?: DataSnowflakeTablesTables): any;
export declare function dataSnowflakeTablesTablesToHclTerraform(struct?: DataSnowflakeTablesTables): any;
export declare class DataSnowflakeTablesTablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTablesTables | undefined;
    set internalValue(value: DataSnowflakeTablesTables | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeTablesTablesDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeTablesTablesShowOutputList;
}
export declare class DataSnowflakeTablesTablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTablesTablesOutputReference;
}
export interface DataSnowflakeTablesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#account DataSnowflakeTables#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#application DataSnowflakeTables#application}
    */
    readonly application?: string;
    /**
    * Returns records for the specified application package.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#application_package DataSnowflakeTables#application_package}
    */
    readonly applicationPackage?: string;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#database DataSnowflakeTables#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#schema DataSnowflakeTables#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeTablesInToTerraform(struct?: DataSnowflakeTablesInOutputReference | DataSnowflakeTablesIn): any;
export declare function dataSnowflakeTablesInToHclTerraform(struct?: DataSnowflakeTablesInOutputReference | DataSnowflakeTablesIn): any;
export declare class DataSnowflakeTablesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeTablesIn | undefined;
    set internalValue(value: DataSnowflakeTablesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationPackage?;
    get applicationPackage(): string;
    set applicationPackage(value: string);
    resetApplicationPackage(): void;
    get applicationPackageInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeTablesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#from DataSnowflakeTables#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#rows DataSnowflakeTables#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeTablesLimitToTerraform(struct?: DataSnowflakeTablesLimitOutputReference | DataSnowflakeTablesLimit): any;
export declare function dataSnowflakeTablesLimitToHclTerraform(struct?: DataSnowflakeTablesLimitOutputReference | DataSnowflakeTablesLimit): any;
export declare class DataSnowflakeTablesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeTablesLimit | undefined;
    set internalValue(value: DataSnowflakeTablesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables snowflake_tables}
*/
export declare class DataSnowflakeTables extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_tables";
    /**
    * Generates CDKTF code for importing a DataSnowflakeTables resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeTables to import
    * @param importFromId The id of the existing DataSnowflakeTables that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeTables to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tables snowflake_tables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeTablesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeTablesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _tables;
    get tables(): DataSnowflakeTablesTablesList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeTablesInOutputReference;
    putIn(value: DataSnowflakeTablesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeTablesIn | undefined;
    private _limit;
    get limit(): DataSnowflakeTablesLimitOutputReference;
    putLimit(value: DataSnowflakeTablesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeTablesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
