/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeTasksConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#id DataSnowflakeTasks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#like DataSnowflakeTasks#like}
    */
    readonly like?: string;
    /**
    * Filters the command output to return only root tasks (tasks with no predecessors).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#root_only DataSnowflakeTasks#root_only}
    */
    readonly rootOnly?: boolean | cdktf.IResolvable;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#starts_with DataSnowflakeTasks#starts_with}
    */
    readonly startsWith?: string;
    /**
    * (Default: `true`) Runs SHOW PARAMETERS FOR TASK for each task returned by SHOW TASK and saves the output to the parameters field as a map. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#with_parameters DataSnowflakeTasks#with_parameters}
    */
    readonly withParameters?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#in DataSnowflakeTasks#in}
    */
    readonly in?: DataSnowflakeTasksIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#limit DataSnowflakeTasks#limit}
    */
    readonly limit?: DataSnowflakeTasksLimit;
}
export interface DataSnowflakeTasksTasksParametersAbortDetachedQuery {
}
export declare function dataSnowflakeTasksTasksParametersAbortDetachedQueryToTerraform(struct?: DataSnowflakeTasksTasksParametersAbortDetachedQuery): any;
export declare function dataSnowflakeTasksTasksParametersAbortDetachedQueryToHclTerraform(struct?: DataSnowflakeTasksTasksParametersAbortDetachedQuery): any;
export declare class DataSnowflakeTasksTasksParametersAbortDetachedQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersAbortDetachedQuery | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersAbortDetachedQuery | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersAbortDetachedQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersAbortDetachedQueryOutputReference;
}
export interface DataSnowflakeTasksTasksParametersAutocommit {
}
export declare function dataSnowflakeTasksTasksParametersAutocommitToTerraform(struct?: DataSnowflakeTasksTasksParametersAutocommit): any;
export declare function dataSnowflakeTasksTasksParametersAutocommitToHclTerraform(struct?: DataSnowflakeTasksTasksParametersAutocommit): any;
export declare class DataSnowflakeTasksTasksParametersAutocommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersAutocommit | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersAutocommit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersAutocommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersAutocommitOutputReference;
}
export interface DataSnowflakeTasksTasksParametersBinaryInputFormat {
}
export declare function dataSnowflakeTasksTasksParametersBinaryInputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersBinaryInputFormat): any;
export declare function dataSnowflakeTasksTasksParametersBinaryInputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersBinaryInputFormat): any;
export declare class DataSnowflakeTasksTasksParametersBinaryInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersBinaryInputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersBinaryInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersBinaryInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersBinaryInputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersBinaryOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersBinaryOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersBinaryOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersBinaryOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersBinaryOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersBinaryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersBinaryOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersBinaryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersBinaryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersBinaryOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientMemoryLimit {
}
export declare function dataSnowflakeTasksTasksParametersClientMemoryLimitToTerraform(struct?: DataSnowflakeTasksTasksParametersClientMemoryLimit): any;
export declare function dataSnowflakeTasksTasksParametersClientMemoryLimitToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientMemoryLimit): any;
export declare class DataSnowflakeTasksTasksParametersClientMemoryLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientMemoryLimit | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientMemoryLimit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientMemoryLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientMemoryLimitOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtx {
}
export declare function dataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtxToTerraform(struct?: DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtx): any;
export declare function dataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtxToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtx): any;
export declare class DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtx | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtx | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtxOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientPrefetchThreads {
}
export declare function dataSnowflakeTasksTasksParametersClientPrefetchThreadsToTerraform(struct?: DataSnowflakeTasksTasksParametersClientPrefetchThreads): any;
export declare function dataSnowflakeTasksTasksParametersClientPrefetchThreadsToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientPrefetchThreads): any;
export declare class DataSnowflakeTasksTasksParametersClientPrefetchThreadsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientPrefetchThreads | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientPrefetchThreads | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientPrefetchThreadsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientPrefetchThreadsOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientResultChunkSize {
}
export declare function dataSnowflakeTasksTasksParametersClientResultChunkSizeToTerraform(struct?: DataSnowflakeTasksTasksParametersClientResultChunkSize): any;
export declare function dataSnowflakeTasksTasksParametersClientResultChunkSizeToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientResultChunkSize): any;
export declare class DataSnowflakeTasksTasksParametersClientResultChunkSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientResultChunkSize | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientResultChunkSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientResultChunkSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientResultChunkSizeOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitive {
}
export declare function dataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitiveToTerraform(struct?: DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitive): any;
export declare function dataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitiveToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitive): any;
export declare class DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitive | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitiveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitiveOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientSessionKeepAlive {
}
export declare function dataSnowflakeTasksTasksParametersClientSessionKeepAliveToTerraform(struct?: DataSnowflakeTasksTasksParametersClientSessionKeepAlive): any;
export declare function dataSnowflakeTasksTasksParametersClientSessionKeepAliveToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientSessionKeepAlive): any;
export declare class DataSnowflakeTasksTasksParametersClientSessionKeepAliveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientSessionKeepAlive | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientSessionKeepAlive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientSessionKeepAliveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientSessionKeepAliveOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequency {
}
export declare function dataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequencyToTerraform(struct?: DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare function dataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequencyToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare class DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequency | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequency | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequencyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference;
}
export interface DataSnowflakeTasksTasksParametersClientTimestampTypeMapping {
}
export declare function dataSnowflakeTasksTasksParametersClientTimestampTypeMappingToTerraform(struct?: DataSnowflakeTasksTasksParametersClientTimestampTypeMapping): any;
export declare function dataSnowflakeTasksTasksParametersClientTimestampTypeMappingToHclTerraform(struct?: DataSnowflakeTasksTasksParametersClientTimestampTypeMapping): any;
export declare class DataSnowflakeTasksTasksParametersClientTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersClientTimestampTypeMapping | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersClientTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersClientTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersClientTimestampTypeMappingOutputReference;
}
export interface DataSnowflakeTasksTasksParametersDateInputFormat {
}
export declare function dataSnowflakeTasksTasksParametersDateInputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersDateInputFormat): any;
export declare function dataSnowflakeTasksTasksParametersDateInputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersDateInputFormat): any;
export declare class DataSnowflakeTasksTasksParametersDateInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersDateInputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersDateInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersDateInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersDateInputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersDateOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersDateOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersDateOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersDateOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersDateOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersDateOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersDateOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersDateOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersDateOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersDateOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimization {
}
export declare function dataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimizationToTerraform(struct?: DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimization): any;
export declare function dataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimizationToHclTerraform(struct?: DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimization): any;
export declare class DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimization | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimization | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimizationOutputReference;
}
export interface DataSnowflakeTasksTasksParametersErrorOnNondeterministicMerge {
}
export declare function dataSnowflakeTasksTasksParametersErrorOnNondeterministicMergeToTerraform(struct?: DataSnowflakeTasksTasksParametersErrorOnNondeterministicMerge): any;
export declare function dataSnowflakeTasksTasksParametersErrorOnNondeterministicMergeToHclTerraform(struct?: DataSnowflakeTasksTasksParametersErrorOnNondeterministicMerge): any;
export declare class DataSnowflakeTasksTasksParametersErrorOnNondeterministicMergeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersErrorOnNondeterministicMerge | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersErrorOnNondeterministicMerge | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersErrorOnNondeterministicMergeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersErrorOnNondeterministicMergeOutputReference;
}
export interface DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdate {
}
export declare function dataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdateToTerraform(struct?: DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdate): any;
export declare function dataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdateToHclTerraform(struct?: DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdate): any;
export declare class DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdate | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdate | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdateOutputReference;
}
export interface DataSnowflakeTasksTasksParametersGeographyOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersGeographyOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersGeographyOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersGeographyOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersGeographyOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersGeographyOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersGeographyOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersGeographyOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersGeographyOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersGeographyOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersGeometryOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersGeometryOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersGeometryOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersGeometryOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersGeometryOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersGeometryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersGeometryOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersGeometryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersGeometryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersGeometryOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtc {
}
export declare function dataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtcToTerraform(struct?: DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtc): any;
export declare function dataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtcToHclTerraform(struct?: DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtc): any;
export declare class DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtc | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtc | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtcOutputReference;
}
export interface DataSnowflakeTasksTasksParametersJdbcUseSessionTimezone {
}
export declare function dataSnowflakeTasksTasksParametersJdbcUseSessionTimezoneToTerraform(struct?: DataSnowflakeTasksTasksParametersJdbcUseSessionTimezone): any;
export declare function dataSnowflakeTasksTasksParametersJdbcUseSessionTimezoneToHclTerraform(struct?: DataSnowflakeTasksTasksParametersJdbcUseSessionTimezone): any;
export declare class DataSnowflakeTasksTasksParametersJdbcUseSessionTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersJdbcUseSessionTimezone | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersJdbcUseSessionTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersJdbcUseSessionTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersJdbcUseSessionTimezoneOutputReference;
}
export interface DataSnowflakeTasksTasksParametersJsonIndent {
}
export declare function dataSnowflakeTasksTasksParametersJsonIndentToTerraform(struct?: DataSnowflakeTasksTasksParametersJsonIndent): any;
export declare function dataSnowflakeTasksTasksParametersJsonIndentToHclTerraform(struct?: DataSnowflakeTasksTasksParametersJsonIndent): any;
export declare class DataSnowflakeTasksTasksParametersJsonIndentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersJsonIndent | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersJsonIndent | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersJsonIndentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersJsonIndentOutputReference;
}
export interface DataSnowflakeTasksTasksParametersLockTimeout {
}
export declare function dataSnowflakeTasksTasksParametersLockTimeoutToTerraform(struct?: DataSnowflakeTasksTasksParametersLockTimeout): any;
export declare function dataSnowflakeTasksTasksParametersLockTimeoutToHclTerraform(struct?: DataSnowflakeTasksTasksParametersLockTimeout): any;
export declare class DataSnowflakeTasksTasksParametersLockTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersLockTimeout | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersLockTimeout | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersLockTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersLockTimeoutOutputReference;
}
export interface DataSnowflakeTasksTasksParametersLogLevel {
}
export declare function dataSnowflakeTasksTasksParametersLogLevelToTerraform(struct?: DataSnowflakeTasksTasksParametersLogLevel): any;
export declare function dataSnowflakeTasksTasksParametersLogLevelToHclTerraform(struct?: DataSnowflakeTasksTasksParametersLogLevel): any;
export declare class DataSnowflakeTasksTasksParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersLogLevel | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersLogLevelOutputReference;
}
export interface DataSnowflakeTasksTasksParametersMultiStatementCount {
}
export declare function dataSnowflakeTasksTasksParametersMultiStatementCountToTerraform(struct?: DataSnowflakeTasksTasksParametersMultiStatementCount): any;
export declare function dataSnowflakeTasksTasksParametersMultiStatementCountToHclTerraform(struct?: DataSnowflakeTasksTasksParametersMultiStatementCount): any;
export declare class DataSnowflakeTasksTasksParametersMultiStatementCountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersMultiStatementCount | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersMultiStatementCount | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersMultiStatementCountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersMultiStatementCountOutputReference;
}
export interface DataSnowflakeTasksTasksParametersNoorderSequenceAsDefault {
}
export declare function dataSnowflakeTasksTasksParametersNoorderSequenceAsDefaultToTerraform(struct?: DataSnowflakeTasksTasksParametersNoorderSequenceAsDefault): any;
export declare function dataSnowflakeTasksTasksParametersNoorderSequenceAsDefaultToHclTerraform(struct?: DataSnowflakeTasksTasksParametersNoorderSequenceAsDefault): any;
export declare class DataSnowflakeTasksTasksParametersNoorderSequenceAsDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersNoorderSequenceAsDefault | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersNoorderSequenceAsDefault | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersNoorderSequenceAsDefaultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersNoorderSequenceAsDefaultOutputReference;
}
export interface DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsInt {
}
export declare function dataSnowflakeTasksTasksParametersOdbcTreatDecimalAsIntToTerraform(struct?: DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsInt): any;
export declare function dataSnowflakeTasksTasksParametersOdbcTreatDecimalAsIntToHclTerraform(struct?: DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsInt): any;
export declare class DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsInt | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsIntOutputReference;
}
export interface DataSnowflakeTasksTasksParametersQueryTag {
}
export declare function dataSnowflakeTasksTasksParametersQueryTagToTerraform(struct?: DataSnowflakeTasksTasksParametersQueryTag): any;
export declare function dataSnowflakeTasksTasksParametersQueryTagToHclTerraform(struct?: DataSnowflakeTasksTasksParametersQueryTag): any;
export declare class DataSnowflakeTasksTasksParametersQueryTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersQueryTag | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersQueryTag | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersQueryTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersQueryTagOutputReference;
}
export interface DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCase {
}
export declare function dataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCase): any;
export declare function dataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCase): any;
export declare class DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface DataSnowflakeTasksTasksParametersRowsPerResultset {
}
export declare function dataSnowflakeTasksTasksParametersRowsPerResultsetToTerraform(struct?: DataSnowflakeTasksTasksParametersRowsPerResultset): any;
export declare function dataSnowflakeTasksTasksParametersRowsPerResultsetToHclTerraform(struct?: DataSnowflakeTasksTasksParametersRowsPerResultset): any;
export declare class DataSnowflakeTasksTasksParametersRowsPerResultsetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersRowsPerResultset | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersRowsPerResultset | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersRowsPerResultsetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersRowsPerResultsetOutputReference;
}
export interface DataSnowflakeTasksTasksParametersS3StageVpceDnsName {
}
export declare function dataSnowflakeTasksTasksParametersS3StageVpceDnsNameToTerraform(struct?: DataSnowflakeTasksTasksParametersS3StageVpceDnsName): any;
export declare function dataSnowflakeTasksTasksParametersS3StageVpceDnsNameToHclTerraform(struct?: DataSnowflakeTasksTasksParametersS3StageVpceDnsName): any;
export declare class DataSnowflakeTasksTasksParametersS3StageVpceDnsNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersS3StageVpceDnsName | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersS3StageVpceDnsName | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersS3StageVpceDnsNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersS3StageVpceDnsNameOutputReference;
}
export interface DataSnowflakeTasksTasksParametersSearchPath {
}
export declare function dataSnowflakeTasksTasksParametersSearchPathToTerraform(struct?: DataSnowflakeTasksTasksParametersSearchPath): any;
export declare function dataSnowflakeTasksTasksParametersSearchPathToHclTerraform(struct?: DataSnowflakeTasksTasksParametersSearchPath): any;
export declare class DataSnowflakeTasksTasksParametersSearchPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersSearchPath | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersSearchPath | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersSearchPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersSearchPathOutputReference;
}
export interface DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSeconds {
}
export declare function dataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSeconds): any;
export declare function dataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSeconds): any;
export declare class DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface DataSnowflakeTasksTasksParametersStatementTimeoutInSeconds {
}
export declare function dataSnowflakeTasksTasksParametersStatementTimeoutInSecondsToTerraform(struct?: DataSnowflakeTasksTasksParametersStatementTimeoutInSeconds): any;
export declare function dataSnowflakeTasksTasksParametersStatementTimeoutInSecondsToHclTerraform(struct?: DataSnowflakeTasksTasksParametersStatementTimeoutInSeconds): any;
export declare class DataSnowflakeTasksTasksParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersStatementTimeoutInSecondsOutputReference;
}
export interface DataSnowflakeTasksTasksParametersStrictJsonOutput {
}
export declare function dataSnowflakeTasksTasksParametersStrictJsonOutputToTerraform(struct?: DataSnowflakeTasksTasksParametersStrictJsonOutput): any;
export declare function dataSnowflakeTasksTasksParametersStrictJsonOutputToHclTerraform(struct?: DataSnowflakeTasksTasksParametersStrictJsonOutput): any;
export declare class DataSnowflakeTasksTasksParametersStrictJsonOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersStrictJsonOutput | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersStrictJsonOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersStrictJsonOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersStrictJsonOutputOutputReference;
}
export interface DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailures {
}
export declare function dataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailuresToTerraform(struct?: DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailures): any;
export declare function dataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailuresToHclTerraform(struct?: DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailures): any;
export declare class DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailuresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailures | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailures | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailuresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailuresOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTaskAutoRetryAttempts {
}
export declare function dataSnowflakeTasksTasksParametersTaskAutoRetryAttemptsToTerraform(struct?: DataSnowflakeTasksTasksParametersTaskAutoRetryAttempts): any;
export declare function dataSnowflakeTasksTasksParametersTaskAutoRetryAttemptsToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTaskAutoRetryAttempts): any;
export declare class DataSnowflakeTasksTasksParametersTaskAutoRetryAttemptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTaskAutoRetryAttempts | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTaskAutoRetryAttempts | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTaskAutoRetryAttemptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTaskAutoRetryAttemptsOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimeInputFormat {
}
export declare function dataSnowflakeTasksTasksParametersTimeInputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersTimeInputFormat): any;
export declare function dataSnowflakeTasksTasksParametersTimeInputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimeInputFormat): any;
export declare class DataSnowflakeTasksTasksParametersTimeInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimeInputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimeInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimeInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimeInputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimeOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersTimeOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersTimeOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersTimeOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimeOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersTimeOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimeOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimeOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimeOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimeOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimestampDayIsAlways24H {
}
export declare function dataSnowflakeTasksTasksParametersTimestampDayIsAlways24HToTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampDayIsAlways24H): any;
export declare function dataSnowflakeTasksTasksParametersTimestampDayIsAlways24HToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampDayIsAlways24H): any;
export declare class DataSnowflakeTasksTasksParametersTimestampDayIsAlways24HOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimestampDayIsAlways24H | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimestampDayIsAlways24H | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimestampDayIsAlways24HList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimestampDayIsAlways24HOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimestampInputFormat {
}
export declare function dataSnowflakeTasksTasksParametersTimestampInputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampInputFormat): any;
export declare function dataSnowflakeTasksTasksParametersTimestampInputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampInputFormat): any;
export declare class DataSnowflakeTasksTasksParametersTimestampInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimestampInputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimestampInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimestampInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimestampInputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimestampLtzOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersTimestampLtzOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampLtzOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersTimestampLtzOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampLtzOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersTimestampLtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimestampLtzOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimestampLtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimestampLtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimestampLtzOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimestampNtzOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersTimestampNtzOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampNtzOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersTimestampNtzOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampNtzOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersTimestampNtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimestampNtzOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimestampNtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimestampNtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimestampNtzOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimestampOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersTimestampOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersTimestampOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersTimestampOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimestampOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimestampOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimestampOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimestampOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimestampTypeMapping {
}
export declare function dataSnowflakeTasksTasksParametersTimestampTypeMappingToTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampTypeMapping): any;
export declare function dataSnowflakeTasksTasksParametersTimestampTypeMappingToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampTypeMapping): any;
export declare class DataSnowflakeTasksTasksParametersTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimestampTypeMapping | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimestampTypeMappingOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimestampTzOutputFormat {
}
export declare function dataSnowflakeTasksTasksParametersTimestampTzOutputFormatToTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampTzOutputFormat): any;
export declare function dataSnowflakeTasksTasksParametersTimestampTzOutputFormatToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimestampTzOutputFormat): any;
export declare class DataSnowflakeTasksTasksParametersTimestampTzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimestampTzOutputFormat | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimestampTzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimestampTzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimestampTzOutputFormatOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTimezone {
}
export declare function dataSnowflakeTasksTasksParametersTimezoneToTerraform(struct?: DataSnowflakeTasksTasksParametersTimezone): any;
export declare function dataSnowflakeTasksTasksParametersTimezoneToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTimezone): any;
export declare class DataSnowflakeTasksTasksParametersTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTimezone | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTimezoneOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTraceLevel {
}
export declare function dataSnowflakeTasksTasksParametersTraceLevelToTerraform(struct?: DataSnowflakeTasksTasksParametersTraceLevel): any;
export declare function dataSnowflakeTasksTasksParametersTraceLevelToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTraceLevel): any;
export declare class DataSnowflakeTasksTasksParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTraceLevel | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTraceLevelOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTransactionAbortOnError {
}
export declare function dataSnowflakeTasksTasksParametersTransactionAbortOnErrorToTerraform(struct?: DataSnowflakeTasksTasksParametersTransactionAbortOnError): any;
export declare function dataSnowflakeTasksTasksParametersTransactionAbortOnErrorToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTransactionAbortOnError): any;
export declare class DataSnowflakeTasksTasksParametersTransactionAbortOnErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTransactionAbortOnError | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTransactionAbortOnError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTransactionAbortOnErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTransactionAbortOnErrorOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevel {
}
export declare function dataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevelToTerraform(struct?: DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevel): any;
export declare function dataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevelToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevel): any;
export declare class DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevel | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevelOutputReference;
}
export interface DataSnowflakeTasksTasksParametersTwoDigitCenturyStart {
}
export declare function dataSnowflakeTasksTasksParametersTwoDigitCenturyStartToTerraform(struct?: DataSnowflakeTasksTasksParametersTwoDigitCenturyStart): any;
export declare function dataSnowflakeTasksTasksParametersTwoDigitCenturyStartToHclTerraform(struct?: DataSnowflakeTasksTasksParametersTwoDigitCenturyStart): any;
export declare class DataSnowflakeTasksTasksParametersTwoDigitCenturyStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersTwoDigitCenturyStart | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersTwoDigitCenturyStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersTwoDigitCenturyStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersTwoDigitCenturyStartOutputReference;
}
export interface DataSnowflakeTasksTasksParametersUnsupportedDdlAction {
}
export declare function dataSnowflakeTasksTasksParametersUnsupportedDdlActionToTerraform(struct?: DataSnowflakeTasksTasksParametersUnsupportedDdlAction): any;
export declare function dataSnowflakeTasksTasksParametersUnsupportedDdlActionToHclTerraform(struct?: DataSnowflakeTasksTasksParametersUnsupportedDdlAction): any;
export declare class DataSnowflakeTasksTasksParametersUnsupportedDdlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersUnsupportedDdlAction | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersUnsupportedDdlAction | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersUnsupportedDdlActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersUnsupportedDdlActionOutputReference;
}
export interface DataSnowflakeTasksTasksParametersUseCachedResult {
}
export declare function dataSnowflakeTasksTasksParametersUseCachedResultToTerraform(struct?: DataSnowflakeTasksTasksParametersUseCachedResult): any;
export declare function dataSnowflakeTasksTasksParametersUseCachedResultToHclTerraform(struct?: DataSnowflakeTasksTasksParametersUseCachedResult): any;
export declare class DataSnowflakeTasksTasksParametersUseCachedResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersUseCachedResult | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersUseCachedResult | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersUseCachedResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersUseCachedResultOutputReference;
}
export interface DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSize {
}
export declare function dataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSizeToTerraform(struct?: DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSize): any;
export declare function dataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSizeToHclTerraform(struct?: DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSize): any;
export declare class DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSize | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSizeOutputReference;
}
export interface DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSeconds {
}
export declare function dataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSecondsToTerraform(struct?: DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare function dataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSecondsToHclTerraform(struct?: DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare class DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSeconds | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference;
}
export interface DataSnowflakeTasksTasksParametersUserTaskTimeoutMs {
}
export declare function dataSnowflakeTasksTasksParametersUserTaskTimeoutMsToTerraform(struct?: DataSnowflakeTasksTasksParametersUserTaskTimeoutMs): any;
export declare function dataSnowflakeTasksTasksParametersUserTaskTimeoutMsToHclTerraform(struct?: DataSnowflakeTasksTasksParametersUserTaskTimeoutMs): any;
export declare class DataSnowflakeTasksTasksParametersUserTaskTimeoutMsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersUserTaskTimeoutMs | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersUserTaskTimeoutMs | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersUserTaskTimeoutMsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersUserTaskTimeoutMsOutputReference;
}
export interface DataSnowflakeTasksTasksParametersWeekOfYearPolicy {
}
export declare function dataSnowflakeTasksTasksParametersWeekOfYearPolicyToTerraform(struct?: DataSnowflakeTasksTasksParametersWeekOfYearPolicy): any;
export declare function dataSnowflakeTasksTasksParametersWeekOfYearPolicyToHclTerraform(struct?: DataSnowflakeTasksTasksParametersWeekOfYearPolicy): any;
export declare class DataSnowflakeTasksTasksParametersWeekOfYearPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersWeekOfYearPolicy | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersWeekOfYearPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersWeekOfYearPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersWeekOfYearPolicyOutputReference;
}
export interface DataSnowflakeTasksTasksParametersWeekStart {
}
export declare function dataSnowflakeTasksTasksParametersWeekStartToTerraform(struct?: DataSnowflakeTasksTasksParametersWeekStart): any;
export declare function dataSnowflakeTasksTasksParametersWeekStartToHclTerraform(struct?: DataSnowflakeTasksTasksParametersWeekStart): any;
export declare class DataSnowflakeTasksTasksParametersWeekStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParametersWeekStart | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParametersWeekStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeTasksTasksParametersWeekStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersWeekStartOutputReference;
}
export interface DataSnowflakeTasksTasksParameters {
}
export declare function dataSnowflakeTasksTasksParametersToTerraform(struct?: DataSnowflakeTasksTasksParameters): any;
export declare function dataSnowflakeTasksTasksParametersToHclTerraform(struct?: DataSnowflakeTasksTasksParameters): any;
export declare class DataSnowflakeTasksTasksParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksParameters | undefined;
    set internalValue(value: DataSnowflakeTasksTasksParameters | undefined);
    private _abortDetachedQuery;
    get abortDetachedQuery(): DataSnowflakeTasksTasksParametersAbortDetachedQueryList;
    private _autocommit;
    get autocommit(): DataSnowflakeTasksTasksParametersAutocommitList;
    private _binaryInputFormat;
    get binaryInputFormat(): DataSnowflakeTasksTasksParametersBinaryInputFormatList;
    private _binaryOutputFormat;
    get binaryOutputFormat(): DataSnowflakeTasksTasksParametersBinaryOutputFormatList;
    private _clientMemoryLimit;
    get clientMemoryLimit(): DataSnowflakeTasksTasksParametersClientMemoryLimitList;
    private _clientMetadataRequestUseConnectionCtx;
    get clientMetadataRequestUseConnectionCtx(): DataSnowflakeTasksTasksParametersClientMetadataRequestUseConnectionCtxList;
    private _clientPrefetchThreads;
    get clientPrefetchThreads(): DataSnowflakeTasksTasksParametersClientPrefetchThreadsList;
    private _clientResultChunkSize;
    get clientResultChunkSize(): DataSnowflakeTasksTasksParametersClientResultChunkSizeList;
    private _clientResultColumnCaseInsensitive;
    get clientResultColumnCaseInsensitive(): DataSnowflakeTasksTasksParametersClientResultColumnCaseInsensitiveList;
    private _clientSessionKeepAlive;
    get clientSessionKeepAlive(): DataSnowflakeTasksTasksParametersClientSessionKeepAliveList;
    private _clientSessionKeepAliveHeartbeatFrequency;
    get clientSessionKeepAliveHeartbeatFrequency(): DataSnowflakeTasksTasksParametersClientSessionKeepAliveHeartbeatFrequencyList;
    private _clientTimestampTypeMapping;
    get clientTimestampTypeMapping(): DataSnowflakeTasksTasksParametersClientTimestampTypeMappingList;
    private _dateInputFormat;
    get dateInputFormat(): DataSnowflakeTasksTasksParametersDateInputFormatList;
    private _dateOutputFormat;
    get dateOutputFormat(): DataSnowflakeTasksTasksParametersDateOutputFormatList;
    private _enableUnloadPhysicalTypeOptimization;
    get enableUnloadPhysicalTypeOptimization(): DataSnowflakeTasksTasksParametersEnableUnloadPhysicalTypeOptimizationList;
    private _errorOnNondeterministicMerge;
    get errorOnNondeterministicMerge(): DataSnowflakeTasksTasksParametersErrorOnNondeterministicMergeList;
    private _errorOnNondeterministicUpdate;
    get errorOnNondeterministicUpdate(): DataSnowflakeTasksTasksParametersErrorOnNondeterministicUpdateList;
    private _geographyOutputFormat;
    get geographyOutputFormat(): DataSnowflakeTasksTasksParametersGeographyOutputFormatList;
    private _geometryOutputFormat;
    get geometryOutputFormat(): DataSnowflakeTasksTasksParametersGeometryOutputFormatList;
    private _jdbcTreatTimestampNtzAsUtc;
    get jdbcTreatTimestampNtzAsUtc(): DataSnowflakeTasksTasksParametersJdbcTreatTimestampNtzAsUtcList;
    private _jdbcUseSessionTimezone;
    get jdbcUseSessionTimezone(): DataSnowflakeTasksTasksParametersJdbcUseSessionTimezoneList;
    private _jsonIndent;
    get jsonIndent(): DataSnowflakeTasksTasksParametersJsonIndentList;
    private _lockTimeout;
    get lockTimeout(): DataSnowflakeTasksTasksParametersLockTimeoutList;
    private _logLevel;
    get logLevel(): DataSnowflakeTasksTasksParametersLogLevelList;
    private _multiStatementCount;
    get multiStatementCount(): DataSnowflakeTasksTasksParametersMultiStatementCountList;
    private _noorderSequenceAsDefault;
    get noorderSequenceAsDefault(): DataSnowflakeTasksTasksParametersNoorderSequenceAsDefaultList;
    private _odbcTreatDecimalAsInt;
    get odbcTreatDecimalAsInt(): DataSnowflakeTasksTasksParametersOdbcTreatDecimalAsIntList;
    private _queryTag;
    get queryTag(): DataSnowflakeTasksTasksParametersQueryTagList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): DataSnowflakeTasksTasksParametersQuotedIdentifiersIgnoreCaseList;
    private _rowsPerResultset;
    get rowsPerResultset(): DataSnowflakeTasksTasksParametersRowsPerResultsetList;
    private _s3StageVpceDnsName;
    get s3StageVpceDnsName(): DataSnowflakeTasksTasksParametersS3StageVpceDnsNameList;
    private _searchPath;
    get searchPath(): DataSnowflakeTasksTasksParametersSearchPathList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): DataSnowflakeTasksTasksParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): DataSnowflakeTasksTasksParametersStatementTimeoutInSecondsList;
    private _strictJsonOutput;
    get strictJsonOutput(): DataSnowflakeTasksTasksParametersStrictJsonOutputList;
    private _suspendTaskAfterNumFailures;
    get suspendTaskAfterNumFailures(): DataSnowflakeTasksTasksParametersSuspendTaskAfterNumFailuresList;
    private _taskAutoRetryAttempts;
    get taskAutoRetryAttempts(): DataSnowflakeTasksTasksParametersTaskAutoRetryAttemptsList;
    private _timeInputFormat;
    get timeInputFormat(): DataSnowflakeTasksTasksParametersTimeInputFormatList;
    private _timeOutputFormat;
    get timeOutputFormat(): DataSnowflakeTasksTasksParametersTimeOutputFormatList;
    private _timestampDayIsAlways24H;
    get timestampDayIsAlways24H(): DataSnowflakeTasksTasksParametersTimestampDayIsAlways24HList;
    private _timestampInputFormat;
    get timestampInputFormat(): DataSnowflakeTasksTasksParametersTimestampInputFormatList;
    private _timestampLtzOutputFormat;
    get timestampLtzOutputFormat(): DataSnowflakeTasksTasksParametersTimestampLtzOutputFormatList;
    private _timestampNtzOutputFormat;
    get timestampNtzOutputFormat(): DataSnowflakeTasksTasksParametersTimestampNtzOutputFormatList;
    private _timestampOutputFormat;
    get timestampOutputFormat(): DataSnowflakeTasksTasksParametersTimestampOutputFormatList;
    private _timestampTypeMapping;
    get timestampTypeMapping(): DataSnowflakeTasksTasksParametersTimestampTypeMappingList;
    private _timestampTzOutputFormat;
    get timestampTzOutputFormat(): DataSnowflakeTasksTasksParametersTimestampTzOutputFormatList;
    private _timezone;
    get timezone(): DataSnowflakeTasksTasksParametersTimezoneList;
    private _traceLevel;
    get traceLevel(): DataSnowflakeTasksTasksParametersTraceLevelList;
    private _transactionAbortOnError;
    get transactionAbortOnError(): DataSnowflakeTasksTasksParametersTransactionAbortOnErrorList;
    private _transactionDefaultIsolationLevel;
    get transactionDefaultIsolationLevel(): DataSnowflakeTasksTasksParametersTransactionDefaultIsolationLevelList;
    private _twoDigitCenturyStart;
    get twoDigitCenturyStart(): DataSnowflakeTasksTasksParametersTwoDigitCenturyStartList;
    private _unsupportedDdlAction;
    get unsupportedDdlAction(): DataSnowflakeTasksTasksParametersUnsupportedDdlActionList;
    private _useCachedResult;
    get useCachedResult(): DataSnowflakeTasksTasksParametersUseCachedResultList;
    private _userTaskManagedInitialWarehouseSize;
    get userTaskManagedInitialWarehouseSize(): DataSnowflakeTasksTasksParametersUserTaskManagedInitialWarehouseSizeList;
    private _userTaskMinimumTriggerIntervalInSeconds;
    get userTaskMinimumTriggerIntervalInSeconds(): DataSnowflakeTasksTasksParametersUserTaskMinimumTriggerIntervalInSecondsList;
    private _userTaskTimeoutMs;
    get userTaskTimeoutMs(): DataSnowflakeTasksTasksParametersUserTaskTimeoutMsList;
    private _weekOfYearPolicy;
    get weekOfYearPolicy(): DataSnowflakeTasksTasksParametersWeekOfYearPolicyList;
    private _weekStart;
    get weekStart(): DataSnowflakeTasksTasksParametersWeekStartList;
}
export declare class DataSnowflakeTasksTasksParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksParametersOutputReference;
}
export interface DataSnowflakeTasksTasksShowOutputTaskRelations {
}
export declare function dataSnowflakeTasksTasksShowOutputTaskRelationsToTerraform(struct?: DataSnowflakeTasksTasksShowOutputTaskRelations): any;
export declare function dataSnowflakeTasksTasksShowOutputTaskRelationsToHclTerraform(struct?: DataSnowflakeTasksTasksShowOutputTaskRelations): any;
export declare class DataSnowflakeTasksTasksShowOutputTaskRelationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksShowOutputTaskRelations | undefined;
    set internalValue(value: DataSnowflakeTasksTasksShowOutputTaskRelations | undefined);
    get finalizedRootTask(): string;
    get finalizer(): string;
    get predecessors(): string[];
}
export declare class DataSnowflakeTasksTasksShowOutputTaskRelationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksShowOutputTaskRelationsOutputReference;
}
export interface DataSnowflakeTasksTasksShowOutput {
}
export declare function dataSnowflakeTasksTasksShowOutputToTerraform(struct?: DataSnowflakeTasksTasksShowOutput): any;
export declare function dataSnowflakeTasksTasksShowOutputToHclTerraform(struct?: DataSnowflakeTasksTasksShowOutput): any;
export declare class DataSnowflakeTasksTasksShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasksShowOutput | undefined;
    set internalValue(value: DataSnowflakeTasksTasksShowOutput | undefined);
    get allowOverlappingExecution(): cdktf.IResolvable;
    get budget(): string;
    get comment(): string;
    get condition(): string;
    get config(): string;
    get createdOn(): string;
    get databaseName(): string;
    get definition(): string;
    get errorIntegration(): string;
    get id(): string;
    get lastCommittedOn(): string;
    get lastSuspendedOn(): string;
    get lastSuspendedReason(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get predecessors(): string[];
    get schedule(): string;
    get schemaName(): string;
    get state(): string;
    private _taskRelations;
    get taskRelations(): DataSnowflakeTasksTasksShowOutputTaskRelationsList;
    get warehouse(): string;
}
export declare class DataSnowflakeTasksTasksShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksShowOutputOutputReference;
}
export interface DataSnowflakeTasksTasks {
}
export declare function dataSnowflakeTasksTasksToTerraform(struct?: DataSnowflakeTasksTasks): any;
export declare function dataSnowflakeTasksTasksToHclTerraform(struct?: DataSnowflakeTasksTasks): any;
export declare class DataSnowflakeTasksTasksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasks | undefined;
    set internalValue(value: DataSnowflakeTasksTasks | undefined);
    private _parameters;
    get parameters(): DataSnowflakeTasksTasksParametersList;
    private _showOutput;
    get showOutput(): DataSnowflakeTasksTasksShowOutputList;
}
export declare class DataSnowflakeTasksTasksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksOutputReference;
}
export interface DataSnowflakeTasksIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#account DataSnowflakeTasks#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#application DataSnowflakeTasks#application}
    */
    readonly application?: string;
    /**
    * Returns records for the specified application package.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#application_package DataSnowflakeTasks#application_package}
    */
    readonly applicationPackage?: string;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#database DataSnowflakeTasks#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#schema DataSnowflakeTasks#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeTasksInToTerraform(struct?: DataSnowflakeTasksInOutputReference | DataSnowflakeTasksIn): any;
export declare function dataSnowflakeTasksInToHclTerraform(struct?: DataSnowflakeTasksInOutputReference | DataSnowflakeTasksIn): any;
export declare class DataSnowflakeTasksInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeTasksIn | undefined;
    set internalValue(value: DataSnowflakeTasksIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationPackage?;
    get applicationPackage(): string;
    set applicationPackage(value: string);
    resetApplicationPackage(): void;
    get applicationPackageInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeTasksLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#from DataSnowflakeTasks#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#rows DataSnowflakeTasks#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeTasksLimitToTerraform(struct?: DataSnowflakeTasksLimitOutputReference | DataSnowflakeTasksLimit): any;
export declare function dataSnowflakeTasksLimitToHclTerraform(struct?: DataSnowflakeTasksLimitOutputReference | DataSnowflakeTasksLimit): any;
export declare class DataSnowflakeTasksLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeTasksLimit | undefined;
    set internalValue(value: DataSnowflakeTasksLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks snowflake_tasks}
*/
export declare class DataSnowflakeTasks extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_tasks";
    /**
    * Generates CDKTF code for importing a DataSnowflakeTasks resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeTasks to import
    * @param importFromId The id of the existing DataSnowflakeTasks that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeTasks to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/data-sources/tasks snowflake_tasks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeTasksConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeTasksConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _rootOnly?;
    get rootOnly(): boolean | cdktf.IResolvable;
    set rootOnly(value: boolean | cdktf.IResolvable);
    resetRootOnly(): void;
    get rootOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _tasks;
    get tasks(): DataSnowflakeTasksTasksList;
    private _withParameters?;
    get withParameters(): boolean | cdktf.IResolvable;
    set withParameters(value: boolean | cdktf.IResolvable);
    resetWithParameters(): void;
    get withParametersInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeTasksInOutputReference;
    putIn(value: DataSnowflakeTasksIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeTasksIn | undefined;
    private _limit;
    get limit(): DataSnowflakeTasksLimitOutputReference;
    putLimit(value: DataSnowflakeTasksLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeTasksLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
