/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the database role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#comment DatabaseRole#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the database role. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#database DatabaseRole#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#id DatabaseRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the database role. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#name DatabaseRole#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#timeouts DatabaseRole#timeouts}
    */
    readonly timeouts?: DatabaseRoleTimeouts;
}
export interface DatabaseRoleShowOutput {
}
export declare function databaseRoleShowOutputToTerraform(struct?: DatabaseRoleShowOutput): any;
export declare function databaseRoleShowOutputToHclTerraform(struct?: DatabaseRoleShowOutput): any;
export declare class DatabaseRoleShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseRoleShowOutput | undefined;
    set internalValue(value: DatabaseRoleShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get grantedDatabaseRoles(): number;
    get grantedToDatabaseRoles(): number;
    get grantedToRoles(): number;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get isInherited(): cdktf.IResolvable;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
}
export declare class DatabaseRoleShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseRoleShowOutputOutputReference;
}
export interface DatabaseRoleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#create DatabaseRole#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#delete DatabaseRole#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#read DatabaseRole#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#update DatabaseRole#update}
    */
    readonly update?: string;
}
export declare function databaseRoleTimeoutsToTerraform(struct?: DatabaseRoleTimeouts | cdktf.IResolvable): any;
export declare function databaseRoleTimeoutsToHclTerraform(struct?: DatabaseRoleTimeouts | cdktf.IResolvable): any;
export declare class DatabaseRoleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseRoleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseRoleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role snowflake_database_role}
*/
export declare class DatabaseRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_database_role";
    /**
    * Generates CDKTF code for importing a DatabaseRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatabaseRole to import
    * @param importFromId The id of the existing DatabaseRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatabaseRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database_role snowflake_database_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseRoleConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseRoleConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _showOutput;
    get showOutput(): DatabaseRoleShowOutputList;
    private _timeouts;
    get timeouts(): DatabaseRoleTimeoutsOutputReference;
    putTimeouts(value: DatabaseRoleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatabaseRoleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
