/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#catalog Database#catalog}
    */
    readonly catalog?: string;
    /**
    * Specifies a comment for the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#comment Database#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#data_retention_time_in_days Database#data_retention_time_in_days}
    */
    readonly dataRetentionTimeInDays?: number;
    /**
    * Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#default_ddl_collation Database#default_ddl_collation}
    */
    readonly defaultDdlCollation?: string;
    /**
    * Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#drop_public_schema_on_creation Database#drop_public_schema_on_creation}
    */
    readonly dropPublicSchemaOnCreation?: boolean | cdktf.IResolvable;
    /**
    * If true, enables stdout/stderr fast path logging for anonymous stored procedures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#enable_console_output Database#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#external_volume Database#external_volume}
    */
    readonly externalVolume?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#id Database#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#is_transient Database#is_transient}
    */
    readonly isTransient?: boolean | cdktf.IResolvable;
    /**
    * Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#log_level Database#log_level}
    */
    readonly logLevel?: string;
    /**
    * Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX_DATA_EXTENSION_TIME_IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#max_data_extension_time_in_days Database#max_data_extension_time_in_days}
    */
    readonly maxDataExtensionTimeInDays?: number;
    /**
    * Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '<db>.<schema>.<object>') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#name Database#name}
    */
    readonly name: string;
    /**
    * If true, the case of quoted identifiers is ignored. For more information, see [QUOTED_IDENTIFIERS_IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#quoted_identifiers_ignore_case Database#quoted_identifiers_ignore_case}
    */
    readonly quotedIdentifiersIgnoreCase?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE_INVALID_CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#replace_invalid_characters Database#replace_invalid_characters}
    */
    readonly replaceInvalidCharacters?: boolean | cdktf.IResolvable;
    /**
    * The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE_SERIALIZATION_POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#storage_serialization_policy Database#storage_serialization_policy}
    */
    readonly storageSerializationPolicy?: string;
    /**
    * How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND_TASK_AFTER_NUM_FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#suspend_task_after_num_failures Database#suspend_task_after_num_failures}
    */
    readonly suspendTaskAfterNumFailures?: number;
    /**
    * Maximum automatic retries allowed for a user task. For more information, see [TASK_AUTO_RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#task_auto_retry_attempts Database#task_auto_retry_attempts}
    */
    readonly taskAutoRetryAttempts?: number;
    /**
    * Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#trace_level Database#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER_TASK_MANAGED_INITIAL_WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#user_task_managed_initial_warehouse_size Database#user_task_managed_initial_warehouse_size}
    */
    readonly userTaskManagedInitialWarehouseSize?: string;
    /**
    * Minimum amount of time between Triggered Task executions in seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#user_task_minimum_trigger_interval_in_seconds Database#user_task_minimum_trigger_interval_in_seconds}
    */
    readonly userTaskMinimumTriggerIntervalInSeconds?: number;
    /**
    * User task execution timeout in milliseconds. For more information, see [USER_TASK_TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#user_task_timeout_ms Database#user_task_timeout_ms}
    */
    readonly userTaskTimeoutMs?: number;
    /**
    * replication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#replication Database#replication}
    */
    readonly replication?: DatabaseReplication;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#timeouts Database#timeouts}
    */
    readonly timeouts?: DatabaseTimeouts;
}
export interface DatabaseReplicationEnableToAccount {
    /**
    * Specifies account identifier for which replication should be enabled. The account identifiers should be in the form of `"<organization_name>"."<account_name>"`. For more information about this resource, see [docs](./account).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#account_identifier Database#account_identifier}
    */
    readonly accountIdentifier: string;
    /**
    * Specifies if failover should be enabled for the specified account identifier
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#with_failover Database#with_failover}
    */
    readonly withFailover?: boolean | cdktf.IResolvable;
}
export declare function databaseReplicationEnableToAccountToTerraform(struct?: DatabaseReplicationEnableToAccount | cdktf.IResolvable): any;
export declare function databaseReplicationEnableToAccountToHclTerraform(struct?: DatabaseReplicationEnableToAccount | cdktf.IResolvable): any;
export declare class DatabaseReplicationEnableToAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseReplicationEnableToAccount | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseReplicationEnableToAccount | cdktf.IResolvable | undefined);
    private _accountIdentifier?;
    get accountIdentifier(): string;
    set accountIdentifier(value: string);
    get accountIdentifierInput(): string | undefined;
    private _withFailover?;
    get withFailover(): boolean | cdktf.IResolvable;
    set withFailover(value: boolean | cdktf.IResolvable);
    resetWithFailover(): void;
    get withFailoverInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseReplicationEnableToAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseReplicationEnableToAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseReplicationEnableToAccountOutputReference;
}
export interface DatabaseReplication {
    /**
    * Allows replicating data to accounts on lower editions in either of the following scenarios: 1. The primary database is in a Business Critical (or higher) account but one or more of the accounts approved for replication are on lower editions. Business Critical Edition is intended for Snowflake accounts with extremely sensitive data. 2. The primary database is in a Business Critical (or higher) account and a signed business associate agreement is in place to store PHI data in the account per HIPAA and HITRUST regulations, but no such agreement is in place for one or more of the accounts approved for replication, regardless if they are Business Critical (or higher) accounts. Both scenarios are prohibited by default in an effort to help prevent account administrators for Business Critical (or higher) accounts from inadvertently replicating sensitive data to accounts on lower editions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#ignore_edition_check Database#ignore_edition_check}
    */
    readonly ignoreEditionCheck?: boolean | cdktf.IResolvable;
    /**
    * enable_to_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#enable_to_account Database#enable_to_account}
    */
    readonly enableToAccount: DatabaseReplicationEnableToAccount[] | cdktf.IResolvable;
}
export declare function databaseReplicationToTerraform(struct?: DatabaseReplicationOutputReference | DatabaseReplication): any;
export declare function databaseReplicationToHclTerraform(struct?: DatabaseReplicationOutputReference | DatabaseReplication): any;
export declare class DatabaseReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseReplication | undefined;
    set internalValue(value: DatabaseReplication | undefined);
    private _ignoreEditionCheck?;
    get ignoreEditionCheck(): boolean | cdktf.IResolvable;
    set ignoreEditionCheck(value: boolean | cdktf.IResolvable);
    resetIgnoreEditionCheck(): void;
    get ignoreEditionCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _enableToAccount;
    get enableToAccount(): DatabaseReplicationEnableToAccountList;
    putEnableToAccount(value: DatabaseReplicationEnableToAccount[] | cdktf.IResolvable): void;
    get enableToAccountInput(): cdktf.IResolvable | DatabaseReplicationEnableToAccount[] | undefined;
}
export interface DatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#create Database#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#delete Database#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#read Database#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#update Database#update}
    */
    readonly update?: string;
}
export declare function databaseTimeoutsToTerraform(struct?: DatabaseTimeouts | cdktf.IResolvable): any;
export declare function databaseTimeoutsToHclTerraform(struct?: DatabaseTimeouts | cdktf.IResolvable): any;
export declare class DatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database snowflake_database}
*/
export declare class Database extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_database";
    /**
    * Generates CDKTF code for importing a Database resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Database to import
    * @param importFromId The id of the existing Database that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Database to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/database snowflake_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseConfig);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionTimeInDays?;
    get dataRetentionTimeInDays(): number;
    set dataRetentionTimeInDays(value: number);
    resetDataRetentionTimeInDays(): void;
    get dataRetentionTimeInDaysInput(): number | undefined;
    private _defaultDdlCollation?;
    get defaultDdlCollation(): string;
    set defaultDdlCollation(value: string);
    resetDefaultDdlCollation(): void;
    get defaultDdlCollationInput(): string | undefined;
    private _dropPublicSchemaOnCreation?;
    get dropPublicSchemaOnCreation(): boolean | cdktf.IResolvable;
    set dropPublicSchemaOnCreation(value: boolean | cdktf.IResolvable);
    resetDropPublicSchemaOnCreation(): void;
    get dropPublicSchemaOnCreationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _externalVolume?;
    get externalVolume(): string;
    set externalVolume(value: string);
    resetExternalVolume(): void;
    get externalVolumeInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isTransient?;
    get isTransient(): boolean | cdktf.IResolvable;
    set isTransient(value: boolean | cdktf.IResolvable);
    resetIsTransient(): void;
    get isTransientInput(): boolean | cdktf.IResolvable | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _maxDataExtensionTimeInDays?;
    get maxDataExtensionTimeInDays(): number;
    set maxDataExtensionTimeInDays(value: number);
    resetMaxDataExtensionTimeInDays(): void;
    get maxDataExtensionTimeInDaysInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _quotedIdentifiersIgnoreCase?;
    get quotedIdentifiersIgnoreCase(): boolean | cdktf.IResolvable;
    set quotedIdentifiersIgnoreCase(value: boolean | cdktf.IResolvable);
    resetQuotedIdentifiersIgnoreCase(): void;
    get quotedIdentifiersIgnoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _replaceInvalidCharacters?;
    get replaceInvalidCharacters(): boolean | cdktf.IResolvable;
    set replaceInvalidCharacters(value: boolean | cdktf.IResolvable);
    resetReplaceInvalidCharacters(): void;
    get replaceInvalidCharactersInput(): boolean | cdktf.IResolvable | undefined;
    private _storageSerializationPolicy?;
    get storageSerializationPolicy(): string;
    set storageSerializationPolicy(value: string);
    resetStorageSerializationPolicy(): void;
    get storageSerializationPolicyInput(): string | undefined;
    private _suspendTaskAfterNumFailures?;
    get suspendTaskAfterNumFailures(): number;
    set suspendTaskAfterNumFailures(value: number);
    resetSuspendTaskAfterNumFailures(): void;
    get suspendTaskAfterNumFailuresInput(): number | undefined;
    private _taskAutoRetryAttempts?;
    get taskAutoRetryAttempts(): number;
    set taskAutoRetryAttempts(value: number);
    resetTaskAutoRetryAttempts(): void;
    get taskAutoRetryAttemptsInput(): number | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _userTaskManagedInitialWarehouseSize?;
    get userTaskManagedInitialWarehouseSize(): string;
    set userTaskManagedInitialWarehouseSize(value: string);
    resetUserTaskManagedInitialWarehouseSize(): void;
    get userTaskManagedInitialWarehouseSizeInput(): string | undefined;
    private _userTaskMinimumTriggerIntervalInSeconds?;
    get userTaskMinimumTriggerIntervalInSeconds(): number;
    set userTaskMinimumTriggerIntervalInSeconds(value: number);
    resetUserTaskMinimumTriggerIntervalInSeconds(): void;
    get userTaskMinimumTriggerIntervalInSecondsInput(): number | undefined;
    private _userTaskTimeoutMs?;
    get userTaskTimeoutMs(): number;
    set userTaskTimeoutMs(value: number);
    resetUserTaskTimeoutMs(): void;
    get userTaskTimeoutMsInput(): number | undefined;
    private _replication;
    get replication(): DatabaseReplicationOutputReference;
    putReplication(value: DatabaseReplication): void;
    resetReplication(): void;
    get replicationInput(): DatabaseReplication | undefined;
    private _timeouts;
    get timeouts(): DatabaseTimeoutsOutputReference;
    putTimeouts(value: DatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
