/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EmailNotificationIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of email addresses that should receive notifications.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#allowed_recipients EmailNotificationIntegration#allowed_recipients}
    */
    readonly allowedRecipients?: string[];
    /**
    * A comment for the email integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#comment EmailNotificationIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#enabled EmailNotificationIntegration#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#id EmailNotificationIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#name EmailNotificationIntegration#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#timeouts EmailNotificationIntegration#timeouts}
    */
    readonly timeouts?: EmailNotificationIntegrationTimeouts;
}
export interface EmailNotificationIntegrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#create EmailNotificationIntegration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#delete EmailNotificationIntegration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#read EmailNotificationIntegration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#update EmailNotificationIntegration#update}
    */
    readonly update?: string;
}
export declare function emailNotificationIntegrationTimeoutsToTerraform(struct?: EmailNotificationIntegrationTimeouts | cdktf.IResolvable): any;
export declare function emailNotificationIntegrationTimeoutsToHclTerraform(struct?: EmailNotificationIntegrationTimeouts | cdktf.IResolvable): any;
export declare class EmailNotificationIntegrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EmailNotificationIntegrationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EmailNotificationIntegrationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration snowflake_email_notification_integration}
*/
export declare class EmailNotificationIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_email_notification_integration";
    /**
    * Generates CDKTF code for importing a EmailNotificationIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EmailNotificationIntegration to import
    * @param importFromId The id of the existing EmailNotificationIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EmailNotificationIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/email_notification_integration snowflake_email_notification_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EmailNotificationIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: EmailNotificationIntegrationConfig);
    private _allowedRecipients?;
    get allowedRecipients(): string[];
    set allowedRecipients(value: string[]);
    resetAllowedRecipients(): void;
    get allowedRecipientsInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): EmailNotificationIntegrationTimeoutsOutputReference;
    putTimeouts(value: EmailNotificationIntegrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EmailNotificationIntegrationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
