/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GitRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier of API INTEGRATION containing information about the remote Git repository such as allowed credentials and prefixes for target URLs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#api_integration GitRepository#api_integration}
    */
    readonly apiIntegration: string;
    /**
    * Specifies a comment for the git repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#comment GitRepository#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the git repository. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#database GitRepository#database}
    */
    readonly database: string;
    /**
    * Specifies the Snowflake secret fully qualified name (e.g `"\"<db_name>\".\"<schema_name>\".\"<secret_name>\""`) containing the credentials to use for authenticating with the remote Git repository. Omit this parameter to use the default secret specified by the API integration or if this integration does not require authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#git_credentials GitRepository#git_credentials}
    */
    readonly gitCredentials?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#id GitRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the git repository; must be unique for the schema in which the git repository is created. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#name GitRepository#name}
    */
    readonly name: string;
    /**
    * Specifies the origin URL of the remote Git repository that this Git repository clone represents. The URL must use HTTPS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#origin GitRepository#origin}
    */
    readonly origin: string;
    /**
    * The schema in which to create the git repository. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#schema GitRepository#schema}
    */
    readonly schema: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#timeouts GitRepository#timeouts}
    */
    readonly timeouts?: GitRepositoryTimeouts;
}
export interface GitRepositoryDescribeOutput {
}
export declare function gitRepositoryDescribeOutputToTerraform(struct?: GitRepositoryDescribeOutput): any;
export declare function gitRepositoryDescribeOutputToHclTerraform(struct?: GitRepositoryDescribeOutput): any;
export declare class GitRepositoryDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GitRepositoryDescribeOutput | undefined;
    set internalValue(value: GitRepositoryDescribeOutput | undefined);
    get apiIntegration(): string;
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get gitCredentials(): string;
    get lastFetchedAt(): string;
    get name(): string;
    get origin(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class GitRepositoryDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GitRepositoryDescribeOutputOutputReference;
}
export interface GitRepositoryShowOutput {
}
export declare function gitRepositoryShowOutputToTerraform(struct?: GitRepositoryShowOutput): any;
export declare function gitRepositoryShowOutputToHclTerraform(struct?: GitRepositoryShowOutput): any;
export declare class GitRepositoryShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GitRepositoryShowOutput | undefined;
    set internalValue(value: GitRepositoryShowOutput | undefined);
    get apiIntegration(): string;
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get gitCredentials(): string;
    get lastFetchedAt(): string;
    get name(): string;
    get origin(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class GitRepositoryShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GitRepositoryShowOutputOutputReference;
}
export interface GitRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#create GitRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#delete GitRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#read GitRepository#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#update GitRepository#update}
    */
    readonly update?: string;
}
export declare function gitRepositoryTimeoutsToTerraform(struct?: GitRepositoryTimeouts | cdktf.IResolvable): any;
export declare function gitRepositoryTimeoutsToHclTerraform(struct?: GitRepositoryTimeouts | cdktf.IResolvable): any;
export declare class GitRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GitRepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GitRepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository snowflake_git_repository}
*/
export declare class GitRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_git_repository";
    /**
    * Generates CDKTF code for importing a GitRepository resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GitRepository to import
    * @param importFromId The id of the existing GitRepository that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GitRepository to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/git_repository snowflake_git_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GitRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: GitRepositoryConfig);
    private _apiIntegration?;
    get apiIntegration(): string;
    set apiIntegration(value: string);
    get apiIntegrationInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): GitRepositoryDescribeOutputList;
    get fullyQualifiedName(): string;
    private _gitCredentials?;
    get gitCredentials(): string;
    set gitCredentials(value: string);
    resetGitCredentials(): void;
    get gitCredentialsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _origin?;
    get origin(): string;
    set origin(value: string);
    get originInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): GitRepositoryShowOutputList;
    private _timeouts;
    get timeouts(): GitRepositoryTimeoutsOutputReference;
    putTimeouts(value: GitRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GitRepositoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
