/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantAccountRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#id GrantAccountRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see [docs](./account_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#parent_role_name GrantAccountRole#parent_role_name}
    */
    readonly parentRoleName?: string;
    /**
    * The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see [docs](./account_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#role_name GrantAccountRole#role_name}
    */
    readonly roleName: string;
    /**
    * The fully qualified name of the user on which specified role will be granted. For more information about this resource, see [docs](./user).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#user_name GrantAccountRole#user_name}
    */
    readonly userName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#timeouts GrantAccountRole#timeouts}
    */
    readonly timeouts?: GrantAccountRoleTimeouts;
}
export interface GrantAccountRoleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#create GrantAccountRole#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#delete GrantAccountRole#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#read GrantAccountRole#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#update GrantAccountRole#update}
    */
    readonly update?: string;
}
export declare function grantAccountRoleTimeoutsToTerraform(struct?: GrantAccountRoleTimeouts | cdktf.IResolvable): any;
export declare function grantAccountRoleTimeoutsToHclTerraform(struct?: GrantAccountRoleTimeouts | cdktf.IResolvable): any;
export declare class GrantAccountRoleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantAccountRoleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GrantAccountRoleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role snowflake_grant_account_role}
*/
export declare class GrantAccountRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_account_role";
    /**
    * Generates CDKTF code for importing a GrantAccountRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantAccountRole to import
    * @param importFromId The id of the existing GrantAccountRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantAccountRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_account_role snowflake_grant_account_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantAccountRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantAccountRoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _parentRoleName?;
    get parentRoleName(): string;
    set parentRoleName(value: string);
    resetParentRoleName(): void;
    get parentRoleNameInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): GrantAccountRoleTimeoutsOutputReference;
    putTimeouts(value: GrantAccountRoleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GrantAccountRoleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
