/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantApplicationRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The fully qualified name of the application on which application role will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#application_name GrantApplicationRole#application_name}
    */
    readonly applicationName?: string;
    /**
    * Specifies the identifier for the application role to grant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#application_role_name GrantApplicationRole#application_role_name}
    */
    readonly applicationRoleName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#id GrantApplicationRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The fully qualified name of the account role on which application role will be granted. For more information about this resource, see [docs](./account_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#parent_account_role_name GrantApplicationRole#parent_account_role_name}
    */
    readonly parentAccountRoleName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#timeouts GrantApplicationRole#timeouts}
    */
    readonly timeouts?: GrantApplicationRoleTimeouts;
}
export interface GrantApplicationRoleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#create GrantApplicationRole#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#delete GrantApplicationRole#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#read GrantApplicationRole#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#update GrantApplicationRole#update}
    */
    readonly update?: string;
}
export declare function grantApplicationRoleTimeoutsToTerraform(struct?: GrantApplicationRoleTimeouts | cdktf.IResolvable): any;
export declare function grantApplicationRoleTimeoutsToHclTerraform(struct?: GrantApplicationRoleTimeouts | cdktf.IResolvable): any;
export declare class GrantApplicationRoleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantApplicationRoleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GrantApplicationRoleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role snowflake_grant_application_role}
*/
export declare class GrantApplicationRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_application_role";
    /**
    * Generates CDKTF code for importing a GrantApplicationRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantApplicationRole to import
    * @param importFromId The id of the existing GrantApplicationRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantApplicationRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_application_role snowflake_grant_application_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantApplicationRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantApplicationRoleConfig);
    private _applicationName?;
    get applicationName(): string;
    set applicationName(value: string);
    resetApplicationName(): void;
    get applicationNameInput(): string | undefined;
    private _applicationRoleName?;
    get applicationRoleName(): string;
    set applicationRoleName(value: string);
    get applicationRoleNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _parentAccountRoleName?;
    get parentAccountRoleName(): string;
    set parentAccountRoleName(value: string);
    resetParentAccountRoleName(): void;
    get parentAccountRoleNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): GrantApplicationRoleTimeoutsOutputReference;
    putTimeouts(value: GrantApplicationRoleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GrantApplicationRoleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
