/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantOwnershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * The fully qualified name of the account role to which privileges will be granted. For more information about this resource, see [docs](./account_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#account_role_name GrantOwnership#account_role_name}
    */
    readonly accountRoleName?: string;
    /**
    * The fully qualified name of the database role to which privileges will be granted. For more information about this resource, see [docs](./database_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#database_role_name GrantOwnership#database_role_name}
    */
    readonly databaseRoleName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#id GrantOwnership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies whether to remove or transfer all existing outbound privileges on the object when ownership is transferred to a new role. Available options are: REVOKE for removing existing privileges and COPY to transfer them with ownership. For more information head over to [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/grant-ownership#optional-parameters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#outbound_privileges GrantOwnership#outbound_privileges}
    */
    readonly outboundPrivileges?: string;
    /**
    * on block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#on GrantOwnership#on}
    */
    readonly on: GrantOwnershipOn;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#timeouts GrantOwnership#timeouts}
    */
    readonly timeouts?: GrantOwnershipTimeouts;
}
export interface GrantOwnershipOnAll {
    /**
    * The fully qualified name of the database. For more information about this resource, see [docs](./database).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#in_database GrantOwnership#in_database}
    */
    readonly inDatabase?: string;
    /**
    * The fully qualified name of the schema. For more information about this resource, see [docs](./schema).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#in_schema GrantOwnership#in_schema}
    */
    readonly inSchema?: string;
    /**
    * Specifies the type of object in plural form on which you are transferring ownership. Available values are: AGGREGATION POLICIES | ALERTS | AUTHENTICATION POLICIES | COMPUTE POOLS | DATA METRIC FUNCTIONS | DATABASES | DATABASE ROLES | DYNAMIC TABLES | EVENT TABLES | EXTERNAL TABLES | EXTERNAL VOLUMES | FAILOVER GROUPS | FILE FORMATS | FUNCTIONS | GIT REPOSITORIES | HYBRID TABLES | ICEBERG TABLES | IMAGE REPOSITORIES | INTEGRATIONS | MATERIALIZED VIEWS | NETWORK POLICIES | NETWORK RULES | PACKAGES POLICIES | PIPES | PROCEDURES | MASKING POLICIES | PASSWORD POLICIES | PROJECTION POLICIES | REPLICATION GROUPS | RESOURCE MONITORS | ROLES | ROW ACCESS POLICIES | SCHEMAS | SESSION POLICIES | SECRETS | SEQUENCES | STAGES | STREAMS | TABLES | TAGS | TASKS | USERS | VIEWS | WAREHOUSES. For more information head over to [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/grant-ownership#required-parameters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#object_type_plural GrantOwnership#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantOwnershipOnAllToTerraform(struct?: GrantOwnershipOnAllOutputReference | GrantOwnershipOnAll): any;
export declare function grantOwnershipOnAllToHclTerraform(struct?: GrantOwnershipOnAllOutputReference | GrantOwnershipOnAll): any;
export declare class GrantOwnershipOnAllOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantOwnershipOnAll | undefined;
    set internalValue(value: GrantOwnershipOnAll | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantOwnershipOnFuture {
    /**
    * The fully qualified name of the database. For more information about this resource, see [docs](./database).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#in_database GrantOwnership#in_database}
    */
    readonly inDatabase?: string;
    /**
    * The fully qualified name of the schema. For more information about this resource, see [docs](./schema).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#in_schema GrantOwnership#in_schema}
    */
    readonly inSchema?: string;
    /**
    * Specifies the type of object in plural form on which you are transferring ownership. Available values are: AGGREGATION POLICIES | ALERTS | AUTHENTICATION POLICIES | COMPUTE POOLS | DATA METRIC FUNCTIONS | DATABASES | DATABASE ROLES | DYNAMIC TABLES | EVENT TABLES | EXTERNAL TABLES | EXTERNAL VOLUMES | FAILOVER GROUPS | FILE FORMATS | FUNCTIONS | GIT REPOSITORIES | HYBRID TABLES | ICEBERG TABLES | IMAGE REPOSITORIES | INTEGRATIONS | MATERIALIZED VIEWS | NETWORK POLICIES | NETWORK RULES | PACKAGES POLICIES | PIPES | PROCEDURES | MASKING POLICIES | PASSWORD POLICIES | PROJECTION POLICIES | REPLICATION GROUPS | RESOURCE MONITORS | ROLES | ROW ACCESS POLICIES | SCHEMAS | SESSION POLICIES | SECRETS | SEQUENCES | STAGES | STREAMS | TABLES | TAGS | TASKS | USERS | VIEWS | WAREHOUSES. For more information head over to [Snowflake documentation](https://docs.snowflake.com/en/sql-reference/sql/grant-ownership#required-parameters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#object_type_plural GrantOwnership#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantOwnershipOnFutureToTerraform(struct?: GrantOwnershipOnFutureOutputReference | GrantOwnershipOnFuture): any;
export declare function grantOwnershipOnFutureToHclTerraform(struct?: GrantOwnershipOnFutureOutputReference | GrantOwnershipOnFuture): any;
export declare class GrantOwnershipOnFutureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantOwnershipOnFuture | undefined;
    set internalValue(value: GrantOwnershipOnFuture | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantOwnershipOn {
    /**
    * Specifies the identifier for the object on which you are transferring ownership.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#object_name GrantOwnership#object_name}
    */
    readonly objectName?: string;
    /**
    * Specifies the type of object on which you are transferring ownership. Available values are: AGGREGATION POLICY | ALERT | AUTHENTICATION POLICY | COMPUTE POOL | DATA METRIC FUNCTION | DATABASE | DATABASE ROLE | DYNAMIC TABLE | EVENT TABLE | EXTERNAL TABLE | EXTERNAL VOLUME | FAILOVER GROUP | FILE FORMAT | FUNCTION | GIT REPOSITORY | HYBRID TABLE | ICEBERG TABLE | IMAGE REPOSITORY | INTEGRATION | MATERIALIZED VIEW | NETWORK POLICY | NETWORK RULE | PACKAGES POLICY | PIPE | PROCEDURE | MASKING POLICY | PASSWORD POLICY | PROJECTION POLICY | REPLICATION GROUP | RESOURCE MONITOR | ROLE | ROW ACCESS POLICY | SCHEMA | SESSION POLICY | SECRET | SEQUENCE | STAGE | STREAM | TABLE | TAG | TASK | USER | VIEW | WAREHOUSE
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#object_type GrantOwnership#object_type}
    */
    readonly objectType?: string;
    /**
    * all block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#all GrantOwnership#all}
    */
    readonly all?: GrantOwnershipOnAll;
    /**
    * future block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#future GrantOwnership#future}
    */
    readonly future?: GrantOwnershipOnFuture;
}
export declare function grantOwnershipOnToTerraform(struct?: GrantOwnershipOnOutputReference | GrantOwnershipOn): any;
export declare function grantOwnershipOnToHclTerraform(struct?: GrantOwnershipOnOutputReference | GrantOwnershipOn): any;
export declare class GrantOwnershipOnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantOwnershipOn | undefined;
    set internalValue(value: GrantOwnershipOn | undefined);
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    resetObjectName(): void;
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    private _all;
    get all(): GrantOwnershipOnAllOutputReference;
    putAll(value: GrantOwnershipOnAll): void;
    resetAll(): void;
    get allInput(): GrantOwnershipOnAll | undefined;
    private _future;
    get future(): GrantOwnershipOnFutureOutputReference;
    putFuture(value: GrantOwnershipOnFuture): void;
    resetFuture(): void;
    get futureInput(): GrantOwnershipOnFuture | undefined;
}
export interface GrantOwnershipTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#create GrantOwnership#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#delete GrantOwnership#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#read GrantOwnership#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#update GrantOwnership#update}
    */
    readonly update?: string;
}
export declare function grantOwnershipTimeoutsToTerraform(struct?: GrantOwnershipTimeouts | cdktf.IResolvable): any;
export declare function grantOwnershipTimeoutsToHclTerraform(struct?: GrantOwnershipTimeouts | cdktf.IResolvable): any;
export declare class GrantOwnershipTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantOwnershipTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GrantOwnershipTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership snowflake_grant_ownership}
*/
export declare class GrantOwnership extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_ownership";
    /**
    * Generates CDKTF code for importing a GrantOwnership resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantOwnership to import
    * @param importFromId The id of the existing GrantOwnership that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantOwnership to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_ownership snowflake_grant_ownership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantOwnershipConfig
    */
    constructor(scope: Construct, id: string, config: GrantOwnershipConfig);
    private _accountRoleName?;
    get accountRoleName(): string;
    set accountRoleName(value: string);
    resetAccountRoleName(): void;
    get accountRoleNameInput(): string | undefined;
    private _databaseRoleName?;
    get databaseRoleName(): string;
    set databaseRoleName(value: string);
    resetDatabaseRoleName(): void;
    get databaseRoleNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _outboundPrivileges?;
    get outboundPrivileges(): string;
    set outboundPrivileges(value: string);
    resetOutboundPrivileges(): void;
    get outboundPrivilegesInput(): string | undefined;
    private _on;
    get on(): GrantOwnershipOnOutputReference;
    putOn(value: GrantOwnershipOn): void;
    get onInput(): GrantOwnershipOn | undefined;
    private _timeouts;
    get timeouts(): GrantOwnershipTimeoutsOutputReference;
    putTimeouts(value: GrantOwnershipTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GrantOwnershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
