/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantPrivilegesToDatabaseRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Default: `false`) Grant all privileges on the database role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#all_privileges GrantPrivilegesToDatabaseRole#all_privileges}
    */
    readonly allPrivileges?: boolean | cdktf.IResolvable;
    /**
    * (Default: `false`) If true, the resource will always produce a “plan” and on “apply” it will re-grant defined privileges. It is supposed to be used only in “grant privileges on all X’s in database / schema Y” or “grant all privileges to X” scenarios to make sure that every new object in a given database / schema is granted by the account role and every new privilege is granted to the database role. Important note: this flag is not compliant with the Terraform assumptions of the config being eventually convergent (producing an empty plan).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#always_apply GrantPrivilegesToDatabaseRole#always_apply}
    */
    readonly alwaysApply?: boolean | cdktf.IResolvable;
    /**
    * (Default: ``) This is a helper field and should not be set. Its main purpose is to help to achieve the functionality described by the always_apply field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#always_apply_trigger GrantPrivilegesToDatabaseRole#always_apply_trigger}
    */
    readonly alwaysApplyTrigger?: string;
    /**
    * The fully qualified name of the database role to which privileges will be granted. For more information about this resource, see [docs](./database_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#database_role_name GrantPrivilegesToDatabaseRole#database_role_name}
    */
    readonly databaseRoleName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#id GrantPrivilegesToDatabaseRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The fully qualified name of the database on which privileges will be granted. For more information about this resource, see [docs](./database).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#on_database GrantPrivilegesToDatabaseRole#on_database}
    */
    readonly onDatabase?: string;
    /**
    * The privileges to grant on the database role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#privileges GrantPrivilegesToDatabaseRole#privileges}
    */
    readonly privileges?: string[];
    /**
    * (Default: `false`) If specified, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#with_grant_option GrantPrivilegesToDatabaseRole#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
    /**
    * on_schema block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#on_schema GrantPrivilegesToDatabaseRole#on_schema}
    */
    readonly onSchema?: GrantPrivilegesToDatabaseRoleOnSchema;
    /**
    * on_schema_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#on_schema_object GrantPrivilegesToDatabaseRole#on_schema_object}
    */
    readonly onSchemaObject?: GrantPrivilegesToDatabaseRoleOnSchemaObject;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#timeouts GrantPrivilegesToDatabaseRole#timeouts}
    */
    readonly timeouts?: GrantPrivilegesToDatabaseRoleTimeouts;
}
export interface GrantPrivilegesToDatabaseRoleOnSchema {
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#all_schemas_in_database GrantPrivilegesToDatabaseRole#all_schemas_in_database}
    */
    readonly allSchemasInDatabase?: string;
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#future_schemas_in_database GrantPrivilegesToDatabaseRole#future_schemas_in_database}
    */
    readonly futureSchemasInDatabase?: string;
    /**
    * The fully qualified name of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#schema_name GrantPrivilegesToDatabaseRole#schema_name}
    */
    readonly schemaName?: string;
}
export declare function grantPrivilegesToDatabaseRoleOnSchemaToTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaOutputReference | GrantPrivilegesToDatabaseRoleOnSchema): any;
export declare function grantPrivilegesToDatabaseRoleOnSchemaToHclTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaOutputReference | GrantPrivilegesToDatabaseRoleOnSchema): any;
export declare class GrantPrivilegesToDatabaseRoleOnSchemaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToDatabaseRoleOnSchema | undefined;
    set internalValue(value: GrantPrivilegesToDatabaseRoleOnSchema | undefined);
    private _allSchemasInDatabase?;
    get allSchemasInDatabase(): string;
    set allSchemasInDatabase(value: string);
    resetAllSchemasInDatabase(): void;
    get allSchemasInDatabaseInput(): string | undefined;
    private _futureSchemasInDatabase?;
    get futureSchemasInDatabase(): string;
    set futureSchemasInDatabase(value: string);
    resetFutureSchemasInDatabase(): void;
    get futureSchemasInDatabaseInput(): string | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    resetSchemaName(): void;
    get schemaNameInput(): string | undefined;
}
export interface GrantPrivilegesToDatabaseRoleOnSchemaObjectAll {
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#in_database GrantPrivilegesToDatabaseRole#in_database}
    */
    readonly inDatabase?: string;
    /**
    * The fully qualified name of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#in_schema GrantPrivilegesToDatabaseRole#in_schema}
    */
    readonly inSchema?: string;
    /**
    * The plural object type of the schema object on which privileges will be granted. Valid values are: AGGREGATION POLICIES | ALERTS | AUTHENTICATION POLICIES | CORTEX SEARCH SERVICES | DATA METRIC FUNCTIONS | DYNAMIC TABLES | EVENT TABLES | EXTERNAL TABLES | FILE FORMATS | FUNCTIONS | GIT REPOSITORIES | HYBRID TABLES | IMAGE REPOSITORIES | ICEBERG TABLES | MASKING POLICIES | MATERIALIZED VIEWS | MODELS | NETWORK RULES | NOTEBOOKS | PACKAGES POLICIES | PASSWORD POLICIES | PIPES | PROCEDURES | PROJECTION POLICIES | ROW ACCESS POLICIES | SECRETS | SERVICES | SESSION POLICIES | SEQUENCES | SNAPSHOTS | STAGES | STREAMS | TABLES | TAGS | TASKS | VIEWS | STREAMLITS | DATASETS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#object_type_plural GrantPrivilegesToDatabaseRole#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantPrivilegesToDatabaseRoleOnSchemaObjectAllToTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference | GrantPrivilegesToDatabaseRoleOnSchemaObjectAll): any;
export declare function grantPrivilegesToDatabaseRoleOnSchemaObjectAllToHclTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference | GrantPrivilegesToDatabaseRoleOnSchemaObjectAll): any;
export declare class GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToDatabaseRoleOnSchemaObjectAll | undefined;
    set internalValue(value: GrantPrivilegesToDatabaseRoleOnSchemaObjectAll | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture {
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#in_database GrantPrivilegesToDatabaseRole#in_database}
    */
    readonly inDatabase?: string;
    /**
    * The fully qualified name of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#in_schema GrantPrivilegesToDatabaseRole#in_schema}
    */
    readonly inSchema?: string;
    /**
    * The plural object type of the schema object on which privileges will be granted. Valid values are: ALERTS | AUTHENTICATION POLICIES | CORTEX SEARCH SERVICES | DATA METRIC FUNCTIONS | DYNAMIC TABLES | EVENT TABLES | EXTERNAL TABLES | FILE FORMATS | FUNCTIONS | GIT REPOSITORIES | HYBRID TABLES | ICEBERG TABLES | MATERIALIZED VIEWS | MODELS | NETWORK RULES | NOTEBOOKS | PASSWORD POLICIES | PIPES | PROCEDURES | SECRETS | SERVICES | SEQUENCES | SNAPSHOTS | STAGES | STREAMS | TABLES | TASKS | VIEWS | STREAMLITS | DATASETS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#object_type_plural GrantPrivilegesToDatabaseRole#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference | GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture): any;
export declare function grantPrivilegesToDatabaseRoleOnSchemaObjectFutureToHclTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference | GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture): any;
export declare class GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture | undefined;
    set internalValue(value: GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantPrivilegesToDatabaseRoleOnSchemaObject {
    /**
    * The fully qualified name of the object on which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#object_name GrantPrivilegesToDatabaseRole#object_name}
    */
    readonly objectName?: string;
    /**
    * The object type of the schema object on which privileges will be granted. Valid values are: AGGREGATION POLICY | ALERT | AUTHENTICATION POLICY | CORTEX SEARCH SERVICE | DATA METRIC FUNCTION | DYNAMIC TABLE | EVENT TABLE | EXTERNAL TABLE | FILE FORMAT | FUNCTION | GIT REPOSITORY | HYBRID TABLE | IMAGE REPOSITORY | ICEBERG TABLE | MASKING POLICY | MATERIALIZED VIEW | MODEL | NETWORK RULE | NOTEBOOK | PACKAGES POLICY | PASSWORD POLICY | PIPE | PROCEDURE | PROJECTION POLICY | ROW ACCESS POLICY | SECRET | SERVICE | SESSION POLICY | SEQUENCE | SNAPSHOT | STAGE | STREAM | TABLE | TAG | TASK | VIEW | STREAMLIT | DATASET
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#object_type GrantPrivilegesToDatabaseRole#object_type}
    */
    readonly objectType?: string;
    /**
    * all block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#all GrantPrivilegesToDatabaseRole#all}
    */
    readonly all?: GrantPrivilegesToDatabaseRoleOnSchemaObjectAll;
    /**
    * future block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#future GrantPrivilegesToDatabaseRole#future}
    */
    readonly future?: GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture;
}
export declare function grantPrivilegesToDatabaseRoleOnSchemaObjectToTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference | GrantPrivilegesToDatabaseRoleOnSchemaObject): any;
export declare function grantPrivilegesToDatabaseRoleOnSchemaObjectToHclTerraform(struct?: GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference | GrantPrivilegesToDatabaseRoleOnSchemaObject): any;
export declare class GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToDatabaseRoleOnSchemaObject | undefined;
    set internalValue(value: GrantPrivilegesToDatabaseRoleOnSchemaObject | undefined);
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    resetObjectName(): void;
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    private _all;
    get all(): GrantPrivilegesToDatabaseRoleOnSchemaObjectAllOutputReference;
    putAll(value: GrantPrivilegesToDatabaseRoleOnSchemaObjectAll): void;
    resetAll(): void;
    get allInput(): GrantPrivilegesToDatabaseRoleOnSchemaObjectAll | undefined;
    private _future;
    get future(): GrantPrivilegesToDatabaseRoleOnSchemaObjectFutureOutputReference;
    putFuture(value: GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture): void;
    resetFuture(): void;
    get futureInput(): GrantPrivilegesToDatabaseRoleOnSchemaObjectFuture | undefined;
}
export interface GrantPrivilegesToDatabaseRoleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#create GrantPrivilegesToDatabaseRole#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#delete GrantPrivilegesToDatabaseRole#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#read GrantPrivilegesToDatabaseRole#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#update GrantPrivilegesToDatabaseRole#update}
    */
    readonly update?: string;
}
export declare function grantPrivilegesToDatabaseRoleTimeoutsToTerraform(struct?: GrantPrivilegesToDatabaseRoleTimeouts | cdktf.IResolvable): any;
export declare function grantPrivilegesToDatabaseRoleTimeoutsToHclTerraform(struct?: GrantPrivilegesToDatabaseRoleTimeouts | cdktf.IResolvable): any;
export declare class GrantPrivilegesToDatabaseRoleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToDatabaseRoleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GrantPrivilegesToDatabaseRoleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role snowflake_grant_privileges_to_database_role}
*/
export declare class GrantPrivilegesToDatabaseRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_privileges_to_database_role";
    /**
    * Generates CDKTF code for importing a GrantPrivilegesToDatabaseRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantPrivilegesToDatabaseRole to import
    * @param importFromId The id of the existing GrantPrivilegesToDatabaseRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantPrivilegesToDatabaseRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_database_role snowflake_grant_privileges_to_database_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantPrivilegesToDatabaseRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantPrivilegesToDatabaseRoleConfig);
    private _allPrivileges?;
    get allPrivileges(): boolean | cdktf.IResolvable;
    set allPrivileges(value: boolean | cdktf.IResolvable);
    resetAllPrivileges(): void;
    get allPrivilegesInput(): boolean | cdktf.IResolvable | undefined;
    private _alwaysApply?;
    get alwaysApply(): boolean | cdktf.IResolvable;
    set alwaysApply(value: boolean | cdktf.IResolvable);
    resetAlwaysApply(): void;
    get alwaysApplyInput(): boolean | cdktf.IResolvable | undefined;
    private _alwaysApplyTrigger?;
    get alwaysApplyTrigger(): string;
    set alwaysApplyTrigger(value: string);
    resetAlwaysApplyTrigger(): void;
    get alwaysApplyTriggerInput(): string | undefined;
    private _databaseRoleName?;
    get databaseRoleName(): string;
    set databaseRoleName(value: string);
    get databaseRoleNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _onDatabase?;
    get onDatabase(): string;
    set onDatabase(value: string);
    resetOnDatabase(): void;
    get onDatabaseInput(): string | undefined;
    private _privileges?;
    get privileges(): string[];
    set privileges(value: string[]);
    resetPrivileges(): void;
    get privilegesInput(): string[] | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _onSchema;
    get onSchema(): GrantPrivilegesToDatabaseRoleOnSchemaOutputReference;
    putOnSchema(value: GrantPrivilegesToDatabaseRoleOnSchema): void;
    resetOnSchema(): void;
    get onSchemaInput(): GrantPrivilegesToDatabaseRoleOnSchema | undefined;
    private _onSchemaObject;
    get onSchemaObject(): GrantPrivilegesToDatabaseRoleOnSchemaObjectOutputReference;
    putOnSchemaObject(value: GrantPrivilegesToDatabaseRoleOnSchemaObject): void;
    resetOnSchemaObject(): void;
    get onSchemaObjectInput(): GrantPrivilegesToDatabaseRoleOnSchemaObject | undefined;
    private _timeouts;
    get timeouts(): GrantPrivilegesToDatabaseRoleTimeoutsOutputReference;
    putTimeouts(value: GrantPrivilegesToDatabaseRoleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GrantPrivilegesToDatabaseRoleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
