/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantPrivilegesToShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#id GrantPrivilegesToShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The fully qualified identifier for the schema for which the specified privilege will be granted for all tables.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#on_all_tables_in_schema GrantPrivilegesToShare#on_all_tables_in_schema}
    */
    readonly onAllTablesInSchema?: string;
    /**
    * The fully qualified name of the database on which privileges will be granted. For more information about this resource, see [docs](./database).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#on_database GrantPrivilegesToShare#on_database}
    */
    readonly onDatabase?: string;
    /**
    * The fully qualified name of the function on which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#on_function GrantPrivilegesToShare#on_function}
    */
    readonly onFunction?: string;
    /**
    * The fully qualified name of the schema on which privileges will be granted. For more information about this resource, see [docs](./schema).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#on_schema GrantPrivilegesToShare#on_schema}
    */
    readonly onSchema?: string;
    /**
    * The fully qualified name of the table on which privileges will be granted. For more information about this resource, see [docs](./table).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#on_table GrantPrivilegesToShare#on_table}
    */
    readonly onTable?: string;
    /**
    * The fully qualified name of the tag on which privileges will be granted. For more information about this resource, see [docs](./tag).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#on_tag GrantPrivilegesToShare#on_tag}
    */
    readonly onTag?: string;
    /**
    * The fully qualified name of the view on which privileges will be granted. For more information about this resource, see [docs](./view).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#on_view GrantPrivilegesToShare#on_view}
    */
    readonly onView?: string;
    /**
    * The privileges to grant on the share. See available list of privileges: https://docs.snowflake.com/en/sql-reference/sql/grant-privilege-share#syntax
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#privileges GrantPrivilegesToShare#privileges}
    */
    readonly privileges: string[];
    /**
    * The fully qualified name of the share on which privileges will be granted. For more information about this resource, see [docs](./share).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#to_share GrantPrivilegesToShare#to_share}
    */
    readonly toShare: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#timeouts GrantPrivilegesToShare#timeouts}
    */
    readonly timeouts?: GrantPrivilegesToShareTimeouts;
}
export interface GrantPrivilegesToShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#create GrantPrivilegesToShare#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#delete GrantPrivilegesToShare#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#read GrantPrivilegesToShare#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#update GrantPrivilegesToShare#update}
    */
    readonly update?: string;
}
export declare function grantPrivilegesToShareTimeoutsToTerraform(struct?: GrantPrivilegesToShareTimeouts | cdktf.IResolvable): any;
export declare function grantPrivilegesToShareTimeoutsToHclTerraform(struct?: GrantPrivilegesToShareTimeouts | cdktf.IResolvable): any;
export declare class GrantPrivilegesToShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToShareTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GrantPrivilegesToShareTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share snowflake_grant_privileges_to_share}
*/
export declare class GrantPrivilegesToShare extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_privileges_to_share";
    /**
    * Generates CDKTF code for importing a GrantPrivilegesToShare resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantPrivilegesToShare to import
    * @param importFromId The id of the existing GrantPrivilegesToShare that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantPrivilegesToShare to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/grant_privileges_to_share snowflake_grant_privileges_to_share} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantPrivilegesToShareConfig
    */
    constructor(scope: Construct, id: string, config: GrantPrivilegesToShareConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _onAllTablesInSchema?;
    get onAllTablesInSchema(): string;
    set onAllTablesInSchema(value: string);
    resetOnAllTablesInSchema(): void;
    get onAllTablesInSchemaInput(): string | undefined;
    private _onDatabase?;
    get onDatabase(): string;
    set onDatabase(value: string);
    resetOnDatabase(): void;
    get onDatabaseInput(): string | undefined;
    private _onFunction?;
    get onFunction(): string;
    set onFunction(value: string);
    resetOnFunction(): void;
    get onFunctionInput(): string | undefined;
    private _onSchema?;
    get onSchema(): string;
    set onSchema(value: string);
    resetOnSchema(): void;
    get onSchemaInput(): string | undefined;
    private _onTable?;
    get onTable(): string;
    set onTable(value: string);
    resetOnTable(): void;
    get onTableInput(): string | undefined;
    private _onTag?;
    get onTag(): string;
    set onTag(value: string);
    resetOnTag(): void;
    get onTagInput(): string | undefined;
    private _onView?;
    get onView(): string;
    set onView(value: string);
    resetOnView(): void;
    get onViewInput(): string | undefined;
    private _privileges?;
    get privileges(): string[];
    set privileges(value: string[]);
    get privilegesInput(): string[] | undefined;
    private _toShare?;
    get toShare(): string;
    set toShare(value: string);
    get toShareInput(): string | undefined;
    private _timeouts;
    get timeouts(): GrantPrivilegesToShareTimeoutsOutputReference;
    putTimeouts(value: GrantPrivilegesToShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GrantPrivilegesToShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
