/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JobServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#comment JobService#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#compute_pool JobService#compute_pool}
    */
    readonly computePool: string;
    /**
    * The database in which to create the service. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#database JobService#database}
    */
    readonly database: string;
    /**
    * Specifies the names of the external access integrations that allow your service to access external sites.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#external_access_integrations JobService#external_access_integrations}
    */
    readonly externalAccessIntegrations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#id JobService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#name JobService#name}
    */
    readonly name: string;
    /**
    * Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#query_warehouse JobService#query_warehouse}
    */
    readonly queryWarehouse?: string;
    /**
    * The schema in which to create the service. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#schema JobService#schema}
    */
    readonly schema: string;
    /**
    * from_specification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#from_specification JobService#from_specification}
    */
    readonly fromSpecification?: JobServiceFromSpecification;
    /**
    * from_specification_template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#from_specification_template JobService#from_specification_template}
    */
    readonly fromSpecificationTemplate?: JobServiceFromSpecificationTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#timeouts JobService#timeouts}
    */
    readonly timeouts?: JobServiceTimeouts;
}
export interface JobServiceDescribeOutput {
}
export declare function jobServiceDescribeOutputToTerraform(struct?: JobServiceDescribeOutput): any;
export declare function jobServiceDescribeOutputToHclTerraform(struct?: JobServiceDescribeOutput): any;
export declare class JobServiceDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobServiceDescribeOutput | undefined;
    set internalValue(value: JobServiceDescribeOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get computePool(): string;
    get createdOn(): string;
    get currentInstances(): number;
    get databaseName(): string;
    get dnsName(): string;
    get externalAccessIntegrations(): string[];
    get isAsyncJob(): cdktf.IResolvable;
    get isJob(): cdktf.IResolvable;
    get isUpgrading(): cdktf.IResolvable;
    get managingObjectDomain(): string;
    get managingObjectName(): string;
    get maxInstances(): number;
    get minInstances(): number;
    get minReadyInstances(): number;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get resumedOn(): string;
    get schemaName(): string;
    get spec(): string;
    get specDigest(): string;
    get status(): string;
    get suspendedOn(): string;
    get targetInstances(): number;
    get updatedOn(): string;
}
export declare class JobServiceDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobServiceDescribeOutputOutputReference;
}
export interface JobServiceShowOutput {
}
export declare function jobServiceShowOutputToTerraform(struct?: JobServiceShowOutput): any;
export declare function jobServiceShowOutputToHclTerraform(struct?: JobServiceShowOutput): any;
export declare class JobServiceShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobServiceShowOutput | undefined;
    set internalValue(value: JobServiceShowOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get computePool(): string;
    get createdOn(): string;
    get currentInstances(): number;
    get databaseName(): string;
    get dnsName(): string;
    get externalAccessIntegrations(): string[];
    get isAsyncJob(): cdktf.IResolvable;
    get isJob(): cdktf.IResolvable;
    get isUpgrading(): cdktf.IResolvable;
    get managingObjectDomain(): string;
    get managingObjectName(): string;
    get maxInstances(): number;
    get minInstances(): number;
    get minReadyInstances(): number;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get resumedOn(): string;
    get schemaName(): string;
    get specDigest(): string;
    get status(): string;
    get suspendedOn(): string;
    get targetInstances(): number;
    get updatedOn(): string;
}
export declare class JobServiceShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobServiceShowOutputOutputReference;
}
export interface JobServiceFromSpecification {
    /**
    * The file name of the service specification. Example: `spec.yaml`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#file JobService#file}
    */
    readonly file?: string;
    /**
    * The path to the service specification file on the given stage. When the path is specified, the `/` character is automatically added as a path prefix. Example: `path/to/spec`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#path JobService#path}
    */
    readonly path?: string;
    /**
    * The fully qualified name of the stage containing the service specification file. At symbol (`@`) is added automatically. Example: `"\"<db_name>\".\"<schema_name>\".\"<stage_name>\""`. For more information about this resource, see [docs](./stage).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#stage JobService#stage}
    */
    readonly stage?: string;
    /**
    * The embedded text of the service specification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#text JobService#text}
    */
    readonly text?: string;
}
export declare function jobServiceFromSpecificationToTerraform(struct?: JobServiceFromSpecificationOutputReference | JobServiceFromSpecification): any;
export declare function jobServiceFromSpecificationToHclTerraform(struct?: JobServiceFromSpecificationOutputReference | JobServiceFromSpecification): any;
export declare class JobServiceFromSpecificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobServiceFromSpecification | undefined;
    set internalValue(value: JobServiceFromSpecification | undefined);
    private _file?;
    get file(): string;
    set file(value: string);
    resetFile(): void;
    get fileInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _stage?;
    get stage(): string;
    set stage(value: string);
    resetStage(): void;
    get stageInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface JobServiceFromSpecificationTemplateUsing {
    /**
    * The name of the template variable. The provider wraps it in double quotes by default, so be aware of that while referencing the argument in the spec definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#key JobService#key}
    */
    readonly key: string;
    /**
    * The value to assign to the variable in the template. The provider wraps it in `$$` by default, so be aware of that while referencing the argument in the spec definition. The value must either be alphanumeric or valid JSON.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#value JobService#value}
    */
    readonly value: string;
}
export declare function jobServiceFromSpecificationTemplateUsingToTerraform(struct?: JobServiceFromSpecificationTemplateUsing | cdktf.IResolvable): any;
export declare function jobServiceFromSpecificationTemplateUsingToHclTerraform(struct?: JobServiceFromSpecificationTemplateUsing | cdktf.IResolvable): any;
export declare class JobServiceFromSpecificationTemplateUsingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobServiceFromSpecificationTemplateUsing | cdktf.IResolvable | undefined;
    set internalValue(value: JobServiceFromSpecificationTemplateUsing | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class JobServiceFromSpecificationTemplateUsingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobServiceFromSpecificationTemplateUsing[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobServiceFromSpecificationTemplateUsingOutputReference;
}
export interface JobServiceFromSpecificationTemplate {
    /**
    * The file name of the service specification template. Example: `spec.yaml`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#file JobService#file}
    */
    readonly file?: string;
    /**
    * The path to the service specification template file on the given stage. When the path is specified, the `/` character is automatically added as a path prefix. Example: `path/to/spec`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#path JobService#path}
    */
    readonly path?: string;
    /**
    * The fully qualified name of the stage containing the service specification template file. At symbol (`@`) is added automatically. Example: `"\"<db_name>\".\"<schema_name>\".\"<stage_name>\""`. For more information about this resource, see [docs](./stage).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#stage JobService#stage}
    */
    readonly stage?: string;
    /**
    * The embedded text of the service specification template.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#text JobService#text}
    */
    readonly text?: string;
    /**
    * using block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#using JobService#using}
    */
    readonly using: JobServiceFromSpecificationTemplateUsing[] | cdktf.IResolvable;
}
export declare function jobServiceFromSpecificationTemplateToTerraform(struct?: JobServiceFromSpecificationTemplateOutputReference | JobServiceFromSpecificationTemplate): any;
export declare function jobServiceFromSpecificationTemplateToHclTerraform(struct?: JobServiceFromSpecificationTemplateOutputReference | JobServiceFromSpecificationTemplate): any;
export declare class JobServiceFromSpecificationTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobServiceFromSpecificationTemplate | undefined;
    set internalValue(value: JobServiceFromSpecificationTemplate | undefined);
    private _file?;
    get file(): string;
    set file(value: string);
    resetFile(): void;
    get fileInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _stage?;
    get stage(): string;
    set stage(value: string);
    resetStage(): void;
    get stageInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
    private _using;
    get using(): JobServiceFromSpecificationTemplateUsingList;
    putUsing(value: JobServiceFromSpecificationTemplateUsing[] | cdktf.IResolvable): void;
    get usingInput(): cdktf.IResolvable | JobServiceFromSpecificationTemplateUsing[] | undefined;
}
export interface JobServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#create JobService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#delete JobService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#read JobService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#update JobService#update}
    */
    readonly update?: string;
}
export declare function jobServiceTimeoutsToTerraform(struct?: JobServiceTimeouts | cdktf.IResolvable): any;
export declare function jobServiceTimeoutsToHclTerraform(struct?: JobServiceTimeouts | cdktf.IResolvable): any;
export declare class JobServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: JobServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service snowflake_job_service}
*/
export declare class JobService extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_job_service";
    /**
    * Generates CDKTF code for importing a JobService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the JobService to import
    * @param importFromId The id of the existing JobService that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the JobService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/job_service snowflake_job_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JobServiceConfig
    */
    constructor(scope: Construct, id: string, config: JobServiceConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _computePool?;
    get computePool(): string;
    set computePool(value: string);
    get computePoolInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): JobServiceDescribeOutputList;
    private _externalAccessIntegrations?;
    get externalAccessIntegrations(): string[];
    set externalAccessIntegrations(value: string[]);
    resetExternalAccessIntegrations(): void;
    get externalAccessIntegrationsInput(): string[] | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryWarehouse?;
    get queryWarehouse(): string;
    set queryWarehouse(value: string);
    resetQueryWarehouse(): void;
    get queryWarehouseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    get serviceType(): string;
    private _showOutput;
    get showOutput(): JobServiceShowOutputList;
    private _fromSpecification;
    get fromSpecification(): JobServiceFromSpecificationOutputReference;
    putFromSpecification(value: JobServiceFromSpecification): void;
    resetFromSpecification(): void;
    get fromSpecificationInput(): JobServiceFromSpecification | undefined;
    private _fromSpecificationTemplate;
    get fromSpecificationTemplate(): JobServiceFromSpecificationTemplateOutputReference;
    putFromSpecificationTemplate(value: JobServiceFromSpecificationTemplate): void;
    resetFromSpecificationTemplate(): void;
    get fromSpecificationTemplateInput(): JobServiceFromSpecificationTemplate | undefined;
    private _timeouts;
    get timeouts(): JobServiceTimeoutsOutputReference;
    putTimeouts(value: JobServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | JobServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
