/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MaskingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the SQL expression that transforms the data. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#body MaskingPolicy#body}
    */
    readonly body: string;
    /**
    * Specifies a comment for the masking policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#comment MaskingPolicy#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the masking policy. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#database MaskingPolicy#database}
    */
    readonly database: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the row access policy or conditional masking policy can reference a column that is already protected by a masking policy. Due to Snowflake limitations, when value is changed, the resource is recreated. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#exempt_other_policies MaskingPolicy#exempt_other_policies}
    */
    readonly exemptOtherPolicies?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#id MaskingPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the masking policy; must be unique for the database and schema in which the masking policy is created. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#name MaskingPolicy#name}
    */
    readonly name: string;
    /**
    * The return data type must match the input data type of the first column that is specified as an input column. For more information about data types, check [Snowflake docs](https://docs.snowflake.com/en/sql-reference/intro-summary-data-types).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#return_data_type MaskingPolicy#return_data_type}
    */
    readonly returnDataType: string;
    /**
    * The schema in which to create the masking policy. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#schema MaskingPolicy#schema}
    */
    readonly schema: string;
    /**
    * argument block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#argument MaskingPolicy#argument}
    */
    readonly argument: MaskingPolicyArgument[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#timeouts MaskingPolicy#timeouts}
    */
    readonly timeouts?: MaskingPolicyTimeouts;
}
export interface MaskingPolicyDescribeOutputSignature {
}
export declare function maskingPolicyDescribeOutputSignatureToTerraform(struct?: MaskingPolicyDescribeOutputSignature): any;
export declare function maskingPolicyDescribeOutputSignatureToHclTerraform(struct?: MaskingPolicyDescribeOutputSignature): any;
export declare class MaskingPolicyDescribeOutputSignatureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaskingPolicyDescribeOutputSignature | undefined;
    set internalValue(value: MaskingPolicyDescribeOutputSignature | undefined);
    get name(): string;
    get type(): string;
}
export declare class MaskingPolicyDescribeOutputSignatureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaskingPolicyDescribeOutputSignatureOutputReference;
}
export interface MaskingPolicyDescribeOutput {
}
export declare function maskingPolicyDescribeOutputToTerraform(struct?: MaskingPolicyDescribeOutput): any;
export declare function maskingPolicyDescribeOutputToHclTerraform(struct?: MaskingPolicyDescribeOutput): any;
export declare class MaskingPolicyDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaskingPolicyDescribeOutput | undefined;
    set internalValue(value: MaskingPolicyDescribeOutput | undefined);
    get body(): string;
    get name(): string;
    get returnType(): string;
    private _signature;
    get signature(): MaskingPolicyDescribeOutputSignatureList;
}
export declare class MaskingPolicyDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaskingPolicyDescribeOutputOutputReference;
}
export interface MaskingPolicyShowOutput {
}
export declare function maskingPolicyShowOutputToTerraform(struct?: MaskingPolicyShowOutput): any;
export declare function maskingPolicyShowOutputToHclTerraform(struct?: MaskingPolicyShowOutput): any;
export declare class MaskingPolicyShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaskingPolicyShowOutput | undefined;
    set internalValue(value: MaskingPolicyShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get exemptOtherPolicies(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class MaskingPolicyShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaskingPolicyShowOutputOutputReference;
}
export interface MaskingPolicyArgument {
    /**
    * The argument name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#name MaskingPolicy#name}
    */
    readonly name: string;
    /**
    * The argument type. VECTOR data types are not yet supported. For more information about data types, check [Snowflake docs](https://docs.snowflake.com/en/sql-reference/intro-summary-data-types).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#type MaskingPolicy#type}
    */
    readonly type: string;
}
export declare function maskingPolicyArgumentToTerraform(struct?: MaskingPolicyArgument | cdktf.IResolvable): any;
export declare function maskingPolicyArgumentToHclTerraform(struct?: MaskingPolicyArgument | cdktf.IResolvable): any;
export declare class MaskingPolicyArgumentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaskingPolicyArgument | cdktf.IResolvable | undefined;
    set internalValue(value: MaskingPolicyArgument | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class MaskingPolicyArgumentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MaskingPolicyArgument[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaskingPolicyArgumentOutputReference;
}
export interface MaskingPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#create MaskingPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#delete MaskingPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#read MaskingPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#update MaskingPolicy#update}
    */
    readonly update?: string;
}
export declare function maskingPolicyTimeoutsToTerraform(struct?: MaskingPolicyTimeouts | cdktf.IResolvable): any;
export declare function maskingPolicyTimeoutsToHclTerraform(struct?: MaskingPolicyTimeouts | cdktf.IResolvable): any;
export declare class MaskingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MaskingPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MaskingPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy snowflake_masking_policy}
*/
export declare class MaskingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_masking_policy";
    /**
    * Generates CDKTF code for importing a MaskingPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MaskingPolicy to import
    * @param importFromId The id of the existing MaskingPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MaskingPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/masking_policy snowflake_masking_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MaskingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MaskingPolicyConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): MaskingPolicyDescribeOutputList;
    private _exemptOtherPolicies?;
    get exemptOtherPolicies(): string;
    set exemptOtherPolicies(value: string);
    resetExemptOtherPolicies(): void;
    get exemptOtherPoliciesInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _returnDataType?;
    get returnDataType(): string;
    set returnDataType(value: string);
    get returnDataTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): MaskingPolicyShowOutputList;
    private _argument;
    get argument(): MaskingPolicyArgumentList;
    putArgument(value: MaskingPolicyArgument[] | cdktf.IResolvable): void;
    get argumentInput(): cdktf.IResolvable | MaskingPolicyArgument[] | undefined;
    private _timeouts;
    get timeouts(): MaskingPolicyTimeoutsOutputReference;
    putTimeouts(value: MaskingPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MaskingPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
