/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProcedureJavaConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Default: `user-defined procedure`) Specifies a comment for the procedure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#comment ProcedureJava#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#database ProcedureJava#database}
    */
    readonly database: string;
    /**
    * Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG_LEVEL). For more information, check [ENABLE_CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#enable_console_output ProcedureJava#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#execute_as ProcedureJava#execute_as}
    */
    readonly executeAs?: string;
    /**
    * The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#external_access_integrations ProcedureJava#external_access_integrations}
    */
    readonly externalAccessIntegrations?: string[];
    /**
    * Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#handler ProcedureJava#handler}
    */
    readonly handler: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#id ProcedureJava#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#is_secure ProcedureJava#is_secure}
    */
    readonly isSecure?: string;
    /**
    * LOG_LEVEL to use when filtering events For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#log_level ProcedureJava#log_level}
    */
    readonly logLevel?: string;
    /**
    * METRIC_LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#metric_level ProcedureJava#metric_level}
    */
    readonly metricLevel?: string;
    /**
    * The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#name ProcedureJava#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#null_input_behavior ProcedureJava#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#packages ProcedureJava#packages}
    */
    readonly packages?: string[];
    /**
    * Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#procedure_definition ProcedureJava#procedure_definition}
    */
    readonly procedureDefinition?: string;
    /**
    * Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#return_type ProcedureJava#return_type}
    */
    readonly returnType: string;
    /**
    * The language runtime version to use. Currently, the supported versions are: 11.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#runtime_version ProcedureJava#runtime_version}
    */
    readonly runtimeVersion: string;
    /**
    * The schema in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#schema ProcedureJava#schema}
    */
    readonly schema: string;
    /**
    * The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#snowpark_package ProcedureJava#snowpark_package}
    */
    readonly snowparkPackage: string;
    /**
    * Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#trace_level ProcedureJava#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#arguments ProcedureJava#arguments}
    */
    readonly arguments?: ProcedureJavaArguments[] | cdktf.IResolvable;
    /**
    * imports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#imports ProcedureJava#imports}
    */
    readonly imports?: ProcedureJavaImports[] | cdktf.IResolvable;
    /**
    * secrets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#secrets ProcedureJava#secrets}
    */
    readonly secrets?: ProcedureJavaSecrets[] | cdktf.IResolvable;
    /**
    * target_path block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#target_path ProcedureJava#target_path}
    */
    readonly targetPath?: ProcedureJavaTargetPath;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#timeouts ProcedureJava#timeouts}
    */
    readonly timeouts?: ProcedureJavaTimeouts;
}
export interface ProcedureJavaParametersEnableConsoleOutput {
}
export declare function procedureJavaParametersEnableConsoleOutputToTerraform(struct?: ProcedureJavaParametersEnableConsoleOutput): any;
export declare function procedureJavaParametersEnableConsoleOutputToHclTerraform(struct?: ProcedureJavaParametersEnableConsoleOutput): any;
export declare class ProcedureJavaParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaParametersEnableConsoleOutput | undefined;
    set internalValue(value: ProcedureJavaParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavaParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaParametersEnableConsoleOutputOutputReference;
}
export interface ProcedureJavaParametersLogLevel {
}
export declare function procedureJavaParametersLogLevelToTerraform(struct?: ProcedureJavaParametersLogLevel): any;
export declare function procedureJavaParametersLogLevelToHclTerraform(struct?: ProcedureJavaParametersLogLevel): any;
export declare class ProcedureJavaParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaParametersLogLevel | undefined;
    set internalValue(value: ProcedureJavaParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavaParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaParametersLogLevelOutputReference;
}
export interface ProcedureJavaParametersMetricLevel {
}
export declare function procedureJavaParametersMetricLevelToTerraform(struct?: ProcedureJavaParametersMetricLevel): any;
export declare function procedureJavaParametersMetricLevelToHclTerraform(struct?: ProcedureJavaParametersMetricLevel): any;
export declare class ProcedureJavaParametersMetricLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaParametersMetricLevel | undefined;
    set internalValue(value: ProcedureJavaParametersMetricLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavaParametersMetricLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaParametersMetricLevelOutputReference;
}
export interface ProcedureJavaParametersTraceLevel {
}
export declare function procedureJavaParametersTraceLevelToTerraform(struct?: ProcedureJavaParametersTraceLevel): any;
export declare function procedureJavaParametersTraceLevelToHclTerraform(struct?: ProcedureJavaParametersTraceLevel): any;
export declare class ProcedureJavaParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaParametersTraceLevel | undefined;
    set internalValue(value: ProcedureJavaParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavaParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaParametersTraceLevelOutputReference;
}
export interface ProcedureJavaParameters {
}
export declare function procedureJavaParametersToTerraform(struct?: ProcedureJavaParameters): any;
export declare function procedureJavaParametersToHclTerraform(struct?: ProcedureJavaParameters): any;
export declare class ProcedureJavaParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaParameters | undefined;
    set internalValue(value: ProcedureJavaParameters | undefined);
    private _enableConsoleOutput;
    get enableConsoleOutput(): ProcedureJavaParametersEnableConsoleOutputList;
    private _logLevel;
    get logLevel(): ProcedureJavaParametersLogLevelList;
    private _metricLevel;
    get metricLevel(): ProcedureJavaParametersMetricLevelList;
    private _traceLevel;
    get traceLevel(): ProcedureJavaParametersTraceLevelList;
}
export declare class ProcedureJavaParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaParametersOutputReference;
}
export interface ProcedureJavaShowOutput {
}
export declare function procedureJavaShowOutputToTerraform(struct?: ProcedureJavaShowOutput): any;
export declare function procedureJavaShowOutputToHclTerraform(struct?: ProcedureJavaShowOutput): any;
export declare class ProcedureJavaShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaShowOutput | undefined;
    set internalValue(value: ProcedureJavaShowOutput | undefined);
    get argumentsRaw(): string;
    get catalogName(): string;
    get createdOn(): string;
    get description(): string;
    get externalAccessIntegrations(): string;
    get isAggregate(): cdktf.IResolvable;
    get isAnsi(): cdktf.IResolvable;
    get isBuiltin(): cdktf.IResolvable;
    get isSecure(): cdktf.IResolvable;
    get isTableFunction(): cdktf.IResolvable;
    get maxNumArguments(): number;
    get minNumArguments(): number;
    get name(): string;
    get schemaName(): string;
    get secrets(): string;
    get validForClustering(): cdktf.IResolvable;
}
export declare class ProcedureJavaShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaShowOutputOutputReference;
}
export interface ProcedureJavaArguments {
    /**
    * The argument type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#arg_data_type ProcedureJava#arg_data_type}
    */
    readonly argDataType: string;
    /**
    * Optional default value for the argument. For text values use single quotes. Numeric values can be unquoted. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#arg_default_value ProcedureJava#arg_default_value}
    */
    readonly argDefaultValue?: string;
    /**
    * The argument name. The provider wraps it in double quotes by default, so be aware of that while referencing the argument in the procedure definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#arg_name ProcedureJava#arg_name}
    */
    readonly argName: string;
}
export declare function procedureJavaArgumentsToTerraform(struct?: ProcedureJavaArguments | cdktf.IResolvable): any;
export declare function procedureJavaArgumentsToHclTerraform(struct?: ProcedureJavaArguments | cdktf.IResolvable): any;
export declare class ProcedureJavaArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaArguments | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureJavaArguments | cdktf.IResolvable | undefined);
    private _argDataType?;
    get argDataType(): string;
    set argDataType(value: string);
    get argDataTypeInput(): string | undefined;
    private _argDefaultValue?;
    get argDefaultValue(): string;
    set argDefaultValue(value: string);
    resetArgDefaultValue(): void;
    get argDefaultValueInput(): string | undefined;
    private _argName?;
    get argName(): string;
    set argName(value: string);
    get argNameInput(): string | undefined;
}
export declare class ProcedureJavaArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureJavaArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaArgumentsOutputReference;
}
export interface ProcedureJavaImports {
    /**
    * Path for import on stage, without the leading `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#path_on_stage ProcedureJava#path_on_stage}
    */
    readonly pathOnStage: string;
    /**
    * Stage location without leading `@`. To use your user's stage set this to `~`, otherwise pass fully qualified name of the stage (with every part contained in double quotes or use `snowflake_stage.<your stage's resource name>.fully_qualified_name` if you manage this stage through terraform).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#stage_location ProcedureJava#stage_location}
    */
    readonly stageLocation: string;
}
export declare function procedureJavaImportsToTerraform(struct?: ProcedureJavaImports | cdktf.IResolvable): any;
export declare function procedureJavaImportsToHclTerraform(struct?: ProcedureJavaImports | cdktf.IResolvable): any;
export declare class ProcedureJavaImportsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaImports | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureJavaImports | cdktf.IResolvable | undefined);
    private _pathOnStage?;
    get pathOnStage(): string;
    set pathOnStage(value: string);
    get pathOnStageInput(): string | undefined;
    private _stageLocation?;
    get stageLocation(): string;
    set stageLocation(value: string);
    get stageLocationInput(): string | undefined;
}
export declare class ProcedureJavaImportsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureJavaImports[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaImportsOutputReference;
}
export interface ProcedureJavaSecrets {
    /**
    * Fully qualified name of the allowed [secret](https://docs.snowflake.com/en/sql-reference/sql/create-secret). You will receive an error if you specify a SECRETS value whose secret isn’t also included in an integration specified by the EXTERNAL_ACCESS_INTEGRATIONS parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#secret_id ProcedureJava#secret_id}
    */
    readonly secretId: string;
    /**
    * The variable that will be used in handler code when retrieving information from the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#secret_variable_name ProcedureJava#secret_variable_name}
    */
    readonly secretVariableName: string;
}
export declare function procedureJavaSecretsToTerraform(struct?: ProcedureJavaSecrets | cdktf.IResolvable): any;
export declare function procedureJavaSecretsToHclTerraform(struct?: ProcedureJavaSecrets | cdktf.IResolvable): any;
export declare class ProcedureJavaSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavaSecrets | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureJavaSecrets | cdktf.IResolvable | undefined);
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _secretVariableName?;
    get secretVariableName(): string;
    set secretVariableName(value: string);
    get secretVariableNameInput(): string | undefined;
}
export declare class ProcedureJavaSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureJavaSecrets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavaSecretsOutputReference;
}
export interface ProcedureJavaTargetPath {
    /**
    * Path for import on stage, without the leading `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#path_on_stage ProcedureJava#path_on_stage}
    */
    readonly pathOnStage: string;
    /**
    * Stage location without leading `@`. To use your user's stage set this to `~`, otherwise pass fully qualified name of the stage (with every part contained in double quotes or use `snowflake_stage.<your stage's resource name>.fully_qualified_name` if you manage this stage through terraform).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#stage_location ProcedureJava#stage_location}
    */
    readonly stageLocation: string;
}
export declare function procedureJavaTargetPathToTerraform(struct?: ProcedureJavaTargetPathOutputReference | ProcedureJavaTargetPath): any;
export declare function procedureJavaTargetPathToHclTerraform(struct?: ProcedureJavaTargetPathOutputReference | ProcedureJavaTargetPath): any;
export declare class ProcedureJavaTargetPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProcedureJavaTargetPath | undefined;
    set internalValue(value: ProcedureJavaTargetPath | undefined);
    private _pathOnStage?;
    get pathOnStage(): string;
    set pathOnStage(value: string);
    get pathOnStageInput(): string | undefined;
    private _stageLocation?;
    get stageLocation(): string;
    set stageLocation(value: string);
    get stageLocationInput(): string | undefined;
}
export interface ProcedureJavaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#create ProcedureJava#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#delete ProcedureJava#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#read ProcedureJava#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#update ProcedureJava#update}
    */
    readonly update?: string;
}
export declare function procedureJavaTimeoutsToTerraform(struct?: ProcedureJavaTimeouts | cdktf.IResolvable): any;
export declare function procedureJavaTimeoutsToHclTerraform(struct?: ProcedureJavaTimeouts | cdktf.IResolvable): any;
export declare class ProcedureJavaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProcedureJavaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureJavaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java snowflake_procedure_java}
*/
export declare class ProcedureJava extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_procedure_java";
    /**
    * Generates CDKTF code for importing a ProcedureJava resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProcedureJava to import
    * @param importFromId The id of the existing ProcedureJava that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProcedureJava to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_java snowflake_procedure_java} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProcedureJavaConfig
    */
    constructor(scope: Construct, id: string, config: ProcedureJavaConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _executeAs?;
    get executeAs(): string;
    set executeAs(value: string);
    resetExecuteAs(): void;
    get executeAsInput(): string | undefined;
    private _externalAccessIntegrations?;
    get externalAccessIntegrations(): string[];
    set externalAccessIntegrations(value: string[]);
    resetExternalAccessIntegrations(): void;
    get externalAccessIntegrationsInput(): string[] | undefined;
    get fullyQualifiedName(): string;
    private _handler?;
    get handler(): string;
    set handler(value: string);
    get handlerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isSecure?;
    get isSecure(): string;
    set isSecure(value: string);
    resetIsSecure(): void;
    get isSecureInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metricLevel?;
    get metricLevel(): string;
    set metricLevel(value: string);
    resetMetricLevel(): void;
    get metricLevelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _packages?;
    get packages(): string[];
    set packages(value: string[]);
    resetPackages(): void;
    get packagesInput(): string[] | undefined;
    private _parameters;
    get parameters(): ProcedureJavaParametersList;
    private _procedureDefinition?;
    get procedureDefinition(): string;
    set procedureDefinition(value: string);
    resetProcedureDefinition(): void;
    get procedureDefinitionInput(): string | undefined;
    get procedureLanguage(): string;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    get runtimeVersionInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): ProcedureJavaShowOutputList;
    private _snowparkPackage?;
    get snowparkPackage(): string;
    set snowparkPackage(value: string);
    get snowparkPackageInput(): string | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _arguments;
    get arguments(): ProcedureJavaArgumentsList;
    putArguments(value: ProcedureJavaArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | ProcedureJavaArguments[] | undefined;
    private _imports;
    get imports(): ProcedureJavaImportsList;
    putImports(value: ProcedureJavaImports[] | cdktf.IResolvable): void;
    resetImports(): void;
    get importsInput(): cdktf.IResolvable | ProcedureJavaImports[] | undefined;
    private _secrets;
    get secrets(): ProcedureJavaSecretsList;
    putSecrets(value: ProcedureJavaSecrets[] | cdktf.IResolvable): void;
    resetSecrets(): void;
    get secretsInput(): cdktf.IResolvable | ProcedureJavaSecrets[] | undefined;
    private _targetPath;
    get targetPath(): ProcedureJavaTargetPathOutputReference;
    putTargetPath(value: ProcedureJavaTargetPath): void;
    resetTargetPath(): void;
    get targetPathInput(): ProcedureJavaTargetPath | undefined;
    private _timeouts;
    get timeouts(): ProcedureJavaTimeoutsOutputReference;
    putTimeouts(value: ProcedureJavaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ProcedureJavaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
